/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.example;

import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.geometry.shared.TSOvalShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldefinition.TSGraphicalDefinition;
import com.tomsawyer.graphicaldrawing.TSEConnector;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEEdgeLabel;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSEImage;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSObjectBuilder;
import com.tomsawyer.graphicaldrawing.ui.simple.TSEBackgroundGraphUI;
import com.tomsawyer.graphicaldrawing.xml.TSObjectBuilderXMLReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphModel.class);
    private TSNodeBuilder nodeBuilder;

    public GraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        TSEBackgroundGraphUI graphUI = (TSEBackgroundGraphUI)this.graph.getUI();
        graphUI.setBackgroundImage(new TSEImage(((Object)((Object)this)).getClass(), "images/background.png"));
        graphUI.setBackgroundImageStyle(3);
    }

    public void loadGraph(IProgressMonitor monitor) {
        try {
            this.nodeBuilder = this.graphManager.getNodeBuilder();
            if (this.nodeBuilder == null) {
                this.nodeBuilder = new TSNodeBuilder();
                this.graphManager.setNodeBuilder(this.nodeBuilder);
            }
            TSObjectBuilderXMLReader xmlReader = new TSObjectBuilderXMLReader(TSGraphicalDefinition.class.getResource("resources/basic/nodeShape.xml"), TSGraphicalDefinition.class);
            xmlReader.setObjectBuilder((TSObjectBuilder)this.nodeBuilder);
            xmlReader.read();
            this.nodeBuilder.setAttribute("Background_Color", (Object)TSEColor.darkGreen);
            this.nodeBuilder.setShape((TSShape)TSOvalShape.getInstance());
            this.nodeBuilder.setResizability(3);
        }
        catch (Exception e) {
            L.error("loadGraph(): ", (Throwable)e);
        }
        TSENode node1 = (TSENode)this.graph.addNode();
        node1.setName((Object)"Node 1");
        TSENode node2 = (TSENode)this.graph.addNode();
        TSENode node3 = (TSENode)this.graph.addNode();
        TSENode node4 = (TSENode)this.graph.addNode();
        TSENode node5 = (TSENode)this.graph.addNode();
        TSENode node6 = (TSENode)this.graph.addNode();
        node2.setName((Object)"Node 2");
        node3.setName((Object)"Node 3");
        node4.setName((Object)"Node 4");
        node5.setName((Object)"Node 5");
        node6.setName((Object)"Node 6");
        TSEConnector connector1 = (TSEConnector)node2.addConnector();
        connector1.setProportionalXOffset(0.0);
        connector1.setProportionalYOffset(0.5);
        connector1.setSize(6.0, 6.0);
        TSEEdge edge1 = (TSEEdge)this.graphManager.addEdge((TSNode)node1, (TSNode)node2);
        edge1.setTargetConnector((TSConnector)connector1);
        this.graphManager.addEdge((TSNode)node1, (TSNode)node3);
        this.graphManager.addEdge((TSNode)node2, (TSNode)node4);
        this.graphManager.addEdge((TSNode)node2, (TSNode)node5);
        this.graphManager.addEdge((TSNode)node3, (TSNode)node5);
        this.graphManager.addEdge((TSNode)node3, (TSNode)node6);
        TSEEdgeLabel label3 = (TSEEdgeLabel)edge1.addLabel();
        label3.setName((Object)"Edge Label");
        monitor.done();
    }
}

