/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sharedresources;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.mainframe.MainframeMenuMouseActionHook;
import com.ez.graphs.sharedresources.SharedResourcesGraphJob;
import com.ez.internal.id.EZEntityID;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.complexity.TSHidingManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;

public class SharedResourcesMouseActionsHook
extends MainframeMenuMouseActionHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private SharedResourcesGraphJob.ExpandAction expandAction = null;
    private SharedResourcesGraphJob.CollapseAction collapseAction = null;
    private SharedResourcesGraphJob job = null;

    public SharedResourcesMouseActionsHook(EZEntityID entityId, SharedResourcesGraphJob job) {
        super(entityId);
        this.job = job;
    }

    @Override
    public List getRightClickContributions(TSENode node) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        TSENode pnode = node;
        if (node != null && (TSEFoldingManager.isFolderNode((TSDNode)node) || !node.isViewable() && node.hasAttribute("PARENT"))) {
            if (this.expandAction == null) {
                this.expandAction = this.job.new SharedResourcesGraphJob.ExpandAction();
            }
            boolean isHidden = TSHidingManager.isHidden((TSGraphMember)node);
            if (node.hasAttribute("PARENT")) {
                pnode = (TSENode)node.getAttributeValue("PARENT");
            }
            this.expandAction.setChecked(false);
            this.expandAction.setNodeToExpand(pnode);
            String expandLabel = Messages.getString(SharedResourcesGraphJob.class, "expand.text", new Integer[]{(Integer)pnode.getAttributeValue("numer of folded nodes(count children)")});
            this.expandAction.setText(expandLabel);
            this.expandAction.setEnabled(!pnode.isExpanded() && !isHidden);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        }
        if (pnode != null && pnode.hasAttribute("list with nodesToFold")) {
            if (this.collapseAction == null) {
                this.collapseAction = this.job.new SharedResourcesGraphJob.CollapseAction();
            }
            this.collapseAction.setChecked(false);
            List nodesToFold = (List)pnode.getAttributeValue("list with nodesToFold");
            Integer resTypeId = (Integer)pnode.getAttributeValue("resType");
            this.collapseAction.setNodesToCollapse(nodesToFold, resTypeId);
            String collapseLabel = Messages.getString(SharedResourcesGraphJob.class, "collapse.text", new String[]{SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId)});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        }
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }

    public void dispose() {
        if (this.expandAction != null) {
            this.expandAction.dispose();
            this.expandAction = null;
        }
        if (this.collapseAction != null) {
            this.collapseAction.dispose();
            this.collapseAction = null;
        }
        super.dispose();
    }
}

