/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sharedresources;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.sharedresources.SharedResourcesNodeLegendInfo;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProgramType;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceCLFileIDSg;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.ez.workspace.model.segments.EZSourceFileIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDatabaseIDSg;
import com.ez.workspace.model.segments.EZSourceIncludeIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProgramTypeIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceQueueManagerIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import com.tomsawyer.graphicaldrawing.complexity.TSENestingManager;
import com.tomsawyer.graphicaldrawing.ui.TSEdgeUI;
import com.tomsawyer.graphicaldrawing.ui.simple.TSEPolylineEdgeUI;
import images.LoadSVGImages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedResourcesGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(SharedResourcesGraphModel.class);
    private static final String ADABAS_DB_NAME = "adabasDbName";
    private static final String ADABAS_FILE_NAME = "adabasFileName";
    public static final String RES_TYPE_ID = "resType";
    public static final String NODES_TO_FOLD_LIST = "list with nodesToFold";
    public static final String COUNT_NODES_FOLDED = "numer of folded nodes(count children)";
    private static Integer FOLDING_NODES_PRAG;
    private List<EZSourceProjectInputType> projects;
    private Set<String> notAccessibleProjects = null;
    @Deprecated
    private List<ProjectApplicationInput> selectedApplications = null;
    @Deprecated
    private Set<String> notAccessibleApplications = null;
    private Map<Integer, List<ProgramInputNoGUI>> sharedResourcesMap;
    private Collection<TSGraphMember> allTSNodes = new HashSet<TSGraphMember>();
    @Deprecated
    private Boolean useApplications = SharedResourcesUtils.useApplications();

    public SharedResourcesGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
        this.initialize();
    }

    private void initialize() {
        this.outForGISV.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        TSEPolylineEdgeUI ui = new TSEPolylineEdgeUI();
        ui.setArrowType(0);
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        edgeBuilder.setEdgeUI((TSEdgeUI)ui);
        edgeBuilder = this.graphManager.getEdgeBuilder();
        TSENestingManager nestingManager = (TSENestingManager)TSENestingManager.getManager((TSDGraphManager)this.graphManager);
        nestingManager.setMetaEdgeBuilder(edgeBuilder);
        TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)this.graphManager);
        foldingManager.setFolderNodeBuilder(this.graphManager.getNodeBuilder());
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        this.initialize();
        monitor.setTaskName(Messages.getString(SharedResourcesGraphModel.class, "loading.graph"));
        HashMap<String, TSENode> prjTSNodes = new HashMap<String, TSENode>();
        HashMap resTSNodes = new HashMap();
        this.allTSNodes.clear();
        boolean mustFoldNodes = false;
        if (this.sharedResourcesMap != null && !this.sharedResourcesMap.isEmpty()) {
            Map<String, TSENode> resMap;
            TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
            TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
            IPreferenceStore store = PreferenceUtils.getPreferenceStore();
            FOLDING_NODES_PRAG = store.getInt("shResFoldPreference");
            L.debug("fold limit from preferences: {}", (Object)FOLDING_NODES_PRAG);
            ArrayList<Integer> resTypeIds = new ArrayList<Integer>(this.sharedResourcesMap.keySet());
            Collections.sort(resTypeIds);
            for (Integer resTypeId : resTypeIds) {
                List<ProgramInputNoGUI> sharedResources;
                resMap = (HashMap)resTSNodes.get(resTypeId);
                if (resMap == null) {
                    resMap = new HashMap();
                    resTSNodes.put(resTypeId, resMap);
                }
                if ((sharedResources = this.sharedResourcesMap.get(resTypeId)).size() >= FOLDING_NODES_PRAG) {
                    mustFoldNodes = true;
                }
                for (ProgramInputNoGUI resourceInput : sharedResources) {
                    boolean allowDrawing;
                    Set resourceProjects = resourceInput.getApplications();
                    if (resourceProjects == null || resourceProjects.size() < 2 || !(allowDrawing = SharedResourcesUtils.allowDrawing((ProgramInputNoGUI)resourceInput, (Integer)resTypeId))) continue;
                    String hsqlUniqueResName = resourceInput.getName();
                    TSENode resNode = (TSENode)resMap.get(hsqlUniqueResName);
                    if (resNode == null) {
                        resNode = this.makeResTSNode(nodeBuilder, resourceInput, resMap);
                    }
                    for (String prjName : resourceProjects) {
                        TSENode prjNode = (TSENode)prjTSNodes.get(prjName);
                        if (prjNode == null) {
                            prjNode = this.makePrjTSNode(nodeBuilder, prjName, prjTSNodes);
                        }
                        edgeBuilder.addEdge(this.graphManager, prjNode, resNode);
                    }
                }
            }
            if (mustFoldNodes) {
                for (Integer resTypeId : resTSNodes.keySet()) {
                    resMap = (Map)resTSNodes.get(resTypeId);
                    if (resMap.size() < FOLDING_NODES_PRAG) continue;
                    ArrayList<TSENode> toFoldNodes = new ArrayList<TSENode>(resMap.values());
                    this.foldNodes(resTypeId, toFoldNodes, false);
                }
                this.createMetaEdges();
            }
        } else {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
            L.debug("no results");
        }
        monitor.setWorkRemaining(0);
    }

    private void createApplicableInputTypeForResource(TSENode resNode, Integer resTypeId, String resName, Set<Pair<String, String>> resInfoPerPrj) {
        EZObjectType inputType = null;
        EZSourceSQLTableIDSg resourceSg = null;
        EZSourceSQLTableIDSg property = null;
        String keyProperty = null;
        switch (resTypeId) {
            case 1: {
                resourceSg = new EZSourceSQLTableIDSg(resName);
                break;
            }
            case 9: {
                int resourceType = 9;
                resourceSg = new EZSourceFileIDSg(resName, resourceType);
                keyProperty = "mainframe resource id sg";
                property = resourceSg;
                break;
            }
            case 18: {
                resourceSg = new EZSourceIMSDatabaseIDSg(resName);
                break;
            }
            case 30: {
                Integer genNumber = null;
                Integer dsId = null;
                resourceSg = new EZSourceDatasetIDSg(resName, dsId, genNumber);
                break;
            }
            case 56: {
                resourceSg = new EZSourceAdabasIDSg(resName);
                break;
            }
            case 64: {
                break;
            }
            case 70: {
                resourceSg = new EZSourceFileIDSg(resName, resTypeId.intValue());
                break;
            }
            case 71: {
                break;
            }
            case 72: {
                resourceSg = new EZSourceCLFileIDSg(resName);
                break;
            }
            case -177: 
            case 77: {
                resName = resName.substring(0, resName.indexOf("(")).trim();
                resourceSg = new EZSourceIDMSRecordIDSg(resName);
                resTypeId = 75;
                keyProperty = "mainframe resource id sg";
                property = resourceSg;
                break;
            }
            case -178: 
            case 78: {
                resName = resName.substring(0, resName.indexOf("(")).trim();
                resourceSg = new EZSourceIDMSSetIDSg(resName);
                resTypeId = 76;
                keyProperty = "mainframe resource id sg";
                property = resourceSg;
                break;
            }
            case 81: {
                resourceSg = new EZSourceQueueManagerIDSg(resName);
                break;
            }
            case 182: {
                resourceSg = new EZSourceDatacomTableIDSg(resName);
                break;
            }
            case 13: 
            case 60: 
            case 67: 
            case 99: {
                resourceSg = new EZSourceIncludeIDSg(resName, null);
                break;
            }
            case 5: {
                resourceSg = new EZSourceProgramIDSg(resName, null, null);
                break;
            }
            default: {
                L.warn("Unhandled resource type (id) {} for applicable input type!", (Object)resTypeId);
            }
        }
        if (resourceSg != null && resInfoPerPrj != null) {
            HashSet<EZSourceProjectIDSg> prjSgs = new HashSet<EZSourceProjectIDSg>();
            block27: for (Pair<String, String> prjResInfoPair : resInfoPerPrj) {
                String prjName = (String)prjResInfoPair.getFirst();
                prjName = this.useApplications != false && prjName.indexOf(":") > 0 ? prjName.substring(0, prjName.indexOf(":")) : prjName;
                for (EZSourceProjectInputType pInputType : this.projects) {
                    if (!pInputType.getName().equalsIgnoreCase(prjName)) continue;
                    if (resTypeId != 5) {
                        inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(resTypeId, "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                    }
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)pInputType.getEntID().getSegment(EZSourceProjectIDSg.class);
                    prjSgs.add(prjSg);
                    EZEntityID entityId = new EZEntityID();
                    entityId.addSegment((EZSegment)prjSg);
                    String resInfo = (String)prjResInfoPair.getSecond();
                    String[] info = null;
                    Integer resDbId = null;
                    String path = null;
                    switch (resTypeId) {
                        case 18: {
                            info = resInfo.split("##EZSRC##");
                            resDbId = Integer.valueOf(info[0]);
                            Integer dbAccessType = info[1].equalsIgnoreCase("null") ? 0 : Integer.valueOf(info[1]);
                            resourceSg = new EZSourceIMSDatabaseIDSg(resName);
                            inputType.addProperty("IMSDB_DATABASE_ID", (Object)resDbId);
                            inputType.addProperty("IMSDB_DATABASE_TYPE", (Object)dbAccessType);
                            break;
                        }
                        case 30: {
                            resDbId = Integer.valueOf((String)prjResInfoPair.getSecond());
                            resourceSg = new EZSourceDatasetIDSg(resName, resDbId, "", null);
                            resourceSg.setIncompleteSegment(true);
                            inputType.addProperty("holds the load modules of the program to be executed in the JCL", (Object)Boolean.FALSE);
                            break;
                        }
                        case 56: {
                            resDbId = Integer.valueOf((String)prjResInfoPair.getSecond());
                            ((EZSourceAdabasIDSg)resourceSg).setNumber(resDbId.intValue());
                            String s = (String)resNode.getAttributeValue(ADABAS_FILE_NAME);
                            ((EZSourceAdabasIDSg)resourceSg).setFileName(s);
                            s = (String)resNode.getAttributeValue(ADABAS_DB_NAME);
                            ((EZSourceAdabasIDSg)resourceSg).setDbName(s);
                            break;
                        }
                        case 9: {
                            inputType.addProperty("logical file attribute", (Object)((EZSourceFileIDSg)resourceSg).getFileName());
                            break;
                        }
                        case 13: 
                        case 60: 
                        case 67: 
                        case 99: {
                            info = resInfo.split("##EZSRC##");
                            resDbId = Integer.valueOf(info[0]);
                            Integer pathId = Integer.valueOf(info[1]);
                            resourceSg = new EZSourceIncludeIDSg(resName, pathId);
                            keyProperty = "mainframe resource id sg";
                            property = resourceSg;
                            EZSourceProgramTypeIDSg programTypeIdSg = new EZSourceProgramTypeIDSg(this.getProgramTypeForIncludeType(resTypeId));
                            entityId.addSegment((EZSegment)programTypeIdSg);
                            path = info[2];
                            if (path != null && path.equalsIgnoreCase("null")) {
                                path = "";
                            }
                            Boolean includeNotInPrj = Boolean.FALSE;
                            if (path == null || path.isEmpty() || resName.equalsIgnoreCase(path)) {
                                includeNotInPrj = Boolean.TRUE;
                            }
                            inputType.addProperty("include is not on disk", (Object)includeNotInPrj);
                            break;
                        }
                        case 5: {
                            String[] names;
                            info = resInfo.split("##EZSRC##");
                            resDbId = Integer.valueOf(info[0]);
                            Integer programTypeId = Integer.valueOf(info[1]);
                            String sAcestorId = info[2];
                            String ancestorName = info[3];
                            path = info[4];
                            if (path != null && path.equalsIgnoreCase("null")) {
                                path = "";
                            }
                            if (programTypeId <= 0) break;
                            try {
                                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(programTypeId);
                            }
                            catch (IllegalStateException ex) {
                                L.debug("unknown type of program; cannot build the input type", (Throwable)ex);
                            }
                            if (inputType == null) break;
                            Boolean occur = Boolean.FALSE;
                            if (path != null && !path.isEmpty()) {
                                occur = Boolean.TRUE;
                            }
                            inputType.addProperty("program occur", (Object)occur);
                            if ((ProgramType.ASSEMBLER_CSECT.getProgramTypeId() == programTypeId.intValue() || ProgramType.ASSEMBLER_ENTRY.getProgramTypeId() == programTypeId.intValue()) && (names = resName.split(":")).length == 2) {
                                resName = names[1];
                            }
                            resourceSg = new EZSourceProgramIDSg(resName, resDbId, programTypeId, occur);
                            resourceSg.setPath(path);
                            if (ancestorName == null || ancestorName.isEmpty()) break;
                            ((EZSourceProgramIDSg)resourceSg).setAncestorName(ancestorName);
                            if (sAcestorId == null) break;
                            Integer ancestorId = Integer.valueOf(sAcestorId);
                            ((EZSourceProgramIDSg)resourceSg).setAncestorId(ancestorId);
                        }
                    }
                    if (inputType == null) continue block27;
                    entityId.addSegment((EZSegment)resourceSg);
                    inputType.setEntID(entityId);
                    inputType.setName(resName);
                    if (property != null) {
                        inputType.addProperty(keyProperty, (Object)property);
                    }
                    resNode.setAttribute("APPLICABLE_INPUT".concat(prjSg.getProjectName()), (Object)inputType);
                    continue block27;
                }
            }
            resNode.setAttribute("project sgs to start all available analysis for each project", prjSgs);
        }
    }

    private Integer getProgramTypeForIncludeType(Integer includeType) {
        Integer programType = ProgramType.UNKNOWN.getProgramTypeId();
        switch (includeType) {
            case 13: {
                programType = ProgramType.COBOL.getProgramTypeId();
                break;
            }
            case 60: {
                programType = ProgramType.NATURAL.getProgramTypeId();
                break;
            }
            case 67: {
                programType = ProgramType.PL1.getProgramTypeId();
                break;
            }
            case 99: {
                programType = ProgramType.ASSEMBLER.getProgramTypeId();
                break;
            }
            default: {
                L.warn("Unhandled include type: {}!", (Object)includeType);
            }
        }
        return programType;
    }

    private TSENode makePrjTSNode(TSNodeBuilder nodeBuilder, String projectName, Map<String, TSENode> map) {
        TSENode projectNode = nodeBuilder.addNode(this.graph);
        this.registerNode(projectNode);
        map.put(projectName, projectNode);
        projectNode.setName((Object)projectName);
        projectNode.setTooltipText(projectName);
        SharedResourcesNodeLegendInfo projectNodeTypeInfo = SharedResourcesNodeLegendInfo.PROJECT;
        if (this.useApplications.booleanValue()) {
            projectNodeTypeInfo = SharedResourcesNodeLegendInfo.APPLICATION;
        }
        projectNode.setAttribute("class_name", (Object)projectNodeTypeInfo.getNodeTypeClass());
        TSESVGImage svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)projectNodeTypeInfo.getGraphImagePath());
        this.setNodeUI(projectNode, svgimage, projectNodeTypeInfo.getTSEColor(), TSEColor.white);
        this.putEntriesInGISV(projectNodeTypeInfo.getLegendLabel(), projectNode);
        this.nodeTypesSetForLegend.add(projectNodeTypeInfo);
        this.createApplicableInputTypeForProject(projectNode);
        return projectNode;
    }

    private TSENode makeResTSNode(TSNodeBuilder nodeBuilder, ProgramInputNoGUI resourceInput, Map<String, TSENode> resMap) {
        TSENode resNode = nodeBuilder.addNode(this.graph);
        this.registerNode(resNode);
        String hsqlUniqueResName = resourceInput.getName();
        resMap.put(hsqlUniqueResName, resNode);
        String resDisplayName = hsqlUniqueResName;
        Integer resTypeId = resourceInput.getTypeCode();
        String resTypeName = SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId);
        if (resTypeId != null) {
            String[] parts = null;
            switch (resTypeId) {
                case 18: {
                    parts = hsqlUniqueResName.split("##EZSRC##");
                    if (parts == null || parts.length < 2) {
                        L.warn("wrong name or path for an IMSDB file: {}", (Object)hsqlUniqueResName);
                        break;
                    }
                    resDisplayName = parts[0];
                    break;
                }
                case 56: {
                    parts = hsqlUniqueResName.split("##EZSRC##");
                    if (parts == null || parts.length != 2) {
                        L.warn("wrong name for an ADABAS file: {}", (Object)hsqlUniqueResName);
                        break;
                    }
                    String firstName = parts[0];
                    String secName = parts[1];
                    resDisplayName = AdabasUtils.getListableName((String)firstName, (String)secName);
                    resNode.setAttribute(ADABAS_FILE_NAME, (Object)firstName);
                    resNode.setAttribute(ADABAS_DB_NAME, (Object)secName);
                    break;
                }
                case 13: 
                case 60: 
                case 67: 
                case 99: {
                    parts = hsqlUniqueResName.split("##EZSRC##");
                    if (parts == null || parts.length != 2) {
                        L.warn("Invalid data for an Include: {}", (Object)hsqlUniqueResName);
                        break;
                    }
                    resDisplayName = parts[0];
                    break;
                }
            }
        }
        resNode.setName((Object)resDisplayName);
        StringBuilder tooltip = new StringBuilder(resTypeName);
        tooltip.append(":");
        tooltip.append(resDisplayName);
        resNode.setTooltipText(tooltip.toString());
        this.setResourceNodeUIStyle(resNode, resTypeId, resourceInput.getResDbIdInPrj(), false);
        this.createApplicableInputTypeForResource(resNode, resTypeId, resDisplayName, resourceInput.getResDbIdInPrj());
        return resNode;
    }

    private void createMetaEdges() {
        LinkedList metaEdgeNodePairList = new LinkedList();
        LinkedList metaEdgesToRemove = new LinkedList();
        this.graphManager.checkMetaEdges(metaEdgeNodePairList, metaEdgesToRemove);
        LinkedList insertedMetaEdges = new LinkedList();
        this.graphManager.updateMetaEdges(metaEdgeNodePairList, metaEdgesToRemove, insertedMetaEdges);
    }

    private void createApplicableInputTypeForProject(TSENode prjNode) {
        for (EZSourceProjectInputType inputType : this.projects) {
            if (!prjNode.getName().equals(inputType.getName())) continue;
            prjNode.setAttribute("APPLICABLE_INPUT", (Object)inputType);
            break;
        }
    }

    public void unregisterNode(TSENode node) {
        this.allTSNodes.remove(node);
    }

    private void registerNode(TSENode node) {
        this.allTSNodes.add((TSGraphMember)node);
    }

    public void foldNodes(Integer resTypeId, List<TSENode> toFoldNodes, boolean createMetaEdges) {
        TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)this.graphManager);
        ArrayList<TSENode> toFoldList = new ArrayList<TSENode>(toFoldNodes);
        TSENode fNode = foldingManager.fold(toFoldList, true);
        this.registerNode(fNode);
        String name = SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId);
        fNode.setName((Object)name);
        String countLbl = Messages.getString(SharedResourcesGraphModel.class, "count.text", new Object[]{name, toFoldNodes.size()});
        fNode.setTooltipText(countLbl);
        fNode.setAttribute(COUNT_NODES_FOLDED, (Object)toFoldNodes.size());
        this.setResourceNodeUIStyle(fNode, resTypeId, null, true);
        for (TSENode child : toFoldNodes) {
            child.setAttribute(NODES_TO_FOLD_LIST, toFoldNodes);
            child.setAttribute(RES_TYPE_ID, (Object)resTypeId);
            child.setAttribute("PARENT", (Object)fNode);
        }
        if (createMetaEdges) {
            this.createMetaEdges();
        }
    }

    private void setResourceNodeUIStyle(TSENode tsNode, Integer resTypeId, Set<Pair<String, String>> resInfoPerPrj, boolean isFoldedNode) {
        TSESVGImage svgimage = null;
        SharedResourcesNodeLegendInfo nodeTypeInfo = null;
        String inventoryLbl = SharedResourcesUtils.getResTypeNameByResTypeId((Integer)resTypeId);
        switch (resTypeId) {
            case 1: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SQL_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SQL_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SQL_TABLE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.SQL_TABLE;
                break;
            }
            case 9: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.FILE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.FILE;
                break;
            }
            case 18: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IMS_DB.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IMS_DB.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IMS_DB.getTSEColor());
                nodeTypeInfo = CallgraphNodeLegendInfo.IMS_DB;
                break;
            }
            case 30: {
                tsNode.setAttribute("class_name", (Object)SharedResourcesNodeLegendInfo.PHYSICAL_DATASET.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)SharedResourcesNodeLegendInfo.PHYSICAL_DATASET.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.PHYSICAL_DATASET.getTSEColor());
                nodeTypeInfo = SharedResourcesNodeLegendInfo.PHYSICAL_DATASET;
                break;
            }
            case 56: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ADABAS.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ADABAS.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ADABAS.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.ADABAS;
                break;
            }
            case 64: {
                tsNode.setAttribute("class_name", (Object)SharedResourcesNodeLegendInfo.AIM_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)SharedResourcesNodeLegendInfo.AIM_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.AIM_TABLE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = SharedResourcesNodeLegendInfo.AIM_TABLE;
                break;
            }
            case 70: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.PRINTER_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.PRINTER_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.PRINTER_FILE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.PRINTER_FILE;
                break;
            }
            case 71: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DB_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DB_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DB_FILE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.DB_FILE;
                break;
            }
            case 72: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.CL_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.CL_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.CL_FILE.getTSEColor());
                nodeTypeInfo = CallgraphNodeLegendInfo.CL_FILE;
                break;
            }
            case 77: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMS_RECORD.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMS_RECORD.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMS_RECORD.getTSEColor());
                nodeTypeInfo = CallgraphNodeLegendInfo.IDMS_RECORD;
                break;
            }
            case -177: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_RECORD.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMSX_RECORD.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_RECORD.getTSEColor());
                nodeTypeInfo = CallgraphNodeLegendInfo.IDMSX_RECORD;
                break;
            }
            case 78: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMS_SET.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMS_SET.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMS_SET.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.IDMS_SET;
                break;
            }
            case -178: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_SET.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMSX_SET.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_SET.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.IDMSX_SET;
                break;
            }
            case 81: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.QUEUE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.QUEUE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.QUEUE.getTSEColor());
                nodeTypeInfo = CallgraphNodeLegendInfo.QUEUE;
                break;
            }
            case 182: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DATACOM_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DATACOM_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DATACOM_TABLE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = CallgraphNodeLegendInfo.DATACOM_TABLE;
                break;
            }
            case 13: 
            case 60: 
            case 67: 
            case 99: {
                tsNode.setAttribute("class_name", (Object)SharedResourcesNodeLegendInfo.INCLUDE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)SharedResourcesNodeLegendInfo.INCLUDE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.INCLUDE.getTSEColor(), TSEColor.white);
                nodeTypeInfo = SharedResourcesNodeLegendInfo.INCLUDE;
                break;
            }
            case 5: {
                if (isFoldedNode) {
                    tsNode.setAttribute("class_name", (Object)SharedResourcesNodeLegendInfo.PROGRAM.getNodeTypeClass());
                    nodeTypeInfo = SharedResourcesNodeLegendInfo.PROGRAM;
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)SharedResourcesNodeLegendInfo.PROGRAM.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.PROGRAM.getTSEColor(), TSEColor.white);
                    break;
                }
                boolean hasMixedType = false;
                Integer savedTypeId = null;
                HashSet<Integer> withPath = new HashSet<Integer>();
                HashSet<Integer> withoutPath = new HashSet<Integer>();
                boolean fileOnDisk = false;
                for (Pair<String, String> prjResInfoPair : resInfoPerPrj) {
                    String resInfo = (String)prjResInfoPair.getSecond();
                    String[] info = resInfo.split("##EZSRC##");
                    Integer currentTypeId = Integer.valueOf(info[1]);
                    String path = info[4];
                    if (path != null && !path.isEmpty() && !path.equalsIgnoreCase("null")) {
                        withPath.add(currentTypeId);
                        fileOnDisk = true;
                    } else {
                        withoutPath.add(currentTypeId);
                    }
                    if (withPath.size() <= 1) continue;
                    hasMixedType = true;
                    break;
                }
                if (!hasMixedType) {
                    if (withPath.size() == 1) {
                        savedTypeId = withPath.toArray(new Integer[1])[0];
                    } else if (withoutPath.size() == 1) {
                        savedTypeId = withoutPath.toArray(new Integer[1])[0];
                    } else {
                        hasMixedType = true;
                    }
                }
                tsNode.setAttribute("class_name", (Object)SharedResourcesNodeLegendInfo.PROGRAM.getNodeTypeClass());
                nodeTypeInfo = SharedResourcesNodeLegendInfo.PROGRAM;
                if (hasMixedType) {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)SharedResourcesNodeLegendInfo.PROGRAM.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.PROGRAM.getTSEColor(), TSEColor.white);
                    inventoryLbl = Messages.getString(SharedResourcesGraphModel.class, "inventory.category.label.mixedtype");
                    break;
                }
                IGraphNodeLegendInfo programNodeTypeInfo = CallgraphNodeLegendInfo.getProgramNodeInfoForType(savedTypeId);
                if (programNodeTypeInfo != null) {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)programNodeTypeInfo.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, SharedResourcesNodeLegendInfo.PROGRAM.getTSEColor(), TSEColor.white);
                    inventoryLbl = programNodeTypeInfo.getLegendLabel();
                    tsNode.setAttribute("program occur", (Object)fileOnDisk);
                    break;
                }
                L.warn("Unhandled/unexpected program type id: {} when creating program node!", (Object)savedTypeId);
                break;
            }
            default: {
                L.warn("Unhandled resource type id: {} when creating resource node!");
            }
        }
        if (!isFoldedNode) {
            this.putEntriesInGISV(inventoryLbl, tsNode);
            this.nodeTypesSetForLegend.add(nodeTypeInfo);
        }
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        Class nodeTypeInfoClass = (Class)tsNode.getAttributeValue("class_name");
        Set<Object> nodes = null;
        if (nodeTypeInfoClass.equals(SharedResourcesNodeLegendInfo.INCLUDE.getNodeTypeClass())) {
            String includeParentCategory = SharedResourcesNodeLegendInfo.INCLUDE.getLegendLabel();
            HashMap<String, HashSet<TSENode>> includeParentMap = (HashMap<String, HashSet<TSENode>>)this.outForGISV.get(includeParentCategory);
            if (includeParentMap == null) {
                includeParentMap = new HashMap<String, HashSet<TSENode>>();
                this.outForGISV.put(includeParentCategory, includeParentMap);
            }
            if ((nodes = (Set)includeParentMap.get(inventoryCategory)) == null) {
                nodes = new HashSet();
                includeParentMap.put(inventoryCategory, (HashSet<TSENode>)nodes);
            }
        } else if (nodeTypeInfoClass.equals(SharedResourcesNodeLegendInfo.PROGRAM.getNodeTypeClass())) {
            String programParentCategory = SharedResourcesNodeLegendInfo.PROGRAM.getLegendLabel();
            HashMap<String, HashSet<TSENode>> programParentMap = (HashMap<String, HashSet<TSENode>>)this.outForGISV.get(programParentCategory);
            if (programParentMap == null) {
                programParentMap = new HashMap<String, HashSet<TSENode>>();
                this.outForGISV.put(programParentCategory, programParentMap);
            }
            if ((nodes = (Set)programParentMap.get(inventoryCategory)) == null) {
                nodes = new HashSet();
                programParentMap.put(inventoryCategory, (HashSet<TSENode>)nodes);
            }
        } else {
            nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
            if (nodes == null) {
                nodes = new HashSet<TSENode>();
                this.outForGISV.put(inventoryCategory, nodes);
            }
        }
        nodes.add(tsNode);
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor) {
        this.setNodeUI(node, svgimage, fillColor, null);
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("uiImage", (Object)svgimage);
        node.setAttribute("Fill_Color", (Object)fillColor);
        node.setAttribute("Color", (Object)textColor);
        this.setNodeUI(node);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            TSEColor color = (TSEColor)node.getAttributeValue("Color");
            if (color != null) {
                node.setAttribute("Text_Color", (Object)color);
            }
        }
    }

    public void updateDrawing() {
        for (TSGraphMember node : this.allTSNodes) {
            this.setNodeUI((TSENode)node);
        }
    }

    public void setNotAccessibleProjects(Set<String> notAccessible) {
        this.notAccessibleProjects = notAccessible;
    }

    public void setSharedResources(Map<Integer, List<ProgramInputNoGUI>> resultMap) {
        this.sharedResourcesMap = resultMap;
    }

    public Collection<TSGraphMember> getNodes() {
        return this.allTSNodes;
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return objType;
    }

    public void setInputProjects(List<EZSourceProjectInputType> projects) {
        this.projects = projects;
    }

    @Deprecated
    public void setSelectedApplications(List<ProjectApplicationInput> selectedApplications) {
        this.selectedApplications = selectedApplications;
    }

    @Deprecated
    public void setNotAccessibleApplications(Set<String> notAccessibleApplications) {
        this.notAccessibleApplications = notAccessibleApplications;
    }
}

