/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sharedresources;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.nodes.AIMTableNode;
import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.CLFileNode;
import com.ez.cobol.callgraph.nodes.DBFileNode;
import com.ez.cobol.callgraph.nodes.GenericProgramNode;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.IncludeNode;
import com.ez.cobol.callgraph.nodes.MainframeProjectNode;
import com.ez.cobol.callgraph.nodes.PhysicalDatasetNode;
import com.ez.cobol.callgraph.nodes.PrinterFileNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.ResourceDatacomTableNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.ResourceSQLTableNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.sharedresources.SharedResourcesGraphModel;
import com.ez.graphs.sharedresources.SharedResourcesMouseActionsHook;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.report.application.utils.ProjectApplicationInput;
import com.ez.report.application.utils.SharedResourcesUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.EZNodeHidingManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import com.tomsawyer.interactive.command.editing.TSEDeleteNodeCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;

public class SharedResourcesGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    @Deprecated
    private Boolean useApplications = SharedResourcesUtils.useApplications();
    private MainframeMouseActionsHook mouseActionsHook = null;

    public SharedResourcesGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new SharedResourcesMouseActionsHook(id, this);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new SharedResourcesGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphModel = new SharedResourcesGraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(SharedResourcesGraphJob.class, "collectingData.taskName"));
        IStatus status = this.runWithProgress((IProgressMonitor)pmonitor.newChild(100));
        if (!status.isOK()) {
            monitor.setCanceled(true);
        } else {
            pmonitor.setWorkRemaining(0);
        }
    }

    private IStatus runWithProgress(IProgressMonitor pmonitor) {
        ArrayList<Object> toRemove;
        IStatus st = Status.OK_STATUS;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(SharedResourcesGraphJob.class, "compute.taskName"));
        List selectedProjects = this.analysis.getContextListValue("input_list");
        Set notAccessibleProjects = this.analysis.getContextSetValue("not accessible projects");
        List selectedApplications = this.analysis.getContextListValue("selected applications for shared resources");
        Set notAccessibleApplications = this.analysis.getContextSetValue("not accessible applications for shared resources");
        List inputs = this.analysis.getContextListValue("selected resources");
        ArrayList<BaseResourceInput> selectedInputTypes = new ArrayList<BaseResourceInput>();
        for (Object obj : inputs) {
            if (obj instanceof BaseResourceInput) {
                selectedInputTypes.add((BaseResourceInput)obj);
                continue;
            }
            if (!(obj instanceof BaseResourceInput4GUI)) continue;
            selectedInputTypes.add(((BaseResourceInput4GUI)obj).getObject());
        }
        if (notAccessibleProjects != null) {
            toRemove = new ArrayList<Object>();
            for (EZSourceProjectInputType inputProject : selectedProjects) {
                if (!notAccessibleProjects.contains(inputProject.getName())) continue;
                toRemove.add(inputProject);
            }
            selectedProjects.removeAll(toRemove);
        }
        if (this.useApplications.booleanValue() && notAccessibleApplications != null) {
            toRemove = new ArrayList();
            for (ProjectApplicationInput inputApp : selectedApplications) {
                if (!notAccessibleApplications.contains(inputApp.getDisplayName())) continue;
                toRemove.add(inputApp);
            }
            selectedApplications.removeAll(toRemove);
        }
        String strDate = SharedResourcesUtils.getGenDate();
        String title = "SharedResources";
        String dbName = SharedResourcesUtils.generateName((String)strDate, (String)title);
        Pair pair = SharedResourcesUtils.getDBData((IProgressMonitor)monitor.newChild(50), (List)selectedProjects, (List)selectedApplications, selectedInputTypes, (String)dbName);
        Map summaryCounts = (Map)pair.getFirst();
        if (summaryCounts != null) {
            HashMap<Integer, List<ProgramInputNoGUI>> sharedResByType = new HashMap<Integer, List<ProgramInputNoGUI>>();
            ArrayList resTypeIds = new ArrayList(summaryCounts.keySet());
            Collections.sort(resTypeIds);
            for (Integer resTypeId : resTypeIds) {
                List sharedResources = SharedResourcesUtils.getSharedResByType((Integer)resTypeId, (String)dbName);
                if (sharedResources == null || sharedResources.isEmpty()) continue;
                sharedResByType.put(resTypeId, sharedResources);
            }
            ((SharedResourcesGraphModel)this.graphModel).setSharedResources(sharedResByType);
        }
        SharedResourcesUtils.closeHSqlServer((String)dbName);
        Set notAccessibleAfterProcessing = (Set)pair.getSecond();
        if (notAccessibleAfterProcessing != null && !notAccessibleAfterProcessing.isEmpty()) {
            ArrayList<Object> toRemove2;
            if (this.useApplications.booleanValue()) {
                toRemove2 = new ArrayList<Object>();
                for (ProjectApplicationInput appInput : selectedApplications) {
                    if (!notAccessibleAfterProcessing.contains(appInput.getDisplayName())) continue;
                    toRemove2.add(appInput);
                }
                selectedApplications.removeAll(toRemove2);
                if (notAccessibleApplications != null) {
                    notAccessibleApplications.addAll(notAccessibleAfterProcessing);
                } else {
                    notAccessibleApplications = notAccessibleAfterProcessing;
                    this.analysis.addContextValue("not accessible applications for shared resources", (Object)notAccessibleApplications);
                }
            } else {
                toRemove2 = new ArrayList();
                for (EZSourceProjectInputType inputProject : selectedProjects) {
                    if (!notAccessibleAfterProcessing.contains(inputProject.getName())) continue;
                    toRemove2.add(inputProject);
                }
                selectedProjects.removeAll(toRemove2);
                if (notAccessibleProjects != null) {
                    notAccessibleProjects.addAll(notAccessibleAfterProcessing);
                } else {
                    notAccessibleProjects = notAccessibleAfterProcessing;
                    this.analysis.addContextValue("not accessible projects", (Object)notAccessibleProjects);
                }
            }
        }
        if (this.useApplications.booleanValue()) {
            ((SharedResourcesGraphModel)this.graphModel).setSelectedApplications(selectedApplications);
            ((SharedResourcesGraphModel)this.graphModel).setNotAccessibleApplications(notAccessibleApplications);
        } else {
            ((SharedResourcesGraphModel)this.graphModel).setNotAccessibleProjects(notAccessibleProjects);
        }
        ((SharedResourcesGraphModel)this.graphModel).setInputProjects(selectedProjects);
        if (monitor.isCanceled()) {
            st = Status.CANCEL_STATUS;
        } else {
            monitor.worked(50);
        }
        return st;
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        IStatus statusResult = super.finalTSGraphOperations(monitor, result);
        if (this.gfi != null) {
            Collection<TSGraphMember> allNodes = ((SharedResourcesGraphModel)this.graphModel).getNodes();
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    protected void redrawAll() {
        this.refreshLegend();
        EZNodeHidingManager hidingManager = (EZNodeHidingManager)this.graphModel.getGraphManager().getHidingManager();
        hidingManager.setGroupSource("flag");
        ArrayList<TSGraphMember> allNodes = new ArrayList<TSGraphMember>(((SharedResourcesGraphModel)this.graphModel).getNodes());
        hidingManager.unhide(allNodes, null, true);
        hidingManager.endEventGroup();
        List cmds = this.doLayout(this.currentLayoutType);
        this.transmitCommands(cmds);
        ((TSEOverviewComponent)this.graphInfo.getOverviewComponent()).updateOverview();
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend, uiStyle);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(nodeLegendInfo.getNodeTypeClass(), imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(AdabasNode.class);
        gfi.registerFilterType(AIMTableNode.class);
        gfi.registerFilterType(CLFileNode.class);
        gfi.registerFilterType(DBFileNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IMSDBNode.class);
        gfi.registerFilterType(IncludeNode.class);
        gfi.registerFilterType(MainframeProjectNode.class);
        gfi.registerFilterType(PhysicalDatasetNode.class);
        gfi.registerFilterType(PrinterFileNode.class);
        gfi.registerFilterType(GenericProgramNode.class);
        gfi.registerFilterType(QueueNode.class);
        gfi.registerFilterType(ResourceDatacomTableNode.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(ResourceSQLTableNode.class);
    }

    public class CollapseAction
    extends GraphTSJobAdapter.ProgressAction {
        private List<TSENode> toFoldNodes;
        private Integer resTypeId;

        public CollapseAction() {
            super((GraphTSJobAdapter)SharedResourcesGraphJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(SharedResourcesGraphJob.class, "collapse.task.text"), -1);
            ((SharedResourcesGraphModel)SharedResourcesGraphJob.this.graphModel).foldNodes(this.resTypeId, this.toFoldNodes, true);
            List cmds = SharedResourcesGraphJob.this.doLayout(SharedResourcesGraphJob.this.currentLayoutType);
            SharedResourcesGraphJob.this.transmitCommands(cmds);
            SharedResourcesGraphJob.this.canvas.requestFocus();
            monitor.done();
        }

        public void setNodesToCollapse(List<TSENode> nodesToFold, Integer resTypeId) {
            this.toFoldNodes = nodesToFold;
            this.resTypeId = resTypeId;
        }
    }

    public class ExpandAction
    extends GraphTSJobAdapter.ProgressAction {
        private TSENode nodeToExpand;

        public ExpandAction() {
            super((GraphTSJobAdapter)SharedResourcesGraphJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(SharedResourcesGraphJob.class, "expand.task.text"), -1);
            TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)SharedResourcesGraphJob.this.graphManager);
            boolean keepHidden = true;
            foldingManager.unfold((TSDNode)this.nodeToExpand, keepHidden);
            TSEDeleteNodeCommand delCom = new TSEDeleteNodeCommand(this.nodeToExpand);
            delCom.setUpdateMetaEdges(false);
            delCom.execute();
            List cmds = SharedResourcesGraphJob.this.doLayout(SharedResourcesGraphJob.this.currentLayoutType);
            SharedResourcesGraphJob.this.transmitCommands(cmds);
            ((SharedResourcesGraphModel)SharedResourcesGraphJob.this.graphModel).unregisterNode(this.nodeToExpand);
            SharedResourcesGraphJob.this.canvas.requestFocus();
            monitor.done();
        }

        public void setNodeToExpand(TSENode nodeToExpand) {
            this.nodeToExpand = nodeToExpand;
        }
    }

    public class SharedResourcesGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;

        public SharedResourcesGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage("sharedResources", "icons/shared.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("sharedResources");
            }
            return this.image;
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            Set inputs = SharedResourcesGraphJob.this.analysis.getContextSetValue("inputs name string");
            if (inputs != null) {
                Iterator it = inputs.iterator();
                while (it.hasNext()) {
                    buf.append((String)it.next());
                    if (!it.hasNext()) continue;
                    buf.append(", ");
                }
            }
            String lbl = Messages.getString(SharedResourcesGraphJob.class, "shared.graph.analysis.lbl", new String[]{buf.toString()});
            return lbl;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    SharedResourcesGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    int uiStyle = SharedResourcesGraphJob.this.graphModel.getUIStyle();
                    SharedResourcesGraphJob.this.addEntriesToLegend(SharedResourcesGraphJob.this.legend, uiStyle, SharedResourcesGraphInfo.this.gfi);
                    sc.setContent((Control)SharedResourcesGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    SharedResourcesGraphJob.this.legend.pack();
                    sc.setMinSize(SharedResourcesGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((SharedResourcesGraphJob)((SharedResourcesGraphInfo)SharedResourcesGraphInfo.this).SharedResourcesGraphJob.this).legend.getSize().x;
                    int x = ((SharedResourcesGraphJob)((SharedResourcesGraphInfo)SharedResourcesGraphInfo.this).SharedResourcesGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            SharedResourcesGraphJob.this.legend = null;
            super.dispose();
        }
    }
}

