/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.screenlayout;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.screenlayout.ScreenLayoutAnalysis;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.model.ScreenInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.collectors.ScreenCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class ScreenLayoutInputsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardName = Messages.getString(ScreenLayoutAnalysis.class, "wizard.title");
        wizard.setWindowTitle(wizardName);
        String title = Messages.getString(ScreenLayoutAnalysis.class, "page.title");
        String description = Messages.getString(ScreenLayoutAnalysis.class, "page.description");
        SingleSelectionPage singleSelectionPage = new SingleSelectionPage("programs page", true);
        singleSelectionPage.setLeftGroupLabel(Messages.getString(ScreenLayoutAnalysis.class, "object.type"));
        singleSelectionPage.setErrMsgNoResource(Messages.getString(ScreenLayoutAnalysis.class, "err.message"));
        singleSelectionPage.setTitle(title);
        singleSelectionPage.setDescription(description);
        ScreenCollector sc = new ScreenCollector(true);
        sc.setQueryName("EZReports_ScreenFlow_ADS_BMS_NATURAL");
        singleSelectionPage.setResourcesCollector((ResourcesCollector)sc);
        wizard.addPage((IWizardPage)singleSelectionPage);
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo projectName = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(projectName);
            for (ScreenInput si : selected) {
                EZEntityID entity = new EZEntityID();
                EZSourceScreenIDSg scrIdSg = new EZSourceScreenIDSg(si.getResourceID(), si.getScreenName(), si.getType(), si.getOccurID());
                scrIdSg.setMapSet(si.getMapSet());
                entity.addSegment((EZSegment)prjIdSg);
                entity.addSegment((EZSegment)scrIdSg);
                list.add(entity);
            }
            analysis.addContextValue("input_list", list);
        }
    }
}

