/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.screenlayout;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.job.DefaultGraphJobAdapter;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.change.DirtyStatus;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenLayoutAnalysisJob
extends DefaultGraphJobAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ScreenLayoutAnalysisJob.class);
    private static final String DEFAULT_ADS_FOLDER = "Ads";
    private static final String DEFAULT_NATURAL_FOLDER = "NATURAL";
    private static final String DEFAULT_IMS_FOLDER = "IMS";
    private static final String FILE_EXTENSION = ".txt";
    private EZEntityID screenID;
    private EZEntityID fileEntity;
    private ProjectInfo projectInfo;
    private Text screenLayoutText;
    private String screenLayoutTextContent;
    private String screenLayoutTextContentRev;
    private boolean screenLayoutTextRev = false;
    private ScreenGraphInfo graphInfo;
    private Action reverseAction;

    public ScreenLayoutAnalysisJob(EZEntityID screenID) {
        super(Messages.getString(ScreenLayoutAnalysisJob.class, "layout.job.text"));
        this.setUser(true);
        this.screenID = screenID;
        this.initialize(screenID);
        L.info("ScreenLayoutAnalysisJob(EZEntityID={})", (Object)screenID);
        this.graphInfo = new ScreenGraphInfo();
    }

    public ScreenLayoutAnalysisJob(String info) {
        super(info);
    }

    private void initialize(EZEntityID id) {
        EZSegment sg = id.getSegment(AnalysisIDSegment.class);
        if (sg != null) {
            this.analysis = (AbstractAnalysis)((AnalysisIDSegment)sg).getAnalysis();
            List inputs = (List)this.analysis.getContextValue("input_list");
            this.fileEntity = (EZEntityID)inputs.get(0);
            this.projectInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        }
    }

    public void init() {
    }

    public boolean belongsTo(Object family) {
        return "GRAPH_JOB".equals(family);
    }

    public void buildComponents(final Composite parent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ScreenLayoutAnalysisJob.this.graphInfo == null || ((ScreenLayoutAnalysisJob)ScreenLayoutAnalysisJob.this).graphInfo.sc == null || ((ScreenLayoutAnalysisJob)ScreenLayoutAnalysisJob.this).graphInfo.sc.isDisposed()) {
                    ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
                    scrolledComposite.setLayoutData((Object)new GridData(1808));
                    ScreenLayoutAnalysisJob.this.screenLayoutText = new Text((Composite)scrolledComposite, 2050);
                    ScreenLayoutAnalysisJob.this.screenLayoutText.setEditable(false);
                    scrolledComposite.setContent((Control)ScreenLayoutAnalysisJob.this.screenLayoutText);
                    ScreenLayoutAnalysisJob.this.screenLayoutText.setLayoutData((Object)new GridData(1808));
                    ScreenLayoutAnalysisJob.this.screenLayoutText.setFont(JFaceResources.getTextFont());
                    ScreenLayoutAnalysisJob.this.graphInfo.addPropertyChangeListener();
                    ((ScreenLayoutAnalysisJob)ScreenLayoutAnalysisJob.this).graphInfo.sc = scrolledComposite;
                }
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    protected IStatus run(IProgressMonitor monitor) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                long jobStartTime = System.currentTimeMillis();
                L.info("{} - start time: {}", (Object)ScreenLayoutAnalysisJob.this.analysis.getType().toString(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()));
                if (ScreenLayoutAnalysisJob.this.screenLayoutTextContent == null || ScreenLayoutAnalysisJob.this.screenLayoutTextContent.equals("")) {
                    boolean hadException = false;
                    String filePath = null;
                    String layoutData = null;
                    try {
                        filePath = ScreenLayoutAnalysisJob.this.getPath();
                        layoutData = ScreenLayoutAnalysisJob.this.readFile(filePath);
                    }
                    catch (Exception exception) {
                        hadException = true;
                        MessageDialog.openError((Shell)ScreenLayoutAnalysisJob.this.screenLayoutText.getShell(), (String)Messages.getString(ScreenLayoutAnalysisJob.class, "openFileError.dialog.title"), (String)Messages.getString(ScreenLayoutAnalysisJob.class, "openFileError.dialog.message", new String[]{filePath}));
                    }
                    if (layoutData == null) {
                        String path;
                        if (!hadException && (path = ScreenLayoutAnalysisJob.this.getPath()) != null) {
                            MessageDialog.openError((Shell)ScreenLayoutAnalysisJob.this.screenLayoutText.getShell(), (String)Messages.getString(ScreenLayoutAnalysisJob.class, "messageDialog.error.title.fileNotFound"), (String)Messages.getString(ScreenLayoutAnalysisJob.class, "messageDialog.message.error.fileNotFound").replace("%PATH%", path).replace("%NAME%", ScreenLayoutAnalysisJob.this.getScreenName()));
                        }
                        status[0] = Status.CANCEL_STATUS;
                    } else {
                        ScreenLayoutAnalysisJob.this.screenLayoutTextContent = layoutData;
                        ScreenLayoutAnalysisJob.this.screenLayoutText.setText(layoutData);
                        ScreenLayoutAnalysisJob.this.screenLayoutText.pack();
                        status[0] = Status.OK_STATUS;
                    }
                }
                ScreenLayoutAnalysisJob.this.changeActionsState();
                long jobDuration = System.currentTimeMillis() - jobStartTime;
                L.info("{} - duration: {} ms.", (Object)ScreenLayoutAnalysisJob.this.analysis.getType().toString(), (Object)jobDuration);
            }
        });
        return status[0];
    }

    public void markAsDirty() {
    }

    public boolean isDirty() {
        return false;
    }

    public GraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public void closing() {
        EZWorkspace ws = EZWorkspace.getInstance();
        ws.removeJob(this.screenID, ((Object)((Object)this)).getClass(), (GraphTranslateJob)this);
        this.analysis = null;
        this.projectInfo = null;
        this.reverseAction = null;
        if (this.screenLayoutText != null) {
            this.screenLayoutText.dispose();
            this.screenLayoutText = null;
        }
        if (this.graphInfo != null) {
            this.graphInfo.dispose();
            this.graphInfo = null;
        }
    }

    private String readFile(String filePath) throws Exception {
        StringBuffer text;
        block21: {
            text = null;
            BufferedReader bufferedReader = null;
            try {
                ByteArrayInputStream is = null;
                InputStreamReader reader = null;
                String encoding = System.getProperty("screenLayoutEnc");
                try {
                    HttpResponseConsumer consumer = null;
                    try {
                        consumer = FileAuthUtils.getFileContent((String)filePath);
                    }
                    catch (Exception e) {
                        L.error("error downloading file: {}", (Object)filePath, (Object)e);
                        String msg = Messages.getString(ScreenLayoutAnalysisJob.class, "openFileError.message", new String[]{filePath});
                        LogUtil.displayErrorMessage((Throwable)e, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                        throw e;
                    }
                    if (consumer != null && consumer.getContent() != null) {
                        is = new ByteArrayInputStream(consumer.getContent().getBytes());
                    } else {
                        L.info("no content returned from FileService for file {}", (Object)filePath);
                    }
                    if (is != null) {
                        try {
                            reader = encoding != null ? new InputStreamReader((InputStream)is, encoding) : new InputStreamReader(is);
                        }
                        catch (UnsupportedEncodingException ex) {
                            L.error("Encoding {} not supported; the default one will be used", (Object)encoding, (Object)ex);
                            String msg = Messages.getString(ScreenLayoutAnalysisJob.class, "wrongEncoding.error.message", new String[]{encoding});
                            LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault());
                            try {
                                reader = new InputStreamReader(is);
                            }
                            catch (Exception e) {
                                L.error("error reading with default charset", (Throwable)e);
                            }
                        }
                        if (reader != null) {
                            String s;
                            bufferedReader = new BufferedReader(reader);
                            while ((s = bufferedReader.readLine()) != null) {
                                if (text == null) {
                                    text = new StringBuffer();
                                } else {
                                    text.append("\n");
                                }
                                text.append(s);
                            }
                        } else {
                            L.warn("stream reader is null");
                        }
                        break block21;
                    }
                    L.warn("input stream is null");
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            catch (IOException e1) {
                L.warn("IOException", (Throwable)e1);
            }
        }
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    private String getPath() {
        String path = (String)this.projectInfo.getInfo().get("projectLocation");
        EZSourceScreenIDSg ezSourceScreenIDSg = (EZSourceScreenIDSg)this.fileEntity.getSegment(EZSourceScreenIDSg.class);
        int screenType = ezSourceScreenIDSg.getScreenType();
        switch (screenType) {
            case 119: {
                path = String.valueOf(path) + File.separator + "MapLayouts" + File.separator + ezSourceScreenIDSg.getMapSet() + File.separator + ezSourceScreenIDSg.getScreenName() + FILE_EXTENSION;
                break;
            }
            case 118: {
                path = String.valueOf(path) + File.separator + "MapLayouts" + File.separator + DEFAULT_ADS_FOLDER + File.separator + ezSourceScreenIDSg.getScreenName() + FILE_EXTENSION;
                break;
            }
            case 120: {
                path = String.valueOf(path) + File.separator + "MapLayouts" + File.separator + DEFAULT_NATURAL_FOLDER + File.separator + ezSourceScreenIDSg.getScreenName() + FILE_EXTENSION;
                break;
            }
            case 121: {
                path = String.valueOf(path) + File.separator + "ScreensLayout" + File.separator + ezSourceScreenIDSg.getMapSet() + File.separator + ezSourceScreenIDSg.getScreenName() + FILE_EXTENSION;
                break;
            }
            case 65: {
                path = String.valueOf(path) + File.separator + "MapLayouts" + File.separator + DEFAULT_IMS_FOLDER + File.separator + ezSourceScreenIDSg.getMapSet() + FILE_EXTENSION;
                break;
            }
            default: {
                path = null;
                throw new RuntimeException(Messages.getString(ScreenLayoutAnalysisJob.class, "noPath.exception", new String[]{String.valueOf(screenType)}));
            }
        }
        L.debug("path={}", (Object)path);
        return path;
    }

    private String getScreenName() {
        EZSourceScreenIDSg ezSourceScreenIDSg = (EZSourceScreenIDSg)this.fileEntity.getSegment(EZSourceScreenIDSg.class);
        return ezSourceScreenIDSg.getScreenName();
    }

    protected void createEdgesActions() {
        if (this.reverseAction == null) {
            this.reverseAction = new Action(Messages.getString(ScreenLayoutAnalysisJob.class, "action.label.reverse"), 1){

                public void run() {
                    ScreenLayoutAnalysisJob.this.revertString();
                }
            };
            this.reverseAction.setEnabled(true);
            this.reverseAction.setImageDescriptor(Activator.getImageDescriptor("icons/text_mirror.png"));
        }
    }

    protected void contributeEdgesEntries(List<ContributionItem> menus) {
        this.createEdgesActions();
        menus.add((ContributionItem)new Separator());
        menus.add((ContributionItem)new ActionContributionItem((IAction)this.reverseAction));
    }

    private void changeActionsState() {
        this.reverseAction.setEnabled(true);
    }

    private void revertString() {
        if (this.screenLayoutTextContentRev == null) {
            String[] strings = this.screenLayoutTextContent.split("\n");
            StringBuffer screenText = null;
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (screenText == null) {
                    screenText = new StringBuffer();
                } else {
                    screenText.append("\n");
                }
                s = new StringBuffer(s).reverse().toString();
                screenText.append(s);
                ++n2;
            }
            this.screenLayoutTextContentRev = screenText.toString();
        }
        boolean bl = this.screenLayoutTextRev = !this.screenLayoutTextRev;
        if (this.screenLayoutTextRev) {
            this.screenLayoutText.setText(this.screenLayoutTextContentRev);
            this.screenLayoutText.pack();
        } else {
            this.screenLayoutText.setText(this.screenLayoutTextContent);
            this.screenLayoutText.pack();
        }
    }

    private class ScreenGraphInfo
    implements GraphInfo {
        private Image image;
        ScrolledComposite sc;
        private IPropertyChangeListener propertyChangeListener;

        public ScreenGraphInfo() {
            SharedImages.registerImage("screenLayout", "icons/screen_layout.png");
        }

        public EZEntityID getID() {
            return ScreenLayoutAnalysisJob.this.screenID;
        }

        public List getMenuItems() {
            return null;
        }

        public List getToolBarItems() {
            ArrayList<ContributionItem> contributionItemList = new ArrayList<ContributionItem>();
            ScreenLayoutAnalysisJob.this.contributeEdgesEntries(contributionItemList);
            return contributionItemList;
        }

        public Map getGlobalActionsContributions() {
            return null;
        }

        public MenuManager getContextManager() {
            return null;
        }

        public ContentViewer getViewer() {
            return null;
        }

        public Composite getControl() {
            return this.sc;
        }

        public CloseHook getCloseHook() {
            return ScreenLayoutAnalysisJob.this;
        }

        public Object getOverviewComponent() {
            return null;
        }

        public Set<StructureContentProvider> getContentProviders() {
            return null;
        }

        public Component getCanvasComponent() {
            return null;
        }

        public Image getImage() {
            this.image = SharedImages.getImage("screenLayout");
            return this.image;
        }

        public String getText() {
            EZSourceScreenIDSg ezSourceScreenIDSg = (EZSourceScreenIDSg)ScreenLayoutAnalysisJob.this.fileEntity.getSegment(EZSourceScreenIDSg.class);
            int screenType = ezSourceScreenIDSg.getScreenType();
            String screenName = "";
            switch (screenType) {
                case 119: {
                    screenName = String.valueOf(ezSourceScreenIDSg.getMapSet()) + " - " + ezSourceScreenIDSg.getScreenName();
                    break;
                }
                case 65: {
                    screenName = ezSourceScreenIDSg.getMapSet();
                    break;
                }
                case 118: 
                case 120: 
                case 121: {
                    screenName = ezSourceScreenIDSg.getScreenName();
                }
            }
            String lbl = Messages.getString(ScreenLayoutAnalysisJob.class, "tab.lbl", new String[]{screenName, ScreenLayoutAnalysisJob.this.projectInfo.getName()});
            L.debug("analysis tab name: {}", (Object)lbl);
            return lbl;
        }

        public String getTooltip() {
            return null;
        }

        public DirtyStatus getDirty() {
            return null;
        }

        public boolean hasLinkWithEditor() {
            return false;
        }

        public boolean hasLegend() {
            return false;
        }

        public ComponentBuilderInterface getLegendControl() {
            return null;
        }

        public void dispose() {
            if (this.sc != null) {
                this.sc.dispose();
            }
            this.removePropertyChangeListener();
            this.image = null;
            this.sc = null;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return null;
        }

        public boolean checkResourcesInAnalsysis(List<IResource> resources, DirtyStatus status) {
            return false;
        }

        public void updateInfoAdapter(GraphInfo cpy) {
            if (cpy instanceof ScreenGraphInfo) {
                ScreenGraphInfo copy = (ScreenGraphInfo)cpy;
                copy.sc.dispose();
                copy.removePropertyChangeListener();
            }
        }

        public boolean isLegendAvailable() {
            return false;
        }

        private void addPropertyChangeListener() {
            if (this.propertyChangeListener == null) {
                this.propertyChangeListener = new ScreenPropertyChangeListener();
                IPreferenceStore prefStore = JFacePreferences.getPreferenceStore();
                prefStore.addPropertyChangeListener(this.propertyChangeListener);
            }
        }

        private void removePropertyChangeListener() {
            if (this.propertyChangeListener != null) {
                IPreferenceStore prefStore = JFacePreferences.getPreferenceStore();
                prefStore.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.propertyChangeListener = null;
        }

        public boolean isReport() {
            return false;
        }
    }

    private class ScreenPropertyChangeListener
    implements IPropertyChangeListener {
        private ScreenPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.jface.textfont")) {
                if (ScreenLayoutAnalysisJob.this.screenLayoutText == null) {
                    L.info("screenLayoutText is null ");
                } else if (ScreenLayoutAnalysisJob.this.screenLayoutText.isDisposed()) {
                    L.info("screenLayoutText is disposed");
                } else {
                    ScreenLayoutAnalysisJob.this.screenLayoutText.setFont(JFaceResources.getTextFont());
                    ScreenLayoutAnalysisJob.this.screenLayoutText.pack();
                }
            }
        }
    }
}

