/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens.ui;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.ItemType;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.graphs.sapiens.ui.inputs.SapiensBaseInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensClassInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensFormInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensOperationInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensProgramInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensQueryInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensRulesetInput;
import com.ez.graphs.sapiens.ui.inputs.SapiensTableInput;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapiensInputsCollector
extends BridgeResourcesCollectorAdapter<SapiensBaseInput> {
    private static final Logger L = LoggerFactory.getLogger(SapiensInputsCollector.class);
    private static final String SPNS_Def_Form_Query = "SELECT RootID, FormNo, FormName, BlockCounter, MenuCounter FROM SPNS_FormDefinition WHERE RootID IN (select * from  #numeric_param_temp) ORDER BY FormNo";
    private static final String SPNS_Def_Class_Query = "SELECT SPNS_ClassDefinition.RootID, SPNS_ClassDefinition.ClassNo, SPNS_ClassDefinition.ClassName, SPNS_ClassInComposite.TableCreator, SPNS_ClassInComposite.TableName, SPNS_ClassInComposite.ParentClassNo, SPNS_ClassInComposite.CompositeNo, SPNS_CompositeDefinition.CompositeName, SPNS_CompositeDefinition.IOModuleName FROM SPNS_ClassDefinition INNER JOIN SPNS_ClassInComposite ON SPNS_ClassDefinition.RootID = SPNS_ClassInComposite.RootID \t\t\t\t\t\t\tAND SPNS_ClassDefinition.ClassNo = SPNS_ClassInComposite.ClassNo INNER JOIN SPNS_CompositeDefinition ON SPNS_ClassInComposite.RootID = SPNS_CompositeDefinition.RootID \t\t\t\t\t\t\tAND SPNS_ClassInComposite.CompositeNo = SPNS_CompositeDefinition.CompositeNo WHERE SPNS_ClassDefinition.RootID IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_Program_Query = "SELECT SPNS_ProgramDefinition.RootID, ProgramNo, ProgramID, ProgramName, [Language] FROM SPNS_ProgramDefinition WHERE SPNS_ProgramDefinition.RootID  IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_Query_Query = "SELECT SPNS_QueryDefinition.RootID, QueryNo, QueryName FROM SPNS_QueryDefinition WHERE SPNS_QueryDefinition.RootID IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_Ruleset_Query = "SELECT RootID, RulesetNo, RulesetName, ProgramID FROM SPNS_RulesetDefinition WHERE RootID IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_Operation_Query = "SELECT RootID, OperationNo, OperationName FROM SPNS_OperationDefinition \t\t\t\t\t\t\t\t\t\t\t\t\t\tWHERE RootID IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_Field_Query = "SELECT RootID, FieldNo, FieldName, DataType, FieldLength, PointDisplacement FROM SPNS_FieldDefinition WHERE RootID IN (select * from  #numeric_param_temp)";
    private static final String SPNS_Def_MenuOptionInForm_Query = "SELECT RootID, FormNo, OptionNo, CalledFormNo]SPNS_MenuOptionInForm FROM SPNS_MenuOptionInForm WHERE RootID IN (select * from  #numeric_param_temp)";
    private static List<ImageObj4Wizard> imagesObjsList;
    private Set<String> parameters = null;

    public List<SapiensBaseInput> collect(boolean useFilters, Set<String> apps, EZSourceConnection bridge) {
        ArrayList<SapiensBaseInput> componentsList = new ArrayList<SapiensBaseInput>();
        ArrayList<Integer> availableTypes = new ArrayList<Integer>();
        imagesObjsList = new ArrayList<ImageObj4Wizard>();
        try {
            String[][] prgResults;
            String[][] rulesetResults;
            String[][] queryResults;
            String[][] operationResults;
            String rootId;
            String[][] classResults;
            Object formName2;
            String rootId2;
            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.parameters.size()]);
            Collections.fill(types, EZSourceDataType.Integer);
            String[][] results = bridge.executeSQL(SPNS_Def_Form_Query, types, new ArrayList<String>(this.parameters));
            if (results != null && results.length > 0) {
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer menuCounter;
                    String[] result = stringArray[n2];
                    rootId2 = result[0];
                    String formNo = result[1];
                    formName2 = result[2];
                    Integer blockCounter = Integer.valueOf(result[3]);
                    SapiensFormInput formRes = new SapiensFormInput(rootId2, formNo, (String)formName2, blockCounter, menuCounter = Integer.valueOf(result[4]));
                    if (!availableTypes.contains(formRes.getTypeCode())) {
                        this.addImage(formRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(formRes);
                    ++n2;
                }
            }
            if ((classResults = bridge.executeSQL(SPNS_Def_Class_Query, types, new ArrayList<String>(this.parameters))) != null && results.length > 0) {
                HashSet<String> tables = new HashSet<String>();
                formName2 = classResults;
                int formNo = classResults.length;
                int n = 0;
                while (n < formNo) {
                    String[] result = formName2[n];
                    rootId = result[0];
                    String classNo = result[1];
                    String className = result[2];
                    String parentClassNo = result[5];
                    String compositeName = result[7];
                    String tableName = result[4];
                    SapiensClassInput classRes = new SapiensClassInput(rootId, classNo, className);
                    classRes.setParentClassName(compositeName);
                    classRes.setParentClassNo(parentClassNo);
                    if (tableName != null && !tableName.trim().isEmpty() && !tables.contains(tableName)) {
                        tables.add(tableName);
                        SapiensTableInput tableRes = new SapiensTableInput(rootId, null, tableName);
                        if (!availableTypes.contains(tableRes.getTypeCode())) {
                            this.addImage(tableRes, imagesObjsList, availableTypes);
                        }
                        componentsList.add(tableRes);
                    }
                    if (!availableTypes.contains(classRes.getTypeCode())) {
                        this.addImage(classRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(classRes);
                    ++n;
                }
            }
            if ((operationResults = bridge.executeSQL(SPNS_Def_Operation_Query, types, new ArrayList<String>(this.parameters))) != null && operationResults.length > 0) {
                formName2 = operationResults;
                int formNo = operationResults.length;
                int n = 0;
                while (n < formNo) {
                    String[] result = formName2[n];
                    rootId = result[0];
                    String operationNo = result[1];
                    String operationName = result[2];
                    SapiensOperationInput opRes = new SapiensOperationInput(rootId, operationNo, operationName);
                    if (!availableTypes.contains(opRes.getTypeCode())) {
                        this.addImage(opRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(opRes);
                    ++n;
                }
            }
            if ((queryResults = bridge.executeSQL(SPNS_Def_Query_Query, types, new ArrayList<String>(this.parameters))) != null && queryResults.length > 0) {
                String[][] stringArray = queryResults;
                int formName2 = queryResults.length;
                int formNo = 0;
                while (formNo < formName2) {
                    String[] result = stringArray[formNo];
                    String rootId3 = result[0];
                    String qNo = result[1];
                    String qName = result[2];
                    SapiensQueryInput qRes = new SapiensQueryInput(rootId3, qNo, qName);
                    if (!availableTypes.contains(qRes.getTypeCode())) {
                        this.addImage(qRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(qRes);
                    ++formNo;
                }
            }
            if ((rulesetResults = bridge.executeSQL(SPNS_Def_Ruleset_Query, types, new ArrayList<String>(this.parameters))) != null && rulesetResults.length > 0) {
                String[][] stringArray = rulesetResults;
                int n = rulesetResults.length;
                int formName2 = 0;
                while (formName2 < n) {
                    String[] result = stringArray[formName2];
                    rootId2 = result[0];
                    String rNo = result[1];
                    String rName = result[2];
                    SapiensRulesetInput rRes = new SapiensRulesetInput(rootId2, rNo, rName);
                    if (!availableTypes.contains(rRes.getTypeCode())) {
                        this.addImage(rRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(rRes);
                    ++formName2;
                }
            }
            if ((prgResults = bridge.executeSQL(SPNS_Def_Program_Query, types, new ArrayList<String>(this.parameters))) != null && prgResults.length > 0) {
                String[][] stringArray = prgResults;
                int n = prgResults.length;
                int n3 = 0;
                while (n3 < n) {
                    String[] result = stringArray[n3];
                    String rootId4 = result[0];
                    String pNo = result[1];
                    String pName = result[3];
                    SapiensProgramInput pRes = new SapiensProgramInput(rootId4, pNo, pName);
                    if (!availableTypes.contains(pRes.getTypeCode())) {
                        this.addImage(pRes, imagesObjsList, availableTypes);
                    }
                    componentsList.add(pRes);
                    ++n3;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return componentsList;
    }

    private void addImage(SapiensBaseInput input, List<ImageObj4Wizard> availableImages, List<Integer> availableTypes) {
        ImageDescriptor image_desc = input.getTypeImageDescriptor();
        String textType = input.getTypeText();
        ItemType type = new ItemType(input.getTypeCode());
        ImageObj4Wizard imageObj = new ImageObj4Wizard(type, textType, image_desc);
        availableImages.add(imageObj);
        availableTypes.add(input.getTypeCode());
    }

    public void setParameters(Set<String> parameters) {
        this.parameters = parameters;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return imagesObjsList;
    }
}

