/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens.model;

import com.ez.graphs.sapiens.model.PFActionForForm;
import com.ez.graphs.sapiens.model.SapiensBaseNode;
import com.ez.internal.id.EZSegment;
import com.ez.workspace.model.segments.EZSapiensFormIDSg;
import java.util.ArrayList;
import java.util.List;

public class SapiensFormNode
extends SapiensBaseNode {
    private List<PFActionForForm> pfActionList = new ArrayList<PFActionForForm>();
    public static final String FORM_BLOCK_COUNTER_KEY = "blockCounter";
    public static final String FORM_MENU_COUNTER_KEY = "MenuCounter";

    public SapiensFormNode(Integer rootId, String name, String no) {
        super(rootId, name, no);
    }

    public SapiensFormNode(EZSapiensFormIDSg formIdSg) {
        super(formIdSg.getRootId(), formIdSg.getFormName(), formIdSg.getFormNo());
        this.addFormProperties(formIdSg.getBlockCounter(), formIdSg.getMenuCounter());
        this.ezSegment = formIdSg;
    }

    public void addFormProperties(Integer blockCounter, Integer menuCounter) {
        this.addProperty(FORM_BLOCK_COUNTER_KEY, blockCounter);
        this.addProperty(FORM_MENU_COUNTER_KEY, menuCounter);
    }

    public Integer getFormBockCounter() {
        Object o;
        Integer formBlockCounter = null;
        if (this.properties != null && (o = this.properties.get(FORM_BLOCK_COUNTER_KEY)) != null) {
            formBlockCounter = (Integer)o;
        }
        return formBlockCounter;
    }

    public Integer getFormMenuCounter() {
        Object o;
        Integer formMenuCounter = null;
        if (this.properties != null && (o = this.properties.get(FORM_MENU_COUNTER_KEY)) != null) {
            formMenuCounter = (Integer)o;
        }
        return formMenuCounter;
    }

    @Override
    public SapiensBaseNode.SapiensType getComponentType() {
        return SapiensBaseNode.SapiensType.FORM;
    }

    public void addPFActionForForm(PFActionForForm pfAction) {
        this.pfActionList.add(pfAction);
    }

    public List<PFActionForForm> getPFActionList() {
        return this.pfActionList;
    }

    @Override
    public EZSegment getEZSegment() {
        if (this.ezSegment == null) {
            this.ezSegment = new EZSapiensFormIDSg(this.rootId, this.name, this.no);
            ((EZSapiensFormIDSg)this.ezSegment).setBlockCounter(this.getFormBockCounter());
            ((EZSapiensFormIDSg)this.ezSegment).setMenuCounter(this.getFormMenuCounter());
        }
        return this.ezSegment;
    }
}

