/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens.model;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.model.SapiensBaseNode;
import com.ez.internal.id.EZSegment;
import com.ez.workspace.model.segments.EZSapiensClassIDSg;

public class SapiensClassNode
extends SapiensBaseNode {
    public static final String PARENT_CLASS_NO_KEY = "parent of this class no";
    public static final String PARENT_CLASS_NAME_KEY = "parent of this class name";

    public SapiensClassNode(Integer rootId, String name, String no) {
        super(rootId, name, no);
    }

    public SapiensClassNode(EZSapiensClassIDSg classIDSg) {
        super(classIDSg.getRootId(), classIDSg.getClassName(), classIDSg.getClassNo());
        this.addProperty(PARENT_CLASS_NAME_KEY, classIDSg.getParentClassName());
        this.addProperty(PARENT_CLASS_NO_KEY, classIDSg.getParentClassNo());
        this.ezSegment = classIDSg;
    }

    @Override
    public SapiensBaseNode.SapiensType getComponentType() {
        return SapiensBaseNode.SapiensType.CLASS;
    }

    public String getParentClassNo() {
        return (String)this.properties.get(PARENT_CLASS_NO_KEY);
    }

    public String getParentClassName() {
        return (String)this.properties.get(PARENT_CLASS_NAME_KEY);
    }

    @Override
    public EZSegment getEZSegment() {
        if (this.ezSegment == null) {
            this.ezSegment = new EZSapiensClassIDSg(this.rootId, this.name, this.no);
            ((EZSapiensClassIDSg)this.ezSegment).setParentClassNo(this.getParentClassNo());
            ((EZSapiensClassIDSg)this.ezSegment).setParentClassName(this.getParentClassName());
        }
        return this.ezSegment;
    }

    @Override
    public String getNodeLabel() {
        String trimName = this.name.trim();
        String parentNo = this.getParentClassNo();
        String parentName = this.getParentClassName();
        if (trimName.length() > 0) {
            if (parentNo != null && parentNo.equalsIgnoreCase("0")) {
                if (parentName != null) {
                    return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "name.parentNo.parentName", new String[]{this.name.trim(), parentName.trim()});
                }
                return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "name.parentNo.parentName", new String[]{this.name.trim(), this.getName()});
            }
            if (parentName != null) {
                return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "name.parentName", new String[]{this.name.trim(), parentName.trim()});
            }
            return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "name.parentName", new String[]{this.name.trim(), this.getName()});
        }
        if (parentNo != null && parentNo.equalsIgnoreCase("0")) {
            if (parentName != null) {
                return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "parentNo.parentName", new String[]{parentName.trim()});
            }
            return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "parentNo.parentName", new String[]{this.getName()});
        }
        if (parentName != null) {
            return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "parentName", new String[]{parentName.trim()});
        }
        return String.valueOf(this.no) + " " + Messages.getString(SapiensClassNode.class, "parentName", new String[]{this.getName()});
    }
}

