/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens.model;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.SapiensConstants;
import com.ez.internal.id.EZSegment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SapiensBaseNode {
    protected HashMap<String, Object> properties = null;
    protected EZSegment ezSegment;
    protected Integer rootId;
    protected String name;
    protected String no;
    protected Map<SapiensConstants.ComponentRelationship, List<SapiensBaseNode>> relationsMap = new HashMap<SapiensConstants.ComponentRelationship, List<SapiensBaseNode>>();

    public SapiensBaseNode(Integer rootId, String name, String no) {
        this.rootId = rootId;
        this.name = name;
        this.no = no;
    }

    public abstract EZSegment getEZSegment();

    public boolean hasRelations() {
        return this.relationsMap.size() > 0;
    }

    public Set<SapiensConstants.ComponentRelationship> getRelationKeys() {
        if (this.hasRelations()) {
            return this.relationsMap.keySet();
        }
        return null;
    }

    public List<SapiensBaseNode> getNodes(SapiensConstants.ComponentRelationship key) {
        return this.relationsMap.get((Object)key);
    }

    public String getName() {
        return this.name;
    }

    public String getNo() {
        return this.no;
    }

    public Integer getRootId() {
        return this.rootId;
    }

    public void addRelation(SapiensConstants.ComponentRelationship key, SapiensBaseNode node) {
        List<SapiensBaseNode> nodes = this.relationsMap.get((Object)key);
        if (nodes == null) {
            nodes = new ArrayList<SapiensBaseNode>();
            this.relationsMap.put(key, nodes);
        }
        if (!nodes.contains(node)) {
            nodes.add(node);
        }
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public void addProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public String getNodeLabel() {
        StringBuilder sb = new StringBuilder(this.no);
        String trimName = this.name.trim();
        if (trimName.length() > 0) {
            sb.append("[");
            sb.append(this.name.trim());
            sb.append("]");
        }
        return sb.toString();
    }

    public abstract SapiensType getComponentType();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.no == null ? 0 : this.no.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SapiensBaseNode other = (SapiensBaseNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.no == null ? other.no != null : !this.no.equals(other.no)) {
            return false;
        }
        return !(this.rootId == null ? other.rootId != null : !this.rootId.equals(other.rootId));
    }

    public static enum SapiensType {
        FORM{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Form");
            }
        }
        ,
        OPERATION{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Operation");
            }
        }
        ,
        CLASS{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Class");
            }
        }
        ,
        MENU{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Menu");
            }
        }
        ,
        PROGRAM{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Program");
            }
        }
        ,
        RULESET{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Ruleset");
            }
        }
        ,
        QUERY{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.Query");
            }
        }
        ,
        PhysicalDBTable{

            public String toString() {
                return Messages.getString(SapiensBaseNode.class, "SapiensType.PhysicalDBTable");
            }
        };

    }
}

