/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.ui.SapiensInputsCollector;
import com.ez.graphs.sapiens.ui.SapiensRootCollector;
import com.ez.graphs.sapiens.ui.SapiensRootInput;
import com.ez.graphs.sapiens.ui.SapiensWizard;
import com.ez.graphs.sapiens.ui.inputs.SapiensBaseInput;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.mainframe.gui.wizard.SingleSelectionPage;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSapiensRootIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;

public class SapiensInputsFilter
extends ProjectInputsFilter {
    private static final String noResourceErrMsg = Messages.getString(SapiensInputsFilter.class, "err.message");
    private static final String SPNS_Graph_GetRootInfo = "SELECT SPNS_SapiensRoot.RootID, MFLPARInfo.MVSConnectionName, SPNS_SapiensRoot.LibraryName, SPNS_SapiensRoot.JobSkeletonMemberName FROM  MFLPARInfo INNER JOIN SPNS_SapiensRoot ON MFLPARInfo.LPARID = SPNS_SapiensRoot.LparID";

    protected PrepareReportWizard getWizard() {
        SapiensWizard wizard = new SapiensWizard();
        String wizardName = Messages.getString(SapiensInputsFilter.class, "wizzard.title");
        wizard.setWindowTitle(wizardName);
        SingleSelectionPage selectSapiensRootPage = new SingleSelectionPage("sapiens root page", false);
        SapiensRootCollector pc = new SapiensRootCollector();
        pc.setResourcesQuery(SPNS_Graph_GetRootInfo);
        selectSapiensRootPage.setResourcesCollector((ResourcesCollector)pc);
        selectSapiensRootPage.setLeftGroupLabel(Messages.getString(SapiensInputsFilter.class, "av.object.type"));
        selectSapiensRootPage.setRightGroupLabel(Messages.getString(SapiensInputsFilter.class, "sel.object.type"));
        selectSapiensRootPage.setTitle(Messages.getString(SapiensInputsFilter.class, "root.page.title"));
        selectSapiensRootPage.setDescription(Messages.getString(SapiensInputsFilter.class, "root.page.description"));
        selectSapiensRootPage.setSelectedPropName("selected sapiens root from library name - job member name");
        selectSapiensRootPage.setErrMsgNoResource(noResourceErrMsg);
        wizard.addPage((IWizardPage)selectSapiensRootPage);
        InputsWithSettingsPage selectSapiensInputsPage = new InputsWithSettingsPage("sapiens inputs page", true, true);
        SapiensInputsCollector sapiensC = new SapiensInputsCollector();
        selectSapiensInputsPage.setResourcesCollector((ResourcesCollector)sapiensC);
        selectSapiensInputsPage.setTitle(Messages.getString(SapiensInputsFilter.class, "page.title"));
        selectSapiensInputsPage.setDescription(Messages.getString(SapiensInputsFilter.class, "page.description"));
        selectSapiensInputsPage.setErrMsgNoResource(Messages.getString(SapiensInputsFilter.class, "err.message"));
        selectSapiensInputsPage.setLeftGroupLabel(Messages.getString(SapiensInputsFilter.class, "av.form.object.type"));
        selectSapiensInputsPage.setRightGroupLabel(Messages.getString(SapiensInputsFilter.class, "sel.form.object.type"));
        String limitGroupButtonText = Messages.getString(SapiensInputsFilter.class, "limit.group.txt");
        String limitGraphButtonText = Messages.getString(SapiensInputsFilter.class, "limit.graph.btn.txt");
        selectSapiensInputsPage.setLimitGraphText(limitGroupButtonText, limitGraphButtonText);
        wizard.addPage((IWizardPage)selectSapiensInputsPage);
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        }
        return wizard;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selected;
        List selectedRootList = wizard.getList("selected sapiens root from library name - job member name");
        EZSapiensRootIDSg rootIdSg = null;
        Iterator iterator = selectedRootList.iterator();
        if (iterator.hasNext()) {
            SapiensRootInput ri = (SapiensRootInput)((Object)iterator.next());
            rootIdSg = new EZSapiensRootIDSg(ri.getResourceID(), ri.getLibraryName(), ri.getJobSkeletonMemberName());
        }
        if ((selected = wizard.getList("selected resources")) != null) {
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo prjInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(prjInfo);
            for (SapiensBaseInput pi : selected) {
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                entity.addSegment((EZSegment)rootIdSg);
                EZSegment sapiensSg = pi.getEZIdSegment();
                entity.addSegment(sapiensSg);
                list.add(entity);
            }
            analysis.addContextValue("input_list", list);
            analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
        }
    }
}

