/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.SapiensConstants;
import com.ez.graphs.sapiens.TSENodeComparator;
import com.ez.graphs.sapiens.model.SapiensBaseNode;
import com.ez.graphs.sapiens.ui.SapiensNodeLegendInfo;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSapiensClass;
import com.ez.internal.analysis.config.inputs.EZSapiensForm;
import com.ez.internal.analysis.config.inputs.EZSapiensOperation;
import com.ez.internal.analysis.config.inputs.EZSapiensProgram;
import com.ez.internal.analysis.config.inputs.EZSapiensQuery;
import com.ez.internal.analysis.config.inputs.EZSapiensRuleset;
import com.ez.internal.analysis.config.inputs.EZSapiensTable;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.model.segments.EZSapiensClassIDSg;
import com.ez.workspace.model.segments.EZSapiensRootIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import images.LoadImageClsLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapiensGraphModel
extends AbstractAnalysisGraphModel {
    private Map<SapiensBaseNode.SapiensType, Map> inputSapiensNodesMap;
    private static final Logger L = LoggerFactory.getLogger(SapiensGraphModel.class);
    private ProjectInfo ezsourcePrj;
    private EZSapiensRootIDSg rootIdSg;

    public SapiensGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(SapiensGraphModel.class, "loading.graph"));
        this.initGraph();
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        LinkedList<SapiensBaseNode> toExpand = new LinkedList<SapiensBaseNode>();
        HashMap<SapiensBaseNode, TSENode> allTSNodes = new HashMap<SapiensBaseNode, TSENode>();
        HashSet<SapiensBaseNode> visitedComponents = new HashSet<SapiensBaseNode>();
        for (Map snodes : this.inputSapiensNodesMap.values()) {
            for (SapiensBaseNode sn : snodes.values()) {
                toExpand.clear();
                toExpand.add(sn);
                while (!toExpand.isEmpty()) {
                    SapiensBaseNode cNode = (SapiensBaseNode)toExpand.poll();
                    if (visitedComponents.contains(cNode)) continue;
                    L.debug("node to expand " + cNode.getName() + " type: " + (Object)((Object)cNode.getComponentType()));
                    visitedComponents.add(cNode);
                    TSENode tsNode = this.getOrCreateTSNode(cNode.getComponentType(), allTSNodes, cNode);
                    this.makeNodeRelationship(cNode, tsNode, allTSNodes, toExpand);
                }
            }
        }
    }

    private void makeNodeRelationship(SapiensBaseNode node, TSENode tsNode, Map<SapiensBaseNode, TSENode> allTSNodes, Queue<SapiensBaseNode> toExpand) {
        if (!node.hasRelations()) {
            return;
        }
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        for (SapiensConstants.ComponentRelationship key : node.getRelationKeys()) {
            List<SapiensBaseNode> components = node.getNodes(key);
            for (SapiensBaseNode rNode : components) {
                TSENode rTSNode = this.getOrCreateTSNode(key.getTargetNodeType(), allTSNodes, rNode);
                TSENode from = key.keepLinkDirection() ? tsNode : rTSNode;
                TSENode to = key.keepLinkDirection() ? rTSNode : tsNode;
                this.getOrCreateEdge(edgeBuilder, from, to, key.getEdgeTypeInfo());
            }
            toExpand.addAll(components);
        }
    }

    private TSEEdge getOrCreateEdge(TSEdgeBuilder edgeBuilder, TSENode from, TSENode to, IGraphEdgeLegendInfo edgeTypeInfo) {
        TSEEdge edge = null;
        List outs = from.outEdges();
        for (TSEEdge ed : outs) {
            if (!ed.getTargetNode().equals(to)) continue;
            edge = ed;
            break;
        }
        if (edge == null) {
            edge = edgeBuilder.addEdge(this.graphManager, from, to);
            edge.setAttribute("Color", (Object)edgeTypeInfo.getTSEColor());
            this.edgeTypesSetForLegend.add(edgeTypeInfo);
        }
        return edge;
    }

    private TSENode getOrCreateTSNode(SapiensBaseNode.SapiensType type, Map<SapiensBaseNode, TSENode> formTSNodes, SapiensBaseNode sapiensNode) {
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        TSENode tsNode = formTSNodes.get(sapiensNode);
        TSEColor fillColor = null;
        TSEColor textColor = null;
        EZSapiensForm applicableInputType = null;
        if (tsNode == null) {
            tsNode = nodeBuilder.addNode(this.graph);
            TSESVGImage svgimage = null;
            SapiensNodeLegendInfo nodeTypeInfo = null;
            switch (sapiensNode.getComponentType()) {
                case FORM: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.FORM.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.FORM.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.FORM.getTSEColor();
                    applicableInputType = new EZSapiensForm();
                    nodeTypeInfo = SapiensNodeLegendInfo.FORM;
                    break;
                }
                case OPERATION: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.OPERATION.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.OPERATION.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.OPERATION.getTSEColor();
                    applicableInputType = new EZSapiensOperation();
                    nodeTypeInfo = SapiensNodeLegendInfo.OPERATION;
                    break;
                }
                case QUERY: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.QUERY.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.QUERY.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.QUERY.getTSEColor();
                    textColor = TSEColor.white;
                    applicableInputType = new EZSapiensQuery();
                    nodeTypeInfo = SapiensNodeLegendInfo.QUERY;
                    break;
                }
                case PROGRAM: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.PROGRAM.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.PROGRAM.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.PROGRAM.getTSEColor();
                    textColor = TSEColor.white;
                    applicableInputType = new EZSapiensProgram();
                    nodeTypeInfo = SapiensNodeLegendInfo.PROGRAM;
                    break;
                }
                case RULESET: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.RULESET.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.RULESET.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.RULESET.getTSEColor();
                    applicableInputType = new EZSapiensRuleset();
                    nodeTypeInfo = SapiensNodeLegendInfo.RULESET;
                    break;
                }
                case MENU: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.MENU.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.MENU.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.MENU.getTSEColor();
                    nodeTypeInfo = SapiensNodeLegendInfo.MENU;
                    break;
                }
                case CLASS: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.CLASS.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.CLASS.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.CLASS.getTSEColor();
                    applicableInputType = new EZSapiensClass();
                    nodeTypeInfo = SapiensNodeLegendInfo.CLASS;
                    break;
                }
                case PhysicalDBTable: {
                    svgimage = LoadTSESVGImage.loadImage(LoadImageClsLoader.class, (String)SapiensNodeLegendInfo.PHYSICAL_DB_TABLE.getGraphImagePath());
                    tsNode.setAttribute("class_name", (Object)SapiensNodeLegendInfo.PHYSICAL_DB_TABLE.getNodeTypeClass());
                    fillColor = SapiensNodeLegendInfo.PHYSICAL_DB_TABLE.getTSEColor();
                    applicableInputType = new EZSapiensTable();
                    nodeTypeInfo = SapiensNodeLegendInfo.PHYSICAL_DB_TABLE;
                }
            }
            tsNode.setAttribute("Sapiens_Node", (Object)sapiensNode);
            tsNode.setAttribute("uiImage", (Object)svgimage);
            this.setNodeUI(tsNode, fillColor, textColor);
            String tagName = sapiensNode.getNodeLabel();
            tsNode.setName((Object)tagName);
            formTSNodes.put(sapiensNode, tsNode);
            if (sapiensNode.getProperty("node is input for callgraph") != null) {
                tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
                tsNode.setAttribute("Text_Color", (Object)TSEColor.blue);
            } else if (sapiensNode.getProperty("node is not expanded in callgraph") != null) {
                tsNode.setAttribute("node is not expanded in callgraph", (Object)Boolean.TRUE);
                tsNode.setAttribute("Text_Color", (Object)TSEColor.darkRed);
            }
            if (applicableInputType != null) {
                tsNode.setAttribute("APPLICABLE_INPUT", (Object)applicableInputType);
                EZEntityID entity = new EZEntityID();
                applicableInputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.ezsourcePrj));
                entity.addSegment((EZSegment)this.rootIdSg);
                EZSegment sapiensSg = sapiensNode.getEZSegment();
                entity.addSegment(sapiensSg);
            }
            this.putEntryInGraphInventory(nodeTypeInfo.getLegendLabel(), tsNode);
            this.nodeTypesSetForLegend.add(nodeTypeInfo);
        }
        return tsNode;
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        } else if (node.hasAttribute("node is not expanded in callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.darkRed);
        }
    }

    public void setNodeUI(TSENode node, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("Fill_Color", (Object)fillColor);
        if (textColor != null) {
            node.setAttribute("Color", (Object)textColor);
            if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                node.setAttribute("Text_Color", (Object)textColor);
            }
        }
        this.setNodeUI(node);
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    private void putEntryInGraphInventory(String lbl, TSENode node) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(lbl);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(lbl, nodes);
        }
        nodes.add(node);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return objType;
    }

    public void setEZSourcePrj(ProjectInfo ezsourcePrj) {
        this.ezsourcePrj = ezsourcePrj;
    }

    public void setRootIdSg(EZSapiensRootIDSg rootIdSg) {
        this.rootIdSg = rootIdSg;
    }

    public void setSapiensInputNodes(Map<SapiensBaseNode.SapiensType, Map> inputsMap) {
        this.inputSapiensNodesMap = inputsMap;
    }

    public void writeGraphToFile(TSEGraph graph, List<EZSegment> fileName, String pathSelected) {
        block11: {
            EZSapiensRootIDSg programName;
            String prgName = "";
            if (fileName.get(1) instanceof EZSapiensRootIDSg) {
                programName = (EZSapiensRootIDSg)fileName.get(1);
                prgName = String.valueOf(programName.getJobMemberName()) + "-" + programName.getLibraryName();
            }
            if (fileName.get(2) instanceof EZSapiensClassIDSg) {
                programName = (EZSapiensClassIDSg)fileName.get(2);
                prgName = String.valueOf(prgName) + "-" + programName.getClassNo() + "-" + programName.getClassName();
            }
            String pathToWrite = String.valueOf(pathSelected) + "/" + prgName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block11;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + prgName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("Sapiens_Node") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                value.append("Statement Type: ");
                value.append(stmtType);
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

