/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens;

import com.ez.cobol.callgraph.utils.IConnectionRunnable;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.SapiensConstants;
import com.ez.graphs.sapiens.SapiensGraphModel;
import com.ez.graphs.sapiens.model.PFActionForForm;
import com.ez.graphs.sapiens.model.RuleWithinRuleset;
import com.ez.graphs.sapiens.model.SapiensBaseNode;
import com.ez.graphs.sapiens.model.SapiensClassNode;
import com.ez.graphs.sapiens.model.SapiensFormNode;
import com.ez.graphs.sapiens.model.SapiensMenuNode;
import com.ez.graphs.sapiens.model.SapiensOperationNode;
import com.ez.graphs.sapiens.model.SapiensProgramNode;
import com.ez.graphs.sapiens.model.SapiensQueryNode;
import com.ez.graphs.sapiens.model.SapiensRulesetNode;
import com.ez.graphs.sapiens.model.SapiensTableNode;
import com.ez.graphs.sapiens.ui.SapiensMouseActionsHook;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSapiensClassIDSg;
import com.ez.workspace.model.segments.EZSapiensFormIDSg;
import com.ez.workspace.model.segments.EZSapiensOperationIDSg;
import com.ez.workspace.model.segments.EZSapiensProgramIDSg;
import com.ez.workspace.model.segments.EZSapiensQueryIDSg;
import com.ez.workspace.model.segments.EZSapiensRootIDSg;
import com.ez.workspace.model.segments.EZSapiensRulesetIDSg;
import com.ez.workspace.model.segments.EZSapiensTableIDSg;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapiensGraphAnalysisJob
extends GraphAnalysisJob
implements IConnectionRunnable {
    private static final Logger L = LoggerFactory.getLogger(SapiensGraphAnalysisJob.class);
    private SapiensMouseActionsHook mouseActionsHook = null;
    private static final String Form_VS_CallingForm_Using_MenuOption_SP_Name = "EZViewer_Sapiens_Form_Vs_CallingForm_Via_MenuOption";
    private static final String Form_VS_CalledForm_Using_MenuOption_SP_Name = "EZViewer_Sapiens_Form_Vs_CalledForm_Via_MenuOption";
    private static final String Form_VS_CalledForm_Using_PF_SP_Name = "EZViewer_Sapiens_Form_Vs_CalledForm_Via_PF";
    private static final String Form_VS_CallingForm_Using_PF_SP_Name = "EZViewer_Sapiens_Form_Vs_CallingForm_Via_PF";
    private static final String Form_VS_CallingForm_Using_BlockInForm_SP_Name = "EZViewer_Sapiens_Form_Vs_CallingForm_Via_BlockInForm";
    private static final String Form_VS_CalledForm_Using_BlockInForm_SP_Name = "EZViewer_Sapiens_Form_Vs_CalledForm_Via_BlockInForm";
    private static final String Form_VS_Operation_SP_Name = "EZViewer_Sapiens_Form_Vs_Operation";
    private static final String Form_VS_Query_Using_BlockInForm_SP_Name = "EZViewer_Sapiens_Forms_Vs_Query_Via_BlockInForm";
    private static final String Form_VS_Program_Using_BlockInForm_SP_Name = "EZViewer_Sapiens_Forms_Vs_Program_Via_BlockInForm";
    private static final String Form_VS_Ruleset_SP_Name = "EZViewer_Sapiens_Forms_Vs_Ruleset";
    private static final String Ruleset_VS_Class_SP_Name = "EZViewer_Sapiens_Ruleset_Vs_Classes";
    private static final String Operation_VS_Class_SP_Name = "EZViewer_Sapiens_Operation_Vs_Classes";
    private static final String Program_VS_Ruleset_SP_Name = "EZViewer_Sapiens_Program_Vs_Ruleset";
    private static final String Query_VS_Ruleset_SP_Name = "EZViewer_Sapiens_Query_Vs_Ruleset";
    private static final String Operation_VS_Ruleset_SP_Name = "EZViewer_Sapiens_Operation_Vs_Ruleset";
    private static final String Classes_VS_Ruleset_SP_Name = "EZViewer_Sapiens_Classes_Vs_Ruleset";
    private static final String Ruleset_VS_Rulesets_CalledViaRule_SP_Name = "EZViewer_Sapiens_Ruleset_Vs_Rulesets_CalledViaRule";
    private static final String Classes_VS_Class_SP_Name = "EZViewer_Sapiens_Classes_Vs_Classes";
    private static final String Program_VS_OutputForm_SP_Name = "EZViewer_Sapiens_Program_Vs_OutputForm";
    private static final String Query_VS_OutputForm_SP_Name = "EZViewer_Sapiens_Query_Vs_OutputForm";
    private static final String Classes_VS_Table_SP_Name = "EZViewer_Sapiens_Classes_Vs_Table";
    private static final String Table_VS_Classes_B_SP_Name = "EZViewer_SapiensBack_Tables_Vs_Classes";
    private static final String Classes_VS_Ruleset_B_SP_Name = "EZViewer_SapiensBack_Classes_Vs_Ruleset";
    private static final String Ruleset_VS_Rulesets_CalledViaRule_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Rulesets_CalledViaRule";
    private static final String Classes_VS_Class_B_SP_Name = "EZViewer_SapiensBack_Classes_Vs_Classes";
    private static final String Ruleset_VS_Class_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Classes";
    private static final String Classes_VS_Operation_B_SP_Name = "EZViewer_SapiensBack_Classes_Vs_Operation";
    private static final String Ruleset_VS_Forms_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Forms";
    private static final String Operation_VS_Forms_B_SP_Name = "EZViewer_SapiensBack_Operation_Vs_Forms";
    private static final String Ruleset_VS_Query_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Query";
    private static final String Query_VS_Forms_B_SP_Name = "EZViewer_SapiensBack_Query_Vs_Forms";
    private static final String Ruleset_VS_Program_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Program";
    private static final String Program_VS_Forms_B_SP_Name = "EZViewer_SapiensBack_Program_Vs_Form_Via_BlockInForm";
    private static final String OutputForm_VS_Query_B_SP_Name = "EZViewer_SapiensBack_OutputForm_Vs_Query";
    private static final String OutputForm_VS_Program_B_SP_Name = "EZViewer_SapiensBack_OutputForm_Vs_Program";
    private static final String Ruleset_VS_Operation_B_SP_Name = "EZViewer_SapiensBack_Ruleset_Vs_Operation";
    private static final String RuleWithinRuleset_SP_Name = "EZViewer_Sapiens_RuleWithinRuleset";
    private static final String PFActionsForForm_SP_Name = "EZViewer_Sapiens_PFActionsForForm";
    private Map<SapiensBaseNode.SapiensType, Map> inputsMap = new HashMap<SapiensBaseNode.SapiensType, Map>();
    private Direction graphDirection;
    private Boolean isGraphLimited;
    private Integer graphLimitation = null;
    private EZSapiensRootIDSg rootIDSg;
    private static final int MAXNAMES = 3;

    public SapiensGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new SapiensMouseActionsHook();
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new SapiensGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphModel = new SapiensGraphModel(new AnalysisGraphManager());
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        this.graphDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("callgraph direction: " + this.graphDirection);
        this.isGraphLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isGraphLimited != null && this.isGraphLimited.booleanValue()) {
            this.graphLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: " + this.graphLimitation);
        } else {
            L.debug("callgraph isn't limited");
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        L.debug("sapiens graph - computeResults");
        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        ((SapiensGraphModel)graphModel).setEZSourcePrj(ezsourcePrj);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(SapiensGraphAnalysisJob.class, "collectingData.taskName"));
        IStatus status = Utils.collectDataFromBridge((IProgressMonitor)pmonitor.newChild(100), (String)ezsourcePrj.getName(), (IConnectionRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        } else {
            pmonitor.setWorkRemaining(0);
        }
    }

    public void runWithProgress(EZSourceConnection conn, IProgressMonitor monitor) {
        L.debug("sapiens graph - run with progress");
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        monitor.setTaskName(Messages.getString(SapiensGraphAnalysisJob.class, "compute.taskName"));
        this.inputsMap.clear();
        List inputs = this.analysis.getContextListValue("input_list");
        Object path = this.analysis.getContextValue("selected path");
        if (path != null && !path.toString().trim().equals("")) {
            for (EZEntityID input : inputs) {
                ArrayList<EZEntityID> singleInput = new ArrayList<EZEntityID>();
                singleInput.add(input);
                this.processInputs(singleInput);
                L.debug("graph starts on sapiens subsystem: " + this.rootIDSg);
                ((SapiensGraphModel)this.graphModel).setRootIdSg(this.rootIDSg);
                String[] rootIdParam = new String[]{String.valueOf(this.rootIDSg.getRootId())};
                HashMap<SapiensBaseNode.SapiensType, Map> allNodesMap = new HashMap<SapiensBaseNode.SapiensType, Map>();
                for (SapiensBaseNode.SapiensType type : this.inputsMap.keySet()) {
                    Map byTypeMap = this.inputsMap.get((Object)type);
                    for (Integer no : byTypeMap.keySet()) {
                        SapiensBaseNode sapiensNode = (SapiensBaseNode)byTypeMap.get(no);
                        sapiensNode.addProperty("node is input for callgraph", Boolean.TRUE);
                        this.addSapiensNode(type, allNodesMap, no, sapiensNode);
                    }
                }
                if (this.graphLimitation != null) {
                    L.debug("calgraph is limited and limit is " + this.graphLimitation);
                }
                Boolean isForward = Direction.doForward((Direction)this.graphDirection);
                Boolean isBackward = Direction.doBackward((Direction)this.graphDirection);
                if (isForward.booleanValue()) {
                    this.createForwardGraph(conn, rootIdParam, allNodesMap, (IProgressMonitor)pmonitor);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                if (isBackward.booleanValue()) {
                    this.createBackwardGraph(conn, rootIdParam, allNodesMap, pmonitor);
                }
                pmonitor.setWorkRemaining(200);
                this.computeRuleWithinRuleset(conn, rootIdParam, allNodesMap, pmonitor.newChild(100));
                this.computePFActionsForForm(conn, rootIdParam, allNodesMap, pmonitor.newChild(100));
                ((SapiensGraphModel)this.graphModel).setSapiensInputNodes(this.inputsMap);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((SapiensGraphModel)this.graphModel).writeGraphToFile(newGraph, input.getSegments(), path.toString());
                ((SapiensGraphModel)this.graphModel).setRootIdSg(null);
                this.inputsMap.clear();
                newGraph.dispose();
            }
        } else {
            this.processInputs(inputs);
            L.debug("graph starts on sapiens subsystem: " + this.rootIDSg);
            ((SapiensGraphModel)this.graphModel).setRootIdSg(this.rootIDSg);
            String[] rootIdParam = new String[]{String.valueOf(this.rootIDSg.getRootId())};
            HashMap<SapiensBaseNode.SapiensType, Map> allNodesMap = new HashMap<SapiensBaseNode.SapiensType, Map>();
            for (SapiensBaseNode.SapiensType type : this.inputsMap.keySet()) {
                Map byTypeMap = this.inputsMap.get((Object)type);
                for (Object no : byTypeMap.keySet()) {
                    SapiensBaseNode sapiensNode = (SapiensBaseNode)byTypeMap.get(no);
                    sapiensNode.addProperty("node is input for callgraph", Boolean.TRUE);
                    if (type == SapiensBaseNode.SapiensType.PhysicalDBTable) {
                        this.addSapiensNode(type, allNodesMap, no.toString(), sapiensNode);
                        continue;
                    }
                    try {
                        this.addSapiensNode(type, allNodesMap, Integer.valueOf(no.toString()), sapiensNode);
                    }
                    catch (NumberFormatException numberFormatException) {
                        L.error("invalid conversion of Sapiens input resource from string to integer.");
                    }
                }
            }
            if (this.graphLimitation != null) {
                L.debug("calgraph is limited and limit is " + this.graphLimitation);
            }
            Boolean isForward = Direction.doForward((Direction)this.graphDirection);
            Boolean isBackward = Direction.doBackward((Direction)this.graphDirection);
            if (isForward.booleanValue()) {
                this.createForwardGraph(conn, rootIdParam, allNodesMap, (IProgressMonitor)pmonitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (isBackward.booleanValue()) {
                this.createBackwardGraph(conn, rootIdParam, allNodesMap, pmonitor);
            }
            pmonitor.setWorkRemaining(200);
            this.computeRuleWithinRuleset(conn, rootIdParam, allNodesMap, pmonitor.newChild(100));
            this.computePFActionsForForm(conn, rootIdParam, allNodesMap, pmonitor.newChild(100));
            ((SapiensGraphModel)this.graphModel).setSapiensInputNodes(this.inputsMap);
        }
        pmonitor.done();
    }

    private void createForwardGraph(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1000);
        monitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.forward.taskName"));
        Map rulesets = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.RULESET);
        HashSet<Object> rulesetParams = rulesets != null ? new HashSet<Object>(rulesets.keySet()) : new HashSet();
        Map classes = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.CLASS);
        HashSet<Object> classesParams = classes != null ? new HashSet<Object>(classes.keySet()) : new HashSet();
        Map operations = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.OPERATION);
        HashSet operationParams = operations != null ? new HashSet(operations.keySet()) : new HashSet();
        Map queries = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.QUERY);
        HashSet<Object> queriesParams = queries != null ? new HashSet<Object>(queries.keySet()) : new HashSet();
        Map programs = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.PROGRAM);
        HashSet<Object> programParams = programs != null ? new HashSet<Object>(programs.keySet()) : new HashSet();
        Map forms = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.FORM);
        HashSet<Object> formParams = forms != null ? new HashSet<Object>(forms.keySet()) : new HashSet();
        this.createFormPrgQueryTree(conn, rootIdParam, allNodesMap, false, queriesParams, programParams, formParams, (IProgressMonitor)monitor.newChild(200));
        monitor.setWorkRemaining(800);
        if (!monitor.isCanceled() && !formParams.isEmpty()) {
            String[][] formVsOperationResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_Operation_SP_Name, (String[])rootIdParam, formParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            SapiensBaseNode.SapiensType type = SapiensBaseNode.SapiensType.FORM;
            SapiensConstants.ComponentRelationship relation = SapiensConstants.ComponentRelationship.FORM_VS_OPERATIONS_ATTR_KEY;
            Set operationFromFormParams = this.processOperationResults(formVsOperationResults, type, relation, allNodesMap);
            operationParams.addAll(operationFromFormParams);
            String[][] formVsRulesetResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_Ruleset_SP_Name, (String[])rootIdParam, formParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            Set rulesetFromFormParams = this.processRuleSetResults(formVsRulesetResults, SapiensBaseNode.SapiensType.FORM, SapiensConstants.ComponentRelationship.FORM_VS_RULESETS_ATTR_KEY, allNodesMap);
            rulesetParams.addAll(rulesetFromFormParams);
        }
        monitor.setWorkRemaining(600);
        if (!monitor.isCanceled() && !operationParams.isEmpty()) {
            monitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.operation.taskName"));
            String[][] operationsVsClassesResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Operation_VS_Class_SP_Name, (String[])rootIdParam, operationParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            Set classFromOperationParams = this.processClassesResults(operationsVsClassesResults, SapiensBaseNode.SapiensType.OPERATION, SapiensConstants.ComponentRelationship.OPERATION_VS_CLASSES_ATTR_KEY, allNodesMap);
            classesParams.addAll(classFromOperationParams);
            String[][] operationsVsRulesetResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Operation_VS_Ruleset_SP_Name, (String[])rootIdParam, operationParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            Set rulesetFromOperationParams = this.processRuleSetResults(operationsVsRulesetResults, SapiensBaseNode.SapiensType.OPERATION, SapiensConstants.ComponentRelationship.OPERATION_VS_RULESETS_ATTR_KEY, allNodesMap);
            rulesetParams.addAll(rulesetFromOperationParams);
        }
        monitor.setWorkRemaining(400);
        if (!monitor.isCanceled() && !queriesParams.isEmpty()) {
            pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.query.taskName"));
            String[][] queryVsRulesets = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Query_VS_Ruleset_SP_Name, (String[])rootIdParam, queriesParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            Set rulesetFromQueryParams = this.processRuleSetResults(queryVsRulesets, SapiensBaseNode.SapiensType.QUERY, SapiensConstants.ComponentRelationship.QUERY_VS_RULESETS_ATTR_KEY, allNodesMap);
            rulesetParams.addAll(rulesetFromQueryParams);
        }
        monitor.setWorkRemaining(300);
        if (!monitor.isCanceled() && !programParams.isEmpty()) {
            pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.program.taskName"));
            String[][] prgVsRulesetResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Program_VS_Ruleset_SP_Name, (String[])rootIdParam, programParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
            Set rulesetFromPrgParams = this.processRuleSetResults(prgVsRulesetResults, SapiensBaseNode.SapiensType.PROGRAM, SapiensConstants.ComponentRelationship.PROGRAM_VS_RULESETS_ATTR_KEY, allNodesMap);
            rulesetParams.addAll(rulesetFromPrgParams);
        }
        monitor.setWorkRemaining(200);
        this.createRulesetClassTree(conn, rootIdParam, allNodesMap, rulesetParams, classesParams, false, monitor.newChild(100));
        monitor.setWorkRemaining(100);
        if (!monitor.isCanceled() && !classesParams.isEmpty()) {
            String[][] classVsTableResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Classes_VS_Table_SP_Name, (String[])rootIdParam, classesParams, (EZSourceDataType)EZSourceDataType.String, (IProgressMonitor)monitor.newChild(100));
            this.processTableResults(classVsTableResults, SapiensBaseNode.SapiensType.CLASS, SapiensConstants.ComponentRelationship.CLASS_VS_TABLE_ATTR_KEY, allNodesMap);
        }
        monitor.done();
    }

    private void createBackwardGraph(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, SubMonitor monitor) {
        SapiensConstants.ComponentRelationship relation;
        SapiensBaseNode.SapiensType type;
        HashSet<Object> formParams;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.backward.taskName"));
        Map rulesets = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.RULESET);
        HashSet<Object> rulesetParams = rulesets != null ? new HashSet<Object>(rulesets.keySet()) : new HashSet();
        Map classes = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.CLASS);
        HashSet<Object> classesParams = classes != null ? new HashSet<Object>(classes.keySet()) : new HashSet();
        Map operations = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.OPERATION);
        HashSet operationParams = operations != null ? new HashSet(operations.keySet()) : new HashSet();
        Map queries = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.QUERY);
        HashSet<Object> queriesParams = queries != null ? new HashSet<Object>(queries.keySet()) : new HashSet();
        Map programs = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.PROGRAM);
        HashSet<Object> programParams = programs != null ? new HashSet<Object>(programs.keySet()) : new HashSet();
        Map tables = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.PhysicalDBTable);
        HashSet tableParams = tables != null ? new HashSet(tables.keySet()) : new HashSet();
        Map forms = this.inputsMap.get((Object)SapiensBaseNode.SapiensType.FORM);
        HashSet<Object> hashSet = formParams = forms != null ? new HashSet<Object>(forms.keySet()) : new HashSet();
        if (!monitor.isCanceled() && !tableParams.isEmpty()) {
            for (SapiensBaseNode tableNode : tables.values()) {
                String tableName = tableNode.getName();
                this.addSapiensNode(SapiensBaseNode.SapiensType.PhysicalDBTable, allNodesMap, tableName, tableNode);
            }
            String[][] tableToClassesResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Table_VS_Classes_B_SP_Name, (String[])rootIdParam, tableParams, (EZSourceDataType)EZSourceDataType.String, (IProgressMonitor)pmonitor.newChild(100));
            if (tableToClassesResults != null && tableToClassesResults.length > 0) {
                pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.table.taskName"));
                String[][] stringArray = tableToClassesResults;
                int n = tableToClassesResults.length;
                int tableName = 0;
                while (tableName < n) {
                    String[] result = stringArray[tableName];
                    Integer rootId = Integer.valueOf(result[0]);
                    String name = result[4];
                    SapiensBaseNode tableNode = this.getSapiensNode(SapiensBaseNode.SapiensType.PhysicalDBTable, allNodesMap, name);
                    String classNo = result[2];
                    String className = result[5];
                    SapiensBaseNode classNode = this.getSapiensNode(SapiensBaseNode.SapiensType.CLASS, allNodesMap, classNo);
                    if (classNode == null) {
                        classNode = new SapiensClassNode(rootId, className, classNo);
                        String parentClassNo = result[7];
                        L.debug("parentClassNo = " + parentClassNo);
                        classNode.addProperty("parent of this class no", parentClassNo);
                        if (!parentClassNo.equalsIgnoreCase("0")) {
                            classNode.addProperty("parent of this class name", result[8]);
                        }
                        this.addSapiensNode(SapiensBaseNode.SapiensType.CLASS, allNodesMap, classNo, classNode);
                        classesParams.add(classNo);
                    }
                    tableNode.addRelation(SapiensConstants.ComponentRelationship.B_TABLE_VS_CLASS_ATTR_KEY, classNode);
                    ++tableName;
                }
            }
        }
        this.createRulesetClassTree(conn, rootIdParam, allNodesMap, rulesetParams, classesParams, true, pmonitor.newChild(100));
        pmonitor.setWorkRemaining(800);
        if (!monitor.isCanceled() && !classesParams.isEmpty()) {
            pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.class.taskName"));
            String[][] clVsOperationResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Classes_VS_Operation_B_SP_Name, (String[])rootIdParam, classesParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.CLASS;
            relation = SapiensConstants.ComponentRelationship.B_CLASSES_VS_OPERATION_ATTR_KEY;
            Set operationFromClassParams = this.processOperationResults(clVsOperationResults, type, relation, allNodesMap);
            operationParams.addAll(operationFromClassParams);
        }
        pmonitor.setWorkRemaining(700);
        if (!monitor.isCanceled() && !rulesetParams.isEmpty()) {
            pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.ruleset.taskName"));
            String[][] rulsetVsFormResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Ruleset_VS_Forms_B_SP_Name, (String[])rootIdParam, rulesetParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.RULESET;
            relation = SapiensConstants.ComponentRelationship.B_RULESET_VS_FORMS_ATTR_KEY;
            Set formFromRulesetParams = this.processBackFormResults(rulsetVsFormResults, type, relation, allNodesMap);
            formParams.addAll(formFromRulesetParams);
            String[][] rulsetVsPrgResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Ruleset_VS_Program_B_SP_Name, (String[])rootIdParam, rulesetParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.RULESET;
            relation = SapiensConstants.ComponentRelationship.B_RULESET_VS_PROGRAM_ATTR_KEY;
            Set prgFromRulesetParams = this.processProgramResults(rulsetVsPrgResults, type, relation, allNodesMap);
            programParams.addAll(prgFromRulesetParams);
            String[][] rulesetVsQueryResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Ruleset_VS_Query_B_SP_Name, (String[])rootIdParam, rulesetParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.RULESET;
            relation = SapiensConstants.ComponentRelationship.B_RULESET_VS_QUERIES_ATTR_KEY;
            Set queriesFromRulesetParams = this.processQueriesResults(rulesetVsQueryResults, type, relation, allNodesMap);
            queriesParams.addAll(queriesFromRulesetParams);
            String[][] rulesetVsOperationResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Ruleset_VS_Operation_B_SP_Name, (String[])rootIdParam, rulesetParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.RULESET;
            relation = SapiensConstants.ComponentRelationship.B_RULESET_VS_OPERATION_ATTR_KEY;
            Set opFromRulesetParams = this.processOperationResults(rulesetVsOperationResults, type, relation, allNodesMap);
            operationParams.addAll(opFromRulesetParams);
        }
        pmonitor.setWorkRemaining(300);
        if (!monitor.isCanceled() && !operationParams.isEmpty()) {
            pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.operation.taskName"));
            String[][] opVsFormResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Operation_VS_Forms_B_SP_Name, (String[])rootIdParam, operationParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
            type = SapiensBaseNode.SapiensType.OPERATION;
            relation = SapiensConstants.ComponentRelationship.B_OPERATION_VS_FORMS_ATTR_KEY;
            Set formFromOpParams = this.processBackFormResults(opVsFormResults, type, relation, allNodesMap);
            formParams.addAll(formFromOpParams);
        }
        pmonitor.setWorkRemaining(200);
        this.createFormPrgQueryTree(conn, rootIdParam, allNodesMap, true, queriesParams, programParams, formParams, (IProgressMonitor)pmonitor.newChild(200));
        pmonitor.done();
    }

    private void createFormPrgQueryTree(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, boolean isBack, Set<Object> queriesParams, Set<Object> programParams, Set<Object> formParams, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        HashSet<Object> localFormParams = new HashSet<Object>();
        localFormParams.addAll(formParams);
        HashSet<Object> localPrgParams = new HashSet<Object>();
        localPrgParams.addAll(programParams);
        HashSet<Object> localQueryParams = new HashSet<Object>();
        localQueryParams.addAll(queriesParams);
        monitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.form.taskName"));
        int step = 0;
        boolean run = true;
        while (!monitor.isCanceled() && !localFormParams.isEmpty() || !localPrgParams.isEmpty() || !localQueryParams.isEmpty()) {
            SapiensBaseNode.SapiensType type;
            List<Object> localTreeForm = this.createFormTree(conn, localFormParams, rootIdParam, allNodesMap, isBack, monitor.newChild(100));
            if (localTreeForm != null && !localTreeForm.isEmpty()) {
                type = SapiensBaseNode.SapiensType.FORM;
                String[][] formVsQueryResults = null;
                SapiensConstants.ComponentRelationship relation = null;
                if (isBack) {
                    formVsQueryResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)OutputForm_VS_Query_B_SP_Name, (String[])rootIdParam, localTreeForm, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    relation = SapiensConstants.ComponentRelationship.B_OUTPUTFORM_VS_QUERY_ATTR_KEY;
                } else {
                    formVsQueryResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_Query_Using_BlockInForm_SP_Name, (String[])rootIdParam, localTreeForm, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    relation = SapiensConstants.ComponentRelationship.FORM_VS_QUERIES_VIA_BLOCKINFORM_ATTR_KEY;
                }
                Set queriesFromFormParams = this.processQueriesResults(formVsQueryResults, type, relation, allNodesMap);
                localQueryParams.addAll(queriesFromFormParams);
                String[][] formVsPrgResults = null;
                if (isBack) {
                    formVsPrgResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)OutputForm_VS_Program_B_SP_Name, (String[])rootIdParam, localTreeForm, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    relation = SapiensConstants.ComponentRelationship.B_OUTPUTFORM_VS_PROGRAM_ATTR_KEY;
                } else {
                    formVsPrgResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_Program_Using_BlockInForm_SP_Name, (String[])rootIdParam, localTreeForm, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    relation = SapiensConstants.ComponentRelationship.FORM_VS_PROGRAMS_VIA_BLOCKINFORM_ATTR_KEY;
                }
                Set prgFromOutputFormParams = this.processProgramResults(formVsPrgResults, type, relation, allNodesMap);
                localPrgParams.addAll(prgFromOutputFormParams);
                formParams.addAll(localTreeForm);
            }
            localFormParams.clear();
            if (!localQueryParams.isEmpty()) {
                monitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.query.taskName"));
                Set formFromQueriesParams = null;
                SapiensBaseNode.SapiensType type2 = SapiensBaseNode.SapiensType.QUERY;
                if (isBack) {
                    String[][] qVsFormResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Query_VS_Forms_B_SP_Name, (String[])rootIdParam, localQueryParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    formFromQueriesParams = this.processBackFormResults(qVsFormResults, type2, SapiensConstants.ComponentRelationship.B_QUERY_VS_FORMS_ATTR_KEY, allNodesMap);
                } else {
                    String[][] queryVsOutputForm = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Query_VS_OutputForm_SP_Name, (String[])rootIdParam, localQueryParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    formFromQueriesParams = this.processOutputFormResults(queryVsOutputForm, type2, SapiensConstants.ComponentRelationship.QUERY_VS_OUTPUTFORM_VIA_BLOCKINFORM_ATTR_KEY, allNodesMap);
                }
                localFormParams.addAll(formFromQueriesParams);
                formParams.addAll(localFormParams);
                queriesParams.addAll(localQueryParams);
            }
            localQueryParams.clear();
            if (!localPrgParams.isEmpty()) {
                monitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.program.taskName"));
                type = SapiensBaseNode.SapiensType.PROGRAM;
                Set formFromPrgParams = null;
                if (isBack) {
                    String[][] pVsFormResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Program_VS_Forms_B_SP_Name, (String[])rootIdParam, localPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    formFromPrgParams = this.processBackFormResults(pVsFormResults, type, SapiensConstants.ComponentRelationship.B_PROGRAM_VS_FORMS_ATTR_KEY, allNodesMap);
                } else {
                    String[][] prgVsOutputResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Program_VS_OutputForm_SP_Name, (String[])rootIdParam, localPrgParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)monitor.newChild(100));
                    formFromPrgParams = this.processOutputFormResults(prgVsOutputResults, type, SapiensConstants.ComponentRelationship.PROGRAM_VS_OUTPUTFORM_ATTR_KEY, allNodesMap);
                }
                localFormParams.addAll(formFromPrgParams);
                formParams.addAll(formFromPrgParams);
                programParams.addAll(localPrgParams);
            }
            localPrgParams.clear();
            boolean bl = run = this.graphLimitation == null || step < this.graphLimitation;
            if (!run) {
                this.markUnexpandedGraphNodes(conn, localFormParams, SapiensBaseNode.SapiensType.FORM, allNodesMap);
            }
            ++step;
        }
    }

    private void processInputs(List<EZEntityID> inputs) {
        for (EZEntityID entity : inputs) {
            EZSapiensTableIDSg tIdSg;
            EZSapiensRulesetIDSg rIdSg;
            EZSapiensProgramIDSg pIdSg;
            EZSapiensOperationIDSg opIdSg;
            EZSapiensQueryIDSg qIdSg;
            EZSapiensClassIDSg classIdSg;
            EZSapiensFormIDSg formIdSg;
            SapiensBaseNode sapiensInput = null;
            HashMap<String, SapiensFormNode> inputsByType = null;
            SapiensBaseNode.SapiensType compType = null;
            String noString = null;
            if (this.rootIDSg == null) {
                this.rootIDSg = (EZSapiensRootIDSg)entity.getSegment(EZSapiensRootIDSg.class);
            }
            if ((formIdSg = (EZSapiensFormIDSg)entity.getSegment(EZSapiensFormIDSg.class)) != null) {
                noString = formIdSg.getFormNo();
                sapiensInput = new SapiensFormNode(formIdSg);
                compType = SapiensBaseNode.SapiensType.FORM;
            }
            if ((classIdSg = (EZSapiensClassIDSg)entity.getSegment(EZSapiensClassIDSg.class)) != null) {
                noString = classIdSg.getClassNo();
                sapiensInput = new SapiensClassNode(classIdSg);
                compType = SapiensBaseNode.SapiensType.CLASS;
            }
            if ((qIdSg = (EZSapiensQueryIDSg)entity.getSegment(EZSapiensQueryIDSg.class)) != null) {
                noString = qIdSg.getQueryNo();
                sapiensInput = new SapiensQueryNode(qIdSg);
                compType = SapiensBaseNode.SapiensType.QUERY;
            }
            if ((opIdSg = (EZSapiensOperationIDSg)entity.getSegment(EZSapiensOperationIDSg.class)) != null) {
                noString = opIdSg.getOperationNo();
                sapiensInput = new SapiensOperationNode(opIdSg);
                compType = SapiensBaseNode.SapiensType.OPERATION;
            }
            if ((pIdSg = (EZSapiensProgramIDSg)entity.getSegment(EZSapiensProgramIDSg.class)) != null) {
                noString = pIdSg.getProgramNo();
                sapiensInput = new SapiensProgramNode(pIdSg);
                compType = SapiensBaseNode.SapiensType.PROGRAM;
            }
            if ((rIdSg = (EZSapiensRulesetIDSg)entity.getSegment(EZSapiensRulesetIDSg.class)) != null) {
                noString = rIdSg.getRulesetNo();
                sapiensInput = new SapiensRulesetNode(rIdSg);
                compType = SapiensBaseNode.SapiensType.RULESET;
            }
            if ((tIdSg = (EZSapiensTableIDSg)entity.getSegment(EZSapiensTableIDSg.class)) != null) {
                noString = tIdSg.getTableName();
                sapiensInput = new SapiensTableNode(tIdSg);
                compType = SapiensBaseNode.SapiensType.PhysicalDBTable;
            }
            if (sapiensInput == null || noString == null || compType == null) continue;
            inputsByType = this.inputsMap.get((Object)compType);
            if (inputsByType == null) {
                inputsByType = new HashMap<String, SapiensFormNode>();
                this.inputsMap.put(compType, inputsByType);
            }
            inputsByType.put(noString, (SapiensFormNode)sapiensInput);
        }
    }

    private void createRulesetClassTree(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, Set<Object> rulesetParams, Set<Object> classesParams, boolean isBack, SubMonitor pmonitor) {
        boolean run;
        boolean bl = run = this.graphLimitation == null || this.graphLimitation > 0;
        if (!run) {
            this.markUnexpandedGraphNodes(conn, classesParams, SapiensBaseNode.SapiensType.CLASS, allNodesMap);
            this.markUnexpandedGraphNodes(conn, rulesetParams, SapiensBaseNode.SapiensType.RULESET, allNodesMap);
            return;
        }
        HashSet<Object> newClassesParams = new HashSet<Object>();
        HashSet<Object> newRulesetsParams = new HashSet<Object>();
        newRulesetsParams.addAll(rulesetParams);
        newClassesParams.addAll(classesParams);
        int step = 1;
        while (!(pmonitor.isCanceled() || !run || newClassesParams.isEmpty() && newRulesetsParams.isEmpty())) {
            SapiensConstants.ComponentRelationship relation;
            String procName;
            L.debug("new classes params : " + newClassesParams);
            L.debug("new rulesets params : " + newRulesetsParams);
            HashSet<Object> localNewRulesetsParams = new HashSet<Object>();
            localNewRulesetsParams.addAll(newRulesetsParams);
            newRulesetsParams.clear();
            HashSet<Object> localNewClassesParams = new HashSet<Object>();
            localNewClassesParams.addAll(newClassesParams);
            newClassesParams.clear();
            if (localNewClassesParams.size() > 0) {
                pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.class.taskName"));
                procName = isBack ? Classes_VS_Ruleset_B_SP_Name : Classes_VS_Ruleset_SP_Name;
                relation = isBack ? SapiensConstants.ComponentRelationship.B_CLASS_VS_RULESETS_ATTR_KEY : SapiensConstants.ComponentRelationship.CLASS_VS_RULESETS_ATTR_KEY;
                String[][] classVsRulesetResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)procName, (String[])rootIdParam, localNewClassesParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                Set rulesetFromClassParams = this.processRuleSetResults(classVsRulesetResults, SapiensBaseNode.SapiensType.CLASS, relation, allNodesMap);
                for (Object rParam : rulesetFromClassParams) {
                    if (rulesetParams.contains(rParam)) continue;
                    newRulesetsParams.add(rParam);
                }
                rulesetParams.addAll(rulesetFromClassParams);
                procName = isBack ? Classes_VS_Class_B_SP_Name : Classes_VS_Class_SP_Name;
                relation = isBack ? SapiensConstants.ComponentRelationship.B_CLASS_VS_CLASSES_ATTR_KEY : SapiensConstants.ComponentRelationship.CLASS_VS_CLASSES_ATTR_KEY;
                String[][] classesVsClassResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)procName, (String[])rootIdParam, localNewClassesParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                Set classesFromClassParams = this.processClassesResults(classesVsClassResults, SapiensBaseNode.SapiensType.CLASS, relation, allNodesMap);
                Iterator iterator = classesFromClassParams.iterator();
                while (iterator.hasNext()) {
                    Object cParam = iterator.next();
                    if (classesParams.contains(cParam)) continue;
                    newClassesParams.add(cParam);
                }
                classesParams.addAll(classesFromClassParams);
            }
            if (localNewRulesetsParams.size() > 0) {
                pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.ruleset.taskName"));
                procName = isBack ? Ruleset_VS_Rulesets_CalledViaRule_B_SP_Name : Ruleset_VS_Rulesets_CalledViaRule_SP_Name;
                relation = isBack ? SapiensConstants.ComponentRelationship.B_RULESET_VS_RULESETS_VIA_RULE_ATTR_KEY : SapiensConstants.ComponentRelationship.RULESET_VS_RULESETS_VIA_RULE_ATTR_KEY;
                String[][] rulesetsVsRulesetsResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)procName, (String[])rootIdParam, localNewRulesetsParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                Set rulesetFromRulesetParams = this.processRuleSetResults(rulesetsVsRulesetsResults, SapiensBaseNode.SapiensType.RULESET, relation, allNodesMap);
                for (Object rParam : rulesetFromRulesetParams) {
                    if (rulesetParams.contains(rParam)) continue;
                    newRulesetsParams.add(rParam);
                }
                rulesetParams.addAll(rulesetFromRulesetParams);
                procName = isBack ? Ruleset_VS_Class_B_SP_Name : Ruleset_VS_Class_SP_Name;
                relation = isBack ? SapiensConstants.ComponentRelationship.B_RULESET_VS_CLASSES_ATTR_KEY : SapiensConstants.ComponentRelationship.RULESET_VS_CLASSES_ATTR_KEY;
                String[][] rulesetsVsClassesResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)procName, (String[])rootIdParam, localNewRulesetsParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                Set classFromRulesetParams = this.processClassesResults(rulesetsVsClassesResults, SapiensBaseNode.SapiensType.RULESET, relation, allNodesMap);
                for (Object cParam : classFromRulesetParams) {
                    if (classesParams.contains(cParam)) continue;
                    newClassesParams.add(cParam);
                }
                classesParams.addAll(classFromRulesetParams);
            }
            boolean bl2 = run = this.graphLimitation == null || step < this.graphLimitation;
            if (!run) {
                this.markUnexpandedGraphNodes(conn, newClassesParams, SapiensBaseNode.SapiensType.CLASS, allNodesMap);
                this.markUnexpandedGraphNodes(conn, newRulesetsParams, SapiensBaseNode.SapiensType.RULESET, allNodesMap);
            }
            ++step;
        }
    }

    private List<Object> createFormTree(EZSourceConnection conn, Set<Object> formParams, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, boolean isBackward, SubMonitor pmonitor) {
        boolean run;
        boolean bl = run = this.graphLimitation == null || this.graphLimitation > 0;
        if (!run || formParams == null || formParams.isEmpty()) {
            this.markUnexpandedGraphNodes(conn, formParams, SapiensBaseNode.SapiensType.FORM, allNodesMap);
            return null;
        }
        ArrayList<Object> backInpt = new ArrayList<Object>();
        ArrayList<Object> forwInpt = new ArrayList<Object>();
        ArrayList<Object> allProcessed = new ArrayList<Object>();
        if (isBackward) {
            backInpt.addAll(formParams);
            allProcessed.addAll(formParams);
        } else {
            forwInpt.addAll(formParams);
            allProcessed.addAll(formParams);
        }
        run = backInpt.size() > 0 || forwInpt.size() > 0;
        int step = 1;
        pmonitor.subTask(Messages.getString(SapiensGraphAnalysisJob.class, "compute.form.taskName"));
        while (run) {
            int i;
            String[][] blockResults;
            String[][] pfResults;
            String[][] results;
            HashSet<Object> params;
            if (backInpt.size() > 0) {
                params = new HashSet<Object>();
                params.addAll(backInpt);
                results = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CallingForm_Using_MenuOption_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                backInpt.clear();
                if (results != null && results.length > 0) {
                    int i2 = 0;
                    while (i2 < results.length) {
                        this.processFormResult(backInpt, allProcessed, allNodesMap, results[i2], true, true, false);
                        ++i2;
                    }
                }
                if ((pfResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CallingForm_Using_PF_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100))) != null && pfResults.length > 0) {
                    int i3 = 0;
                    while (i3 < pfResults.length) {
                        this.processFormResult(backInpt, allProcessed, allNodesMap, pfResults[i3], false, true, false);
                        ++i3;
                    }
                }
                if ((blockResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CallingForm_Using_BlockInForm_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100))) != null && blockResults.length > 0) {
                    i = 0;
                    while (i < blockResults.length) {
                        this.processFormResult(backInpt, allProcessed, allNodesMap, blockResults[i], false, true, true);
                        ++i;
                    }
                }
            }
            if (forwInpt.size() > 0) {
                params = new HashSet();
                params.addAll(forwInpt);
                results = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CalledForm_Using_MenuOption_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
                forwInpt.clear();
                if (results != null && results.length > 0) {
                    int i4 = 0;
                    while (i4 < results.length) {
                        this.processFormResult(forwInpt, allProcessed, allNodesMap, results[i4], true, false, false);
                        ++i4;
                    }
                }
                if ((pfResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CalledForm_Using_PF_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100))) != null && pfResults.length > 0) {
                    int i5 = 0;
                    while (i5 < pfResults.length) {
                        this.processFormResult(forwInpt, allProcessed, allNodesMap, pfResults[i5], false, false, false);
                        ++i5;
                    }
                }
                if ((blockResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)Form_VS_CalledForm_Using_BlockInForm_SP_Name, (String[])rootIdParam, params, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100))) != null && blockResults.length > 0) {
                    i = 0;
                    while (i < blockResults.length) {
                        this.processFormResult(forwInpt, allProcessed, allNodesMap, blockResults[i], false, false, true);
                        ++i;
                    }
                }
            }
            boolean bl2 = run = !(backInpt.size() <= 0 && forwInpt.size() <= 0 || this.graphLimitation != null && step >= this.graphLimitation);
            if (!run) {
                if (isBackward) {
                    this.markUnexpandedGraphNodes(conn, backInpt, SapiensBaseNode.SapiensType.FORM, allNodesMap);
                } else {
                    this.markUnexpandedGraphNodes(conn, forwInpt, SapiensBaseNode.SapiensType.FORM, allNodesMap);
                }
            }
            ++step;
        }
        return allProcessed;
    }

    private void addSapiensNode(SapiensBaseNode.SapiensType type, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, Integer no, SapiensBaseNode sapiensNode) {
        HashMap<Integer, SapiensBaseNode> nodes = allNodesMap.get((Object)type);
        if (nodes == null) {
            nodes = new HashMap<Integer, SapiensBaseNode>();
            allNodesMap.put(type, nodes);
        }
        nodes.put(no, sapiensNode);
    }

    private void addSapiensNode(SapiensBaseNode.SapiensType type, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, String name, SapiensBaseNode sapiensNode) {
        HashMap<String, SapiensBaseNode> nodes = allNodesMap.get((Object)type);
        if (nodes == null) {
            nodes = new HashMap<String, SapiensBaseNode>();
            allNodesMap.put(type, nodes);
        }
        nodes.put(name, sapiensNode);
    }

    private SapiensBaseNode getSapiensNode(SapiensBaseNode.SapiensType type, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, Object key) {
        Map nodesByType = allNodesMap.get((Object)type);
        return nodesByType != null ? (SapiensBaseNode)nodesByType.get(key) : null;
    }

    private void processTableResults(String[][] fromVsTableResults, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        if (fromVsTableResults != null && fromVsTableResults.length > 0) {
            String[][] stringArray = fromVsTableResults;
            int n = fromVsTableResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                String tableName = result[2];
                Integer rootId = Integer.valueOf(result[0]);
                if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)tableName) != null && !tableName.trim().isEmpty()) {
                    SapiensBaseNode tableNode = this.getSapiensNode(SapiensBaseNode.SapiensType.PhysicalDBTable, allNodesMap, tableName);
                    if (tableNode == null) {
                        tableNode = new SapiensTableNode(rootId, tableName);
                        this.addSapiensNode(SapiensBaseNode.SapiensType.PhysicalDBTable, allNodesMap, tableName, tableNode);
                    }
                    Integer fromNo = Integer.valueOf(result[1]);
                    SapiensBaseNode fromNode = this.getSapiensNode(type, allNodesMap, fromNo);
                    fromNode.addRelation(relation, tableNode);
                }
                ++n2;
            }
        }
    }

    private Set processOutputFormResults(String[][] fromVsOutputFormResults, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet formParams = new HashSet();
        if (fromVsOutputFormResults != null && fromVsOutputFormResults.length > 0) {
            String[][] stringArray = fromVsOutputFormResults;
            int n = fromVsOutputFormResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer fromNo = Integer.valueOf(result[1]);
                SapiensBaseNode formNode = this.makeFormNode(result, formParams, null, allNodesMap);
                SapiensBaseNode fromNode = this.getSapiensNode(type, allNodesMap, fromNo);
                fromNode.addRelation(relation, formNode);
                ++n2;
            }
        }
        return formParams;
    }

    private Set processProgramResults(String[][] fromVsPrgResults, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet<Integer> programParams = new HashSet<Integer>();
        if (fromVsPrgResults != null && fromVsPrgResults.length > 0) {
            String[][] stringArray = fromVsPrgResults;
            int n = fromVsPrgResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rootId = Integer.valueOf(result[0]);
                Integer formNo = Integer.valueOf(result[1]);
                SapiensBaseNode sapiensFrom = this.getSapiensNode(type, allNodesMap, formNo);
                String pName = result[3];
                Integer pNo = Integer.valueOf(result[2]);
                SapiensBaseNode pNode = this.getSapiensNode(SapiensBaseNode.SapiensType.PROGRAM, allNodesMap, pNo);
                if (pNode == null) {
                    pNode = new SapiensProgramNode(rootId, pName, pNo.toString());
                    this.addSapiensNode(SapiensBaseNode.SapiensType.PROGRAM, allNodesMap, pNo, pNode);
                    programParams.add(pNo);
                }
                sapiensFrom.addRelation(relation, pNode);
                ++n2;
            }
        }
        return programParams;
    }

    private Set processQueriesResults(String[][] fromVsQueryResult, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet<Integer> queriesParams = new HashSet<Integer>();
        if (fromVsQueryResult != null && fromVsQueryResult.length > 0) {
            String[][] stringArray = fromVsQueryResult;
            int n = fromVsQueryResult.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rootId = Integer.valueOf(result[0]);
                Integer fromNo = Integer.valueOf(result[1]);
                SapiensBaseNode sapiensFrom = this.getSapiensNode(type, allNodesMap, fromNo);
                String qName = result[3];
                Integer qNo = Integer.valueOf(result[2]);
                SapiensBaseNode qNode = this.getSapiensNode(SapiensBaseNode.SapiensType.QUERY, allNodesMap, qNo);
                if (qNode == null) {
                    qNode = new SapiensQueryNode(rootId, qName, qNo.toString());
                    this.addSapiensNode(SapiensBaseNode.SapiensType.QUERY, allNodesMap, qNo, qNode);
                    queriesParams.add(qNo);
                }
                sapiensFrom.addRelation(relation, qNode);
                ++n2;
            }
        }
        return queriesParams;
    }

    private Set processBackFormResults(String[][] fromVsFormResults, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet formParams = new HashSet();
        if (fromVsFormResults != null && fromVsFormResults.length > 0) {
            String[][] stringArray = fromVsFormResults;
            int n = fromVsFormResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                SapiensBaseNode formNode = this.makeFormNode(result, formParams, null, allNodesMap);
                Integer fromNo = Integer.valueOf(result[1]);
                SapiensBaseNode sapiensFrom = this.getSapiensNode(type, allNodesMap, fromNo);
                sapiensFrom.addRelation(relation, formNode);
                ++n2;
            }
        }
        return formParams;
    }

    private Set processOperationResults(String[][] fromVsOperationResults, SapiensBaseNode.SapiensType type, SapiensConstants.ComponentRelationship relation, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet<Integer> operationParams = new HashSet<Integer>();
        if (fromVsOperationResults != null && fromVsOperationResults.length > 0) {
            String[][] stringArray = fromVsOperationResults;
            int n = fromVsOperationResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rootId = Integer.valueOf(result[0]);
                Integer fromNo = Integer.valueOf(result[1]);
                SapiensBaseNode sapiensFrom = this.getSapiensNode(type, allNodesMap, fromNo);
                String operationName = result[3];
                Integer operationNo = Integer.valueOf(result[2]);
                SapiensBaseNode operationNode = this.getSapiensNode(SapiensBaseNode.SapiensType.OPERATION, allNodesMap, operationNo);
                if (operationNode == null) {
                    operationNode = new SapiensOperationNode(rootId, operationName, operationNo.toString());
                    this.addSapiensNode(SapiensBaseNode.SapiensType.OPERATION, allNodesMap, operationNo, operationNode);
                    operationParams.add(operationNo);
                }
                sapiensFrom.addRelation(relation, operationNode);
                ++n2;
            }
        }
        return operationParams;
    }

    private Set processClassesResults(String[][] fromToClassesResults, SapiensBaseNode.SapiensType fromType, SapiensConstants.ComponentRelationship relationshipKey, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet<Integer> classesParams = new HashSet<Integer>();
        if (fromToClassesResults != null && fromToClassesResults.length > 0) {
            String[][] stringArray = fromToClassesResults;
            int n = fromToClassesResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rootId = Integer.valueOf(result[0]);
                Integer rNo = Integer.valueOf(result[1]);
                SapiensBaseNode fromNode = this.getSapiensNode(fromType, allNodesMap, rNo);
                Integer classNo = Integer.valueOf(result[2]);
                String className = result[5];
                SapiensBaseNode classNode = this.getSapiensNode(SapiensBaseNode.SapiensType.CLASS, allNodesMap, classNo);
                if (classNode == null) {
                    classNode = new SapiensClassNode(rootId, className, classNo.toString());
                    String parentClassNo = result[7];
                    L.debug("parentClassNo = " + parentClassNo);
                    classNode.addProperty("parent of this class no", parentClassNo);
                    if (!parentClassNo.equalsIgnoreCase("0")) {
                        classNode.addProperty("parent of this class name", result[8]);
                    }
                    this.addSapiensNode(SapiensBaseNode.SapiensType.CLASS, allNodesMap, classNo, classNode);
                    classesParams.add(classNo);
                }
                fromNode.addRelation(relationshipKey, classNode);
                ++n2;
            }
        }
        return classesParams;
    }

    private Set processRuleSetResults(String[][] fromToRulesetResults, SapiensBaseNode.SapiensType fromType, SapiensConstants.ComponentRelationship relationshipKey, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        HashSet<Integer> rulesetParams = new HashSet<Integer>();
        if (fromToRulesetResults != null && fromToRulesetResults.length > 0) {
            String[][] stringArray = fromToRulesetResults;
            int n = fromToRulesetResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rootId = Integer.valueOf(result[0]);
                Integer fromNo = Integer.valueOf(result[1]);
                SapiensBaseNode sapiensFrom = this.getSapiensNode(fromType, allNodesMap, fromNo);
                String rName = result[3];
                Integer rNo = Integer.valueOf(result[2]);
                SapiensBaseNode rNode = this.getSapiensNode(SapiensBaseNode.SapiensType.RULESET, allNodesMap, rNo);
                if (rNode == null) {
                    rNode = new SapiensRulesetNode(rootId, rName, rNo.toString());
                    this.addSapiensNode(SapiensBaseNode.SapiensType.RULESET, allNodesMap, rNo, rNode);
                    rulesetParams.add(rNo);
                }
                sapiensFrom.addRelation(relationshipKey, rNode);
                ++n2;
            }
        }
        return rulesetParams;
    }

    private void processFormResult(List<Object> inpt, List<Object> allProcessed, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, String[] result, boolean isViaMenu, boolean isBack, boolean isBlockInForm) {
        SapiensBaseNode calledNode;
        Integer rootId = Integer.valueOf(result[0]);
        Integer inptFormNo = Integer.valueOf(result[1]);
        SapiensBaseNode sapiensNode = this.makeFormNode(result, inpt, allProcessed, allNodesMap);
        SapiensBaseNode sapiensInput = this.getSapiensNode(SapiensBaseNode.SapiensType.FORM, allNodesMap, inptFormNo);
        SapiensBaseNode callingNode = isBack ? sapiensNode : sapiensInput;
        SapiensBaseNode sapiensBaseNode = calledNode = isBack ? sapiensInput : sapiensNode;
        if (isViaMenu) {
            this.makeFormLinkViaMenu(allNodesMap, result[7], rootId, calledNode, callingNode, isBack);
        } else if (sapiensNode != null) {
            SapiensConstants.ComponentRelationship relationship = null;
            relationship = isBack ? (isBlockInForm ? SapiensConstants.ComponentRelationship.FORM_VS_PARENTS_VIA_BLOCKINFORM_ATTR_KEY : SapiensConstants.ComponentRelationship.FORM_VS_PARENTS_VIA_PF_ATTR_KEY) : (isBlockInForm ? SapiensConstants.ComponentRelationship.FORM_VS_FOLLOWINGS_VIA_BLOCKINFORM_ATTR_KEY : SapiensConstants.ComponentRelationship.FORM_VS_FOLLOWINGS_VIA_PF_ATTR_KEY);
            sapiensInput.addRelation(relationship, sapiensNode);
        }
    }

    private SapiensBaseNode makeFormNode(String[] result, Collection inpt, List<Object> allProcessed, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        Integer rootId = Integer.valueOf(result[0]);
        Integer formNo = Integer.valueOf(result[2]);
        String formName = result[3];
        SapiensBaseNode sapiensNode = this.getSapiensNode(SapiensBaseNode.SapiensType.FORM, allNodesMap, formNo);
        if (sapiensNode != null) {
            L.trace("already processed");
        }
        if (formNo != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)formName) != null && sapiensNode == null) {
            sapiensNode = new SapiensFormNode(rootId, formName, formNo.toString());
            if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)result[5]) != null && com.ez.mainframe.data.utils.Utils.filterNullValue((String)result[6]) != null) {
                Integer menuCounter = Integer.valueOf(result[5]);
                Integer blockCounter = Integer.valueOf(result[6]);
                ((SapiensFormNode)sapiensNode).addFormProperties(blockCounter, menuCounter);
            }
            this.addSapiensNode(SapiensBaseNode.SapiensType.FORM, allNodesMap, (int)formNo, sapiensNode);
            if (allProcessed == null || !allProcessed.contains(formNo)) {
                inpt.add(formNo);
                if (allProcessed != null) {
                    allProcessed.add(formNo);
                }
            }
        }
        L.debug("make Form Node " + sapiensNode);
        return sapiensNode;
    }

    private void makeFormLinkViaMenu(Map<SapiensBaseNode.SapiensType, Map> allNodesMap, String optionNoString, Integer rootId, SapiensBaseNode calledNode, SapiensBaseNode callingNode, boolean isBack) {
        Integer optionNo;
        if (com.ez.mainframe.data.utils.Utils.filterNullValue((String)optionNoString) != null && (optionNo = Integer.valueOf(optionNoString)) > 0) {
            ArrayList<Integer> menuOptions;
            SapiensBaseNode menuNode = this.getSapiensNode(SapiensBaseNode.SapiensType.MENU, allNodesMap, callingNode.getNo());
            if (menuNode == null) {
                menuNode = new SapiensMenuNode(rootId, callingNode.getName(), callingNode.getNo());
                this.addSapiensNode(SapiensBaseNode.SapiensType.MENU, allNodesMap, Integer.valueOf(callingNode.getNo()), menuNode);
            }
            if ((menuOptions = (ArrayList<Integer>)menuNode.getProperty("OptionNo")) == null) {
                menuOptions = new ArrayList<Integer>();
                menuNode.addProperty("OptionNo", menuOptions);
            }
            menuOptions.add(optionNo);
            if (isBack) {
                calledNode.addRelation(SapiensConstants.ComponentRelationship.FORM_VS_PARENTS_MENU_VIA_MENUOPTION_ATTR_KEY, menuNode);
                menuNode.addRelation(SapiensConstants.ComponentRelationship.MENU_VS_PARENTS_FORM_VIA_MENUOPTION_ATTR_KEY, callingNode);
            } else {
                callingNode.addRelation(SapiensConstants.ComponentRelationship.FORM_VS_FOLLOWINGS_MENU_VIA_MENUOPTION_ATTR_KEY, menuNode);
                if (calledNode != null) {
                    menuNode.addRelation(SapiensConstants.ComponentRelationship.MENU_VS_FOLLOWINGS_FORM_VIA_MENUOPTION_ATTR_KEY, calledNode);
                }
            }
        }
    }

    private void computePFActionsForForm(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, SubMonitor pmonitor) {
        Map forms = allNodesMap.get((Object)SapiensBaseNode.SapiensType.FORM);
        if (forms == null || forms.isEmpty()) {
            return;
        }
        Set formParams = forms.keySet();
        String[][] pfResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)PFActionsForForm_SP_Name, (String[])rootIdParam, formParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
        if (pfResults != null && pfResults.length > 0) {
            String[][] stringArray = pfResults;
            int n = pfResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer formNo = Integer.valueOf(result[1]);
                Integer pfNo = Integer.valueOf(result[2]);
                String commandLine = result[3];
                SapiensFormNode formNode = (SapiensFormNode)this.getSapiensNode(SapiensBaseNode.SapiensType.FORM, allNodesMap, formNo);
                formNode.addPFActionForForm(new PFActionForForm(pfNo.toString(), commandLine));
                ++n2;
            }
        }
    }

    private void computeRuleWithinRuleset(EZSourceConnection conn, String[] rootIdParam, Map<SapiensBaseNode.SapiensType, Map> allNodesMap, SubMonitor pmonitor) {
        Map rulesets = allNodesMap.get((Object)SapiensBaseNode.SapiensType.RULESET);
        if (rulesets == null || rulesets.isEmpty()) {
            return;
        }
        Set rulesetParams = rulesets.keySet();
        String[][] rulesResults = Utils.runStoredProcedure((EZSourceConnection)conn, (String)RuleWithinRuleset_SP_Name, (String[])rootIdParam, rulesetParams, (EZSourceDataType)EZSourceDataType.Integer, (IProgressMonitor)pmonitor.newChild(100));
        if (rulesResults != null && rulesResults.length > 0) {
            String[][] stringArray = rulesResults;
            int n = rulesResults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                Integer rulesetNo = Integer.valueOf(result[1]);
                Integer ruleNo = Integer.valueOf(result[2]);
                String ruleName = result[3];
                String seq = result[4];
                String sourceLine = result[5];
                SapiensRulesetNode rNode = (SapiensRulesetNode)this.getSapiensNode(SapiensBaseNode.SapiensType.RULESET, allNodesMap, rulesetNo);
                if (rNode != null) {
                    rNode.addRuleWithinRuleset(new RuleWithinRuleset(ruleNo.toString(), seq, ruleName, sourceLine));
                } else {
                    L.debug("ruleset node not found " + rulesetNo);
                }
                ++n2;
            }
        }
    }

    private void markUnexpandedGraphNodes(EZSourceConnection conn, Collection<Object> params, SapiensBaseNode.SapiensType type, Map<SapiensBaseNode.SapiensType, Map> allNodesMap) {
        if (params == null) {
            return;
        }
        for (Object no : params) {
            SapiensBaseNode sNode = this.getSapiensNode(type, allNodesMap, no);
            sNode.addProperty("node is not expanded in callgraph", Boolean.TRUE);
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor pmonitor, IStatus result) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(SapiensGraphAnalysisJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)monitor, result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        monitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(SapiensFormNode.class);
        gfi.registerFilterType(SapiensProgramNode.class);
        gfi.registerFilterType(SapiensClassNode.class);
        gfi.registerFilterType(SapiensRulesetNode.class);
        gfi.registerFilterType(SapiensTableNode.class);
        gfi.registerFilterType(SapiensQueryNode.class);
        gfi.registerFilterType(SapiensOperationNode.class);
        gfi.registerFilterType(SapiensMenuNode.class);
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        if (uiStyle == 0) {
            Utils.setImageProvider((LegendPanel)legend);
        }
        this.addNodesToLegend(legend, uiStyle);
        Utils.setImageProvider((LegendPanel)legend);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(nodeLegendInfo.getNodeTypeClass(), imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    class SapiensGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public SapiensGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage("sapiensGraph", "icons/sapiens.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("sapiensGraph");
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            ProjectInfo ezsourcePrj = (ProjectInfo)SapiensGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            StringBuilder sb = new StringBuilder();
            int idx = 0;
            List inputs = SapiensGraphAnalysisJob.this.analysis.getContextListValue("input_list");
            int all = inputs.size();
            int more = 0;
            String sapiensSubsystem = "";
            if (SapiensGraphAnalysisJob.this.rootIDSg != null) {
                sapiensSubsystem = SapiensGraphAnalysisJob.this.rootIDSg.getJobMemberName();
            }
            int pos = 0;
            block0: for (SapiensBaseNode.SapiensType typeComp : SapiensGraphAnalysisJob.this.inputsMap.keySet()) {
                if (truncate && idx >= 3) break;
                sb.append(" ".concat(typeComp.toString()).concat(" "));
                Map bytypes = (Map)SapiensGraphAnalysisJob.this.inputsMap.get((Object)typeComp);
                Collection nodes = bytypes.values();
                for (SapiensBaseNode sNode : nodes) {
                    if (idx >= 3) {
                        more = all - idx;
                        continue block0;
                    }
                    sb.append(sNode.getNodeLabel());
                    if (pos < nodes.size() - 1) {
                        sb.append(", ");
                    }
                    ++pos;
                    ++idx;
                }
            }
            this.tabName = more != 0 ? Messages.getString(SapiensGraphAnalysisJob.class, "tabName.more", new String[]{sapiensSubsystem, "" + sb, String.valueOf(more), ezsourcePrj.getName()}) : Messages.getString(SapiensGraphAnalysisJob.class, "tabName", new String[]{sapiensSubsystem, "" + sb, ezsourcePrj.getName()});
            return this.tabName;
        }

        public String getTooltip() {
            if (SapiensGraphAnalysisJob.this.graphDirection != null) {
                if (SapiensGraphAnalysisJob.this.isGraphLimited != null && SapiensGraphAnalysisJob.this.isGraphLimited.booleanValue()) {
                    return Messages.getString(SapiensGraphAnalysisJob.class, "tooltip", new String[]{this.tabName, SapiensGraphAnalysisJob.this.graphDirection.toString(), "" + SapiensGraphAnalysisJob.this.graphLimitation});
                }
                return Messages.getString(SapiensGraphAnalysisJob.class, "tooltip1", new String[]{this.tabName, SapiensGraphAnalysisJob.this.graphDirection.toString()});
            }
            if (SapiensGraphAnalysisJob.this.isGraphLimited != null && SapiensGraphAnalysisJob.this.isGraphLimited.booleanValue()) {
                return Messages.getString(SapiensGraphAnalysisJob.class, "tooltip2", new String[]{this.tabName, "" + SapiensGraphAnalysisJob.this.graphLimitation});
            }
            return Messages.getString(SapiensGraphAnalysisJob.class, "tooltip3", new String[]{this.tabName});
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    SapiensGraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    SapiensGraphAnalysisJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor(image);
                        }
                    });
                    int uiStyle = SapiensGraphAnalysisJob.this.graphModel.getUIStyle();
                    SapiensGraphAnalysisJob.this.addEntriesToLegend(SapiensGraphAnalysisJob.this.legend, uiStyle, SapiensGraphInfo.this.gfi);
                    sc.setContent((Control)SapiensGraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    SapiensGraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(SapiensGraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((SapiensGraphAnalysisJob)((SapiensGraphInfo)SapiensGraphInfo.this).SapiensGraphAnalysisJob.this).legend.getSize().x;
                    int x = ((SapiensGraphAnalysisJob)((SapiensGraphInfo)SapiensGraphInfo.this).SapiensGraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

