/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.sapiens;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.sapiens.SapiensGraphAnalysisJob;
import com.ez.graphs.sapiens.SapiensInputsFilter;
import com.ez.graphs.sapiens.SapiensSettingsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapiensGraphAnalysis
extends MainframeGraphAnalysis {
    private static final Logger L = LoggerFactory.getLogger(SapiensGraphAnalysis.class);
    private SapiensGraphAnalysisJob job;

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (SapiensGraphAnalysisJob)wk.getJob(id, SapiensGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public String getLabelType() {
        return Messages.getString(SapiensGraphAnalysis.class, "label.type");
    }

    @Override
    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_SAPIENS_GRAPH_ANALYSIS;
    }

    @Override
    protected InputsFilter getInputsFilter() {
        ProjectInputsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            L.debug("start for sapiens graph on a project.");
            iFilter = new SapiensInputsFilter();
        } else {
            L.debug("start sapiens graph on components");
            iFilter = new SapiensSettingsFilter();
        }
        return iFilter;
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret = super.equals(obj);
        if (ret) {
            Direction cgDirection1;
            AbstractAnalysis a2 = (AbstractAnalysis)obj;
            Direction cgDirection = (Direction)this.getContextValue("graph direction: forward or backward or both");
            if (!cgDirection.equals((Object)(cgDirection1 = (Direction)a2.getContextValue("graph direction: forward or backward or both")))) {
                ret = false;
            }
            if (ret) {
                Boolean isLimited1 = (Boolean)this.getContextValue("is graph limited");
                isLimited1 = isLimited1 == null ? false : isLimited1;
                Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
                if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                    ret = false;
                }
                if (ret && isLimited1.booleanValue()) {
                    Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
                    Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
                    if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                        ret = false;
                    }
                }
            }
        }
        return ret;
    }
}

