/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.VariableUsageNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class VariableUsageSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private VariableUsageNode node;
    private static final String EMPTY_STRING = "";
    private Text txtName;
    private Text txtPic;
    private Text txtLevel;
    private Text txtStartRow;
    private Text txtAncestor;
    private Text txtFather;
    private Text isFiller;
    private Text isGlobal;
    private static String LABEL_TEXT_TRUE = Messages.getString(VariableUsageSection.class, "true.text");
    private static String LABEL_TEXT_FALSE = Messages.getString(VariableUsageSection.class, "false.text");

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)200);
        GridData gd2 = new GridData();
        gd2.widthHint = DpiScaler.getScaledSize((int)50);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.name"));
        this.txtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtName.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.level"));
        this.txtLevel = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtLevel.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.pic"));
        this.txtPic = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtPic.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.startRow"));
        this.txtStartRow = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtStartRow.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.ancestor"));
        this.txtAncestor = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtAncestor.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.father"));
        this.txtFather = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtFather.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.isFiller"));
        this.isFiller = this.getWidgetFactory().createText(this.composite, LABEL_TEXT_FALSE, 8);
        this.isFiller.setLayoutData((Object)gd2);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(VariableUsageSection.class, "label.isGlobal"));
        this.isGlobal = this.getWidgetFactory().createText(this.composite, LABEL_TEXT_FALSE, 8);
        this.isGlobal.setLayoutData((Object)gd2);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.node != null) {
            this.txtName.setText(this.node.getName());
            this.txtPic.setText(this.node.getPic());
            this.txtLevel.setText(this.node.getLevel());
            this.txtStartRow.setText(this.node.getStartRow());
            this.txtAncestor.setText(this.node.getAncestor());
            this.txtFather.setText(this.node.getFather());
            this.isFiller.setText(this.node.isFiller() ? LABEL_TEXT_TRUE : LABEL_TEXT_FALSE);
            this.isGlobal.setText(this.node.isGlobal() ? LABEL_TEXT_TRUE : LABEL_TEXT_FALSE);
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtName.setText(EMPTY_STRING);
        this.txtPic.setText(EMPTY_STRING);
        this.txtLevel.setText(EMPTY_STRING);
        this.txtStartRow.setText(EMPTY_STRING);
        this.txtAncestor.setText(EMPTY_STRING);
        this.txtFather.setText(EMPTY_STRING);
        this.isFiller.setText(LABEL_TEXT_FALSE);
        this.isGlobal.setText(LABEL_TEXT_FALSE);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null) {
            this.node = (VariableUsageNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

