/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.SystemNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SystemSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private EZEntityID eid;
    private static final String EMPTY_STRING = "";
    private Text txtSystem;
    private Text txtCPUID;
    private SystemNode model = null;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)200);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(SystemSection.class, "label.name"));
        this.txtSystem = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtSystem.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(SystemSection.class, "label.CPUId"));
        this.txtCPUID = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCPUID.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        if (this.model != null) {
            if (this.model.getSystemName() != null) {
                this.txtSystem.setText(this.model.getSystemName());
            }
            if (this.model.getCpuId() != null) {
                this.txtCPUID.setText(this.model.getCpuId());
            }
        } else {
            this.clearData();
        }
        this.composite.setVisible(true);
        this.composite.pack();
    }

    private void clearData() {
        this.txtSystem.setText(EMPTY_STRING);
        this.txtCPUID.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof SystemNode) {
            this.model = (SystemNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

