/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.SysplexNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.utils.Utils;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SysplexSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private EZEntityID eid;
    private Text txtSysplex;
    private Text txtCPC;
    private static final String EMPTY_STRING = "";

    public void refresh() {
        EZSourceMainframeNodeIdSg sg;
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.eid != null && (sg = (EZSourceMainframeNodeIdSg)this.eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null) {
            String cpcName;
            SysplexNode object = (SysplexNode)sg.getResNode();
            String sysName = object.getSysplexName();
            if (Utils.filterNullValue((String)sysName) != null) {
                this.txtSysplex.setText(sysName);
            }
            if (Utils.filterNullValue((String)(cpcName = object.getCpcName())) != null) {
                this.txtCPC.setText(cpcName);
            }
        }
        super.refresh();
    }

    private void clearData() {
        this.txtSysplex.setText(EMPTY_STRING);
        this.txtCPC.setText(EMPTY_STRING);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)200);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(SysplexSection.class, "label.name"));
        this.txtSysplex = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtSysplex.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(SysplexSection.class, "label.CPCName"));
        this.txtCPC = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCPC.setLayoutData((Object)gd);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID) {
            this.eid = (EZEntityID)input;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

