/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.ScreenNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ScreenSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private ScreenNode model;
    private static final String EMPTY_STRING = "";
    private Text txtName;
    private Text txtType;
    private Text txtMapSet;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(ScreenSection.class, "name.label"));
        this.txtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtName.setLayoutData((Object)gd);
        this.txtName.pack();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(ScreenSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtType.setLayoutData((Object)gd);
        this.txtType.pack();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(ScreenSection.class, "mapset.label"));
        this.txtMapSet = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtMapSet.setLayoutData((Object)gd);
        this.txtMapSet.pack();
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            this.txtName.setText(this.model.getName());
            this.txtType.setText(this.model.getType());
            this.txtMapSet.setText(this.model.getMapset());
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtName.setText(EMPTY_STRING);
        this.txtType.setText(EMPTY_STRING);
        this.txtMapSet.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof ScreenNode) {
            this.model = (ScreenNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

