/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class QueueSection
extends AbstractEZSection {
    private QueueNode node;
    private static final String EMPTY_STRING = "";
    private Text txtQueue;
    private Text txtSubSystem;
    private Text txtSystemName;
    private Text txtDeadLetter;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)200);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(QueueSection.class, "queue.manager.name.label"));
        this.txtQueue = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtQueue.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(QueueSection.class, "system.name.label"));
        this.txtSystemName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtSystemName.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(QueueSection.class, "sub.system.name.label"));
        this.txtSubSystem = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtSubSystem.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(QueueSection.class, "dead.letter.queue.label"));
        this.txtDeadLetter = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtDeadLetter.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.node != null) {
            this.txtQueue.setText(this.node.getName());
            this.txtSubSystem.setText(this.node.getSubSystemName());
            this.txtSystemName.setText(this.node.getSystemName());
            this.txtDeadLetter.setText(this.node.getDeadLetter());
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtQueue.setText(EMPTY_STRING);
        this.txtSubSystem.setText(EMPTY_STRING);
        this.txtSystemName.setText(EMPTY_STRING);
        this.txtDeadLetter.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null) {
            this.node = (QueueNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

