/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.properties.IMSSegmentPropertiesNode;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class IMSSegmentSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EMPTY_STRING = "";
    private Text txtName;
    private Text txtSegType;
    private Text externalTxtName;
    private Text txtType;
    private Text txtBytes;
    private Text txtEncoding;
    private Text txtFreq;
    private Text txtRemarks;
    private Label txtNameLabel;
    private Label txtSegTypeLabel;
    private Label externalTxtNameLabel;
    private Label txtTypeLabel;
    private Label txtBytesLabel;
    private Label txtEncodingLabel;
    private Label txtFreqLabel;
    private Label txtRemarksLabel;
    private IMSSegmentPropertiesNode model;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        this.txtNameLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "name.label"));
        this.txtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtName.setLayoutData((Object)gd);
        this.externalTxtNameLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "external.name.label"));
        this.externalTxtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.externalTxtName.setLayoutData((Object)gd);
        this.txtSegTypeLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "seg.type.label"));
        this.txtSegType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtSegType.setLayoutData((Object)gd);
        this.txtTypeLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtType.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtBytesLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "bytes.label"));
        this.txtBytes = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtBytes.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtEncodingLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "encoding.label"));
        this.txtEncoding = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtEncoding.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtFreqLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "freq.label"));
        this.txtFreq = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtFreq.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.txtRemarksLabel = this.getWidgetFactory().createLabel(this.composite, Messages.getString(IMSSegmentSection.class, "remarks.label"));
        this.txtRemarks = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtRemarks.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getName() != null) {
                this.txtName.setText(this.model.getName());
                if (!this.txtName.isVisible()) {
                    this.showWidgets(new Control[]{this.txtNameLabel, this.txtName});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtNameLabel, this.txtName});
            }
            if (this.model.getExternalName() != null) {
                this.externalTxtName.setText(this.model.getExternalName());
                if (!this.externalTxtName.isVisible()) {
                    this.showWidgets(new Control[]{this.externalTxtNameLabel, this.externalTxtName});
                }
            } else {
                this.hideWidgets(new Control[]{this.externalTxtNameLabel, this.externalTxtName});
            }
            if (this.model.getSegType() != null) {
                this.txtSegType.setText(this.model.getSegType());
                if (!this.txtSegType.isVisible()) {
                    this.showWidgets(new Control[]{this.txtSegTypeLabel, this.txtSegType});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtSegTypeLabel, this.txtSegType});
            }
            if (this.model.getType() != null) {
                this.txtType.setText(this.model.getType());
                if (!this.txtType.isVisible()) {
                    this.showWidgets(new Control[]{this.txtTypeLabel, this.txtType});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtTypeLabel, this.txtType});
            }
            if (this.model.getBytes() != null) {
                this.txtBytes.setText(this.model.getBytes());
                if (!this.txtBytes.isVisible()) {
                    this.showWidgets(new Control[]{this.txtBytesLabel, this.txtBytes});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtBytesLabel, this.txtBytes});
            }
            if (this.model.getEncoding() != null) {
                this.txtEncoding.setText(this.model.getEncoding());
                if (!this.txtEncoding.isVisible()) {
                    this.showWidgets(new Control[]{this.txtEncodingLabel, this.txtEncoding});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtEncodingLabel, this.txtEncoding});
            }
            if (this.model.getFreq() != null) {
                this.txtFreq.setText(this.model.getFreq());
                if (!this.txtFreq.isVisible()) {
                    this.showWidgets(new Control[]{this.txtFreqLabel, this.txtFreq});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtFreqLabel, this.txtFreq});
            }
            if (this.model.getRemarks() != null) {
                this.txtRemarks.setText(this.model.getRemarks());
                if (!this.txtRemarks.isVisible()) {
                    this.showWidgets(new Control[]{this.txtRemarksLabel, this.txtRemarks});
                }
            } else {
                this.hideWidgets(new Control[]{this.txtRemarksLabel, this.txtRemarks});
            }
        }
        this.composite.pack();
        this.composite.getParent().pack();
    }

    private void clearData() {
        this.txtName.setText(EMPTY_STRING);
        this.txtSegType.setText(EMPTY_STRING);
        this.externalTxtName.setText(EMPTY_STRING);
        this.txtType.setText(EMPTY_STRING);
        this.txtBytes.setText(EMPTY_STRING);
        this.txtEncoding.setText(EMPTY_STRING);
        this.txtFreq.setText(EMPTY_STRING);
        this.txtRemarks.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof IMSSegmentPropertiesNode) {
            this.model = (IMSSegmentPropertiesNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

