/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractTableSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.model.StatementInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStmtSection
extends AbstractTableSection {
    private static final Logger L = LoggerFactory.getLogger(GenericStmtSection.class);
    private StatementInfo node;
    private static final String EMPTY_STRING = "";
    private Text txtType;

    public void refresh() {
        if (this.node != null) {
            String stmtDescription = this.node.getStatementName();
            L.debug("stmtDescription" + stmtDescription);
            this.txtType.setText(stmtDescription);
        }
        super.refresh();
    }

    protected Set getOwnedRows() {
        HashSet inputs = new HashSet();
        if (this.node != null) {
            inputs.addAll(this.node.getLocations());
        }
        return inputs;
    }

    protected Object getKeyForRow(Object object) {
        return new Object[]{((Object[])object)[0], ((Object[])object)[2], ((Object[])object)[3]};
    }

    protected List getValuesForRow(Object object) {
        ArrayList<String> list = new ArrayList<String>();
        Object[] tsf = (Object[])object;
        list.add((String)tsf[0]);
        list.add((String)tsf[1]);
        if (tsf[2] != null) {
            list.add("(" + tsf[2] + "," + tsf[3] + ")");
        } else {
            list.add(EMPTY_STRING);
        }
        return list;
    }

    protected Map getColumnLabelsAndIndexes() {
        String pathText = Messages.getString(GenericStmtSection.class, "path.text");
        String typeText = Messages.getString(GenericStmtSection.class, "type.text");
        String locationText = Messages.getString(GenericStmtSection.class, "location.text");
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        map.put(0, new String[]{pathText, pathText});
        map.put(1, new String[]{typeText, typeText});
        map.put(2, new String[]{locationText, locationText});
        return map;
    }

    protected int getHeightHint() {
        return DpiScaler.getScaledSize((int)200);
    }

    protected int getWidthHint() {
        return DpiScaler.getScaledSize((int)200);
    }

    protected void addElementsBeforeTable() {
        Composite lblComposite = this.getWidgetFactory().createComposite(this.composite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        lblComposite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.minimumWidth = 200;
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(lblComposite, Messages.getString(GenericStmtSection.class, "type.text.label"));
        this.txtType = this.getWidgetFactory().createText(lblComposite, EMPTY_STRING, 8);
        this.txtType.setLayoutData((Object)gd);
    }

    protected void addElementsAfterTable() {
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID) {
            EZEntityID eid = (EZEntityID)input;
            if (eid != null) {
                EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class);
                this.node = (StatementNode)sg.getResNode();
            }
        } else if (input instanceof StatementInfo) {
            this.node = (StatementInfo)input;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

