/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class GenericProgramSection
extends AbstractEZSection {
    private MainframeSourceNode model;
    private static final String EMPTY_STRING = "";
    private Text txtPath;
    private Text txtType;
    private Map<String, Pair<Label, Text>> additionalControls = new HashMap<String, Pair<Label, Text>>();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericProgramSection.class, "path.label"));
        this.txtPath = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtPath.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(GenericProgramSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtType.setLayoutData((Object)gd);
        if (this.model != null) {
            List entries = this.model.getEntries();
            for (Pair e : entries) {
                Label l = this.getWidgetFactory().createLabel(this.composite, (String)e.getFirst());
                Text txt = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
                txt.setLayoutData((Object)gd);
                this.additionalControls.put((String)e.getFirst(), (Pair<Label, Text>)new Pair((Object)l, (Object)txt));
            }
        }
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getPath() != null) {
                this.txtPath.setText(this.model.getPath());
            } else {
                this.txtPath.setText(EMPTY_STRING);
            }
            if (this.model.getType() != null) {
                this.txtType.setText(this.model.getType());
            } else {
                this.txtType.setText(EMPTY_STRING);
            }
            List entries = this.model.getEntries();
            for (Pair p : entries) {
                Label l = this.getWidgetFactory().createLabel(this.composite, (String)p.getFirst());
                Text txt = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                txt.setLayoutData((Object)gd);
                this.additionalControls.put((String)p.getFirst(), (Pair<Label, Text>)new Pair((Object)l, (Object)txt));
                if (p.getSecond() != null) {
                    txt.setText((String)p.getSecond());
                    continue;
                }
                txt.setText(EMPTY_STRING);
            }
        }
        this.composite.layout();
    }

    private void clearData() {
        this.txtPath.setText(EMPTY_STRING);
        this.txtType.setText(EMPTY_STRING);
        for (Pair<Label, Text> pswt : this.additionalControls.values()) {
            ((Label)pswt.getFirst()).dispose();
            ((Text)pswt.getSecond()).dispose();
        }
        this.additionalControls.clear();
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof MainframeSourceNode) {
            this.model = (MainframeSourceNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

