/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DatasetSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EMPTY_STRING = "";
    private Text txtName;
    private Text txtMemberName;
    private Text txtGenerationNumber;
    private Text txtType;
    private DatasetNode model;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(DatasetSection.class, "name.label"));
        this.txtName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtName.setLayoutData((Object)gd);
        this.txtName.pack();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(DatasetSection.class, "member.name.label"));
        this.txtMemberName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtMemberName.setLayoutData((Object)gd);
        this.txtMemberName.pack();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(DatasetSection.class, "generation.number.label"));
        this.txtGenerationNumber = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtGenerationNumber.setLayoutData((Object)gd);
        this.txtGenerationNumber.pack();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(DatasetSection.class, "type.label"));
        this.txtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtType.setLayoutData((Object)gd);
        this.txtType.pack();
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getDatasetName() != null) {
                this.txtName.setText(this.model.getDatasetName());
            }
            if (this.model.getDatasetMemberName() != null) {
                this.txtMemberName.setText(this.model.getDatasetMemberName());
            }
            if (this.model.getDatasetGenerationNumber() != null) {
                if (this.model.getDatasetGenerationNumber().equals(0)) {
                    this.txtGenerationNumber.setText(EMPTY_STRING);
                } else {
                    this.txtGenerationNumber.setText(EMPTY_STRING + this.model.getDatasetGenerationNumber());
                }
            }
            if (this.model.getDatasetType() != null) {
                this.txtType.setText(this.model.getDatasetType());
            }
        }
        this.txtName.pack();
        this.txtMemberName.pack();
        this.txtGenerationNumber.pack();
        this.txtType.pack();
        this.composite.pack();
    }

    private void clearData() {
        this.txtName.setText(EMPTY_STRING);
        this.txtMemberName.setText(EMPTY_STRING);
        this.txtGenerationNumber.setText(EMPTY_STRING);
        this.txtType.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof DatasetNode) {
            this.model = (DatasetNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

