/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.DB2Node;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractTreeSection;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public class DB2Section
extends AbstractTreeSection {
    private EZEntityID eid;
    private Set<String> databases = new HashSet<String>();

    protected void buildElements(Object next, TreeItem keyItem) {
        String databaseName = (String)next;
        List<String> tables = this.getTablesForDb(databaseName);
        if (tables != null) {
            for (String table : tables) {
                TreeItem item = new TreeItem(keyItem, 0);
                String[] values = new String[]{"", table};
                item.setText(values);
                item.setData((Object)table);
            }
        }
    }

    protected List<String> getValuesForRow(Object next) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add((String)next);
        ret.add("");
        return ret;
    }

    protected Set getOwnedRows() {
        this.databases.clear();
        if (this.eid != null) {
            EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)this.eid.getSegment(EZSourceMainframeNodeIdSg.class);
            DB2Node obj = (DB2Node)sg.getResNode();
            this.databases.addAll(obj.getDatabases());
        }
        return this.databases;
    }

    protected void buildColumns() {
        TreeColumn colName = new TreeColumn(this.tree, 16384);
        colName.setText(Messages.getString(DB2Section.class, "database.name.text"));
        colName.setWidth(120);
        TreeColumn colTable = new TreeColumn(this.tree, 16384);
        colTable.setText(Messages.getString(DB2Section.class, "tables.text"));
        colTable.setWidth(200);
        this.columns = new ArrayList();
        this.columns.add(colName);
        this.columns.add(colTable);
    }

    protected void hookContextMenu() {
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID) {
            this.eid = (EZEntityID)input;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }

    private List<String> getTablesForDb(String databaseName) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.eid != null) {
            EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)this.eid.getSegment(EZSourceMainframeNodeIdSg.class);
            DB2Node obj = (DB2Node)sg.getResNode();
            list.addAll(obj.getDbTablesForDb(databaseName));
        }
        return list;
    }
}

