/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.cobol.callgraph.nodes.CPUNode;
import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.utils.Utils;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CPUSection
extends AbstractEZSection {
    private CPUNode node;
    private static final String EMPTY_STRING = "";
    private Text txtCPUId;
    private Text txtCPUModel;
    private Text txtTotalCPU;
    private Text txtEngineActiveNumber;
    private Text txtCPCName;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.widthHint = DpiScaler.getScaledSize((int)200);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(CPUSection.class, "cpu.id.label"));
        this.txtCPUId = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCPUId.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(CPUSection.class, "cpu.model.label"));
        this.txtCPUModel = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCPUModel.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(CPUSection.class, "number.of.cpus.label"));
        this.txtTotalCPU = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtTotalCPU.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(CPUSection.class, "no.of.engines.label"));
        this.txtEngineActiveNumber = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtEngineActiveNumber.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(CPUSection.class, "cpc.name.label"));
        this.txtCPCName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCPCName.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.node != null) {
            String cpcName;
            String activeCount;
            String cpuCount;
            String cpuModel;
            String cpuId = this.node.getCPUID();
            if (Utils.filterNullValue((String)cpuId) != null) {
                this.txtCPUId.setText(cpuId);
            }
            if (Utils.filterNullValue((String)(cpuModel = this.node.getCPUModel())) != null) {
                this.txtCPUModel.setText(cpuModel);
            }
            if (Utils.filterNullValue((String)(cpuCount = this.node.getCPUCount())) != null) {
                this.txtTotalCPU.setText(cpuCount);
            }
            if (Utils.filterNullValue((String)(activeCount = this.node.getActiveEngineCount())) != null) {
                this.txtEngineActiveNumber.setText(activeCount);
            }
            if (Utils.filterNullValue((String)(cpcName = this.node.getCPCName())) != null) {
                this.txtCPCName.setText(cpcName);
            }
        }
    }

    private void clearData() {
        this.txtCPUId.setText(EMPTY_STRING);
        this.txtCPUModel.setText(EMPTY_STRING);
        this.txtTotalCPU.setText(EMPTY_STRING);
        this.txtEngineActiveNumber.setText(EMPTY_STRING);
        this.txtCPCName.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null) {
            EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class);
            this.node = (CPUNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

