/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.properties.sections;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.properties.sections.GenericProgramRelatedSection;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.properties.CA7JobNode;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CA7JobSection
extends AbstractEZSection {
    private Text txtName;
    private Text txtType;
    private Text txtJobInfo;
    private CA7JobNode model;

    private static int textStyle(boolean isMultiline) {
        return isMultiline ? 2634 : 8;
    }

    private static GridData textGridData() {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        this.txtName = this.createText(Messages.getString(GenericProgramRelatedSection.class, "name.label"), false);
        this.txtType = this.createText(Messages.getString(GenericProgramRelatedSection.class, "type.label"), false);
        this.txtJobInfo = this.createText(Messages.getString(CA7JobSection.class, "job_info.label"), true);
    }

    private Text createText(String label, boolean isMultiline) {
        this.getWidgetFactory().createLabel(this.composite, label);
        Text textArea = this.getWidgetFactory().createText(this.composite, "", CA7JobSection.textStyle(isMultiline));
        textArea.setLayoutData((Object)CA7JobSection.textGridData());
        return textArea;
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getName() != null) {
                this.txtName.setText(this.model.getName());
            }
            if (this.model.getType() != null) {
                this.txtType.setText(this.model.getType());
            }
            if (this.model.getJobInfo() != null) {
                this.txtJobInfo.setText(this.model.getJobInfo());
            }
        }
        this.txtName.pack();
        this.txtType.pack();
        this.txtJobInfo.pack();
        this.composite.pack();
    }

    private void clearData() {
        this.txtName.setText("");
        this.txtType.setText("");
        this.txtJobInfo.setText("");
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (!(input instanceof EZEntityID)) {
            return;
        }
        EZEntityID eid = (EZEntityID)input;
        EZSourceMainframeNodeIdSg sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class);
        if (sg != null && (node = sg.getResNode()) instanceof CA7JobNode) {
            this.model = (CA7JobNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

