/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.programflow;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.nodes.ADSDialogProgramNode;
import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.AdsMapNode;
import com.ez.cobol.callgraph.nodes.AlgolProgramNode;
import com.ez.cobol.callgraph.nodes.AsmCsectProgramNode;
import com.ez.cobol.callgraph.nodes.AsmEntryProgramNode;
import com.ez.cobol.callgraph.nodes.AssemblerProgramNode;
import com.ez.cobol.callgraph.nodes.CLProgramNode;
import com.ez.cobol.callgraph.nodes.CobolProgramNode;
import com.ez.cobol.callgraph.nodes.DALFileNode;
import com.ez.cobol.callgraph.nodes.DBFileNode;
import com.ez.cobol.callgraph.nodes.DBINode;
import com.ez.cobol.callgraph.nodes.EZRexxProgramNode;
import com.ez.cobol.callgraph.nodes.FortranProgramNode;
import com.ez.cobol.callgraph.nodes.IMSDBNode;
import com.ez.cobol.callgraph.nodes.IdmsRecordNode;
import com.ez.cobol.callgraph.nodes.IdmsSetNode;
import com.ez.cobol.callgraph.nodes.NaturalMapNode;
import com.ez.cobol.callgraph.nodes.NaturalProgramNode;
import com.ez.cobol.callgraph.nodes.PLIProgramNode;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.cobol.callgraph.nodes.PrinterFileNode;
import com.ez.cobol.callgraph.nodes.QueueManagerNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.ResourceDatacomTableNode;
import com.ez.cobol.callgraph.nodes.ResourceFileNode;
import com.ez.cobol.callgraph.nodes.ResourceSQLTableNode;
import com.ez.cobol.callgraph.nodes.SCLProgramNode;
import com.ez.cobol.callgraph.nodes.SmartDbModuleProgramNode;
import com.ez.cobol.callgraph.nodes.SmartScreenNode;
import com.ez.cobol.callgraph.nodes.SmartSubroutineNode;
import com.ez.cobol.callgraph.nodes.TPMSXMapNode;
import com.ez.cobol.callgraph.nodes.TerminalNode;
import com.ez.cobol.callgraph.nodes.TerminalOrTransactionNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.nodes.UnknownProgramNode;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.flowchart.FlowchartGraphAnalysis;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.programflow.FlowGraphModel;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.ProgFlowNodeLegendInfo;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.MappingConstants;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ProgramInput;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.EZFitInCanvasCommand;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ProgFlowGraphJob
extends AnnotatedGraphJob
implements IMFRunnable {
    private static final Logger L = LoggerFactory.getLogger(ProgFlowGraphJob.class);
    private static final String PROG_GRAF_PARAGRAPHS = "EZReports_ProgGraf_paragraphs";
    private static final String PROG_GRAF_LINKS = "EZReports_ProgGraf_links";
    private static final String PROG_GRAF_PROGRAM_PATH = "EZReports_ProgGraf_programPath";
    private static final String PROG_GRAF_GENERIC_RESOURCE_CALL = "ProgramCallGraph";
    private static final String PROG_GRAF_NATURAL_MAP_WITH_PATH = "EZReports_ProgGraf_natural_map";
    private static final String PROG_GRAF_FILE = "EZReports_ProgGraf_fileWithoutPrinterFile";
    private static final String PROG_GRAF_PRINTERFILE = "EZReports_ProgGraf_printerFile";
    private static final String PROG_GRAF_BMS_MAP_WITH_PATH = "EZReports_ProgGraf_map";
    private static final String PROG_GRAF_ADS_MAP = "EZReports_ProgGraf_ads_map";
    private static final String PROG_GRAF_GOTO = "EZReports_ProgGraf_goto";
    private static final String PROG_GRAF_PL1INTERNALPROCCALLS = "EZReports_ProgGraf_pl1InternalProcCalls";
    private static final String PROG_GRAF_RECORDS = "EZReports_ProgGraf_idms_records_def";
    private static final String PROG_GRAF_SETS = "EZReports_ProgGraf_idms_sets_def";
    private static final String PROG_GRAF_SQLTABLE_WITH_PATH = "EZReports_ProgCallGraph_sqltables";
    private static final String PROG_GRAF_SMART_SCREENS = "EZReports_ProgGraf_smartScreens";
    private static final String PROG_GRAF_TPMSX = "EZReports_ProgGraf_TPMSX";
    private static final String PROG_GRAF_ADS_CALL = "EZReports_ProgGraf_ads_call";
    private static final String PROG_GRAF_FILE_VME = "EZReports_ProgGraf_fileWithoutPrinterFile_VME";
    private static final String RESOURCE_NAME_QUERY = "select Resources.ResourceID, Resources.Name from Resources where Resources.ResourceID IN (Select * from #numeric_param_temp)";
    private Action flowChartAction = null;
    private int programType;
    private GraphTSJobAdapter.ProgressAction customLayout = null;
    private EZEntityID inputEntityId;
    private MainframeMouseActionsHook mouseActionsHook = null;

    public ProgFlowGraphJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new MainframeMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new ProgFlowGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphModel = new FlowGraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
            this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        super.computeResults(graphModel, monitor);
        String ezsourcePrj = (String)this.analysis.getContextValue("input_project_names");
        IStatus status = com.ez.cobol.callgraph.utils.Utils.collectDataFromBridge((IProgressMonitor)monitor, (String)ezsourcePrj, (IMFRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        }
    }

    private void obtainInputs(SubMonitor pmonitor, ArrayList<String> prgAsParam, String name, String path, boolean isTest, String project) {
        EZSourceProjectIDSg prjIdSg;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ((FlowGraphModel)this.graphModel).clear();
        ((FlowGraphModel)this.graphModel).inputPrgName = name;
        ((FlowGraphModel)this.graphModel).projectIdSg = prjIdSg = (EZSourceProjectIDSg)this.inputEntityId.getSegment(EZSourceProjectIDSg.class);
        monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.paragraphs"));
        String[][] paragraphs = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_PARAGRAPHS, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).paragraphs = paragraphs;
        String[][] gotoStmts = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_GOTO, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).gotoStmts = gotoStmts;
        ArrayList<String> programNames = new ArrayList<String>();
        this.collectResources4Graph(programNames, prgAsParam, project, (IProgressMonitor)monitor);
        String proc = prjIdSg.getProjectInfo().isVME() ? PROG_GRAF_FILE_VME : PROG_GRAF_FILE;
        String[][] files = com.ez.cobol.callgraph.utils.Utils.runProc((String)proc, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).files = files;
        String[][] pfiles = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_PRINTERFILE, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).printerfiles = pfiles;
        Set standardProcs = null;
        String[][] links = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_LINKS, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).links = links;
        if (links != null) {
            boolean showStandardSCLProcs = PreferenceUtils.isShowingSCLProcs();
            if (!showStandardSCLProcs) {
                String ezsourcePrj = (String)this.analysis.getContextValue("input_project_names");
                standardProcs = com.ez.cobol.callgraph.utils.Utils.getStandardProcedures((String)ezsourcePrj, (IProgressMonitor)monitor.newChild(10));
            }
            String[][] stringArray = links;
            int n = links.length;
            int n2 = 0;
            while (n2 < n) {
                String[] link = stringArray[n2];
                String calledPrgTypeId = link[7];
                if (showStandardSCLProcs || !MappingConstants.SCL_Procedure_Type_STRING.equals(calledPrgTypeId) || !com.ez.cobol.callgraph.utils.Utils.isSCLStandardProcedure((String)link[5], (Set)standardProcs)) {
                    programNames.add(link[5]);
                }
                ++n2;
            }
        }
        String[][] pl1InternalCalls = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_PL1INTERNALPROCCALLS, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).pl1InternalCalls = pl1InternalCalls;
        if (!programNames.isEmpty()) {
            String[][] progPaths = isTest && System.getProperty("test") != null ? com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_PROGRAM_PATH, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project) : com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_PROGRAM_PATH, programNames, (EZSourceDataType)EZSourceDataType.String, (String)project);
            ((FlowGraphModel)this.graphModel).programPaths = progPaths;
        }
        String[][] ads_calls = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_ADS_CALL, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).ads_calls = ads_calls;
        ((FlowGraphModel)this.graphModel).standardProcs = standardProcs;
        monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.files"));
        String[][] tpmsxMaps = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_TPMSX, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        ((FlowGraphModel)this.graphModel).tpmsxMaps = tpmsxMaps;
        if (isTest && System.getProperty("test").equals("full")) {
            ((FlowGraphModel)this.graphModel).writeToFile(name, path.toString());
        }
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        boolean hasFlow;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgFlowGraphJob.class, "collecting.data"));
        List inputs = this.analysis.getContextListValue("input_list");
        this.inputEntityId = (EZEntityID)inputs.get(0);
        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)this.inputEntityId.getSegment(EZSourceProgramIDSg.class);
        String targetName = prgIdSg.getProgramName();
        this.programType = prgIdSg.getTypeId();
        boolean bl = hasFlow = this.programType == 1 || this.programType == 2 || this.programType == 10 || this.programType == 3 || this.programType == 9;
        if (hasFlow) {
            List progrNames = this.analysis.getContextListValue("available resources");
            Object path = this.analysis.getContextValue("selected path");
            String ezsourcePrj = (String)this.analysis.getContextValue("input_project_names");
            if (path != null && !path.toString().trim().equals("")) {
                TSEGraph mainGraph = this.graphModel.getGraph();
                int i = 0;
                while (i < progrNames.size()) {
                    ArrayList<String> prgAsParam = new ArrayList<String>();
                    prgAsParam.add(((ProgramInput)progrNames.get(i)).getName());
                    this.obtainInputs(monitor, prgAsParam, ((ProgramInput)progrNames.get(i)).getName(), path.toString(), true, ezsourcePrj);
                    this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                    TSEGraph newGraph = this.graphModel.getGraph();
                    ((FlowGraphModel)this.graphModel).writeGraphToFile(newGraph, ((ProgramInput)progrNames.get(i)).getName(), path.toString());
                    newGraph.dispose();
                    ++i;
                }
                this.graphModel.setGraph(mainGraph);
            } else {
                ArrayList<String> prgAsParam = new ArrayList<String>();
                prgAsParam.add(targetName);
                String emptyString = "";
                this.obtainInputs(monitor, prgAsParam, targetName, emptyString, false, ezsourcePrj);
            }
        }
        monitor.done();
    }

    private void collectResources4Graph(List<String> programNames, List<String> prgAsParam, String project, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(ProgFlowGraphJob.class, "collect.resources.taskName"));
        String[][] results = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_GENERIC_RESOURCE_CALL, prgAsParam, (EZSourceDataType)EZSourceDataType.String, (String)project);
        HashMap<Integer, Pair> resourcesWUDetailsByType = new HashMap<Integer, Pair>();
        if (results != null) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Pair details;
                String[] cols = stringArray[n2];
                Integer resType = Integer.valueOf(cols[12]);
                if (resourcesWUDetailsByType.get(resType) != null) {
                    details = (Pair)resourcesWUDetailsByType.get(resType);
                    ((Set)details.getFirst()).add(Integer.valueOf(cols[11]));
                    ((Set)details.getSecond()).add(cols);
                } else {
                    details = new Pair();
                    HashSet<Integer> ids = new HashSet<Integer>();
                    ids.add(Integer.valueOf(cols[11]));
                    details.setFirst(ids);
                    HashSet<String[]> wuDetails = new HashSet<String[]>();
                    wuDetails.add(cols);
                    details.setSecond(wuDetails);
                    resourcesWUDetailsByType.put(resType, details);
                }
                ++n2;
            }
        }
        block21: for (Integer resType : resourcesWUDetailsByType.keySet()) {
            Pair details = (Pair)resourcesWUDetailsByType.get(resType);
            switch (resType) {
                case 1: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.sql.tables"));
                    ((FlowGraphModel)this.graphModel).sqltables = (Collection)details.getSecond();
                    String[][] tablePaths = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_SQLTABLE_WITH_PATH, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).tablePaths = tablePaths;
                    break;
                }
                case 190: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.dbi"));
                    String resQuery = RESOURCE_NAME_QUERY;
                    Set<String[]> dbisSet = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, resQuery, project, monitor);
                    ((FlowGraphModel)this.graphModel).dbi = dbisSet;
                    break;
                }
                case 182: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.datacom"));
                    String datacomQuery = "select DatacomTables.ID, DatacomTables.TableName from DatacomTables where DatacomTables.ID IN (Select * from #numeric_param_temp)";
                    Set<String[]> datacoms = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, datacomQuery, project, monitor);
                    ((FlowGraphModel)this.graphModel).datacoms = datacoms;
                    break;
                }
                case 61: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.screens.natural"));
                    ((FlowGraphModel)this.graphModel).natural_maps = (Collection)details.getSecond();
                    String[][] nmPaths = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_NATURAL_MAP_WITH_PATH, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).natMapPaths = nmPaths;
                    break;
                }
                case 6: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.screens.bms"));
                    ((FlowGraphModel)this.graphModel).bms_maps = (Set)details.getSecond();
                    String[][] bmsPaths = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_BMS_MAP_WITH_PATH, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).bmsPaths = bmsPaths;
                    break;
                }
                case 56: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.adabas"));
                    Set<String[]> adabasSet = this.completeWithDetails((Pair<Set<Integer>, Set<String[]>>)details, "SELECT AdabasFiles.FileID, AdabasFiles.FileID, (CASE WHEN MFAdabasFiles.FileName IS NOT NULL THEN MFAdabasFiles.FileName          ELSE CONVERT(varchar(16), AdabasFiles.FileNumber) END) as fName , (CASE WHEN MFAdabasDB.DBName IS  NOT NULL THEN MFAdabasDB.DBName          ELSE CONVERT(varchar(16), AdabasDatabases.DBNumber) END) as db FROM AdabasFiles  INNER JOIN AdabasDatabases ON AdabasDatabases.AdabasDBID=AdabasFiles.AdabasDBID  LEFT JOIN MFAdabasFiles ON MFAdabasFiles.FileNumber=AdabasFiles.FileNumber  LEFT JOIN MFAdabasDB ON MFAdabasDB.DBNumber= AdabasDatabases.DBNumber WHERE AdabasFiles.FileID IN (Select * from #numeric_param_temp)", project, monitor);
                    if (adabasSet == null || adabasSet.isEmpty()) continue block21;
                    if (((FlowGraphModel)this.graphModel).adabasResources == null) {
                        ((FlowGraphModel)this.graphModel).adabasResources = new HashSet<String[]>();
                    }
                    ((FlowGraphModel)this.graphModel).adabasResources.addAll(adabasSet);
                    break;
                }
                case 62: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.adabas"));
                    Set<String[]> adabasSet = this.completeWithDetails((Pair<Set<Integer>, Set<String[]>>)details, "SELECT AdabasView.ViewID, AdabasFiles.FileID, (CASE WHEN MFAdabasFiles.FileName IS NOT NULL THEN MFAdabasFiles.FileName          ELSE CONVERT(varchar(16), AdabasFiles.FileNumber) END) as fName , (CASE WHEN MFAdabasDB.DBName IS  NOT NULL THEN MFAdabasDB.DBName          ELSE CONVERT(varchar(16), AdabasDatabases.DBNumber) END) as db FROM AdabasView INNER JOIN AdabasFiles ON AdabasView.AdabasFileID = AdabasFiles.FileID  INNER JOIN AdabasDatabases ON AdabasDatabases.AdabasDBID=AdabasFiles.AdabasDBID  LEFT JOIN MFAdabasFiles ON MFAdabasFiles.FileNumber=AdabasFiles.FileNumber  LEFT JOIN MFAdabasDB ON MFAdabasDB.DBNumber= AdabasDatabases.DBNumber WHERE AdabasView.ViewID IN (Select * from #numeric_param_temp) ", project, monitor);
                    if (adabasSet == null || adabasSet.isEmpty()) continue block21;
                    if (((FlowGraphModel)this.graphModel).adabasResources == null) {
                        ((FlowGraphModel)this.graphModel).adabasResources = new HashSet<String[]>();
                    }
                    ((FlowGraphModel)this.graphModel).adabasResources.addAll(adabasSet);
                    break;
                }
                case 193: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.adabas"));
                    Set<String[]> adabasSet = this.completeWithDetails((Pair<Set<Integer>, Set<String[]>>)details, "SELECT NaturalDBView.ViewId, AdabasFiles.FileID , (CASE WHEN MFAdabasFiles.FileName IS NOT NULL THEN MFAdabasFiles.FileName          ELSE CONVERT(varchar(16), AdabasFiles.FileNumber) END) as fName , (CASE WHEN MFAdabasDB.DBName IS  NOT NULL THEN MFAdabasDB.DBName          ELSE CONVERT(varchar(16), AdabasDatabases.DBNumber) END) as db FROM NaturalDBView INNER JOIN NaturalDDM on NaturalDDM.DDM_ID = NaturalDBView.DDM_ID  INNER JOIN AdabasView ON AdabasView.ViewID=NaturalDDM.ReferenceResourceID AND NaturalDDM.ResourceType=62  INNER JOIN AdabasFiles ON AdabasFiles.FileID=AdabasView.AdabasFileID  INNER JOIN AdabasDatabases ON AdabasDatabases.AdabasDBID=AdabasFiles.AdabasDBID  LEFT JOIN MFAdabasFiles ON MFAdabasFiles.FileNumber=AdabasFiles.FileNumber  LEFT JOIN MFAdabasDB ON MFAdabasDB.DBNumber= AdabasDatabases.DBNumber WHERE NaturalDBView.ViewId IN (Select * from #numeric_param_temp)", project, monitor);
                    if (adabasSet == null || adabasSet.isEmpty()) continue block21;
                    if (((FlowGraphModel)this.graphModel).adabasResources == null) {
                        ((FlowGraphModel)this.graphModel).adabasResources = new HashSet<String[]>();
                    }
                    ((FlowGraphModel)this.graphModel).adabasResources.addAll(adabasSet);
                    break;
                }
                case 77: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.idms.record"));
                    ((FlowGraphModel)this.graphModel).idmsCallRecords = (Collection)details.getSecond();
                    results = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_RECORDS, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).recordDefinitions = results;
                    break;
                }
                case 78: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.idms.set"));
                    ((FlowGraphModel)this.graphModel).idmsCallSets = (Collection)details.getSecond();
                    String[][] setDefinitions = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_SETS, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).setDefinitions = setDefinitions;
                    break;
                }
                case 14: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.transactions"));
                    String transactionsQuery = "select Resources.ResourceID, Resources.Name, Resources.ProgName, Programs_1.ProgramTypeID, Programs_1.ProgramID, Programs_1.Ancestor, Programs_2.ProgramID from Resources LEFT JOIN Programs AS Programs_1 on Programs_1.ProgramName = Resources.ProgName LEFT JOIN Programs AS Programs_2 on Programs_1.Ancestor=Programs_2.ProgramName where Resources.ResourceID IN (Select * from #numeric_param_temp)";
                    Set<String[]> transactionsSet = this.completeWithDetails((Pair<Set<Integer>, Set<String[]>>)details, transactionsQuery, project, monitor);
                    ((FlowGraphModel)this.graphModel).transactions = transactionsSet;
                    for (String[] dbDetails : transactionsSet) {
                        String prgId;
                        String string = prgId = dbDetails.length > 19 ? dbDetails[15] : dbDetails[10];
                        if (Utils.filterNullValue((String)prgId) == null) continue;
                        programNames.add(prgId);
                    }
                    continue block21;
                }
                case 189: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.dal"));
                    String dalQuery = "select Resources.ResourceID, Resources.Name, Resources.OccurID from Resources where Resources.ResourceID IN (Select * from #numeric_param_temp)";
                    Collection dalID = (Collection)details.getFirst();
                    List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dalID.size()]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    results = com.ez.cobol.callgraph.utils.Utils.runSQLQuery((String)dalQuery, (Collection)dalID, (EZSourceDataType)EZSourceDataType.Integer, (String)project, (IProgressMonitor)monitor);
                    HashMap<String, Pair> dalMap = new HashMap<String, Pair>();
                    String[][] stringArray = results;
                    int n = results.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String[] cols = stringArray[n3];
                        dalMap.put(cols[0], new Pair((Object)cols[1], (Object)cols[2]));
                        ++n3;
                    }
                    HashSet<String[]> dalSet = new HashSet<String[]>();
                    for (String[] dal : (Set)details.getSecond()) {
                        String[] dalDetails = new String[dal.length + 2];
                        System.arraycopy(dal, 0, dalDetails, 0, dal.length);
                        Pair p = (Pair)dalMap.get(dal[11]);
                        dalDetails[dal.length] = (String)p.getFirst();
                        dalDetails[dal.length + 1] = (String)p.getSecond();
                        dalSet.add(dalDetails);
                    }
                    ((FlowGraphModel)this.graphModel).dal = dalSet;
                    break;
                }
                case 81: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.queue"));
                    String qsQuery = "select MQQueues.QueueID, MQQueues.QueueName from MQQueues where MQQueues.QueueID IN (Select * from #numeric_param_temp)";
                    Set<String[]> mqQueuesSet = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, qsQuery, project, monitor);
                    ((FlowGraphModel)this.graphModel).mqQueues = mqQueuesSet;
                    break;
                }
                case 79: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.queue.manager"));
                    String managersQuery = "select MQQueueManagers.QueueManagerID, MQQueueManagers.QueueManagerName from MQQueueManagers where MQQueueManagers.QueueManagerID IN (Select * from #numeric_param_temp)";
                    Set<String[]> mqManagers = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, managersQuery, project, monitor);
                    ((FlowGraphModel)this.graphModel).mqManagers = mqManagers;
                    break;
                }
                case 69: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.smart.screens"));
                    ((FlowGraphModel)this.graphModel).smartScreens = (Collection)details.getSecond();
                    results = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_SMART_SCREENS, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    ((FlowGraphModel)this.graphModel).smartScreenPaths = results;
                    break;
                }
                case 95: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.screens.ads"));
                    results = com.ez.cobol.callgraph.utils.Utils.runProc((String)PROG_GRAF_ADS_MAP, (Collection)((Collection)details.getFirst()), (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                    HashMap<String, String[]> adsMapMap = new HashMap<String, String[]>();
                    String[][] stringArray = results;
                    int n = results.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String[] adsMapDetails = stringArray[n4];
                        adsMapMap.put(adsMapDetails[0], adsMapDetails);
                        ++n4;
                    }
                    HashSet<String[]> resultsSet = new HashSet<String[]>();
                    for (String[] adsMapsWU : (Set)details.getSecond()) {
                        String[] mapDetails = (String[])adsMapMap.get(adsMapsWU[0]);
                        String[] adsMap = new String[adsMapsWU.length + mapDetails.length - 1];
                        System.arraycopy(adsMapsWU, 0, adsMap, 0, adsMapsWU.length);
                        System.arraycopy(mapDetails, 1, adsMap, adsMapsWU.length, mapDetails.length - 1);
                        resultsSet.add(adsMap);
                    }
                    ((FlowGraphModel)this.graphModel).ads_maps = resultsSet;
                    break;
                }
                case 18: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.imsDB"));
                    String imsDBQuery = "select IMSDBInfo.DBId, IMSDBInfo.DBName from IMSDBInfo  where IMSDBInfo.DBId IN (Select * from #numeric_param_temp)";
                    Set<String[]> imsDBs = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, imsDBQuery, project, monitor);
                    if (((FlowGraphModel)this.graphModel).imsdbs == null) {
                        ((FlowGraphModel)this.graphModel).imsdbs = new HashSet<String[]>();
                    }
                    ((FlowGraphModel)this.graphModel).imsdbs.addAll(imsDBs);
                    break;
                }
                case 19: 
                case 21: {
                    monitor.subTask(Messages.getString(ProgFlowGraphJob.class, "compute.imsDB"));
                    String imsQuery = RESOURCE_NAME_QUERY;
                    Set<String[]> imsdbs = this.completeWithResourceName((Pair<Set<Integer>, Set<String[]>>)details, imsQuery, project, monitor);
                    if (((FlowGraphModel)this.graphModel).imsdbs == null) {
                        ((FlowGraphModel)this.graphModel).imsdbs = new HashSet<String[]>();
                    }
                    ((FlowGraphModel)this.graphModel).imsdbs.addAll(imsdbs);
                }
            }
        }
    }

    private Set<String[]> completeWithResourceName(Pair<Set<Integer>, Set<String[]>> details, String resQuery, String project, SubMonitor monitor) {
        Collection dbIDs = (Collection)details.getFirst();
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dbIDs.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        String[][] results = com.ez.cobol.callgraph.utils.Utils.runSQLQuery((String)resQuery, (Collection)dbIDs, (EZSourceDataType)EZSourceDataType.Integer, (String)project, (IProgressMonitor)monitor);
        HashSet<String[]> dbSet = new HashSet<String[]>();
        if (results != null) {
            HashMap<String, String> dbMap = new HashMap<String, String>();
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] db = stringArray[n2];
                dbMap.put(db[0], db[1]);
                ++n2;
            }
            for (String[] db : (Set)details.getSecond()) {
                String[] dbDetails = new String[db.length + 1];
                System.arraycopy(db, 0, dbDetails, 0, db.length);
                dbDetails[db.length] = (String)dbMap.get(db[11]);
                dbSet.add(dbDetails);
            }
        } else {
            L.warn("no details for resQuery=" + resQuery + ", dbId=" + dbIDs);
        }
        return dbSet;
    }

    private Set<String[]> completeWithDetails(Pair<Set<Integer>, Set<String[]>> genericResults, String resQuery, String project, SubMonitor monitor) {
        Collection dbIDs = (Collection)genericResults.getFirst();
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dbIDs.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        String[][] results = com.ez.cobol.callgraph.utils.Utils.runSQLQuery((String)resQuery, (Collection)dbIDs, (EZSourceDataType)EZSourceDataType.Integer, (String)project, (IProgressMonitor)monitor);
        HashSet<String[]> dbSet = new HashSet<String[]>();
        if (results != null) {
            HashMap<String, String[]> dbMap = new HashMap<String, String[]>();
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] db = stringArray[n2];
                dbMap.put(db[0], Arrays.copyOfRange(db, 1, db.length));
                ++n2;
            }
            for (String[] db : (Set)genericResults.getSecond()) {
                String[] resId = (String[])dbMap.get(db[11]);
                if (resId != null) {
                    String[] dbDetails = new String[db.length + resId.length];
                    System.arraycopy(db, 0, dbDetails, 0, db.length);
                    System.arraycopy(resId, 0, dbDetails, db.length, resId.length);
                    dbSet.add(dbDetails);
                    continue;
                }
                L.debug("no details for resourceId=" + resId);
            }
        } else {
            L.warn("no details for resQuery=" + resQuery + ", dbId=" + dbIDs);
        }
        return dbSet;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        int dl = this.getDefaultLayout();
        this.customLayout = new GraphTSJobAdapter.ProgressAction((GraphTSJobAdapter)this, Messages.getString(ProgFlowGraphJob.class, "resLayout.action.text"), 8){

            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString(ProgFlowGraphJob.class, "resourceLay.task.text"), -1);
                List cmds = ProgFlowGraphJob.this.doLayout(5);
                ProgFlowGraphJob.this.transmitCommands(cmds);
                ProgFlowGraphJob.this.currentLayoutType = 5;
                monitor.done();
            }
        };
        if (dl == 5) {
            this.customLayout.setChecked(true);
        } else {
            this.customLayout.setChecked(false);
        }
        this.customLayout.setToolTipText(Messages.getString(ProgFlowGraphJob.class, "resLay.action.tooltip"));
        ImageDescriptor id = Activator.getImageDescriptor("icons//resourcesLayout.png");
        this.customLayout.setImageDescriptor(id);
        this.createEdgesActions();
        this.createIconActions();
        List inputs = this.analysis.getContextListValue("input_list");
        final EZEntityID inputEntityId = (EZEntityID)inputs.get(0);
        EZSourceProgramIDSg prgIdSg = (EZSourceProgramIDSg)inputEntityId.getSegment(EZSourceProgramIDSg.class);
        final int programType = prgIdSg.getTypeId();
        if (programType != ProgramType.ADS_PROCESS.getProgramTypeId()) {
            L.debug("create 'flow chart' action for program type id " + programType);
            this.flowChartAction = new Action(){

                public void run() {
                    EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(programType));
                    if (inputType != null) {
                        L.debug("analysis inputType" + inputType.getName());
                        inputType.setEntID(inputEntityId);
                        EZAnalysisType analysisType = EZWorkspace.getInstance().getSpecificAnalysisType(inputType, FlowchartGraphAnalysis.class);
                        if (analysisType != null) {
                            L.debug("analysisType:" + analysisType.getName());
                            EZAnalysis analysis = analysisType.getImplementorInstance();
                            ArrayList<EZObjectType> inputs = new ArrayList<EZObjectType>();
                            inputs.add(inputType);
                            analysis.setInputs(inputs);
                            L.debug("before execute flow chart");
                            analysis.execute();
                            ProgFlowGraphJob.this.flowChartAction.setChecked(false);
                        }
                    }
                }
            };
            this.flowChartAction.setText(Messages.getString(ProgFlowGraphJob.class, "flowchart.action.text"));
            this.flowChartAction.setToolTipText(Messages.getString(ProgFlowGraphJob.class, "flowchart.action.tooltip"));
            id = Activator.getImageDescriptor("icons/programflowchart.png");
            this.flowChartAction.setImageDescriptor(id);
            this.flowChartAction.setChecked(false);
        }
    }

    public List getMenuItems() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(new ActionContributionItem((IAction)this.fitAction));
        menuItems.add(new Separator());
        menuItems.add(new ActionContributionItem((IAction)this.select));
        menuItems.add(new ActionContributionItem((IAction)this.pan));
        menuItems.add(new ActionContributionItem((IAction)this.mzoom));
        menuItems.add(new ActionContributionItem((IAction)this.izoom));
        menuItems.add(new ActionContributionItem((IAction)this.nedges));
        menuItems.add(new Separator());
        menuItems.add(new ActionContributionItem((IAction)this.customLayout));
        menuItems.add(new ActionContributionItem((IAction)this.hierarchical));
        menuItems.add(new ActionContributionItem((IAction)this.symmetric));
        menuItems.add(new ActionContributionItem((IAction)this.circular));
        menuItems.add(new ActionContributionItem((IAction)this.orthogonal));
        this.contributeRedrawEntry(menuItems);
        this.contributeEdgesEntries(menuItems);
        this.contributeIconEntries(menuItems);
        return menuItems;
    }

    public List getToolBarItems() {
        ArrayList<Object> toolbars = new ArrayList<Object>();
        if (this.flowChartAction != null) {
            L.debug("add 'flow chart' toolbar action");
            toolbars.add(new Separator());
            toolbars.add(new ActionContributionItem((IAction)this.flowChartAction));
        }
        this.contributeIconEntries(toolbars);
        this.contributeEdgesEntries(toolbars);
        this.contributeRedrawEntry(toolbars);
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.fitAction));
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.select));
        toolbars.add(new ActionContributionItem((IAction)this.pan));
        toolbars.add(new ActionContributionItem((IAction)this.mzoom));
        toolbars.add(new ActionContributionItem((IAction)this.izoom));
        toolbars.add(new ActionContributionItem((IAction)this.nedges));
        toolbars.add(new Separator());
        toolbars.add(new ActionContributionItem((IAction)this.customLayout));
        toolbars.add(new ActionContributionItem((IAction)this.hierarchical));
        toolbars.add(new ActionContributionItem((IAction)this.symmetric));
        toolbars.add(new ActionContributionItem((IAction)this.circular));
        toolbars.add(new ActionContributionItem((IAction)this.orthogonal));
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
        if (this.customLayout != null) {
            this.customLayout.setEnabled(state);
        }
        if (this.flowChartAction != null) {
            this.flowChartAction.setEnabled(state);
        }
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        IStatus statusResult = super.finalTSGraphOperations(monitor, result);
        if (this.gfi != null) {
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        return statusResult;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        com.ez.cobol.callgraph.utils.Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend, uiStyle);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
                if (nodeLegendInfo instanceof ProgFlowNodeLegendInfo) {
                    imagePath = nodeLegendInfo.getColorboxImagePath();
                }
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(nodeLegendInfo.getNodeTypeClass(), imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    private void addFilters(GraphFilterInfo gfi) {
        gfi.registerFilterType(ParagraphNode.class);
        gfi.registerFilterType(ADSDialogProgramNode.class);
        gfi.registerFilterType(AlgolProgramNode.class);
        gfi.registerFilterType(AssemblerProgramNode.class);
        gfi.registerFilterType(AsmCsectProgramNode.class);
        gfi.registerFilterType(AsmEntryProgramNode.class);
        gfi.registerFilterType(CLProgramNode.class);
        gfi.registerFilterType(CobolProgramNode.class);
        gfi.registerFilterType(FortranProgramNode.class);
        gfi.registerFilterType(NaturalProgramNode.class);
        gfi.registerFilterType(PLIProgramNode.class);
        gfi.registerFilterType(EZRexxProgramNode.class);
        gfi.registerFilterType(SCLProgramNode.class);
        gfi.registerFilterType(SmartDbModuleProgramNode.class);
        gfi.registerFilterType(SmartSubroutineNode.class);
        gfi.registerFilterType(UnknownProgramNode.class);
        gfi.registerFilterType(AdabasNode.class);
        gfi.registerFilterType(AdsMapNode.class);
        gfi.registerFilterType(ResourceFileNode.class);
        gfi.registerFilterType(IdmsRecordNode.class);
        gfi.registerFilterType(IdmsSetNode.class);
        gfi.registerFilterType(IMSDBNode.class);
        gfi.registerFilterType(NaturalMapNode.class);
        gfi.registerFilterType(PrinterFileNode.class);
        gfi.registerFilterType(QueueNode.class);
        gfi.registerFilterType(QueueManagerNode.class);
        gfi.registerFilterType(SmartScreenNode.class);
        gfi.registerFilterType(ResourceSQLTableNode.class);
        gfi.registerFilterType(TerminalNode.class);
        gfi.registerFilterType(TerminalOrTransactionNode.class);
        gfi.registerFilterType(TransactionNode.class);
        gfi.registerFilterType(ResourceDatacomTableNode.class);
        gfi.registerFilterType(TPMSXMapNode.class);
        gfi.registerFilterType(DBFileNode.class);
        gfi.registerFilterType(DALFileNode.class);
        gfi.registerFilterType(DBINode.class);
    }

    protected int getDefaultLayout() {
        return 5;
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        if (type == 5) {
            ((FlowGraphModel)this.graphModel).customLayout();
            layoutCommand = new EZFitInCanvasCommand(this.canvas);
        } else {
            layoutCommand = super.doLayout(type, graph);
        }
        return layoutCommand;
    }

    public void closing() {
        super.closing();
        this.customLayout = null;
    }

    public class ProgFlowGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;

        public ProgFlowGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage("programFlow", "icons/resourcesLayout.png");
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("programFlow");
            }
            return this.image;
        }

        public String getText() {
            StringBuilder sb = new StringBuilder();
            List inputs = ProgFlowGraphJob.this.analysis.getContextListValue("input_list");
            for (Object obj : inputs) {
                if (!(obj instanceof EZEntityID)) continue;
                EZEntityID entity = (EZEntityID)obj;
                EZSourceProgramIDSg prgSg = (EZSourceProgramIDSg)entity.getSegment(EZSourceProgramIDSg.class);
                sb.append(prgSg.getProgramName());
                if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                sb.append(", ");
            }
            String lbl = Messages.getString(ProgFlowGraphJob.class, "prg.flow.graph.analysis.lbl", new String[]{sb.toString(), ProgFlowGraphJob.this.analysis.getContextValue("input_project_names").toString()});
            return lbl;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){
                private LegendPanel legend;

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    this.legend = new LegendPanel((Composite)sc, 0);
                    int uiStyle = ProgFlowGraphJob.this.graphModel.getUIStyle();
                    ProgFlowGraphJob.this.addEntriesToLegend(this.legend, uiStyle, ProgFlowGraphInfo.this.gfi);
                    sc.setContent((Control)this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    this.legend.pack();
                    sc.setMinSize(this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = this.legend.getSize().x;
                    int x = this.legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            ProgFlowGraphJob.this.legend = null;
            super.dispose();
        }
    }
}

