/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.programflow;

import com.ez.cobol.callgraph.CallgraphEdgeLegendInfo;
import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.nodes.ParagraphNode;
import com.ez.cobol.callgraph.utils.CallgraphEdgeUtils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.programflow.TSENodeComparator;
import com.ez.graphs.viewer.utils.ProgFlowEdgeLegendInfo;
import com.ez.graphs.viewer.utils.ProgFlowNodeLegendInfo;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.AdabasUtils;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.MappingConstants;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceAdabasIDSg;
import com.ez.workspace.model.segments.EZSourceDALIDSg;
import com.ez.workspace.model.segments.EZSourceDBIIDSg;
import com.ez.workspace.model.segments.EZSourceDDCLElementIDSg;
import com.ez.workspace.model.segments.EZSourceDatacomTableIDSg;
import com.ez.workspace.model.segments.EZSourceFileIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSRecordIDSg;
import com.ez.workspace.model.segments.EZSourceIDMSSetIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDBIDSg;
import com.ez.workspace.model.segments.EZSourceIMSDatabaseIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceQueueIDSg;
import com.ez.workspace.model.segments.EZSourceQueueManagerIDSg;
import com.ez.workspace.model.segments.EZSourceSQLTableIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceSmartScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.geometry.shared.TSConstSize;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.composite.TSCompositeNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSImageUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSSplitterUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSTextUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElementPoint;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.interactive.service.layout.client.TSEApplyLayoutResults;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.TSRoutingInputTailor;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import images.LoadSVGImages;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FlowGraphModel
extends AnnotatedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String SCREEN_NAME_KEY = "screenName";
    private static final String SCREEN_OCCUR_ID_ATTRIBUTE = "ScreenOccurId Attribute";
    private static final String SCREEN_ID = "ScreenID attribute";
    private static final Logger L = LoggerFactory.getLogger(FlowGraphModel.class);
    private static final String TEXT_COLOR = "Text_Color";
    private static final String FILL_COLOR = "Fill_Color";
    private static final String EDGE_DIRECTION = "edge direction";
    private boolean IS_FILTER_EXIT_PARAGRAPHS_COBOL_CALLGRAPH = false;
    private TSNodeBuilder nodeBuilder;
    private TSEdgeBuilder edgeBuilder;
    private List<TSENode> paraNodes = new ArrayList<TSENode>();
    private List<TSENode> resNodes = new ArrayList<TSENode>();
    public String[][] paragraphs;
    public String[][] gotoStmts;
    public Set<String[]> transactions;
    public Set<String[]> dal;
    public Set<String[]> bms_maps;
    public String[][] bmsPaths;
    public Set<String[]> ads_maps;
    public Collection<String[]> natural_maps;
    public String[][] natMapPaths;
    public String[][] files;
    public String[][] printerfiles;
    public Set<String[]> adabasResources;
    public String[][] links;
    public String[][] programPaths;
    public String[][] pl1InternalCalls;
    public Collection<String[]> idmsCallRecords;
    public String[][] recordDefinitions;
    public Collection<String[]> idmsCallSets;
    public String[][] setDefinitions;
    public Collection<String[]> sqltables;
    public String[][] ads_calls;
    public Set<String[]> mqManagers;
    public Set<String[]> mqQueues;
    public Set<String[]> imsdbs;
    public String[][] tablePaths;
    public Collection<String[]> smartScreens;
    public String[][] smartScreenPaths;
    public Set<String[]> datacoms;
    public String[][] tpmsxMaps;
    public Set<String[]> dbi;
    public EZSourceProjectIDSg projectIdSg;
    public String inputPrgName;
    int minParagraphHeightNode = 40;
    int minResHeightNode = 40;
    int minVerticalParagraphSpace = 60;
    int paragraphEdgeSpacingCoeficient = 1;
    int resXDisplacement = 400;
    Set<String> standardProcs;

    public FlowGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
        this.initialize();
    }

    private void initialize() {
        this.outForGISV.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        if (this.paragraphs == null) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(FlowGraphModel.class, "noresults.node.name"));
            L.debug("no paragraphs ");
        } else {
            this.initGraph();
            this.paraNodes.clear();
            this.resNodes.clear();
            HashMap<String, TSENode> paragraphNodes = new HashMap<String, TSENode>();
            int prevFallThroughType = 0;
            TSENode prevNode = null;
            String prgType = null;
            String[][] stringArray = this.paragraphs;
            int n = this.paragraphs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] paragraph = stringArray[n2];
                boolean createNode = false;
                if (this.IS_FILTER_EXIT_PARAGRAPHS_COBOL_CALLGRAPH) {
                    int isExitPara = Integer.parseInt(paragraph[5]);
                    if (isExitPara != -1) {
                        createNode = true;
                    } else if (this.gotoStmts != null) {
                        String[][] stringArray2 = this.gotoStmts;
                        int n3 = this.gotoStmts.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String[] gotoStmt = stringArray2[n4];
                            int type = Integer.valueOf(gotoStmt[4]);
                            if (gotoStmt[3].equals(paragraph[1]) && type == 22) {
                                createNode = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                } else {
                    createNode = true;
                }
                if (createNode) {
                    prgType = paragraph[11];
                    IGraphNodeLegendInfo paraType = FlowGraphModel.getParaTypeByPrgType(prgType);
                    TSENode para = this.nodeBuilder.addNode(this.graph);
                    ParagraphNode paraNode = new ParagraphNode(paragraph[1], paragraph[2], paragraph[5], paragraph[12], paragraph[13], paragraph[3], paragraph[14], paragraph[15]);
                    para.setAttribute("Node_Mainframe", (Object)paraNode);
                    para.setAttribute(FILL_COLOR, (Object)paraType.getTSEColor());
                    this.makeFileAttribute((TSGraphMember)para, paragraph[10], paragraph[11], paragraph[6], paragraph[8], paragraph[7], paragraph[9]);
                    para.setName((Object)paragraph[1]);
                    para.setTooltipText(paragraph[1]);
                    if (prevFallThroughType > 0 && prevNode != null) {
                        TSEEdge fallThrough = this.edgeBuilder.addEdge(this.graphManager, prevNode, para);
                        fallThrough.setAttribute("STMT_TYPE", (Object)ResourceLink.FAKE_STMT_TYPE_FOR_FALL_THROUGH_STRING);
                        this.makeFileAttribute((TSGraphMember)fallThrough, paragraph[10], paragraph[11], paragraph[6], paragraph[8], paragraph[7], paragraph[9]);
                        if (prevFallThroughType == 1) {
                            fallThrough.setAttribute("Color", (Object)ProgFlowEdgeLegendInfo.FALLTHROUGH.getTSEColor());
                            this.edgeTypesSetForLegend.add(ProgFlowEdgeLegendInfo.FALLTHROUGH);
                        } else {
                            fallThrough.setAttribute("Color", (Object)ProgFlowEdgeLegendInfo.COND_FALLTHROUGH.getTSEColor());
                            this.edgeTypesSetForLegend.add(ProgFlowEdgeLegendInfo.COND_FALLTHROUGH);
                        }
                    }
                    prevFallThroughType = Integer.valueOf(paragraph[3]);
                    prevNode = para;
                    this.paraNodes.add(para);
                    paragraphNodes.put(paragraph[1], para);
                    paraNode.setParagraphTypeLbl(paraType.getLegendLabel());
                    para.setAttribute("class_name", (Object)paraType.getNodeTypeClass());
                    this.putEntriesInGISV(paraType.getLegendLabel(), para);
                    this.nodeTypesSetForLegend.add(paraType);
                } else {
                    prevNode = null;
                }
                ++n2;
            }
            if (this.gotoStmts != null) {
                stringArray = this.gotoStmts;
                n = this.gotoStmts.length;
                n2 = 0;
                while (n2 < n) {
                    String[] gotoStmt = stringArray[n2];
                    int type = Integer.valueOf(gotoStmt[4]);
                    TSENode source = (TSENode)paragraphNodes.get(gotoStmt[1]);
                    TSENode dest = (TSENode)paragraphNodes.get(gotoStmt[3]);
                    if (dest != null) {
                        ProgFlowEdgeLegendInfo edgeType = null;
                        DIRECTION direction = DIRECTION.RIGHT_TO_RIGHT;
                        int conditionalType = Integer.valueOf(gotoStmt[5]);
                        if (type == 22) {
                            edgeType = conditionalType == 1 ? ProgFlowEdgeLegendInfo.COND_GOTO : CallgraphEdgeLegendInfo.GOTO;
                        } else {
                            edgeType = conditionalType == 1 ? ProgFlowEdgeLegendInfo.COND_PERFORM : ProgFlowEdgeLegendInfo.PERFORM;
                            direction = DIRECTION.LEFT_TO_LEFT;
                        }
                        TSEEdge gotoEdge = this.getEdgeIfExists(source, dest, gotoStmt[4], edgeType.getTSEColor());
                        if (gotoEdge == null) {
                            gotoEdge = this.edgeBuilder.addEdge(this.graphManager, source, dest);
                            gotoEdge.setAttribute("STMT_TYPE", (Object)gotoStmt[4]);
                            gotoEdge.setAttribute("Color", (Object)edgeType.getTSEColor());
                            gotoEdge.setAttribute(EDGE_DIRECTION, (Object)direction);
                        }
                        this.makeFileAttribute((TSGraphMember)gotoEdge, gotoStmt[10], prgType, gotoStmt[6], gotoStmt[8], gotoStmt[7], gotoStmt[9]);
                        this.edgeTypesSetForLegend.add(edgeType);
                    }
                    ++n2;
                }
            }
            this.makeTransactionNodes(paragraphNodes, prgType);
            this.makeBmsMapNodes(paragraphNodes, prgType);
            this.makeAdsMapNodes(paragraphNodes, prgType);
            this.makeNaturalMapNodes(paragraphNodes, prgType);
            this.makeFileNodes(paragraphNodes, prgType);
            this.makePrinterFileNodes(paragraphNodes, prgType);
            this.makeAdabasNodes(paragraphNodes, prgType);
            this.makePl1InternalCalls(paragraphNodes, prgType);
            this.makeIdmsCallRecordNodes(paragraphNodes, prgType);
            this.makeIdmsCallSetNodes(paragraphNodes, prgType);
            this.makeSqlTableNodes(paragraphNodes, prgType);
            this.makeAdsCallNodes(paragraphNodes, prgType);
            this.makeMQManagerNodes(paragraphNodes, prgType);
            this.makeMQQueueNodes(paragraphNodes, prgType);
            this.makeIMSDBNodes(paragraphNodes, prgType);
            this.makeSmartScreenNodes(paragraphNodes, prgType);
            this.makeDatacomNodes(paragraphNodes, prgType);
            this.makeDALNodes(paragraphNodes, prgType);
            this.makeDBINodes(paragraphNodes, prgType);
            this.makeProgramNodes(paragraphNodes, prgType);
            if (this.projectIdSg.getProjectInfo().isVME()) {
                this.makeTPMSXMapsNodes(paragraphNodes, prgType);
            }
            this.findAnnotations(monitor);
        }
        monitor.done();
    }

    private void makeProgramNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        block5: {
            HashMap<String, TSENode> unknownPrograms = new HashMap<String, TSENode>();
            HashMap<String, HashMap<String, TSENode>> programsMap = new HashMap<String, HashMap<String, TSENode>>();
            if (this.links == null) break block5;
            boolean showStandardSCLProcs = PreferenceUtils.isShowingSCLProcs();
            int pos = 0;
            while (pos < this.links.length) {
                block6: {
                    String name;
                    boolean isUnknown;
                    String prgTypeIdString;
                    TSENode linkNode;
                    TSENode para;
                    String[] link;
                    block9: {
                        block7: {
                            block8: {
                                boolean isPrevUnknown;
                                link = this.links[pos];
                                para = paragraphNodes.get(link[1]);
                                if (para == null) break block6;
                                linkNode = null;
                                prgTypeIdString = link[7];
                                isUnknown = Utils.filterNullValue((String)prgTypeIdString) == null || prgTypeIdString.equals("-1") || prgTypeIdString.equals("0");
                                String string = name = this.useAncestorInformation(link[14], prgTypeIdString) ? String.valueOf(link[5]) + ":" + link[14] : link[5];
                                if (!showStandardSCLProcs && MappingConstants.SCL_Procedure_Type_STRING.equals(prgTypeIdString) && com.ez.cobol.callgraph.utils.Utils.isSCLStandardProcedure((String)name, this.standardProcs)) break block6;
                                if (!isUnknown) break block7;
                                if (pos + 1 >= this.links.length) break block8;
                                boolean bl = isPrevUnknown = Utils.filterNullValue((String)this.links[pos + 1][7]) == null || this.links[pos + 1][7].equals("-1") || this.links[pos + 1][7].equals("0");
                                if (this.links[pos][0].equals(this.links[pos + 1][0]) && this.links[pos][8].equals(this.links[pos + 1][8]) && !isPrevUnknown) break block6;
                            }
                            linkNode = (TSENode)unknownPrograms.get(name);
                            break block9;
                        }
                        Map typeMap = (Map)programsMap.get(prgTypeIdString);
                        TSENode tSENode = linkNode = typeMap != null ? (TSENode)typeMap.get(name) : null;
                    }
                    if (linkNode == null) {
                        linkNode = this.nodeBuilder.addNode(this.graph);
                        linkNode.setName((Object)name);
                        linkNode.setTooltipText(name);
                        String prgTypeDescription = Utils.getPrgType((String)prgTypeIdString);
                        linkNode.setAttribute("Node_Mainframe", (Object)new MainframeSourceNode(prgTypeDescription, ""));
                        if (isUnknown) {
                            unknownPrograms.put(name, linkNode);
                        } else {
                            HashMap<String, TSENode> typeMap = (HashMap<String, TSENode>)programsMap.get(prgTypeIdString);
                            if (typeMap == null) {
                                typeMap = new HashMap<String, TSENode>();
                                programsMap.put(prgTypeIdString, typeMap);
                            }
                            typeMap.put(name, linkNode);
                            this.createApplicableInputType(linkNode, link[5], link[6], link[14], link[15], prgTypeIdString);
                        }
                        this.resNodes.add(linkNode);
                    }
                    int type = Integer.valueOf(prgTypeIdString);
                    this.setProgramUIStyle(linkNode, type);
                    String edgeType = link[2];
                    TSEEdge linkEdge = this.getOrCreateEdge(para, linkNode, edgeType, DIRECTION.RIGHT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)linkEdge, link[13], prgType, link[9], link[11], link[10], link[12]);
                }
                ++pos;
            }
        }
    }

    private boolean useAncestorInformation(String ancestor, String prgTypeIdString) {
        return !MappingConstants.SCL_Procedure_Type_STRING.equals(prgTypeIdString) && Utils.filterNullValue((String)ancestor) != null && !ancestor.isEmpty();
    }

    private void makeTransactionNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.transactions != null) {
            HashMap<String, TSENode> trNodes = new HashMap<String, TSENode>();
            for (String[] tr : this.transactions) {
                String programName;
                TSENode source = paragraphNodes.get(tr[1]);
                if (source == null) continue;
                String string = programName = tr.length > 19 ? tr[15] : tr[10];
                if (Utils.filterNullValue((String)programName) == null) {
                    String trName = tr[14];
                    TSENode trNode = (TSENode)trNodes.get(trName);
                    if (trNode == null) {
                        trNode = this.nodeBuilder.addNode(this.graph);
                        this.setResourceUIStyle(trNode, 14);
                        trNode.setName((Object)trName);
                        trNode.setTooltipText(trName);
                        this.setPropertiesViewer(trNode, trName, ResultElementType.TRANSACTION.getDisplayName());
                        trNodes.put(trName, trNode);
                        this.resNodes.add(trNode);
                        this.createApplicableInputTypeForResource(trNode, 14, null);
                    }
                    String edgeType = tr[3];
                    TSEEdge edge = this.getOrCreateEdge(source, trNode, edgeType, DIRECTION.RIGHT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)edge, tr[8], prgType, tr[4], tr[6], tr[5], tr[7]);
                    continue;
                }
                if (this.inputPrgName.equalsIgnoreCase(programName)) {
                    TSENode firstParagraph = this.paraNodes.get(0);
                    String edgeType = tr[3];
                    TSEEdge edge = this.getOrCreateEdge(source, firstParagraph, edgeType, DIRECTION.RIGHT_TO_RIGHT);
                    this.makeFileAttribute((TSGraphMember)edge, tr[8], prgType, tr[4], tr[6], tr[5], tr[7]);
                    continue;
                }
                String[][] linksFromTransaction = new String[1][16];
                String prgId = tr[17];
                String prgTypeId = tr[16];
                String[] stringArray = new String[16];
                stringArray[0] = tr[0];
                stringArray[1] = tr[1];
                stringArray[2] = tr[3];
                stringArray[5] = programName;
                stringArray[6] = prgId;
                stringArray[7] = prgTypeId;
                stringArray[9] = tr[4];
                stringArray[10] = tr[5];
                stringArray[11] = tr[6];
                stringArray[12] = tr[7];
                stringArray[13] = tr[8];
                stringArray[14] = tr[18];
                stringArray[15] = tr[19];
                linksFromTransaction[0] = stringArray;
                int length = linksFromTransaction.length;
                if (this.links == null) {
                    this.links = new String[length][16];
                    System.arraycopy(linksFromTransaction, 0, this.links, 0, length);
                    continue;
                }
                String[][] temp = new String[this.links.length + length][16];
                System.arraycopy(linksFromTransaction, 0, temp, 0, length);
                System.arraycopy(this.links, 0, temp, length, this.links.length);
                this.links = temp;
            }
        }
    }

    private void makeBmsMapNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.bms_maps != null) {
            HashMap<String, String[]> bmsMapsDetails = new HashMap<String, String[]>();
            String[][] stringArray = this.bmsPaths;
            int n = this.bmsPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] mnPathAndDetails = stringArray[n2];
                bmsMapsDetails.put(mnPathAndDetails[0], mnPathAndDetails);
                ++n2;
            }
            HashMap<String, TSENode> bmsMapNodes = new HashMap<String, TSENode>();
            for (String[] map : this.bms_maps) {
                TSENode para = paragraphNodes.get(map[1]);
                if (para == null) continue;
                String[] mapDetails = (String[])bmsMapsDetails.get(map[11]);
                String name = mapDetails[1];
                String mapName = mapDetails[7] != null && !mapDetails[7].isEmpty() ? mapDetails[7].concat("-").concat(name) : name;
                TSENode mapNode = (TSENode)bmsMapNodes.get(mapName);
                if (mapNode == null) {
                    mapNode = this.nodeBuilder.addNode(this.graph);
                    mapNode.setName((Object)mapName);
                    mapNode.setAttribute(SCREEN_NAME_KEY, (Object)name);
                    mapNode.setTooltipText(mapName);
                    this.setPropertiesViewer(mapNode, mapName, ResultElementType.BMS_MAP.getDisplayName());
                    bmsMapNodes.put(mapName, mapNode);
                    this.setResourceUIStyle(mapNode, 69);
                    this.resNodes.add(mapNode);
                    if (mapDetails[8] != null) {
                        mapNode.setAttribute(SCREEN_OCCUR_ID_ATTRIBUTE, (Object)Integer.valueOf(mapDetails[8]));
                    }
                    mapNode.setAttribute(SCREEN_ID, (Object)Integer.valueOf(map[11]));
                    this.createApplicableInputTypeForResource(mapNode, 6, mapDetails[7]);
                }
                TSEEdge mapEdge = null;
                int type = Integer.valueOf(map[3]);
                mapEdge = type == 96 || type == 439 ? this.getOrCreateEdge(mapNode, para, map[3], DIRECTION.LEFT_TO_RIGHT) : this.getOrCreateEdge(para, mapNode, map[3], DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)mapEdge, map[8], prgType, map[4], map[6], map[5], map[7]);
                if (mapDetails[6] == null || mapDetails[6].isEmpty()) continue;
                this.makeFileAttribute((TSGraphMember)mapNode, mapDetails[6], Integer.toString(10006), mapDetails[2], mapDetails[4], mapDetails[3], mapDetails[5]);
            }
        }
    }

    private void makeAdsMapNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.ads_maps != null) {
            HashMap<String, TSENode> adsMapNodes = new HashMap<String, TSENode>();
            for (String[] map : this.ads_maps) {
                TSENode para = paragraphNodes.get(map[1]);
                if (para == null) continue;
                String mapName = map[14];
                TSENode mapNode = (TSENode)adsMapNodes.get(mapName);
                if (mapNode == null) {
                    mapNode = this.nodeBuilder.addNode(this.graph);
                    mapNode.setName((Object)mapName);
                    mapNode.setTooltipText(mapName);
                    this.setPropertiesViewer(mapNode, mapName, ResultElementType.ADS_MAP.getDisplayName());
                    adsMapNodes.put(mapName, mapNode);
                    this.setResourceUIStyle(mapNode, 95);
                    this.resNodes.add(mapNode);
                    if (map[20] != null && !map[20].isEmpty()) {
                        mapNode.setAttribute(SCREEN_OCCUR_ID_ATTRIBUTE, (Object)Integer.valueOf(map[20]));
                    }
                    mapNode.setAttribute(SCREEN_ID, (Object)Integer.valueOf(map[11]));
                    this.createApplicableInputTypeForResource(mapNode, 95, null);
                    String adsMapPath = map[19];
                    if (Utils.filterNullValue((String)adsMapPath) != null) {
                        this.makeFileAttribute((TSGraphMember)mapNode, adsMapPath, Integer.toString(10095), map[15], map[17], map[16], map[18]);
                    }
                }
                String type = map[3];
                TSEEdge mapEdge = this.getOrCreateEdge(para, mapNode, type, DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)mapEdge, map[8], prgType, map[4], map[6], map[5], map[7]);
            }
        }
    }

    private void makeNaturalMapNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.natural_maps != null) {
            HashMap<String, String[]> natMapsDetails = new HashMap<String, String[]>();
            String[][] stringArray = this.natMapPaths;
            int n = this.natMapPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] mnDetails = stringArray[n2];
                natMapsDetails.put(mnDetails[0], mnDetails);
                ++n2;
            }
            HashMap<String, TSENode> natMapNodes = new HashMap<String, TSENode>();
            for (String[] map : this.natural_maps) {
                TSENode para = paragraphNodes.get(map[1]);
                if (para == null) continue;
                String[] mapDetails = (String[])natMapsDetails.get(map[11]);
                String name = mapDetails[1];
                String mapName = mapDetails[8] != null && !mapDetails[8].isEmpty() ? mapDetails[8].concat("-").concat(name) : name;
                TSENode mapNode = (TSENode)natMapNodes.get(mapName);
                if (mapNode == null) {
                    mapNode = this.nodeBuilder.addNode(this.graph);
                    mapNode.setName((Object)mapName);
                    mapNode.setAttribute(SCREEN_NAME_KEY, (Object)name);
                    mapNode.setTooltipText(mapName);
                    this.setPropertiesViewer(mapNode, mapName, ResultElementType.NATURAL_MAP.getDisplayName());
                    natMapNodes.put(mapName, mapNode);
                    this.setResourceUIStyle(mapNode, 61);
                    this.resNodes.add(mapNode);
                    if (mapDetails[2] != null) {
                        mapNode.setAttribute(SCREEN_OCCUR_ID_ATTRIBUTE, (Object)Integer.valueOf(mapDetails[2]));
                    }
                    mapNode.setAttribute(SCREEN_ID, (Object)Integer.valueOf(map[11]));
                    this.createApplicableInputTypeForResource(mapNode, 61, null);
                }
                String edgeType = map[3];
                TSEEdge mapEdge = this.getOrCreateEdge(para, mapNode, edgeType, DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)mapEdge, map[8], prgType, map[4], map[6], map[5], map[7]);
                if (Utils.filterNullValue((String)mapDetails[7]) == null) continue;
                this.makeFileAttribute((TSGraphMember)mapNode, mapDetails[7], Integer.toString(10061), mapDetails[3], mapDetails[5], mapDetails[4], mapDetails[6]);
            }
        }
    }

    private void makePrinterFileNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.printerfiles != null) {
            HashMap<String, TSENode> pfileNodes = new HashMap<String, TSENode>();
            String[][] stringArray = this.printerfiles;
            int n = this.printerfiles.length;
            int n2 = 0;
            while (n2 < n) {
                String[] pfile = stringArray[n2];
                TSENode para = paragraphNodes.get(pfile[1]);
                if (para != null) {
                    String name = pfile[10];
                    TSENode pfileNode = (TSENode)pfileNodes.get(name);
                    if (pfileNode == null) {
                        pfileNode = this.nodeBuilder.addNode(this.graph);
                        pfileNode.setName((Object)name);
                        pfileNode.setTooltipText(name);
                        this.setPropertiesViewer(pfileNode, name, ResultElementType.PRINTER_FILE.getDisplayName());
                        int type = 70;
                        this.setResourceUIStyle(pfileNode, type);
                        pfileNodes.put(name, pfileNode);
                        this.resNodes.add(pfileNode);
                        this.createApplicableInputTypeForResource(pfileNode, type, null);
                    }
                    TSEEdge fileEdge = null;
                    int type = Integer.valueOf(pfile[2]);
                    fileEdge = type == 119 || type == 31 || type == 120 || type == 124 || type == 121 || type == 422 ? this.getOrCreateEdge(pfileNode, para, pfile[2], DIRECTION.LEFT_TO_RIGHT) : this.getOrCreateEdge(para, pfileNode, pfile[2], DIRECTION.RIGHT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)fileEdge, pfile[9], prgType, pfile[5], pfile[7], pfile[6], pfile[8]);
                }
                ++n2;
            }
        }
    }

    private void makeDALNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.dal != null) {
            HashMap<String, TSENode> dalMapNodes = new HashMap<String, TSENode>();
            for (String[] dalObj : this.dal) {
                TSENode para = paragraphNodes.get(dalObj[1]);
                if (para == null) continue;
                String dalName = dalObj[14];
                TSENode dalNode = (TSENode)dalMapNodes.get(dalName);
                if (dalNode == null) {
                    dalNode = this.nodeBuilder.addNode(this.graph);
                    dalNode.setName((Object)dalName);
                    dalNode.setTooltipText(dalName);
                    this.setPropertiesViewer(dalNode, dalName, ResultElementType.DAL.getDisplayName());
                    dalMapNodes.put(dalName, dalNode);
                    this.setResourceUIStyle(dalNode, 189);
                    this.resNodes.add(dalNode);
                    this.createApplicableInputTypeForResource(dalNode, 189, dalObj[15]);
                }
                String stmtType = dalObj[3];
                String stmtBRead = dalObj[13];
                TSEEdge fileEdge = this.makeEdge(para, dalNode, stmtType, stmtBRead);
                this.makeFileAttribute((TSGraphMember)fileEdge, dalObj[8], prgType, dalObj[4], dalObj[6], dalObj[5], dalObj[7]);
            }
        }
    }

    private void makeFileNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.files != null) {
            HashMap<String, TSENode> fileNodes = new HashMap<String, TSENode>();
            String[][] stringArray = this.files;
            int n = this.files.length;
            int n2 = 0;
            while (n2 < n) {
                String[] file = stringArray[n2];
                TSENode para = paragraphNodes.get(file[1]);
                if (para != null) {
                    TSENode fileNode;
                    String logicalName = file[3];
                    String physicalFileName = file[13];
                    String nodeName = physicalFileName != null && !physicalFileName.isEmpty() ? String.valueOf(physicalFileName) + (logicalName != null ? "(".concat(logicalName).concat(")") : "") : "(" + logicalName + ")";
                    int type = 9;
                    if ("16".equalsIgnoreCase(file[11])) {
                        type = 71;
                    }
                    if ((fileNode = (TSENode)fileNodes.get(nodeName)) == null) {
                        fileNode = this.nodeBuilder.addNode(this.graph);
                        fileNode.setName((Object)nodeName);
                        fileNode.setTooltipText(nodeName);
                        this.setPropertiesViewer(fileNode, nodeName, ResultElementType.FILE.getDisplayName());
                        this.setResourceUIStyle(fileNode, type);
                        fileNodes.put(nodeName, fileNode);
                        this.resNodes.add(fileNode);
                        String name = physicalFileName != null && !physicalFileName.isEmpty() ? physicalFileName : logicalName;
                        EZSourceFileIDSg resSgID = new EZSourceFileIDSg(logicalName, type);
                        EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(type), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                        if (inputType != null) {
                            inputType.setName(name);
                            EZEntityID entityid = new EZEntityID();
                            entityid.addSegment((EZSegment)this.projectIdSg);
                            entityid.addSegment((EZSegment)resSgID);
                            inputType.addProperty("mainframe resource id sg", (Object)resSgID);
                            inputType.setEntID(entityid);
                            if (physicalFileName != null) {
                                inputType.addProperty("isPhysicalFile attribute", (Object)physicalFileName);
                            }
                            if (logicalName != null) {
                                inputType.addProperty("logical file attribute", (Object)logicalName);
                            }
                            fileNode.setAttribute("APPLICABLE_INPUT", (Object)inputType);
                        }
                    }
                    TSEEdge fileEdge = null;
                    int stmttype = Integer.valueOf(file[2]);
                    fileEdge = stmttype == 119 || stmttype == 31 || stmttype == 120 || stmttype == 124 || stmttype == 121 || stmttype == 422 ? this.getOrCreateEdge(fileNode, para, file[2], DIRECTION.LEFT_TO_RIGHT) : this.getOrCreateEdge(para, fileNode, file[2], DIRECTION.RIGHT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)fileEdge, file[9], prgType, file[5], file[7], file[6], file[8]);
                }
                ++n2;
            }
        }
    }

    private void makeAdabasNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.adabasResources != null) {
            HashMap<String, TSENode> adabasNodes = new HashMap<String, TSENode>();
            for (String[] adabas : this.adabasResources) {
                TSENode para = paragraphNodes.get(adabas[1]);
                if (para == null) {
                    L.warn("not found ts node for paragraph name " + adabas[1]);
                    continue;
                }
                String adabasDbId = adabas[14];
                if (adabasDbId != null && !adabasDbId.isEmpty()) {
                    TSENode adabasNode = (TSENode)adabasNodes.get(adabasDbId);
                    if (adabasNode == null) {
                        String dbName = adabas[16];
                        String fileName = adabas[15];
                        adabasNode = this.nodeBuilder.addNode(this.graph);
                        String adabasName = AdabasUtils.getListableName((String)fileName, (String)dbName);
                        adabasNode.setName((Object)adabasName);
                        adabasNode.setTooltipText(adabasDbId);
                        this.setResourceUIStyle(adabasNode, 56);
                        this.setPropertiesViewer(adabasNode, adabasName, ResultElementType.ADABAS_FILE.getDisplayName());
                        adabasNodes.put(adabasDbId, adabasNode);
                        this.resNodes.add(adabasNode);
                        this.createApplicableInputTypeForResource(adabasNode, 56, null);
                        EZObjectType inputType = (EZObjectType)adabasNode.getAttributeValue("APPLICABLE_INPUT");
                        EZSourceAdabasIDSg sg = (EZSourceAdabasIDSg)inputType.getProperty("mainframe resource id sg");
                        sg.setDbName(dbName);
                        sg.setFileName(fileName);
                        sg.setNumber(Integer.valueOf(adabasDbId).intValue());
                    }
                    String stmtType = adabas[3];
                    String stmtBRead = adabas[13];
                    TSEEdge adabasEdge = this.makeEdge(para, adabasNode, stmtType, stmtBRead);
                    this.makeFileAttribute((TSGraphMember)adabasEdge, adabas[8], prgType, adabas[4], adabas[6], adabas[5], adabas[7]);
                    continue;
                }
                L.info("adabas with resourceid=" + adabas[11] + " not found in program " + adabas[10] + " (id=" + adabas[9] + ")");
            }
        }
    }

    private void makePl1InternalCalls(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.pl1InternalCalls != null) {
            String[][] stringArray = this.pl1InternalCalls;
            int n = this.pl1InternalCalls.length;
            int n2 = 0;
            while (n2 < n) {
                String[] pl1InternalCall = stringArray[n2];
                String stmtType = "435";
                TSENode para = paragraphNodes.get(pl1InternalCall[2]);
                if (para != null) {
                    TSENode pl1InternalCallNode = paragraphNodes.get(pl1InternalCall[4]);
                    if (pl1InternalCallNode == null) {
                        pl1InternalCallNode = this.nodeBuilder.addNode(this.graph);
                        pl1InternalCallNode.setName((Object)pl1InternalCall[4]);
                        pl1InternalCallNode.setTooltipText(pl1InternalCall[4]);
                        paragraphNodes.put(pl1InternalCall[4], pl1InternalCallNode);
                        this.paraNodes.add(pl1InternalCallNode);
                        this.putEntriesInGISV(ProgFlowNodeLegendInfo.PARAGRAPH.getLegendLabel(), pl1InternalCallNode);
                        pl1InternalCallNode.setAttribute("class_name", (Object)ProgFlowNodeLegendInfo.PARAGRAPH.getNodeTypeClass());
                        this.nodeTypesSetForLegend.add(ProgFlowNodeLegendInfo.PARAGRAPH);
                    }
                    TSEEdge pl1InternalCallEdge = this.getOrCreateEdge(para, pl1InternalCallNode, stmtType, DIRECTION.LEFT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)pl1InternalCallEdge, pl1InternalCall[9], prgType, pl1InternalCall[5], pl1InternalCall[7], pl1InternalCall[6], pl1InternalCall[8]);
                }
                ++n2;
            }
        }
    }

    private void makeIdmsCallRecordNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.idmsCallRecords != null) {
            HashMap<String, String[]> recordDefs = new HashMap<String, String[]>();
            String[][] stringArray = this.recordDefinitions;
            int n = this.recordDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] recDef = stringArray[n2];
                recordDefs.put(recDef[0], recDef);
                ++n2;
            }
            HashMap<String, TSENode> idmsCallRecordNodes = new HashMap<String, TSENode>();
            for (String[] idmsCallRec : this.idmsCallRecords) {
                String[] recDef = (String[])recordDefs.get(idmsCallRec[11]);
                String name = recDef[1];
                TSENode para = paragraphNodes.get(idmsCallRec[1]);
                if (para == null) continue;
                TSENode idmsRecNode = (TSENode)idmsCallRecordNodes.get(name);
                if (idmsRecNode == null) {
                    idmsRecNode = this.nodeBuilder.addNode(this.graph);
                    idmsRecNode.setName((Object)name);
                    idmsRecNode.setTooltipText(name);
                    this.setPropertiesViewer(idmsRecNode, name, ResultElementType.IDMS_RECORD.getDisplayName());
                    this.setResourceUIStyle(idmsRecNode, 75);
                    idmsCallRecordNodes.put(name, idmsRecNode);
                    this.resNodes.add(idmsRecNode);
                    this.createApplicableInputTypeForResource(idmsRecNode, 75, recDef[8]);
                }
                TSEEdge idmsRecEdge = null;
                int type = Integer.valueOf(idmsCallRec[3]);
                if (type >= 564 && type <= 571 || type >= 541 && type <= 546 || type == 514 || type == 1927) {
                    idmsRecEdge = this.getOrCreateEdge(idmsRecNode, para, idmsCallRec[3], DIRECTION.LEFT_TO_RIGHT);
                } else if (type == 528 || type == 534 || type == 540 || type == 562 || type == 585 || type == 521 || type == 757 || type == 763 || type == 764) {
                    idmsRecEdge = this.getOrCreateEdge(para, idmsRecNode, idmsCallRec[3], DIRECTION.RIGHT_TO_LEFT);
                }
                this.makeFileAttribute((TSGraphMember)idmsRecEdge, idmsCallRec[8], prgType, idmsCallRec[4], idmsCallRec[6], idmsCallRec[5], idmsCallRec[7]);
                if (this.projectIdSg.getProjectInfo().isVME()) {
                    if (Utils.filterNullValue((String)recDef[9]) == null) continue;
                    this.makeFileAttribute((TSGraphMember)idmsRecNode, recDef[9], String.valueOf(14), recDef[10], recDef[12]);
                    continue;
                }
                if (Utils.filterNullValue((String)recDef[6]) == null) continue;
                this.makeFileAttribute((TSGraphMember)idmsRecNode, recDef[6], null, recDef[2], recDef[4], recDef[3], recDef[5]);
            }
        }
    }

    private void makeIdmsCallSetNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.idmsCallSets != null) {
            HashMap<String, String[]> setDefs = new HashMap<String, String[]>();
            String[][] stringArray = this.setDefinitions;
            int n = this.setDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                String[] setDef = stringArray[n2];
                setDefs.put(setDef[0], setDef);
                ++n2;
            }
            HashMap<String, TSENode> idmsCallSetNodes = new HashMap<String, TSENode>();
            for (String[] idmsCallSet : this.idmsCallSets) {
                TSENode para = paragraphNodes.get(idmsCallSet[1]);
                if (para == null) continue;
                String[] setDetails = (String[])setDefs.get(idmsCallSet[11]);
                TSENode idmsSetNode = (TSENode)idmsCallSetNodes.get(setDetails[1]);
                if (idmsSetNode == null) {
                    idmsSetNode = this.nodeBuilder.addNode(this.graph);
                    idmsSetNode.setName((Object)setDetails[1]);
                    idmsSetNode.setTooltipText(setDetails[1]);
                    String name = setDetails[1];
                    this.setPropertiesViewer(idmsSetNode, name, ResultElementType.IDMS_SET.getDisplayName());
                    this.setResourceUIStyle(idmsSetNode, 76);
                    idmsCallSetNodes.put(setDetails[1], idmsSetNode);
                    this.resNodes.add(idmsSetNode);
                    this.createApplicableInputTypeForResource(idmsSetNode, 76, setDetails[8]);
                }
                TSEEdge idmsCallSetEdge = null;
                int type = Integer.valueOf(idmsCallSet[3]);
                if (type >= 564 && type <= 571 || type >= 541 && type <= 546 || type == 515) {
                    idmsCallSetEdge = this.getOrCreateEdge(idmsSetNode, para, idmsCallSet[3], DIRECTION.LEFT_TO_RIGHT);
                } else if (type == 528 || type == 534 || type == 757 || type == 763 || type == 764) {
                    idmsCallSetEdge = this.getOrCreateEdge(para, idmsSetNode, idmsCallSet[3], DIRECTION.RIGHT_TO_LEFT);
                }
                this.makeFileAttribute((TSGraphMember)idmsCallSetEdge, idmsCallSet[8], prgType, idmsCallSet[4], idmsCallSet[6], idmsCallSet[5], idmsCallSet[7]);
                if (this.projectIdSg.getProjectInfo().isVME()) {
                    if (Utils.filterNullValue((String)setDetails[9]) == null) continue;
                    this.makeFileAttribute((TSGraphMember)idmsSetNode, setDetails[9], String.valueOf(14), setDetails[10], setDetails[12]);
                    continue;
                }
                if (Utils.filterNullValue((String)setDetails[6]) == null) continue;
                this.makeFileAttribute((TSGraphMember)idmsSetNode, setDetails[6], null, setDetails[2], setDetails[4], setDetails[3], setDetails[5]);
            }
        }
    }

    private void makeSqlTableNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.sqltables != null) {
            HashMap<String, String[]> sqlTDetails = new HashMap<String, String[]>();
            String[][] stringArray = this.tablePaths;
            int n = this.tablePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] sqlDetails = stringArray[n2];
                sqlTDetails.put(sqlDetails[0], sqlDetails);
                ++n2;
            }
            HashMap<String, TSENode> sqltableNodes = new HashMap<String, TSENode>();
            for (String[] sqltable : this.sqltables) {
                TSENode para = paragraphNodes.get(sqltable[1]);
                if (para == null) continue;
                String[] sqlTabledetails = (String[])sqlTDetails.get(sqltable[11]);
                TSENode sqlTableNode = (TSENode)sqltableNodes.get(sqlTabledetails[1]);
                if (sqlTableNode == null) {
                    sqlTableNode = this.nodeBuilder.addNode(this.graph);
                    sqlTableNode.setName((Object)sqlTabledetails[1]);
                    sqlTableNode.setTooltipText(sqlTabledetails[1]);
                    String name = sqlTabledetails[1];
                    this.setPropertiesViewer(sqlTableNode, name, ResultElementType.SQL_TABLE.getDisplayName());
                    this.setResourceUIStyle(sqlTableNode, 1);
                    sqltableNodes.put(sqlTabledetails[1], sqlTableNode);
                    this.resNodes.add(sqlTableNode);
                    this.createApplicableInputTypeForResource(sqlTableNode, 1, null);
                }
                TSEEdge sqltableEdge = this.makeEdge(para, sqlTableNode, sqltable[3], sqltable[13]);
                this.makeFileAttribute((TSGraphMember)sqltableEdge, sqltable[8], prgType, sqltable[4], sqltable[6], sqltable[5], sqltable[7]);
                if (Utils.filterNullValue((String)sqlTabledetails[2]) == null) continue;
                this.makeFileAttribute((TSGraphMember)sqlTableNode, sqlTabledetails[2], null, sqlTabledetails[3], sqlTabledetails[5], sqlTabledetails[4], sqlTabledetails[6]);
            }
        }
    }

    private void makeDBINodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.dbi != null) {
            HashMap<String, TSENode> dbiNodes = new HashMap<String, TSENode>();
            for (String[] dbiObj : this.dbi) {
                TSENode para = paragraphNodes.get(dbiObj[1]);
                if (para == null) continue;
                String name = dbiObj[14];
                TSENode dbiNode = (TSENode)dbiNodes.get(name);
                if (dbiNode == null) {
                    dbiNode = this.nodeBuilder.addNode(this.graph);
                    dbiNode.setName((Object)name);
                    dbiNode.setTooltipText(name);
                    this.setPropertiesViewer(dbiNode, name, ResultElementType.DBI_CATEGORY.getDisplayName());
                    Integer resType = Integer.valueOf(dbiObj[12]);
                    this.setResourceUIStyle(dbiNode, resType);
                    dbiNodes.put(name, dbiNode);
                    this.resNodes.add(dbiNode);
                    String strResID = dbiObj[11];
                    this.createApplicableInputTypeForResource(dbiNode, resType, strResID);
                }
                String stmtType = dbiObj[3];
                String stmtBRead = dbiObj[13];
                TSEEdge edge = this.makeEdge(para, dbiNode, stmtType, stmtBRead);
                this.makeFileAttribute((TSGraphMember)edge, dbiObj[8], prgType, dbiObj[4], dbiObj[6], dbiObj[5], dbiObj[7]);
            }
        }
    }

    private void makeAdsCallNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.ads_calls != null) {
            String[][] stringArray = this.ads_calls;
            int n = this.ads_calls.length;
            int n2 = 0;
            while (n2 < n) {
                TSENode adsCallNode;
                String[] ads_call = stringArray[n2];
                TSENode para1 = paragraphNodes.get(ads_call[1]);
                if (para1 != null && (adsCallNode = paragraphNodes.get(ads_call[5])) != null) {
                    TSEEdge paraEdge = this.getOrCreateEdge(para1, adsCallNode, ads_call[2], DIRECTION.LEFT_TO_LEFT);
                    this.makeFileAttribute((TSGraphMember)paraEdge, ads_call[10], prgType, ads_call[6], ads_call[8], ads_call[7], ads_call[9]);
                    paraEdge.setAttribute("Color", (Object)ProgFlowEdgeLegendInfo.PERFORM.getTSEColor());
                    this.edgeTypesSetForLegend.add(ProgFlowEdgeLegendInfo.PERFORM);
                }
                ++n2;
            }
        }
    }

    private void makeMQManagerNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.mqManagers != null) {
            HashMap<String, TSENode> mqManagerNodes = new HashMap<String, TSENode>();
            for (String[] mqManager : this.mqManagers) {
                TSENode para = paragraphNodes.get(mqManager[1]);
                if (para == null) continue;
                String name = mqManager[14];
                TSENode mqManagerNode = (TSENode)mqManagerNodes.get(name);
                if (mqManagerNode == null) {
                    mqManagerNode = this.nodeBuilder.addNode(this.graph);
                    mqManagerNode.setName((Object)name);
                    mqManagerNode.setTooltipText(name);
                    this.setPropertiesViewer(mqManagerNode, name, ResultElementType.MQ_MANAGER.getDisplayName());
                    this.setResourceUIStyle(mqManagerNode, 79);
                    mqManagerNodes.put(name, mqManagerNode);
                    this.resNodes.add(mqManagerNode);
                    this.createApplicableInputTypeForResource(mqManagerNode, 79, null);
                }
                TSEEdge mqManagersEdge = this.getOrCreateEdge(para, mqManagerNode, mqManager[3], DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)mqManagersEdge, mqManager[8], prgType, mqManager[4], mqManager[6], mqManager[5], mqManager[7]);
            }
        }
    }

    private void makeDatacomNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.datacoms != null) {
            HashMap<String, TSENode> datacomNodes = new HashMap<String, TSENode>();
            for (String[] datacom : this.datacoms) {
                TSENode para = paragraphNodes.get(datacom[1]);
                if (para == null) continue;
                String name = datacom[14];
                TSENode dNode = (TSENode)datacomNodes.get(name);
                if (dNode == null) {
                    dNode = this.nodeBuilder.addNode(this.graph);
                    dNode.setName((Object)name);
                    dNode.setTooltipText(name);
                    this.setPropertiesViewer(dNode, name, ResultElementType.DATACOM.getDisplayName());
                    this.setResourceUIStyle(dNode, 182);
                    datacomNodes.put(name, dNode);
                    this.resNodes.add(dNode);
                    this.createApplicableInputTypeForResource(dNode, 182, null);
                }
                TSEEdge dEdge = null;
                dEdge = datacom[3].equals("1858") || datacom[3].equals("1924") ? this.getOrCreateEdge(para, dNode, datacom[3], DIRECTION.RIGHT_TO_LEFT) : this.getOrCreateEdge(dNode, para, datacom[3], DIRECTION.LEFT_TO_RIGHT);
                this.makeFileAttribute((TSGraphMember)dEdge, datacom[8], prgType, datacom[4], datacom[6], datacom[5], datacom[7]);
            }
        }
    }

    private void makeMQQueueNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.mqQueues != null) {
            HashMap<String, TSENode> mqQueueNodes = new HashMap<String, TSENode>();
            for (String[] mqQueue : this.mqQueues) {
                TSENode para = paragraphNodes.get(mqQueue[1]);
                if (para == null) continue;
                String name = mqQueue[14];
                TSENode mqQueueNode = (TSENode)mqQueueNodes.get(name);
                if (mqQueueNode == null) {
                    mqQueueNode = this.nodeBuilder.addNode(this.graph);
                    mqQueueNode.setName((Object)name);
                    mqQueueNode.setTooltipText(name);
                    this.setPropertiesViewer(mqQueueNode, name, ResultElementType.MQ_QUEUE.getDisplayName());
                    this.setResourceUIStyle(mqQueueNode, 81);
                    mqQueueNodes.put(name, mqQueueNode);
                    this.resNodes.add(mqQueueNode);
                    this.createApplicableInputTypeForResource(mqQueueNode, 81, null);
                }
                TSEEdge mqQueuesEdge = null;
                int type = Integer.valueOf(mqQueue[3]);
                mqQueuesEdge = type == 601 ? this.getOrCreateEdge(mqQueueNode, para, mqQueue[3], DIRECTION.LEFT_TO_RIGHT) : this.getOrCreateEdge(para, mqQueueNode, mqQueue[3], DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)mqQueuesEdge, mqQueue[8], prgType, mqQueue[4], mqQueue[6], mqQueue[5], mqQueue[7]);
            }
        }
    }

    private void makeIMSDBNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.imsdbs != null) {
            HashMap<String, TSENode> imsdbNodes = new HashMap<String, TSENode>();
            for (String[] imsdb : this.imsdbs) {
                TSENode para = paragraphNodes.get(imsdb[1]);
                if (para == null) continue;
                String name = imsdb[14];
                TSENode imsdbNode = (TSENode)imsdbNodes.get(name);
                if (imsdbNode == null) {
                    imsdbNode = this.nodeBuilder.addNode(this.graph);
                    imsdbNode.setName((Object)name);
                    imsdbNode.setTooltipText(name);
                    int nodeType = Integer.valueOf(imsdb[12]);
                    String strNodeType = com.ez.cobol.callgraph.utils.Utils.getExternalizedImsDbType((int)nodeType);
                    this.setPropertiesViewer(imsdbNode, name, strNodeType);
                    this.setResourceUIStyle(imsdbNode, nodeType);
                    imsdbNodes.put(name, imsdbNode);
                    this.resNodes.add(imsdbNode);
                    this.createApplicableInputTypeForResource(imsdbNode, nodeType, imsdb[11]);
                }
                TSEEdge imsdbEdge = null;
                int edgeType = Integer.valueOf(imsdb[3]);
                if (edgeType == 230 || edgeType == 227 || edgeType == 229 || edgeType == 688 || edgeType == 689 || edgeType == 691 || edgeType == 692 || edgeType == 694) {
                    imsdbEdge = this.getOrCreateEdge(imsdbNode, para, imsdb[3], DIRECTION.LEFT_TO_RIGHT);
                }
                if (edgeType == 233 || edgeType == 231 || edgeType == 234 || edgeType == 235 || edgeType == 680 || edgeType == 684 || edgeType == 698 || edgeType == 705 || edgeType == 706) {
                    imsdbEdge = this.getOrCreateEdge(para, imsdbNode, imsdb[3], DIRECTION.RIGHT_TO_LEFT);
                }
                if (imsdbEdge == null) {
                    imsdbEdge = this.getOrCreateEdge(imsdbNode, para, imsdb[3], DIRECTION.LEFT_TO_RIGHT);
                }
                this.makeFileAttribute((TSGraphMember)imsdbEdge, imsdb[8], prgType, imsdb[4], imsdb[6], imsdb[5], imsdb[7]);
            }
        }
    }

    private void makeSmartScreenNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.smartScreens != null) {
            HashMap<String, String[]> screensMap = new HashMap<String, String[]>();
            String[][] stringArray = this.smartScreenPaths;
            int n = this.smartScreenPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String[] screenDetails = stringArray[n2];
                screensMap.put(screenDetails[0], screenDetails);
                ++n2;
            }
            HashMap<String, TSENode> smartScreenNodes = new HashMap<String, TSENode>();
            for (String[] smartScreen : this.smartScreens) {
                TSENode para = paragraphNodes.get(smartScreen[2]);
                if (para == null) continue;
                String[] screenDetails = (String[])screensMap.get(smartScreen[11]);
                String name = screenDetails[1];
                TSENode smartScreenNode = (TSENode)smartScreenNodes.get(name);
                if (smartScreenNode == null) {
                    smartScreenNode = this.nodeBuilder.addNode(this.graph);
                    smartScreenNode.setName((Object)name);
                    smartScreenNode.setTooltipText(name);
                    this.setPropertiesViewer(smartScreenNode, name, ResultElementType.SMART_SCREEN.getDisplayName());
                    int nodeType = Integer.valueOf(smartScreen[12]);
                    this.setResourceUIStyle(smartScreenNode, nodeType);
                    smartScreenNodes.put(screenDetails[1], smartScreenNode);
                    this.resNodes.add(smartScreenNode);
                    String screenPath = screenDetails[6];
                    if (Utils.filterNullValue((String)screenPath) != null) {
                        this.makeFileAttribute((TSGraphMember)smartScreenNode, screenPath, prgType, screenDetails[2], screenDetails[4], screenDetails[3], screenDetails[5]);
                        this.createApplicableInputTypeForResource(smartScreenNode, nodeType, null);
                    }
                }
                TSEEdge screenEdge = this.getOrCreateEdge(para, smartScreenNode, smartScreen[3], DIRECTION.RIGHT_TO_LEFT);
                this.makeFileAttribute((TSGraphMember)screenEdge, smartScreen[8], null, smartScreen[4], smartScreen[6], smartScreen[5], smartScreen[7]);
            }
        }
    }

    private void makeTPMSXMapsNodes(Map<String, TSENode> paragraphNodes, String prgType) {
        if (this.tpmsxMaps != null) {
            HashMap<String, TSENode> tpmsxMapsNodes = new HashMap<String, TSENode>();
            String[][] stringArray = this.tpmsxMaps;
            int n = this.tpmsxMaps.length;
            int n2 = 0;
            while (n2 < n) {
                String[] tpmsxMap = stringArray[n2];
                TSENode para = paragraphNodes.get(tpmsxMap[13]);
                if (para != null) {
                    String name = tpmsxMap[1];
                    TSENode tpmsxMapNode = (TSENode)tpmsxMapsNodes.get(tpmsxMap[1]);
                    if (tpmsxMapNode == null) {
                        tpmsxMapNode = this.nodeBuilder.addNode(this.graph);
                        tpmsxMapNode.setName((Object)tpmsxMap[1]);
                        tpmsxMapNode.setTooltipText(tpmsxMap[1]);
                        tpmsxMapNode.setAttribute(SCREEN_ID, (Object)Integer.valueOf(tpmsxMap[0]));
                        this.setResourceUIStyle(tpmsxMapNode, 101);
                        this.setPropertiesViewer(tpmsxMapNode, name, ResultElementType.TPMSX_MAP.getDisplayName());
                        tpmsxMapsNodes.put(tpmsxMap[1], tpmsxMapNode);
                        this.resNodes.add(tpmsxMapNode);
                        this.createApplicableInputTypeForResource(tpmsxMapNode, 101, null);
                    }
                    TSEEdge mapEdge = null;
                    if (tpmsxMap[3].equals("1838")) {
                        mapEdge = this.getOrCreateEdge(tpmsxMapNode, para, tpmsxMap[3], DIRECTION.LEFT_TO_RIGHT);
                    } else if (tpmsxMap[3].equals("1839")) {
                        mapEdge = this.getOrCreateEdge(para, tpmsxMapNode, tpmsxMap[3], DIRECTION.RIGHT_TO_LEFT);
                    }
                    this.makeFileAttribute((TSGraphMember)mapEdge, tpmsxMap[9], null, tpmsxMap[5], tpmsxMap[6], tpmsxMap[7], tpmsxMap[8]);
                }
                ++n2;
            }
        }
    }

    private TSEEdge makeEdge(TSENode paraTSNode, TSENode resTSNode, String stmtType, String stmtBRead) {
        TSEEdge fileEdge = null;
        fileEdge = "0".equals(stmtBRead) || "2".equals(stmtBRead) ? this.getOrCreateEdge(paraTSNode, resTSNode, stmtType, DIRECTION.RIGHT_TO_LEFT) : this.getOrCreateEdge(resTSNode, paraTSNode, stmtType, DIRECTION.LEFT_TO_RIGHT);
        return fileEdge;
    }

    protected static IGraphNodeLegendInfo getParaTypeByPrgType(int prgTypeId) {
        ProgFlowNodeLegendInfo paraType = null;
        switch (prgTypeId) {
            case 1: 
            case 9: {
                paraType = ProgFlowNodeLegendInfo.PARAGRAPH;
                break;
            }
            case 3: 
            case 10: {
                paraType = ProgFlowNodeLegendInfo.SUBROUTINE;
                break;
            }
            case 2: {
                paraType = ProgFlowNodeLegendInfo.PROCEDURE;
            }
        }
        return paraType;
    }

    protected static IGraphNodeLegendInfo getParaTypeByPrgType(String prgType) {
        Integer prgTypeId = Integer.parseInt(prgType);
        return FlowGraphModel.getParaTypeByPrgType(prgTypeId);
    }

    private void makeFileAttribute(TSGraphMember nodeOrEdge, String fileName, String fileType, String ... positionInfos) {
        TextSelectionInFile infoSel = new TextSelectionInFile(fileName, fileType, positionInfos);
        com.ez.cobol.callgraph.utils.Utils.setFileAttribute((TSGraphMember)nodeOrEdge, (TextSelectionInFile)infoSel);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null) {
            if (gNode.hasAttribute("APPLICABLE_INPUT")) {
                objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
            }
            if (!gNode.hasAttribute("mainframe project name")) {
                gNode.setAttribute("mainframe project name", (Object)this.projectIdSg.getProjectName());
            }
        }
        return objType;
    }

    private void createApplicableInputType(TSENode node, String prgName, String programId, String ancestorName, String ancestorId, String prgType) {
        if (node.hasAttribute("APPLICABLE_INPUT")) {
            return;
        }
        Integer prgTypeId = Integer.parseInt(prgType);
        EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(prgTypeId);
        if (inputType != null) {
            inputType.setName(prgName);
            Boolean occur = false;
            if (this.programPaths != null) {
                String[][] stringArray = this.programPaths;
                int n = this.programPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] path = stringArray[n2];
                    if (path[2].equalsIgnoreCase(programId)) {
                        this.makeFileAttribute((TSGraphMember)node, path[7], path[1], path[3], path[5], path[4], path[6]);
                        MainframeSourceNode pn = (MainframeSourceNode)node.getAttributeValue("Node_Mainframe");
                        pn.setPath(path[7]);
                        occur = true;
                        break;
                    }
                    ++n2;
                }
            }
            EZEntityID entityid = new EZEntityID();
            entityid.addSegment((EZSegment)this.projectIdSg);
            EZSourceProgramIDSg prgSg = new EZSourceProgramIDSg(prgName, Integer.valueOf(Integer.parseInt(programId)), prgTypeId, occur);
            if (Utils.filterNullValue((String)ancestorName) != null && !ancestorName.isEmpty()) {
                try {
                    prgSg.setAncestorId(Integer.valueOf(ancestorId));
                }
                catch (NumberFormatException numberFormatException) {
                    L.warn("ancestor id is not a number for ancestor name " + ancestorName);
                }
                prgSg.setAncestorName(ancestorName);
            }
            entityid.addSegment((EZSegment)prgSg);
            inputType.setEntID(entityid);
            String prgNameWithAncestor = (String)node.getName();
            inputType.addProperty("program name", (Object)prgNameWithAncestor);
            inputType.addProperty("program occur", (Object)occur);
            node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        }
    }

    private void createApplicableInputTypeForResource(TSENode node, int resourceType, String info) {
        EZObjectType inputType;
        EZSourceSQLTableIDSg resSgID = null;
        EZSourceDDCLElementIDSg secondSeg = null;
        String name = node.getText();
        String propKey = null;
        Integer propValue = null;
        switch (resourceType) {
            case 1: {
                resSgID = new EZSourceSQLTableIDSg(name);
                break;
            }
            case 6: 
            case 61: 
            case 95: 
            case 101: {
                int scrType = 119;
                if (resourceType == 95) {
                    scrType = 118;
                }
                if (resourceType == 61) {
                    scrType = 120;
                }
                if (resourceType == 101) {
                    scrType = 101;
                }
                if (node.hasAttribute(SCREEN_NAME_KEY)) {
                    name = (String)node.getAttributeValue(SCREEN_NAME_KEY);
                }
                Integer scrOccurID = node.hasAttribute(SCREEN_OCCUR_ID_ATTRIBUTE) ? (Integer)node.getAttributeValue(SCREEN_OCCUR_ID_ATTRIBUTE) : -1;
                Integer screenID = (Integer)node.getAttributeValue(SCREEN_ID);
                resSgID = new EZSourceScreenIDSg(screenID, name, scrType, scrOccurID);
                ((EZSourceScreenIDSg)resSgID).setMapSet(info);
                break;
            }
            case 14: {
                resSgID = new EZSourceTransactionIDSg(name);
                break;
            }
            case 56: {
                resSgID = new EZSourceAdabasIDSg(name);
                break;
            }
            case 81: {
                resSgID = new EZSourceQueueIDSg(name);
                break;
            }
            case 79: {
                resSgID = new EZSourceQueueManagerIDSg(name);
                break;
            }
            case 182: {
                resSgID = new EZSourceDatacomTableIDSg(name);
                break;
            }
            case 18: {
                resSgID = new EZSourceIMSDatabaseIDSg(name);
                propKey = "IMSDB_DATABASE_ID";
                propValue = Integer.valueOf(info);
                break;
            }
            case 19: {
                resSgID = new EZSourceIMSDBIDSg(name, resourceType);
                propKey = "imsdb TERMINAL, DATABASE, TERMINAL_OR_TRANSACTION";
                propValue = resourceType;
                break;
            }
            case 75: {
                resSgID = new EZSourceIDMSRecordIDSg(name);
                if (!this.projectIdSg.getProjectInfo().isVME()) break;
                Integer ddclElementId = null;
                if (Utils.filterNullValue((String)info) != null) {
                    ddclElementId = Integer.parseInt(info);
                }
                secondSeg = new EZSourceDDCLElementIDSg(name, Integer.valueOf(3), ddclElementId);
                break;
            }
            case 76: {
                resSgID = new EZSourceIDMSSetIDSg(name);
                if (!this.projectIdSg.getProjectInfo().isVME()) break;
                Integer ddclElementId = null;
                if (Utils.filterNullValue((String)info) != null) {
                    ddclElementId = Integer.parseInt(info);
                }
                secondSeg = new EZSourceDDCLElementIDSg(name, Integer.valueOf(10), ddclElementId);
                break;
            }
            case 69: {
                resSgID = new EZSourceSmartScreenIDSg(name);
                break;
            }
            case 70: {
                resSgID = new EZSourceFileIDSg(name, resourceType);
                break;
            }
            case 9: {
                resSgID = new EZSourceFileIDSg(name, resourceType);
                break;
            }
            case 189: {
                resSgID = new EZSourceDALIDSg(name);
                ((EZSourceDALIDSg)resSgID).setVirtual(info);
                break;
            }
            case 71: {
                resSgID = new EZSourceFileIDSg(name, resourceType);
                break;
            }
            case 190: {
                resSgID = new EZSourceDBIIDSg(Integer.valueOf(info), name);
            }
        }
        if (resSgID != null && (inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(resourceType), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE")) != null) {
            inputType.setName((String)node.getName());
            EZEntityID entityid = new EZEntityID();
            entityid.addSegment((EZSegment)this.projectIdSg);
            entityid.addSegment((EZSegment)resSgID);
            inputType.addProperty("mainframe resource id sg", (Object)resSgID);
            if (secondSeg != null) {
                entityid.addSegment((EZSegment)secondSeg);
            }
            inputType.setEntID(entityid);
            if (propKey != null && propValue != null) {
                inputType.addProperty(propKey, (Object)propValue);
            }
            node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        }
    }

    private TSEEdge getEdgeIfExists(TSENode parent, TSENode childTS, String edgeType, TSEColor color) {
        TSEEdge edgeResult = null;
        List outs = parent.outEdges();
        for (TSEEdge edge : outs) {
            if (!edge.getTargetNode().equals(childTS) || !edge.hasAttribute("STMT_TYPE") || !edgeType.equals((String)edge.getAttributeValue("STMT_TYPE"))) continue;
            if (color != null) {
                if (!edge.hasAttribute("Color") || !color.equals((Object)((TSEColor)edge.getAttributeValue("Color")))) continue;
                edgeResult = edge;
                continue;
            }
            edgeResult = edge;
            break;
        }
        return edgeResult;
    }

    private TSEEdge getEdgeIfExists(TSENode parent, TSENode childTS, String edgeType) {
        return this.getEdgeIfExists(parent, childTS, edgeType, null);
    }

    private TSEEdge getOrCreateEdge(TSENode parent, TSENode childTS, String stmtType, DIRECTION edgeDirection) {
        TSEEdge edge = this.getEdgeIfExists(parent, childTS, stmtType);
        if (edge != null) {
            return edge;
        }
        edge = this.edgeBuilder.addEdge(this.graphManager, parent, childTS);
        edge.setAttribute(EDGE_DIRECTION, (Object)edgeDirection);
        CallgraphEdgeLegendInfo edgeType = CallgraphEdgeUtils.getEdgeTypeByStmt((String)stmtType);
        TSEColor edgeColor = TSEColor.black;
        if (edgeType != null) {
            edgeColor = edgeType.getTSEColor();
            this.edgeTypesSetForLegend.add(edgeType);
        }
        edge.setAttribute("Color", (Object)edgeColor);
        edge.setAttribute("STMT_TYPE", (Object)stmtType);
        return edge;
    }

    private void initGraph() {
        this.outForGISV.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
        this.nodeBuilder = this.graphManager.getNodeBuilder();
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new TSNodeBuilder();
            this.graphManager.setNodeBuilder(this.nodeBuilder);
        }
        this.edgeBuilder = this.graphManager.getEdgeBuilder();
        if (this.edgeBuilder == null) {
            this.edgeBuilder = new TSEdgeBuilder();
            this.graphManager.setEdgeBuilder(this.edgeBuilder);
        }
        this.nodeBuilder.setAttribute("Background_Color", (Object)TSEColor.darkGreen);
        this.nodeBuilder.setShape((TSShape)TSPolygonShape.getInstance((String)"rrect"));
        this.nodeBuilder.setResizability(3);
        TSCompositeNodeUI nodeUI = (TSCompositeNodeUI)this.nodeBuilder.getNodeUI();
        if (nodeUI == null) {
            nodeUI = new TSCompositeNodeUI();
        }
        TSTextUIElement imgTextElement = new TSTextUIElement();
        imgTextElement.setText("$tag()");
        imgTextElement.setName("imgTextElement");
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "TEXT_COLOR", (Serializable)((Object)"<Text_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "TEXT_FONT", (Serializable)((Object)"<Text_Font>"));
        nodeUI.getStyle().setProperty((TSUIElement)imgTextElement, "HORIZONTAL_JUSTIFICATION", (Serializable)Integer.valueOf(2));
        TSImageUIElement imgElement = new TSImageUIElement("image", new TSUIElementPoint(-0.5, 0.0, 0.5, 0.0), new TSUIElementPoint(0.5, 0.0, -0.5, 0.0));
        nodeUI.getStyle().setProperty((TSUIElement)imgElement, "TIGHT_WIDTH", (Serializable)Double.valueOf(40.0));
        nodeUI.getStyle().setProperty((TSUIElement)imgElement, "TIGHT_HEIGHT", (Serializable)Double.valueOf(40.0));
        TSSplitterUIElement splitterElement = new TSSplitterUIElement("splitter", (TSUIElement)imgElement, (TSUIElement)imgTextElement);
        nodeUI.getStyle().setProperty((TSUIElement)splitterElement, "FIXED_ELEMENT_LOCATION", (Serializable)new Integer(0));
    }

    public void setProgramUIStyle(TSENode tsNode, int type) {
        TSESVGImage svgimage = null;
        String inventoryLbl = null;
        switch (type) {
            case -1: 
            case 0: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.UNKNOWN.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.UNKNOWN.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.UNKNOWN.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.UNKNOWN.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.UNKNOWN);
                break;
            }
            case 1: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.COBOL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.COBOL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.COBOL.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.COBOL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.COBOL);
                break;
            }
            case 2: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.PL1.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.PL1.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.PL1.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.PL1.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.PL1);
                break;
            }
            case 3: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.NATURAL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.NATURAL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.NATURAL.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.NATURAL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.NATURAL);
                break;
            }
            case 4: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SMART_DB_MODULE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SMART_DB_MODULE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SMART_DB_MODULE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.SMART_DB_MODULE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SMART_DB_MODULE);
                break;
            }
            case 8: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ASSEMBLER.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ASSEMBLER.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ASSEMBLER.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.ASSEMBLER.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ASSEMBLER);
                break;
            }
            case 9: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.REXX.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.REXX.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.REXX.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.REXX.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.REXX);
                break;
            }
            case 11: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ADS_DIALOG.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ADS_DIALOG.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ADS_DIALOG.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.ADS_DIALOG.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ADS_DIALOG);
                break;
            }
            case 15: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ASSEMBLER_CSECT.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ASSEMBLER_CSECT.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ASSEMBLER_CSECT.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.ASSEMBLER_CSECT.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ASSEMBLER_CSECT);
                break;
            }
            case 16: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ASSEMBLER_ENTRY_POINT);
                break;
            }
            case 6: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SMART_SUBROUTINE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SMART_SUBROUTINE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SMART_SUBROUTINE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.SMART_SUBROUTINE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SMART_SUBROUTINE);
                break;
            }
            case 7: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.CL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.CL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.CL.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.CL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.CL);
                break;
            }
            case 13: 
            case 19: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SCL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SCL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SCL.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.SCL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SCL);
                break;
            }
            case 17: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.FORTRAN.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.FORTRAN.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.FORTRAN.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.FORTRAN.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.FORTRAN);
                break;
            }
            case 18: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ALGOL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ALGOL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ALGOL.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.ALGOL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ALGOL);
            }
        }
        this.putEntriesInGISV(inventoryLbl, tsNode);
    }

    public void setResourceUIStyle(TSENode tsNode, int type) {
        TSESVGImage svgimage = null;
        String inventoryLbl = null;
        switch (type) {
            case 14: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.TRANSACTION.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.TRANSACTION.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.TRANSACTION.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.TRANSACTION.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.TRANSACTION);
                break;
            }
            case 69: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SCREEN.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SCREEN.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SCREEN.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.SCREEN.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SCREEN);
                break;
            }
            case 61: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.MAP.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.MAP.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.MAP.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.MAP.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.MAP);
                break;
            }
            case 95: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ADS_MAP.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ADS_MAP.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ADS_MAP.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.ADS_MAP.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ADS_MAP);
                break;
            }
            case 9: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.FILE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.FILE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.FILE);
                break;
            }
            case 56: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.ADABAS.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.ADABAS.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.ADABAS.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.ADABAS.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.ADABAS);
                break;
            }
            case 18: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IMS_DB.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IMS_DB.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IMS_DB.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.IMS_DB.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IMS_DB);
                break;
            }
            case 19: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.TERMINAL.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.TERMINAL.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.TERMINAL.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.TERMINAL.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.TERMINAL);
                break;
            }
            case 1: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.SQL_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.SQL_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.SQL_TABLE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.SQL_TABLE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.SQL_TABLE);
                break;
            }
            case 190: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DBI_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DBI_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DBI_TABLE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.DBI_TABLE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.DBI_TABLE);
                break;
            }
            case 21: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.TERMINAL_OR_TRANSACTION);
                break;
            }
            case 81: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.QUEUE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.QUEUE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.QUEUE.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.QUEUE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.QUEUE);
                break;
            }
            case 79: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.QUEUE_MANAGER.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.QUEUE_MANAGER.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.QUEUE_MANAGER.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.QUEUE_MANAGER.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.QUEUE_MANAGER);
                break;
            }
            case 75: {
                if (this.projectIdSg.getProjectInfo().isIDMSXDbVMEProject()) {
                    tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_RECORD.getNodeTypeClass());
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMSX_RECORD.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_RECORD.getTSEColor());
                    inventoryLbl = CallgraphNodeLegendInfo.IDMSX_RECORD.getLegendLabel();
                    this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMSX_RECORD);
                    break;
                }
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMS_RECORD.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMS_RECORD.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMS_RECORD.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.IDMS_RECORD.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMS_RECORD);
                break;
            }
            case 76: {
                if (this.projectIdSg.getProjectInfo().isIDMSXDbVMEProject()) {
                    tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMSX_SET.getNodeTypeClass());
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMSX_SET.getGraphImagePath());
                    this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMSX_SET.getTSEColor());
                    inventoryLbl = CallgraphNodeLegendInfo.IDMSX_SET.getLegendLabel();
                    this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMSX_SET);
                    break;
                }
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.IDMS_SET.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.IDMS_SET.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.IDMS_SET.getTSEColor());
                inventoryLbl = CallgraphNodeLegendInfo.IDMS_SET.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.IDMS_SET);
                break;
            }
            case 70: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.PRINTER_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.PRINTER_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.PRINTER_FILE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.PRINTER_FILE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.PRINTER_FILE);
                break;
            }
            case 71: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DB_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DB_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DB_FILE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.DB_FILE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.DB_FILE);
                break;
            }
            case 189: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DAL_FILE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DAL_FILE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DAL_FILE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.DAL_FILE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.DAL_FILE);
                break;
            }
            case 182: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.DATACOM_TABLE.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.DATACOM_TABLE.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.DATACOM_TABLE.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.DATACOM_TABLE.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.DATACOM_TABLE);
                break;
            }
            case 101: {
                tsNode.setAttribute("class_name", (Object)CallgraphNodeLegendInfo.TPMSX_MAP.getNodeTypeClass());
                svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)CallgraphNodeLegendInfo.TPMSX_MAP.getGraphImagePath());
                this.setNodeUI(tsNode, svgimage, CallgraphNodeLegendInfo.TPMSX_MAP.getTSEColor(), TSEColor.white);
                inventoryLbl = CallgraphNodeLegendInfo.TPMSX_MAP.getLegendLabel();
                this.nodeTypesSetForLegend.add(CallgraphNodeLegendInfo.TPMSX_MAP);
            }
        }
        this.putEntriesInGISV(inventoryLbl, tsNode);
    }

    public void customLayout() {
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)this.graphManager);
        this.customTSLayout();
        TSHierarchicalLayoutInputTailor hit = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraph)this.graph);
        hit.setAsCurrentLayoutStyle();
        List edges = this.graph.edges();
        for (TSEdge edge : edges) {
            DIRECTION dir = (DIRECTION)((Object)edge.getAttributeValue(EDGE_DIRECTION));
            if (dir == null) continue;
            int type = dir.ordinal();
            switch (type) {
                case 0: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                case 1: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 2: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 1);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 2);
                    break;
                }
                case 3: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 2);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 1);
                    break;
                }
                default: {
                    hit.setSourceAttachmentSide((TSDEdge)edge, 4);
                    hit.setTargetAttachmentSide((TSDEdge)edge, 8);
                }
            }
        }
        this.doRouting(inputData);
    }

    private void doRouting(TSEAllOptionsServiceInputData inputData) {
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSRoutingInputTailor routingInputTailor = new TSRoutingInputTailor((TSServiceInputDataInterface)inputData, (TSDGraphManager)this.graphManager);
        routingInputTailor.setFixedPositions(true);
        routingInputTailor.setFixedSizes(false);
        routingInputTailor.setEdgeList(this.graphManager.getMainDisplayGraph().edges());
        routingInputTailor.setAsCurrentOperation();
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSEApplyLayoutResults applyResult = new TSEApplyLayoutResults();
        applyResult.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
    }

    private void customTSLayout() {
        Map<Double, TSENode> paraCenters = this.positionParagraphNodes();
        this.graph.edgeSet.size();
        HashMap<Double, List<TSENode>> resPositions = new HashMap<Double, List<TSENode>>();
        TSConstSize resNodeSize = null;
        block0: for (TSENode resNode : this.resNodes) {
            List<Double> ry = this.computeResourcePosition(resNode);
            if (resNodeSize == null) {
                resNodeSize = resNode.getSize();
            } else if (resNodeSize.getWidth() < resNode.getWidth()) {
                resNodeSize = resNode.getSize();
            }
            resNode.setResizability(0x1000000);
            for (double d : ry) {
                ArrayList<TSENode> nodes = (ArrayList<TSENode>)resPositions.get(d);
                if (nodes != null && ry.size() - 1 != ry.indexOf(d)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<TSENode>();
                }
                resPositions.put(d, nodes);
                nodes.add(resNode);
                continue block0;
            }
        }
        this.positionResources(paraCenters, resPositions, resNodeSize);
    }

    private Map<Double, TSENode> positionParagraphNodes() {
        double y = 0.0;
        TSConstSize nodeS = null;
        for (TSENode paraNode : this.paraNodes) {
            int edges = paraNode.inEdges().size();
            y = y - (double)this.minVerticalParagraphSpace - (double)((edges += paraNode.outEdges().size()) * this.paragraphEdgeSpacingCoeficient);
            paraNode.setCenter(0.0, y);
            paraNode.setAttribute("para", (Object)true);
            y -= (double)(edges * this.paragraphEdgeSpacingCoeficient);
            TSConstSize paraS = paraNode.getSize();
            if (nodeS == null) {
                nodeS = paraS;
                continue;
            }
            if (!(nodeS.getWidth() < paraS.getWidth())) continue;
            nodeS = paraS;
        }
        return this.adjustParaSizes(nodeS);
    }

    private Map<Double, TSENode> adjustParaSizes(TSConstSize maxWidthNode) {
        HashMap<Double, TSENode> centers = new HashMap<Double, TSENode>();
        for (TSENode paraNode : this.paraNodes) {
            paraNode.setSize(new TSConstSize(maxWidthNode.getWidth(), Math.max(paraNode.getHeight(), (double)this.minParagraphHeightNode)));
            double ycenter = paraNode.getCenterY();
            centers.put(ycenter, paraNode);
            paraNode.setResizability(0x1000000);
        }
        return centers;
    }

    private void positionResources(Map<Double, TSENode> paraCenters, Map<Double, List<TSENode>> resPositions, TSConstSize resNodeSize) {
        ArrayList<Double> paraPos = new ArrayList<Double>(paraCenters.keySet());
        Collections.sort(paraPos);
        int minVerticalParagraphSpace = 60;
        double y = 0.0;
        for (Double paray : paraPos) {
            TSENode paraNode = paraCenters.remove(paray);
            List<TSENode> resNodes = resPositions.remove(paray);
            if (y == 0.0) {
                y = paraNode.getCenterY();
            }
            if (resNodes != null) {
                int maxDispl = resNodes.size();
                int nDispl = maxDispl / 2;
                int i = 0;
                for (TSENode node : resNodes) {
                    node.setSize(new TSConstSize(resNodeSize.getWidth(), Math.max(paraNode.getHeight(), (double)this.minResHeightNode)));
                    node.setCenter((double)this.resXDisplacement, y);
                    if (i == nDispl) {
                        paraNode.setCenterY(y);
                    }
                    y += (double)minVerticalParagraphSpace;
                    ++i;
                }
                continue;
            }
            paraNode.setCenterY(y);
            y += (double)minVerticalParagraphSpace;
        }
    }

    private List<Double> computeResourcePosition(TSENode resNode) {
        int level;
        double y;
        ArrayList<Double> positions = new ArrayList<Double>();
        HashMap<Double, Integer> posMap = new HashMap<Double, Integer>();
        this.buildConnectivityMap(resNode, posMap, true);
        this.buildConnectivityMap(resNode, posMap, false);
        int maxLevel = -1;
        Iterator iterator = posMap.keySet().iterator();
        while (iterator.hasNext()) {
            y = (Double)iterator.next();
            level = (Integer)posMap.get(y);
            if (level <= maxLevel) continue;
            maxLevel = level;
        }
        iterator = posMap.keySet().iterator();
        while (iterator.hasNext()) {
            y = (Double)iterator.next();
            level = (Integer)posMap.get(y);
            if (level != maxLevel) continue;
            positions.add(y);
        }
        if (positions.isEmpty()) {
            double pos = 0.0;
            positions.add(pos);
        }
        return positions;
    }

    private void buildConnectivityMap(TSENode resNode, Map<Double, Integer> posMap, boolean inDirection) {
        List edgeList = null;
        edgeList = inDirection ? resNode.inEdges() : resNode.outEdges();
        for (Object oEdge : edgeList) {
            TSEEdge edge = (TSEEdge)oEdge;
            TSENode node = null;
            node = inDirection ? (TSENode)edge.getSourceNode() : (TSENode)edge.getTargetNode();
            if (!((Boolean)node.getAttributeValue("para")).booleanValue()) continue;
            double ny = node.getCenterY();
            Integer edges = posMap.get(ny);
            if (edges == null) {
                edges = new Integer(1);
                posMap.put(ny, 1);
                continue;
            }
            posMap.put(ny, edges + 1);
        }
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor) {
        this.setNodeUI(node, svgimage, fillColor, null);
    }

    private void setNodeUI(TSENode node, TSESVGImage svgimage, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("uiImage", (Object)svgimage);
        node.setAttribute(FILL_COLOR, (Object)fillColor);
        node.setAttribute("Color", (Object)textColor);
        this.setNodeUI(node);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute(TEXT_COLOR, (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            TSEColor color = (TSEColor)node.getAttributeValue("Color");
            if (color != null) {
                node.setAttribute(TEXT_COLOR, (Object)color);
            }
        }
    }

    public void updateDrawing() {
        TSDGraph hide;
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    public void writeToFile(String fileName, String pathSelected) {
        String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
        String newLine = System.getProperty("line.separator");
        try {
            Set<String> sorted;
            ArrayList<Integer> exclude;
            File file;
            boolean found = false;
            File firstProg = new File(pathToWrite);
            if (firstProg.exists() && !firstProg.isDirectory()) {
                while (!found) {
                    File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                    if (f.exists() && !f.isDirectory()) continue;
                    found = true;
                }
            }
            if ((file = new File(pathToWrite)).delete()) {
                L.info("File was refreshed.");
            }
            FileWriter fw = new FileWriter(file, true);
            fw.write("Program name : " + fileName);
            fw.write(newLine);
            fw.write(newLine);
            fw.write("*************************************************** DATABASE DATA *************************************************");
            fw.write(newLine);
            fw.write(newLine);
            fw.write("Paragraphs :");
            if (this.paragraphs != null) {
                fw.write(newLine);
                exclude = new ArrayList<Integer>();
                exclude.add(4);
                sorted = this.sortArray(this.paragraphs, 10, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("GotoStmts :");
            if (this.gotoStmts != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(2);
                sorted = this.sortArray(this.gotoStmts, 10, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Transactions :");
            if (this.transactions != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.transactions, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Dal :");
            if (this.dal != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.dal, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Bms_maps :");
            if (this.bms_maps != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.bms_maps, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("BmsPaths :");
            if (this.bmsPaths != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(8);
                sorted = this.sortArray(this.bmsPaths, 6, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Ads_maps :");
            if (this.ads_maps != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.ads_maps, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Natural_maps :");
            if (this.natural_maps != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortCollection(this.natural_maps, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("NatMapPaths :");
            if (this.natMapPaths != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.natMapPaths, 7, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Files :");
            if (this.files != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.files, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Printerfiles :");
            if (this.printerfiles != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.printerfiles, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("AdabasResources :");
            if (this.adabasResources != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.adabasResources, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Links :");
            if (this.links != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(6);
                sorted = this.sortArray(this.links, 13, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("ProgramPaths :");
            if (this.programPaths != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(2);
                sorted = this.sortArray(this.programPaths, 7, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Pl1InternalCalls :");
            if (this.pl1InternalCalls != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.pl1InternalCalls, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("IdmsCallRecords :");
            if (this.idmsCallRecords != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(9);
                sorted = this.sortCollection(this.idmsCallRecords, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("RecordDefinitions :");
            if (this.recordDefinitions != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.recordDefinitions, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("IdmsCallSets :");
            if (this.idmsCallSets != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                exclude.add(9);
                sorted = this.sortCollection(this.idmsCallSets, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("SetDefinitions :");
            if (this.setDefinitions != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.setDefinitions, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Sqltables :");
            if (this.sqltables != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortCollection(this.sqltables, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("ads_calls :");
            if (this.ads_calls != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.ads_calls, 10, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("MqManagers :");
            if (this.mqManagers != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.mqManagers, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("mqQueues :");
            if (this.mqQueues != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.mqQueues, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("imsdbs :");
            if (this.imsdbs != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.imsdbs, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("tablePaths :");
            if (this.tablePaths != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.tablePaths, 2, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("SmartScreens :");
            if (this.smartScreens != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortCollection(this.smartScreens, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("SmartScreenPaths :");
            if (this.smartScreenPaths != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.smartScreenPaths, 6, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Datacoms :");
            if (this.datacoms != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.datacoms, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("tpmsxMaps :");
            if (this.tpmsxMaps != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortArray(this.tpmsxMaps, 9, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.write(newLine);
            fw.write("Dbi :");
            if (this.dbi != null) {
                fw.write(newLine);
                exclude = new ArrayList();
                sorted = this.sortSet(this.dbi, 8, exclude);
                for (String lineParagraph : sorted) {
                    fw.write(lineParagraph);
                    fw.write(newLine);
                }
            } else {
                fw.write("none");
            }
            fw.close();
        }
        catch (IOException iOException) {
            L.error("Couldn't write to file");
        }
    }

    private void setPropertiesViewer(TSENode resourceNode, String resourceName, String resourceType) {
        resourceNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(resourceName, resourceType));
    }

    public void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
        String newLine = System.getProperty("line.separator");
        try {
            FileWriter fw;
            File f;
            File firstProg;
            boolean found;
            if (System.getProperty("test").equals("full")) {
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                    pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt") - 2)) + ".txt";
                }
                fw = new FileWriter(pathToWrite, true);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
            } else {
                File file;
                found = false;
                firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
            }
            List graphNodes = graph.nodes();
            TSENodeComparator comparator = new TSENodeComparator();
            Collections.sort(graphNodes, comparator);
            for (TSENode node : graphNodes) {
                String name = node.getText();
                fw.write(newLine);
                fw.write(name);
                for (Object allAttrNames : node.getAttributeNames()) {
                    if (allAttrNames.toString().equals("FILE")) {
                        Set locations = (Set)node.getAttributeValue("FILE");
                        if (locations == null) continue;
                        for (TextSelectionInFile tsf : locations) {
                            fw.write(newLine);
                            fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                            fw.write(newLine);
                            fw.write("Program type :" + tsf.getPrgType());
                            fw.write(newLine);
                        }
                        continue;
                    }
                    if (allAttrNames.toString().trim().equals(SCREEN_OCCUR_ID_ATTRIBUTE) || allAttrNames.toString().trim().equals(SCREEN_ID) || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                    fw.write(newLine);
                    fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                }
                List inEdges = node.inEdges();
                fw.write(newLine);
                fw.write(newLine);
                fw.write("The in edges :");
                this.writeEdge(inEdges, node, fw);
                List outEdges = node.outEdges();
                fw.write(newLine);
                fw.write("The out edges :");
                this.writeEdge(outEdges, node, fw);
                fw.write(newLine);
            }
            fw.close();
        }
        catch (IOException iOException) {
            L.error("Couldn't write to file");
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                DIRECTION edgeDirection = null;
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute(EDGE_DIRECTION)) {
                    edgeDirection = (DIRECTION)((Object)tSEEdge.getAttributeValue(EDGE_DIRECTION));
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                value.append("Statement Type: ");
                value.append(stmtType);
                value.append("  with direction : ");
                value.append((Object)edgeDirection);
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }

    public void clear() {
        this.paragraphs = null;
        this.gotoStmts = null;
        this.transactions = null;
        this.dal = null;
        this.bms_maps = null;
        this.bmsPaths = null;
        this.ads_maps = null;
        this.natural_maps = null;
        this.natMapPaths = null;
        this.files = null;
        this.printerfiles = null;
        this.adabasResources = null;
        this.links = null;
        this.programPaths = null;
        this.pl1InternalCalls = null;
        this.idmsCallRecords = null;
        this.recordDefinitions = null;
        this.idmsCallSets = null;
        this.setDefinitions = null;
        this.sqltables = null;
        this.ads_calls = null;
        this.mqManagers = null;
        this.mqQueues = null;
        this.imsdbs = null;
        this.tablePaths = null;
        this.smartScreens = null;
        this.smartScreenPaths = null;
        this.datacoms = null;
        this.tpmsxMaps = null;
        this.dbi = null;
    }

    private Set<String> sortArray(String[][] array, int position, List<Integer> exclude) {
        TreeSet<String> sorted = new TreeSet<String>();
        int i = 0;
        while (i < array.length) {
            StringBuilder arrayToString = new StringBuilder();
            int j = 1;
            while (j < array[i].length) {
                if (j == position) {
                    String name = this.projectIdSg.getProjectName();
                    if (array[i][j] != null && array[i][j].contains(name)) {
                        arrayToString.append(array[i][j].substring(array[i][j].lastIndexOf("\\") + 1));
                        arrayToString.append(" ");
                    }
                } else if (!exclude.contains(j)) {
                    arrayToString.append(array[i][j]);
                    arrayToString.append(" ");
                }
                ++j;
            }
            sorted.add(arrayToString.toString());
            ++i;
        }
        return sorted;
    }

    private Set<String> sortSet(Set<String[]> set, int position, List<Integer> exclude) {
        TreeSet<String> sorted = new TreeSet<String>();
        for (String[] iterator : set) {
            StringBuilder arrayToString = new StringBuilder();
            int i = 1;
            while (i < iterator.length) {
                if (i == position) {
                    if (iterator[i] != null && iterator[i].contains(this.projectIdSg.getProjectName())) {
                        arrayToString.append(iterator[i].substring(iterator[i].lastIndexOf("\\") + 1));
                        arrayToString.append(" ");
                    }
                } else if (!exclude.contains(i)) {
                    arrayToString.append(iterator[i]);
                    arrayToString.append(" ");
                }
                ++i;
            }
            sorted.add(arrayToString.toString());
        }
        return sorted;
    }

    private Set<String> sortCollection(Collection<String[]> collection, int position, List<Integer> exclude) {
        TreeSet<String> sorted = new TreeSet<String>();
        for (String[] iterator : collection) {
            StringBuilder arrayToString = new StringBuilder();
            int i = 1;
            while (i < iterator.length) {
                if (i == position) {
                    if (iterator[i] != null && iterator[i].contains(this.projectIdSg.getProjectName())) {
                        arrayToString.append(iterator[i].substring(iterator[i].lastIndexOf("\\") + 1));
                        arrayToString.append(" ");
                    }
                } else if (!exclude.contains(i)) {
                    arrayToString.append(iterator[i]);
                    arrayToString.append(" ");
                }
                ++i;
            }
            sorted.add(arrayToString.toString());
        }
        return sorted;
    }

    static enum DIRECTION {
        LEFT_TO_LEFT,
        RIGHT_TO_RIGHT,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

