/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.mainframe;

import com.ez.cobol.callgraph.nodes.AdabasNode;
import com.ez.cobol.callgraph.nodes.CICSNode;
import com.ez.cobol.callgraph.nodes.CPUNode;
import com.ez.cobol.callgraph.nodes.DB2Node;
import com.ez.cobol.callgraph.nodes.DiskNode;
import com.ez.cobol.callgraph.nodes.QueueNode;
import com.ez.cobol.callgraph.nodes.SysplexNode;
import com.ez.cobol.callgraph.nodes.SystemNode;
import com.ez.graphs.internal.Messages;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.Utils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.EZNodeBuilder;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import images.LoadSVGImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeModel.class);
    private static final String OnlineCPU_Identifier = "+";
    private static final String ZIIP_Identifier = "I";
    private static final String ZAAP_Identifier = "A";
    private static final int SYSPLEX_NODE_TYPE = 0;
    private static final int LPAR_NODE_TYPE = 1;
    private static final int CPU_NODE_TYPE = 2;
    private static final int SYSTEM_NODE_TYPE = 3;
    private static final int DISK_NODE_TYPE = 4;
    private static final int MQ_NODE_TYPE = 5;
    private static final int CICS_NODE_TYPE = 6;
    private static final int ADABAS_NODE_TYPE = 7;
    private static final int NATURAL_NODE_TYPE = 8;
    private static final int DB_NODE_TYPE = 9;
    private TSNodeBuilder nodeBuilder;
    private TSEdgeBuilder edgeBuilder;
    private Map<String, TSENode> systemsMap;
    private List<TSENode> tsNodes;
    public String[][] sysplexRes;
    public String[][] cpuRes;
    public String[][] cicsRes;
    public String[][] naturalRes;
    public String[][] adabasRes;
    public String[][] disksRes;
    public String[][] mqRes;
    public String[][] dbRes;
    public String[][] db2TRes;

    public MainframeModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public void loadGraph(IProgressMonitor monitor) {
        this.initGraph();
        this.nodeBuilder = this.graphManager.getNodeBuilder();
        this.edgeBuilder = this.graphManager.getEdgeBuilder();
        if (this.nodeBuilder == null) {
            this.nodeBuilder = new EZNodeBuilder();
            this.graphManager.setNodeBuilder(this.nodeBuilder);
        }
        if (this.edgeBuilder == null) {
            this.edgeBuilder = new TSEdgeBuilder();
            this.graphManager.setEdgeBuilder(this.edgeBuilder);
        }
        this.nodeBuilder.setResizability(3);
        if (this.sysplexRes == null || this.sysplexRes.length == 0) {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
            L.debug("no results");
        } else {
            this.tsNodes = new ArrayList<TSENode>();
            this.systemsMap = new HashMap<String, TSENode>();
            HashMap<String, TSENode> sysplexNodes = new HashMap<String, TSENode>();
            int i = 0;
            while (i < this.sysplexRes.length) {
                HashSet<String> systemNames;
                String[] sysplex = this.sysplexRes[i];
                String sysplexName = sysplex[2];
                TSENode sysplexNode = (TSENode)sysplexNodes.get(sysplexName);
                String system = sysplex[1];
                String cpcName = sysplex[3];
                String cpuId = sysplex[5];
                String lparName = sysplex[6];
                if (sysplexNode == null) {
                    sysplexNode = this.makeNode(Messages.getString(MainframeModel.class, "makeNode.sysplexNode.name", new String[]{sysplexName}), 0, Messages.getString(MainframeModel.class, "makeNode.sysplexNode.tooltip"));
                    sysplexNodes.put(sysplexName, sysplexNode);
                    sysplexNode.setAttribute("CPC", (Object)cpcName);
                    sysplexNode.setAttribute("CPUId", (Object)cpuId);
                    systemNames = new HashSet<String>();
                    sysplexNode.setAttribute("systemNames", systemNames);
                }
                systemNames = (HashSet<String>)sysplexNode.getAttributeValue("systemNames");
                systemNames.add(system);
                TSENode systemNode = this.systemsMap.get(system);
                if (systemNode == null) {
                    systemNode = this.makeNode(Messages.getString(MainframeModel.class, "makeNode.systemNode.name", new String[]{system}), 3, Messages.getString(MainframeModel.class, "makeNode.systemNode.tooltip"));
                    systemNode.setAttribute("Node_Mainframe", (Object)new SystemNode(system, cpuId));
                    this.systemsMap.put(system, systemNode);
                }
                if (Utils.filterNullValue((String)lparName) != null && !lparName.trim().isEmpty()) {
                    TSENode lparNode = this.makeNode(lparName, 1, Messages.getString(MainframeModel.class, "makeNode.lparNode.tooltip"));
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysplexNode, lparNode);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    e = this.edgeBuilder.addEdge(this.graphManager, lparNode, systemNode);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                } else {
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysplexNode, systemNode);
                    e.setAttribute("Color", (Object)TSEColor.green);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                }
                ++i;
            }
            for (String sysplexName : sysplexNodes.keySet()) {
                TSENode sysplexNode = (TSENode)sysplexNodes.get(sysplexName);
                String cpcName = (String)sysplexNode.getAttributeValue("CPC");
                Set systemNames = (Set)sysplexNode.getAttributeValue("systemNames");
                sysplexNode.setAttribute("Node_Mainframe", (Object)new SysplexNode(sysplexName, systemNames, cpcName));
            }
            if (this.cpuRes != null && this.cpuRes.length > 0) {
                this.createCPUNode();
            }
            if (this.cicsRes != null && this.cicsRes.length > 0) {
                this.createCICSNode();
            }
            if (this.naturalRes != null && this.naturalRes.length > 0) {
                this.createNaturalNodes();
            }
            if (this.adabasRes != null && this.adabasRes.length > 0) {
                this.createAdabasNode();
            }
            if (this.disksRes != null && this.disksRes.length > 0) {
                this.createDiskNodes();
            }
            if (this.mqRes != null && this.mqRes.length > 0) {
                this.createMQNode();
            }
            if (this.dbRes != null && this.dbRes.length > 0) {
                this.createDBNode();
            }
            this.systemsMap.clear();
            this.systemsMap = null;
        }
        monitor.done();
    }

    private void initGraph() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
    }

    private void createCPUNode() {
        String CPUnodeType = "eCPU";
        HashMap<TSENode, String> cpus = new HashMap<TSENode, String>();
        int i = 0;
        while (i < this.cpuRes.length) {
            TSENode sysNode;
            String[] cpu = this.cpuRes[i];
            String sysName = cpu[1];
            String cpuName = cpu[2];
            String cpcName = cpu[6];
            String cpuID = cpu[3];
            String CPUsCount = cpu[4];
            String enginesNr = cpu[5];
            String cpuNr = cpu[7];
            String cfr_ignored_0 = cpu[10];
            String cpuStatus = cpu[9];
            String specialField = cpu[8];
            CPUnodeType.concat(".").concat(cpcName);
            if (Utils.filterNullValue((String)cpuID) != null && !cpuID.isEmpty()) {
                if (Utils.filterNullValue((String)cpuName) == null) {
                    cpuName = "";
                }
                cpuName = cpuName.isEmpty() ? cpuID : cpuName.concat("\n").concat(cpuID);
            }
            String status = "";
            if (Utils.filterNullValue((String)cpuNr) != null && !cpuNr.isEmpty()) {
                if (cpuStatus.equals(OnlineCPU_Identifier)) {
                    status = Messages.getString(MainframeModel.class, "status.active");
                    if (specialField.equals(ZIIP_Identifier)) {
                        status = Messages.getString(MainframeModel.class, "status.active.ziip");
                    }
                    if (specialField.equals(ZAAP_Identifier)) {
                        status = Messages.getString(MainframeModel.class, "status.active.zaap");
                    }
                } else {
                    status = Messages.getString(MainframeModel.class, "status.inactive");
                }
            }
            if ((sysNode = this.systemsMap.get(sysName)) == null) {
                L.debug("System node null!!!");
            } else if (cpuName != null) {
                HashMap<String, String> statusMap;
                cpus.put(sysNode, cpuName);
                TSENode cpuNode = (TSENode)sysNode.getAttributeValue("CPU");
                if (cpuNode == null) {
                    cpuNode = this.makeNode(Messages.getString(MainframeModel.class, "makeNode.cpuNode.name", new String[]{cpuName}), 2, Messages.getString(MainframeModel.class, "makeNode.cpuNode.tooltip"));
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, cpuNode, sysNode);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    sysNode.setAttribute("CPU", (Object)cpuNode);
                    cpuNode.setAttribute("CPU ID: ", (Object)cpuID);
                    cpuNode.setAttribute("CPU Model: ", (Object)cpuName);
                    cpuNode.setAttribute("Total # of CPUs: ", (Object)CPUsCount);
                    cpuNode.setAttribute("# of engines active: ", (Object)enginesNr);
                    cpuNode.setAttribute("CPC name: ", (Object)cpcName);
                }
                if ((statusMap = (HashMap<String, String>)cpuNode.getAttributeValue("CPU Number: ")) == null) {
                    statusMap = new HashMap<String, String>();
                    cpuNode.setAttribute("CPU Number: ", statusMap);
                }
                statusMap.put(cpuNr, status);
            }
            ++i;
        }
        for (TSENode sysNode : cpus.keySet()) {
            TSENode cpuNode = (TSENode)sysNode.getAttributeValue("CPU");
            String cpuId = (String)cpuNode.getAttributeValue("CPU ID: ");
            String cpuModel = (String)cpuNode.getAttributeValue("CPU Model: ");
            String cpuCount = (String)cpuNode.getAttributeValue("Total # of CPUs: ");
            String cpuActiveEng = (String)cpuNode.getAttributeValue("# of engines active: ");
            String cpcName = (String)cpuNode.getAttributeValue("CPC name: ");
            Map statusMap = (Map)cpuNode.getAttributeValue("CPU Number: ");
            cpuNode.setAttribute("Node_Mainframe", (Object)new CPUNode(cpuId, cpuModel, cpuCount, cpuActiveEng, cpcName, statusMap));
        }
    }

    private void createCICSNode() {
        HashMap<String, ArrayList<TSENode>> systemCicsMap = new HashMap<String, ArrayList<TSENode>>();
        int j = 0;
        while (j < this.cicsRes.length) {
            String[] cics = this.cicsRes[j];
            String sysName = cics[1];
            String cicsName = cics[2];
            TSENode sysNode = this.systemsMap.get(sysName);
            if (sysNode == null) {
                L.debug("System node null!!!");
            } else {
                TSENode cicsNode = (TSENode)sysNode.getAttributeValue(cicsName);
                ArrayList<String> list = null;
                ArrayList<String> files = null;
                if (cicsNode == null) {
                    cicsNode = this.makeNode(cicsName, 6, Messages.getString(MainframeModel.class, "makeNode.cicsNode.tooltip"));
                    sysNode.setAttribute(cicsName, (Object)cicsNode);
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, cicsNode);
                    e.setAttribute("Color", (Object)TSEColor.blue);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    list = new ArrayList<String>();
                    cicsNode.setAttribute("list", list);
                    files = new ArrayList<String>();
                    cicsNode.setAttribute("files", files);
                    ArrayList<TSENode> cicsList = (ArrayList<TSENode>)systemCicsMap.get(sysName);
                    if (cicsList == null) {
                        cicsList = new ArrayList<TSENode>();
                        systemCicsMap.put(sysName, cicsList);
                    }
                    cicsList.add(cicsNode);
                } else {
                    list = (ArrayList<String>)cicsNode.getAttributeValue("list");
                    files = (ArrayList<String>)cicsNode.getAttributeValue("files");
                }
                if (Utils.filterNullValue((String)cics[4]) != null && !cics[4].equals("")) {
                    list.add(cics[4]);
                }
                if (Utils.filterNullValue((String)cics[5]) != null && !cics[5].equals("")) {
                    files.add(cics[5]);
                }
            }
            ++j;
        }
        for (String sysName : systemCicsMap.keySet()) {
            List cicsList = (List)systemCicsMap.get(sysName);
            for (TSENode cicsNode : cicsList) {
                List list = (List)cicsNode.getAttributeValue("list");
                List files = (List)cicsNode.getAttributeValue("files");
                cicsNode.setAttribute("class_name", CICSNode.class);
                String cicsName = (String)cicsNode.getName();
                cicsNode.setAttribute("Node_Mainframe", (Object)new CICSNode(cicsName, list, files));
            }
        }
    }

    private void createNaturalNodes() {
        int i = 0;
        while (i < this.naturalRes.length) {
            String[] natural = this.naturalRes[i];
            String sysName = natural[1];
            String natName = natural[2];
            TSENode sysNode = this.systemsMap.get(sysName);
            if (sysNode == null) {
                L.debug("System node null!!!");
            } else {
                TSENode natNode = (TSENode)sysNode.getAttributeValue("NATURAL");
                if (natNode == null) {
                    natNode = this.makeNode(natName, 8, Messages.getString(MainframeModel.class, "makeNode.natNode.tooltip"));
                    natNode.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    sysNode.setAttribute("NATURAL", (Object)natNode);
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, natNode);
                    e.setAttribute("Color", (Object)TSEColor.blue);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                }
            }
            ++i;
        }
    }

    private void createAdabasNode() {
        int i = 0;
        while (i < this.adabasRes.length) {
            String[] adabas = this.adabasRes[i];
            String sysName = adabas[1];
            String dbName = adabas[2];
            String adabasName = "(ADABAS)";
            TSENode sysNode = this.systemsMap.get(sysName);
            if (sysNode == null) {
                L.debug("System node null!!!");
            } else {
                TSENode adabasNode = (TSENode)sysNode.getAttributeValue("ADABAS");
                AdabasNode adEntity = null;
                if (adabasNode == null) {
                    adabasNode = this.makeNode(adabasName, 7, "(ADABAS)");
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, adabasNode);
                    e.setAttribute("Color", (Object)TSEColor.blue);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    sysNode.setAttribute("ADABAS", (Object)adabasNode);
                    adEntity = new AdabasNode();
                    adabasNode.setAttribute("Node_Mainframe", (Object)adEntity);
                } else {
                    adEntity = (AdabasNode)adabasNode.getAttributeValue("Node_Mainframe");
                }
                adEntity.addDatabase(dbName);
            }
            ++i;
        }
    }

    private void createDiskNodes() {
        HashMap<String, Integer> sysDisks = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.disksRes.length) {
            String[] disk = this.disksRes[i];
            String sysName = disk[1];
            if (sysDisks.containsKey(sysName)) {
                int count = (Integer)sysDisks.get(sysName) + 1;
                sysDisks.put(sysName, count);
            } else {
                sysDisks.put(sysName, 1);
            }
            ++i;
        }
        for (String sys : sysDisks.keySet()) {
            int count = (Integer)sysDisks.get(sys);
            TSENode diskNode = this.makeNode(Messages.getString(MainframeModel.class, "makeNode.diskNode.name", new String[]{String.valueOf(count)}), 4, Messages.getString(MainframeModel.class, "makeNode.diskNode.tooltip"));
            TSENode sysNode = this.systemsMap.get(sys);
            diskNode.setAttribute("Node_Mainframe", (Object)new DiskNode("DASD", count));
            TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, diskNode);
            e.setAttribute("Color", (Object)TSEColor.blue);
            e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
        }
    }

    private void createMQNode() {
        int i = 0;
        while (i < this.mqRes.length) {
            String[] mq = this.mqRes[i];
            String sysName = mq[1];
            String mqName = mq[3];
            TSENode sysNode = this.systemsMap.get(sysName);
            if (sysNode == null) {
                L.debug("System node null!!!");
            } else {
                TSENode mqNode = (TSENode)sysNode.getAttributeValue("MQ");
                if (mqNode == null) {
                    mqNode = this.makeNode(mqName, 5, "(MQS)");
                    sysNode.setAttribute("MQ", (Object)mqNode);
                    mqNode.setAttribute("class_name", QueueNode.class);
                    mqNode.setAttribute("Node_Mainframe", (Object)new QueueNode(mqName, sysName, mq[2], mq[4]));
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, mqNode);
                    e.setAttribute("Color", (Object)TSEColor.blue);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                }
            }
            ++i;
        }
    }

    private void createDBNode() {
        int i = 0;
        while (i < this.dbRes.length) {
            String[] db = this.dbRes[i];
            String sysName = db[1];
            String dbName = db[2];
            String dbID = db[3];
            String subSysName = db[4];
            TSENode sysNode = this.systemsMap.get(sysName);
            if (sysNode == null) {
                L.debug("System node null!!!");
            } else {
                TSENode dbNode;
                Map dbTables = null;
                if (sysNode.getAttributeValue("dbinfo") != null) {
                    dbTables = (Map)sysNode.getAttributeValue("dbinfo");
                } else {
                    dbTables = new HashMap();
                    sysNode.setAttribute("dbinfo", dbTables);
                }
                Pair dbInfo = new Pair((Object)Integer.parseInt(dbID), (Object)dbName);
                if (!dbTables.keySet().contains(dbInfo)) {
                    dbTables.put(dbInfo, new ArrayList());
                }
                if ((dbNode = (TSENode)sysNode.getAttributeValue("DB")) == null) {
                    dbNode = this.makeNode(Messages.getString(MainframeModel.class, "makeNode.dbNode.name", new String[]{subSysName}), 9, Messages.getString(MainframeModel.class, "makeNode.dbNode.tooltip", new String[]{sysName}));
                    TSEEdge e = this.edgeBuilder.addEdge(this.graphManager, sysNode, dbNode);
                    e.setAttribute("Color", (Object)TSEColor.blue);
                    e.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.FALSE);
                    sysNode.setAttribute("DB", (Object)dbNode);
                }
            }
            ++i;
        }
        if (this.db2TRes != null && this.db2TRes.length > 0) {
            String[][] stringArray = this.db2TRes;
            int n = this.db2TRes.length;
            int n2 = 0;
            while (n2 < n) {
                String[] col = stringArray[n2];
                TSENode sysNode = this.systemsMap.get(col[2]);
                TSENode dbNode = (TSENode)sysNode.getAttributeValue("DB");
                Map dbTables = (Map)sysNode.getAttributeValue("dbinfo");
                for (Pair dbInfo : dbTables.keySet()) {
                    if (!String.valueOf(dbInfo.getFirst()).equals(col[0])) continue;
                    List tables = (List)dbTables.get(dbInfo);
                    tables.add(col[1]);
                    break;
                }
                dbNode.setAttribute("Node_Mainframe", (Object)new DB2Node(dbTables));
                ++n2;
            }
        }
    }

    private TSENode makeNode(String name, int type, String tooltip) {
        TSENode tsNode = this.nodeBuilder.addNode(this.getGraph());
        tsNode.setName((Object)name);
        tsNode.setTooltipText(tooltip);
        tsNode.setAttribute("RESOURCE_TYPE_INTEGER", (Object)type);
        String inventoryCategory = null;
        switch (type) {
            case 0: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.SYSPLEX_NODE_TYPE");
                break;
            }
            case 1: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.LPAR_NODE_TYPE");
                break;
            }
            case 2: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.CPU_NODE_TYPE");
                break;
            }
            case 3: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.SYSTEM_NODE_TYPE");
                break;
            }
            case 6: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.CICS_NODE_TYPE");
                break;
            }
            case 8: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.NATURAL_NODE_TYPE");
                break;
            }
            case 7: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.ADABAS_NODE_TYPE");
                break;
            }
            case 4: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.DISK_NODE_TYPE");
                break;
            }
            case 5: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.MQ_NODE_TYPE");
                break;
            }
            case 9: {
                inventoryCategory = Messages.getString(MainframeModel.class, "inventoryCategory.DB_NODE_TYPE");
            }
        }
        this.putEntriesInGISV(inventoryCategory, tsNode);
        this.setUIStyle(tsNode);
        this.tsNodes.add(tsNode);
        return tsNode;
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    public void updateDrawing() {
        for (TSENode node : this.tsNodes) {
            this.setUIStyle(node);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.tsNodes != null) {
            this.tsNodes.clear();
            this.tsNodes = null;
        }
    }

    public void setUIStyle(TSENode tsNode) {
        TSESVGImage svgimage = null;
        Integer nodeType = (Integer)tsNode.getAttributeValue("RESOURCE_TYPE_INTEGER");
        if (nodeType != null) {
            switch (nodeType) {
                case 0: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"sysplex.svg");
                    this.setUIStyle(tsNode, TSEColor.darkCyan, svgimage);
                    break;
                }
                case 1: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"LPAR.svg");
                    this.setUIStyle(tsNode, TSEColor.darkGreen, svgimage);
                    break;
                }
                case 2: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"CPU.svg");
                    this.setUIStyle(tsNode, TSEColor.blue, svgimage);
                    break;
                }
                case 3: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"System.svg");
                    this.setUIStyle(tsNode, TSEColor.yellow, svgimage);
                    break;
                }
                case 6: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"CICS.svg");
                    this.setUIStyle(tsNode, TSEColor.red, svgimage);
                    break;
                }
                case 8: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"natural.svg");
                    this.setUIStyle(tsNode, TSEColor.paleGreen, svgimage);
                    break;
                }
                case 7: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"adabas.svg");
                    this.setUIStyle(tsNode, TSEColor.paleGray, svgimage);
                    break;
                }
                case 4: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"Disk.svg");
                    this.setUIStyle(tsNode, TSEColor.darkMagenta, svgimage);
                    break;
                }
                case 5: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"MQ.svg");
                    this.setUIStyle(tsNode, TSEColor.cyan, svgimage);
                    break;
                }
                case 9: {
                    svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)"DB2.svg");
                    this.setUIStyle(tsNode, TSEColor.darkBlue, svgimage);
                }
            }
        }
    }

    protected void setUIStyle(TSENode node, TSEColor asTextColor, TSESVGImage svgimage) {
        if (this.uiStyle == 2 && svgimage != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("uiImage", (Object)svgimage);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            node.setAttribute("Fill_Color", (Object)asTextColor);
        }
    }
}

