/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.mainframe;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.analysis.graph.mouseHook.AnalysisContributorComparator;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class MainframeMenuMouseActionHook
extends MainframeMouseActionsHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String SUBMENU_ANALYSIS_INPUT_PROJECT_SEGMENTS = "project sgs to start all available analysis for each project";

    public MainframeMenuMouseActionHook(EZEntityID entityId) {
        super(entityId);
    }

    public List getRightClickContributions(TSENode node) {
        ArrayList<Object> contextItems = new ArrayList<Object>();
        if (node.hasAttribute(SUBMENU_ANALYSIS_INPUT_PROJECT_SEGMENTS)) {
            Set prjs = (Set)node.getAttributeValue(SUBMENU_ANALYSIS_INPUT_PROJECT_SEGMENTS);
            HashMap<MenuManager, Integer> info = new HashMap<MenuManager, Integer>();
            for (EZSourceProjectIDSg sg : prjs) {
                String prjName = sg.getProjectName();
                MenuManager prjSubMenu = new MenuManager(prjName);
                contextItems.add(prjSubMenu);
                info.put(prjSubMenu, 0);
                ArrayList list = new ArrayList();
                node.setAttribute("APPLICABLE_INPUT", node.getAttributeValue("APPLICABLE_INPUT".concat(prjName)));
                this.addAnalysisActions(node, list);
                node.removeAttribute("APPLICABLE_INPUT");
                HashMap<IContributionItem, Integer> infoAnalysis = new HashMap<IContributionItem, Integer>();
                int groupNo = 0;
                for (Object obj : list) {
                    IContributionItem ci = (IContributionItem)obj;
                    if (ci.isSeparator()) {
                        infoAnalysis.put(ci, ++groupNo);
                        ++groupNo;
                        continue;
                    }
                    infoAnalysis.put(ci, groupNo);
                }
                Collections.sort(list, new AnalysisContributorComparator(infoAnalysis));
                for (IContributionItem o : list) {
                    prjSubMenu.add(o);
                }
            }
            Collections.sort(contextItems, new AnalysisContributorComparator(info));
            contextItems.add(new Separator());
        }
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }
}

