/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.mainframe;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.IConnectionRunnable;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.jobflow.JobFlowGraphJob;
import com.ez.graphs.mainframe.MainframeModel;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.analysis.job.SelectionJob;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeAnalysisJob
extends GraphAnalysisJob
implements IConnectionRunnable {
    private static final Logger L = LoggerFactory.getLogger(MainframeAnalysisJob.class);
    public static final String SYSPLEX_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFSysplexInfo.SysplexName, MFHWInfo.CPCName, MFLPARInfo.LPARNumber, MFHWInfo.CPUID, MFLPARInfo.LPARName FROM  MFSysplexInfo INNER JOIN MFHWInfo INNER JOIN MFLPARInfo ON MFHWInfo.MainframeID = MFLPARInfo.MainframeID ON MFSysplexInfo.SysplexID = MFLPARInfo.SysplexID WHERE (MFSysplexInfo.SysplexID <> - 1)";
    public static final String CPU_QUERY = "SELECT DISTINCT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFHWInfo.CPUModel, MFHWInfo.CPUID, MFHWInfo.TotalCPUs, MFHWInfo.ActiveEngines, MFHWInfo.CPCName, MFOCCPUInfo.CPUNumber, MFOCCPUInfo.CPUspecial, MFOCCPUInfo.CPUStatus, MFLPARInfo.MVSConnectionName FROM MFOCCPUInfo INNER JOIN MFOCCPCInfo ON MFOCCPUInfo.CPCId = MFOCCPCInfo.CPCId RIGHT OUTER JOIN MFHWInfo INNER JOIN MFLPARInfo ON MFHWInfo.MainframeID = MFLPARInfo.MainframeID ON MFOCCPCInfo.LparId = MFLPARInfo.LPARID AND MFOCCPCInfo.STSIInstr = MFHWInfo.CPCName WHERE (MFHWInfo.MainframeID <> - 1)";
    public static final String CICS_QUERY = "SELECT  MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFCICSInfo.CICSName, '' AS APPLID, MFCICSList.ListName, MFCICSInfoFiles.FileDSName, MFCICSInfoFiles.MemberName, MFCICSInfoFiles.RecordType, MFSysplexInfo.SysplexName FROM MFLPARInfo INNER JOIN MFCICSInfoFiles ON MFLPARInfo.LPARID = MFCICSInfoFiles.LPARConnID INNER JOIN MFCICSInfo ON MFLPARInfo.LPARID = MFCICSInfo.LPARID AND MFCICSInfoFiles.CICSID = MFCICSInfo.CICSID INNER JOIN MFSysplexInfo ON MFLPARInfo.SysplexID = MFSysplexInfo.SysplexID LEFT OUTER JOIN MFCICSList ON MFCICSInfoFiles.CICSInfoFileID = MFCICSList.CICSID WHERE  (MFLPARInfo.LPARID <> - 1)";
    public static final String NATURAL_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFNaturalLibraries.LibraryName FROM MFLPARInfo INNER JOIN MFNaturalLibraries ON MFLPARInfo.LPARID = MFNaturalLibraries.LparID WHERE  (MFLPARInfo.LPARID <> - 1)";
    public static final String ADABAS_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFDB2Databases.Name FROM MFLPARInfo INNER JOIN MFAdabasDB ON MFLPARInfo.LPARID = MFAdabasDB.LparID INNER JOIN MFDB2Databases on MFDB2Databases.DBID = MFAdabasDB.DBId WHERE (MFLPARInfo.LPARID <> - 1)";
    public static final String DB_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFDB2Databases.Name, MFDB2Databases.DBID, MFDB2Databases.DB2SubsystemName FROM MFLPARInfo INNER JOIN MFDB2Databases ON MFLPARInfo.LPARID = MFDB2Databases.LparID WHERE     (MFLPARInfo.LPARID <> - 1)";
    public static final String DISKS_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFDiskTypes.DiskTypeName, MFPhysicalDevices.DeviceID FROM MFDiskTypes INNER JOIN MFPhysicalDevices INNER JOIN MFLPARInfo INNER JOIN MFLPARvsDevice ON MFLPARInfo.LPARID = MFLPARvsDevice.LPARID ON MFPhysicalDevices.DeviceID = MFLPARvsDevice.DeviceID ON MFDiskTypes.DiskTypeID = MFPhysicalDevices.DiskType WHERE (MFLPARInfo.LPARID <> - 1) AND (MFPhysicalDevices.DeviceID <> - 1) AND (MFDiskTypes.DiskTypeName = 'DASD') AND (MFPhysicalDevices.DeviceStatus = 'O')";
    public static final String MQ_QUERY = "SELECT MFLPARInfo.LPARID, MFLPARInfo.SystemName, MFQManagerInfo.MQSubsystemName, MFQManagerInfo.QManagerName, MFQManagerInfo.DeadQName, MFQManagerInfo.AlterDate FROM MFLPARInfo INNER JOIN MFQManagerInfo ON MFLPARInfo.LPARID = MFQManagerInfo.LparID WHERE     (MFLPARInfo.LPARID <> - 1)";
    public static final String DB2_TABLES_QUERY = "SELECT MFDB2Databases.DBID, MFDB2Tables.Name AS TableName, MFLPARInfo.SystemName FROM MFDB2Databases INNER JOIN MFDB2Tables ON MFDB2Databases.DBID = MFDB2Tables.DBID INNER JOIN\t\tMFLPARInfo\t ON MFLPARInfo.LPARID = MFDB2Databases.LparID WHERE     (MFDB2Databases.LparID <> - 1)";
    private MainframeMouseActionsHook mouseActionsHook;
    private SelectionJob selectionJob;

    public MainframeAnalysisJob(EZEntityID id) {
        super(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new MainframeGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new MainframeModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        this.mouseActionsHook = new MainframeMouseActionsHook(this.id);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        this.selectionJob = new SelectionJob(this.id);
        this.mouseActionsHook.setSelectJob(this.selectionJob);
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        String ezsourcePrjName = (String)this.analysis.getContextValue("input_project_names");
        IStatus status = Utils.collectDataFromBridge((IProgressMonitor)monitor, (String)ezsourcePrjName, (IConnectionRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        }
    }

    public void runWithProgress(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(JobFlowGraphJob.class, "compute.taskName"));
        String[][] sysplexRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)SYSPLEX_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).sysplexRes = sysplexRes;
        String[][] CPURes = Utils.runSQLQuery((EZSourceConnection)conn, (String)CPU_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).cpuRes = CPURes;
        String[][] CICSRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)CICS_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).cicsRes = CICSRes;
        String[][] NaturalRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)NATURAL_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).naturalRes = NaturalRes;
        String[][] ADABASRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)ADABAS_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).adabasRes = ADABASRes;
        String[][] disksRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)DISKS_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).disksRes = disksRes;
        String[][] MQRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)MQ_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).mqRes = MQRes;
        String[][] DBRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)DB_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).dbRes = DBRes;
        String[][] db2TRes = Utils.runSQLQuery((EZSourceConnection)conn, (String)DB2_TABLES_QUERY, null, null, (IProgressMonitor)monitor.newChild(100));
        ((MainframeModel)this.graphModel).db2TRes = db2TRes;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    public class MainframeGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public MainframeGraphInfo(EZEntityID id) {
            super(id);
            SharedImages.registerImage("mainframeERD", "icons/erd.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("mainframeERD");
            }
            return this.image;
        }

        public String getText() {
            String ezsourcePrjName = (String)MainframeAnalysisJob.this.analysis.getContextValue("input_project_names");
            return Messages.getString(MainframeAnalysisJob.class, "mainframe.graph.analysis.lbl", new String[]{ezsourcePrjName});
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }
    }
}

