/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.mainframe;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.mainframe.MainframeAnalysisJob;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainframeAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MainframeAnalysis.class);
    protected MainframeAnalysisJob job = null;

    @Override
    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (MainframeAnalysisJob)wk.getJob(id, MainframeAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    @Override
    public void setInputs(List inputs) {
        if (inputs != null) {
            String prjName = null;
            for (Object inpObj : inputs) {
                if (!(inpObj instanceof EZSourceProjectInputType)) continue;
                prjName = ((EZSourceProjectInputType)inpObj).getName();
                this.addContextValue("input_project_names", prjName);
                ProjectInfo pi = (ProjectInfo)((EZSourceProjectInputType)inpObj).getProperty("PROJECT_INFO");
                this.addContextValue("PROJECT_INFO", pi);
                break;
            }
        }
    }

    @Override
    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    public String getLabelType() {
        return Messages.getString(MainframeAnalysis.class, "analysis.type");
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_MAINFRAME_ANALYSIS;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        Object inputs1 = this.getContextValue("input_project_names");
        Object inputs2 = a2.getContextValue("input_project_names");
        boolean ret = this.type.equals((Object)a2.getType()) && inputs1.equals(inputs2);
        return ret;
    }

    @Override
    public boolean filterInputs() {
        Object inputs = this.getContextValue("input_project_names");
        boolean result = false;
        if (inputs == null) {
            result = true;
        }
        if (result) {
            this.notifyFinish();
        }
        return result;
    }
}

