/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.jobflow;

import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.jobflow.JobFlowgraphEdgeLegendInfo;
import com.ez.graphs.jobflow.JobFlowgraphNodeLegendInfo;
import com.ez.graphs.jobflow.TSENodeComparator;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceExecProc;
import com.ez.internal.analysis.config.inputs.EZSourceJclStep;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.model.segments.EZSourceAAUTOJobIDSg;
import com.ez.workspace.model.segments.EZSourceExecProcIDSg;
import com.ez.workspace.model.segments.EZSourceJclStepIDSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceScreenIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSEFont;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.TSNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.TSCompositeNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSConditionalUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSGroupUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSImageUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSOvalUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSShapeTextUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSShapeUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSSwitchUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElementPoint;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.TSServiceOutputData;
import com.tomsawyer.service.TSServiceOutputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import com.tomsawyer.service.layout.client.TSApplyLayoutResults;
import com.tomsawyer.service.layout.client.TSLayoutProxy;
import com.tomsawyer.util.shared.TSProperty;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFlowGraphModel
extends AnnotatedGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JobFlowGraphModel.class);
    public static final String STEP_NAME_IN_JCL = "stepInJCL executing pgm or proc";
    private EZSourceJobIDSg inputJobSg;
    private TextSelectionInFile sel;
    String[][] ifs = null;
    String[][] steps = null;
    private ProjectInfo ezsourcePrj;
    private ArrayList<List<TSENode>> tsNodeLevels = new ArrayList();

    public JobFlowGraphModel(AnalysisGraphManager graphManager) {
        this.graphManager = graphManager;
        this.initialize();
    }

    public void clear() {
        this.ifs = null;
        this.steps = null;
        this.tsNodeLevels.clear();
    }

    private void initialize() {
        this.outForGISV.clear();
        this.tsNodeLevels.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    public void loadGraph(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        pmonitor.setTaskName(Messages.getString(JobFlowGraphModel.class, "loading.graph"));
        this.initGraph();
        if (this.sel == null) {
            this.graphManager.setNodeBuilder((TSNodeBuilder)((AnalysisGraphManager)this.graphManager).makeNodeBuilder());
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(JobFlowGraphModel.class, "noresults.node.name"));
            L.debug("no results for {}", (Object)this.inputJobSg);
        } else {
            TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
            TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
            nodeBuilder.setResizability(3);
            nodeBuilder.setShape((TSShape)TSPolygonShape.getInstance((String)"rrect"));
            this.createUI(nodeBuilder);
            String inventoryCategory = "";
            String jobQName = this.inputJobSg.getJobName();
            TSENode parent = nodeBuilder.addNode(this.graph);
            parent.setAttribute("drawing", (Object)"roundtext");
            parent.setName((Object)jobQName);
            parent.setTooltipText(jobQName);
            parent.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.JOB.getTSEColor());
            parent.setAttribute("Node_Mainframe", (Object)new MainframeSourceNode(ResultElementType.JCL_JOB.getDisplayName(), this.sel.getFileName()));
            parent.setAttribute("class_name", (Object)JobFlowgraphNodeLegendInfo.JOB.getNodeTypeClass());
            Utils.setFileAttribute((TSGraphMember)parent, (TextSelectionInFile)this.sel);
            this.createApplicableInputType(jobQName, parent, 22);
            inventoryCategory = JobFlowgraphNodeLegendInfo.JOB.getLegendLabel();
            this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.JOB);
            this.putEntriesInGISV(inventoryCategory, parent);
            TSENode node = null;
            Stack<Object[]> ifStack = new Stack<Object[]>();
            boolean thenBranch = true;
            if (this.steps != null) {
                String[][] stringArray = this.steps;
                int n = this.steps.length;
                int n2 = 0;
                while (n2 < n) {
                    String nodeName;
                    String[] cols = stringArray[n2];
                    String edgeTag = null;
                    int cId = Integer.valueOf(cols[0]);
                    TSENode newp = this.closeIfsPreviousToCurrent(cId, ifStack, edgeBuilder, this.graphManager);
                    if (newp != null) {
                        parent = newp;
                    }
                    if (cols[3].equals("0")) {
                        node = nodeBuilder.addNode(this.graph);
                        node.setAttribute("drawing", (Object)"roundtext");
                        nodeName = cols[1];
                        if (!cols[5].equals("0")) {
                            String procName = cols[5];
                            nodeName = String.valueOf(nodeName) + " (" + procName + ")";
                            node.setName((Object)nodeName);
                            node.setTooltipText(nodeName);
                            node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.JOB_STEP_PROC.getTSEColor());
                            node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.TRUE);
                            inventoryCategory = JobFlowgraphNodeLegendInfo.JOB_STEP_PROC.getLegendLabel();
                            this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.JOB_STEP_PROC);
                            this.createApplicableInputType(nodeName, node, 25);
                            this.setPropertiesViewer(node, nodeName, ResultElementType.JOB_STEP_PROC.getDisplayName());
                        } else {
                            node.setName((Object)nodeName);
                            node.setTooltipText(nodeName);
                            node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.JOB_STEP.getTSEColor());
                            node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.TRUE);
                            this.setPropertiesViewer(node, nodeName, ResultElementType.JOB_STEP.getDisplayName());
                            inventoryCategory = JobFlowgraphNodeLegendInfo.JOB_STEP.getLegendLabel();
                            this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.JOB_STEP);
                            this.createApplicableInputType(nodeName, node, 24);
                        }
                        if (!ifStack.isEmpty()) {
                            Object[] ifInfo = ifStack.peek();
                            String[] ifDetails = (String[])ifInfo[0];
                            int thenId = Integer.valueOf(ifDetails[4]);
                            int elseId = Integer.valueOf(ifDetails[5]);
                            if (cId == thenId) {
                                parent = (TSENode)ifInfo[3];
                                thenBranch = true;
                                edgeTag = "then";
                            }
                            if (cId == elseId) {
                                parent = (TSENode)ifInfo[4];
                                thenBranch = false;
                                edgeTag = "else";
                            }
                            if (thenBranch) {
                                ifInfo[3] = node;
                                if (!cols[5].equals("0")) {
                                    node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_THEN.getTSEColor());
                                    this.setPropertiesViewer(node, nodeName, ResultElementType.COND_JOB_STEP_PROC_THEN.getDisplayName());
                                    inventoryCategory = JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_THEN.getLegendLabel();
                                    this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_THEN);
                                } else {
                                    node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.COND_JOB_STEP_THEN.getTSEColor());
                                    this.setPropertiesViewer(node, nodeName, ResultElementType.COND_JOB_STEP_PROC_THEN.getDisplayName());
                                    inventoryCategory = JobFlowgraphNodeLegendInfo.COND_JOB_STEP_THEN.getLegendLabel();
                                    this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.COND_JOB_STEP_THEN);
                                }
                            } else {
                                ifInfo[4] = node;
                                if (!cols[5].equals("0")) {
                                    node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_ELSE.getTSEColor());
                                    this.setPropertiesViewer(node, nodeName, ResultElementType.COND_JOB_STEP_PROC_ELSE.getDisplayName());
                                    inventoryCategory = JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_ELSE.getLegendLabel();
                                    this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.COND_JOB_STEP_PROC_ELSE);
                                } else {
                                    node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.COND_JOB_STEP_ELSE.getTSEColor());
                                    this.setPropertiesViewer(node, nodeName, ResultElementType.COND_JOB_STEP_PROC_ELSE.getDisplayName());
                                    inventoryCategory = JobFlowgraphNodeLegendInfo.COND_JOB_STEP_ELSE.getLegendLabel();
                                    this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.COND_JOB_STEP_ELSE);
                                }
                            }
                        }
                        this.putEntriesInGISV(inventoryCategory, node);
                    } else {
                        node = nodeBuilder.addNode(this.graph);
                        nodeName = cols[1];
                        node.setName((Object)nodeName);
                        node.setTooltipText(nodeName);
                        node.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.CONDITIONAL_NODE.getTSEColor());
                        node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)Boolean.TRUE);
                        node.setAttribute("drawing", (Object)"roundtext");
                        this.setPropertiesViewer(node, nodeName, ResultElementType.JCL_IF.getDisplayName());
                        this.createApplicableInputType(nodeName, node, 28);
                        this.nodeTypesSetForLegend.add(JobFlowgraphNodeLegendInfo.CONDITIONAL_NODE);
                        TSENode end = nodeBuilder.addNode(this.graph);
                        end.setAttribute("drawing", (Object)"guguloi");
                        end.setAttribute("Fill_Color", (Object)JobFlowgraphNodeLegendInfo.CONDITIONAL_NODE.getTSEColor());
                        this.setPropertiesViewer(end, nodeName, ResultElementType.JCL_IF.getDisplayName());
                        String[] ifdetails = this.getIf(this.ifs, cols[3]);
                        Object[] ifInfo = new Object[]{ifdetails, node, end, node, node, thenBranch};
                        ifStack.push(ifInfo);
                    }
                    TSEEdge edge = edgeBuilder.addEdge(this.graphManager, parent, node);
                    if (edgeTag != null) {
                        edge.addLabel().setName(edgeTag);
                    }
                    this.edgeTypesSetForLegend.add(JobFlowgraphEdgeLegendInfo.FLOW_PATH);
                    parent = node;
                    ++n2;
                }
            }
            while (!ifStack.isEmpty()) {
                this.closeIfsPreviousToCurrent(null, ifStack, edgeBuilder, this.graphManager);
            }
            this.findAnnotations(monitor);
        }
    }

    private void createApplicableInputType(String nodeName, TSENode node, int resType) {
        EZSourceJclStep inputType = null;
        switch (resType) {
            case 22: {
                inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
                if (inputType == null) break;
                inputType.setName(nodeName);
                EZEntityID entity = new EZEntityID();
                inputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.ezsourcePrj));
                entity.addSegment((EZSegment)this.inputJobSg);
                entity.addSegment((EZSegment)new EZSourceAAUTOJobIDSg(this.inputJobSg.getJobName(), null));
                node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
                break;
            }
            case 24: {
                this.setPropertiesViewer(node, nodeName, ResultElementType.JCL_STEP.getDisplayName());
                break;
            }
            case 28: {
                inputType = new EZSourceJclStep();
                inputType.setName(nodeName);
                EZEntityID entity = new EZEntityID();
                inputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceJclStepIDSg(nodeName));
                node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
                this.setPropertiesViewer(node, nodeName, ResultElementType.JCL_IF.getDisplayName());
                break;
            }
            case 25: {
                String procName = nodeName.substring(nodeName.indexOf("(") + 1, nodeName.indexOf(")"));
                String stepName = nodeName.substring(0, nodeName.indexOf("(") - 1);
                inputType = new EZSourceExecProc();
                inputType.setName(procName);
                inputType.addProperty(STEP_NAME_IN_JCL, (Object)stepName);
                EZEntityID entity = new EZEntityID();
                inputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceExecProcIDSg(procName));
                node.setAttribute("APPLICABLE_INPUT", (Object)inputType);
                this.setPropertiesViewer(node, nodeName, ResultElementType.JCL_PROCEDURE.getDisplayName());
            }
        }
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZEntityID id;
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT") && (id = (objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT")).getEntID()) != null && id.getSegment(EZSourceProjectIDSg.class) == null) {
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)new EZSourceProjectIDSg(this.ezsourcePrj));
            entity.addEntitySegments(id);
            objType.setEntID(entity);
        }
        return objType;
    }

    public void customLayout() {
        this.doHierarchicalLayout(3);
    }

    public void setEzsourcePrj(ProjectInfo ezsourcePrj) {
        this.ezsourcePrj = ezsourcePrj;
    }

    private void initGraph() {
        this.outForGISV.clear();
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    private void createUI(TSNodeBuilder nodeBuilder) {
        TSCompositeNodeUI nodeUI = new TSCompositeNodeUI();
        TSGroupUIElement rootElement = new TSGroupUIElement();
        nodeUI.setRootElement((TSUIElement)rootElement);
        TSGroupUIElement textGrElement = new TSGroupUIElement();
        TSShapeUIElement shapeElement = new TSShapeUIElement();
        textGrElement.addElement((TSUIElement)shapeElement);
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "TIGHT_WIDTH", (Serializable)new Double(20.0));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "TIGHT_HEIGHT", (Serializable)new Double(20.0));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "FILL_COLOR", (Serializable)((Object)"<Fill_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "LINE_WIDTH", (Serializable)Double.valueOf(0.01));
        TSShapeTextUIElement textElement = new TSShapeTextUIElement();
        textElement.setProperty(new TSProperty("text", (Object)"$tag()"));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_COLOR", (Serializable)((Object)"<Text_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_FONT", (Serializable)new TSEFont("SansSerif-plain-16"));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_TRUNCATION_ENABLED", (Serializable)Boolean.FALSE);
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_WRAP_ENABLED", (Serializable)Boolean.FALSE);
        textGrElement.addElement((TSUIElement)textElement);
        TSSwitchUIElement switchElementType = new TSSwitchUIElement();
        switchElementType.setFunction("$valueOf(drawing)");
        switchElementType.addChild("roundtext", (TSUIElement)textGrElement);
        TSOvalUIElement oval = new TSOvalUIElement();
        switchElementType.addChild("guguloi", (TSUIElement)oval);
        rootElement.addElement((TSUIElement)switchElementType);
        TSImageUIElement warningElement = new TSImageUIElement("warning", new TSUIElementPoint(-0.5, 0.0, 0.5, 0.0), new TSUIElementPoint(-0.5, 12.0, 0.5, -12.0));
        TSConditionalUIElement statusCondition = new TSConditionalUIElement("statusCondition", "$stringEquals(true, <annotation>)");
        statusCondition.setIfElement((TSUIElement)warningElement);
        rootElement.addElement((TSUIElement)statusCondition);
        nodeUI.setRootElement((TSUIElement)rootElement);
        nodeUI.getStyle().setProperty((TSUIElement)warningElement, "IMAGE", (Serializable)LoadTSESVGImage.getAnnotsDecorationImage());
        nodeBuilder.setNodeUI((TSNodeUI)nodeUI);
    }

    public void setJobInfo(EZSourceJobIDSg jobIdSg, TextSelectionInFile sel) {
        this.inputJobSg = jobIdSg;
        this.sel = sel;
    }

    public void setIfs(String[][] ifs) {
        this.ifs = ifs;
    }

    public void setSteps(String[][] steps) {
        this.steps = steps;
    }

    /*
     * Unable to fully structure code
     */
    private TSENode closeIfsPreviousToCurrent(Integer stepID, Stack<Object[]> ifStack, TSEdgeBuilder edgeBuilder, TSEGraphManager gmanager) {
        block12: {
            block11: {
                forceClose = false;
                cId = -1;
                workStack = new LinkedList<Object[]>();
                if (stepID == null) {
                    forceClose = true;
                } else {
                    cId = stepID;
                }
                found = false;
                parent = null;
                if (!forceClose) ** GOTO lbl24
                found = true;
                while (ifStack.size() > 0) {
                    workStack.addFirst(ifStack.pop());
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    ifInfo = ifStack.peek();
                    ifDetails = (String[])ifInfo[0];
                    follow = Integer.valueOf(ifDetails[6]);
                    if (follow > 0 && cId == follow) {
                        found = true;
                    } else if (found) break;
                    workStack.addFirst(ifStack.pop());
lbl24:
                    // 2 sources

                    ** while (!ifStack.isEmpty())
                }
            }
            if (!found) ** GOTO lbl48
            end = null;
            while (workStack.size() > 0) {
                ifInfo = (Object[])workStack.removeLast();
                branch = (Boolean)ifInfo[5];
                if (end != null) {
                    if (branch) {
                        ifInfo[3] = end;
                    } else {
                        ifInfo[4] = end;
                    }
                    end = null;
                }
                edgeBuilder.addEdge(gmanager, (TSENode)ifInfo[3], (TSENode)ifInfo[2]);
                edgeBuilder.addEdge(gmanager, (TSENode)ifInfo[4], (TSENode)ifInfo[2]);
                this.edgeTypesSetForLegend.add(JobFlowgraphEdgeLegendInfo.FLOW_PATH);
                parent = end = (TSENode)ifInfo[2];
            }
            break block12;
lbl-1000:
            // 1 sources

            {
                ifStack.push((Object[])workStack.removeFirst());
lbl48:
                // 2 sources

                ** while (workStack.size() > 0)
            }
        }
        return parent;
    }

    private String[] getIf(String[][] ifs, String id) {
        String[] foundDet = null;
        String[][] stringArray = ifs;
        int n = ifs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] row = stringArray[n2];
            if (row[2].equals(id)) {
                foundDet = row;
            }
            ++n2;
        }
        return foundDet;
    }

    protected void doHierarchicalLayout(int levelDirection) {
        TSLayoutProxy layoutProxy = new TSLayoutProxy();
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)this.graphManager);
        TSHierarchicalLayoutInputTailor hierarchicalLayoutInputTailor = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData);
        hierarchicalLayoutInputTailor.setGraph(this.graphManager.getMainDisplayGraph());
        hierarchicalLayoutInputTailor.setLevelDirection(levelDirection);
        hierarchicalLayoutInputTailor.setLevelAlignment(1);
        hierarchicalLayoutInputTailor.setOrthogonalRouting(false);
        hierarchicalLayoutInputTailor.setKeepNodeSizes(true);
        hierarchicalLayoutInputTailor.setAsCurrentLayoutStyle();
        hierarchicalLayoutInputTailor.setConstantHorizontalSpacingBetweenNodes(20.0);
        hierarchicalLayoutInputTailor.setConstantVerticalSpacingBetweenNodes(20.0);
        hierarchicalLayoutInputTailor.setHorizontalSpacingBetweenEdges(20.0);
        hierarchicalLayoutInputTailor.setVerticalSpacingBetweenEdges(20.0);
        this.applyConstraints(inputData, this.graphManager);
        TSServiceOutputData outputData = new TSServiceOutputData();
        layoutProxy.run((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
        TSApplyLayoutResults applyResults = new TSApplyLayoutResults();
        applyResults.apply((TSServiceInputDataInterface)inputData, (TSServiceOutputDataInterface)outputData);
    }

    protected void applyConstraints(TSEAllOptionsServiceInputData inputData, TSEGraphManager gManager) {
        TSLayoutInputTailor tailor = new TSLayoutInputTailor((TSServiceInputDataInterface)inputData);
        tailor.setGraphManager((TSDGraphManager)gManager);
        tailor.setAsCurrentOperation();
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    private void setPropertiesViewer(TSENode node, String nodeName, String nodeType) {
        node.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(nodeName, nodeType));
    }

    public void writeGraphToFile(TSEGraph graph, List<EZSegment> fileName, String pathSelected) {
        block16: {
            EZSourceProgramIDSg programName;
            String prgName = "";
            if (fileName.get(1) instanceof EZSourceProgramIDSg) {
                programName = (EZSourceProgramIDSg)fileName.get(1);
                prgName = programName.getProgramName();
            } else if (fileName.get(1) instanceof EZSourceJobIDSg) {
                programName = (EZSourceJobIDSg)fileName.get(1);
                prgName = programName.getJobExpandedName();
            } else if (fileName.get(1) instanceof EZSourceTransactionIDSg) {
                programName = (EZSourceTransactionIDSg)fileName.get(1);
                prgName = programName.getTransactionName();
            } else if (fileName.get(1) instanceof EZSourceScreenIDSg) {
                programName = (EZSourceScreenIDSg)fileName.get(1);
                prgName = programName.getScreenNameToPrint();
            }
            String pathToWrite = String.valueOf(pathSelected) + "/" + prgName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals("")) break block16;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + prgName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = "";
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = "";
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                value.append("Statement Type: ");
                value.append(stmtType);
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

