/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.jobflow;

import com.ez.cobol.callgraph.CallGraphBuilder;
import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.jobflow.JobFlowGraphModel;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphEdgeLegendInfo;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFlowGraphJob
extends AnnotatedGraphJob
implements IMFRunnable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(JobFlowGraphJob.class);
    private static final String EZREP_PROCEDURE_5 = "EZReports_JobFlowReport_q5";
    private static final String EZREP_PROCEDURE_6 = "EZReports_JobFlowReport_q6_steps";
    private MainframeMouseActionsHook mouseActionsHook = null;

    public JobFlowGraphJob(EZEntityID ezId) {
        super(ezId);
        this.mouseActionsHook = new MainframeMouseActionsHook(ezId);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new JobFlowGraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
            this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((com.ez.workspace.analysis.graph.model.GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor monitor) {
        super.computeResults(model, monitor);
        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        ((JobFlowGraphModel)this.graphModel).setEzsourcePrj(ezsourcePrj);
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(JobFlowGraphJob.class, "collectingData.taskName"));
        IStatus status = Utils.collectDataFromBridge((IProgressMonitor)pmonitor.newChild(100), (String)ezsourcePrj.getName(), (IMFRunnable)this);
        if (!status.isOK()) {
            monitor.setCanceled(true);
        } else {
            pmonitor.setWorkRemaining(0);
        }
    }

    private void obtainInputs(EZEntityID input, String project) {
        EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)input.getSegment(EZSourceJobIDSg.class);
        String inputType = String.valueOf(jobIdSg.getTypeId());
        String[][] ifs = null;
        String[][] steps = null;
        if (CallGraphBuilder.JOB_TYPE_STRING.equals(inputType)) {
            HashSet<Integer> jobIDsAsParam = new HashSet<Integer>();
            jobIDsAsParam.add(jobIdSg.getJobId());
            String[][] jobPaths = Utils.runProc((String)"EZReports_JobCallgraph_JobPath", jobIDsAsParam, (EZSourceDataType)EZSourceDataType.Integer, (String)project);
            TextSelectionInFile sel = null;
            if (jobPaths != null) {
                String[] jobPath = jobPaths[0];
                sel = new TextSelectionInFile(jobPath[7], CallGraphBuilder.JOB_TYPE_STRING, new String[]{jobPath[3], jobPath[4], jobPath[5], jobPath[6]});
            }
            ((JobFlowGraphModel)this.graphModel).setJobInfo(jobIdSg, sel);
            if (sel != null) {
                ifs = Utils.runProc((String)EZREP_PROCEDURE_5, jobIDsAsParam, (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                ((JobFlowGraphModel)this.graphModel).setIfs(ifs);
                steps = Utils.runProc((String)EZREP_PROCEDURE_6, jobIDsAsParam, (EZSourceDataType)EZSourceDataType.Integer, (String)project);
                ((JobFlowGraphModel)this.graphModel).setSteps(steps);
            }
        }
    }

    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(JobFlowGraphJob.class, "compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        Object path = this.analysis.getContextValue("selected path");
        ProjectInfo ezsourcePrj = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        String project = ezsourcePrj.getName();
        if (path != null && !path.toString().trim().equals("")) {
            TSEGraph mainGraph = this.graphModel.getGraph();
            for (EZEntityID input : inputs) {
                this.obtainInputs(input, project);
                this.graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = this.graphModel.getGraph();
                ((JobFlowGraphModel)this.graphModel).writeGraphToFile(newGraph, input.getSegments(), path.toString());
                ((JobFlowGraphModel)this.graphModel).clear();
                newGraph.dispose();
            }
            this.graphModel.setGraph(mainGraph);
        } else {
            EZEntityID input = (EZEntityID)inputs.get(0);
            this.obtainInputs(input, project);
        }
        monitor.done();
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(JobFlowGraphJob.class, "dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations(monitor, result);
        L.debug("done doing layout");
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addEntriesToLegend(LegendPanel legend) {
        Utils.setImageProvider((LegendPanel)legend);
        this.addNodesToLegend(legend);
        this.addEdgesToLegend(legend);
    }

    private void addNodesToLegend(LegendPanel legend) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            legend.placeLegendEntry(nodeLegendInfo.getColorboxImagePath(), nodeLegendInfo.getLegendLabel());
        }
    }

    private void addEdgesToLegend(LegendPanel legend) {
        Set edgeTypesSetForLegend = this.graphModel.getEdgeTypesForLegend();
        ArrayList edgeTypesList = new ArrayList(edgeTypesSetForLegend);
        Collections.sort(edgeTypesList, new Comparator<IGraphEdgeLegendInfo>(){

            @Override
            public int compare(IGraphEdgeLegendInfo edgeType1, IGraphEdgeLegendInfo edgeType2) {
                return edgeType1.getLegendLabel().compareTo(edgeType2.getLegendLabel());
            }
        });
        for (IGraphEdgeLegendInfo edgeLegendInfo : edgeTypesList) {
            legend.placeLegendEntry(edgeLegendInfo.getLegendImagePath(), edgeLegendInfo.getLegendLabel());
        }
    }

    public void closing() {
        EZMouseTool mouseTool;
        this.mouseActionsHook = null;
        if (this.canvas != null && this.canvas.getToolManager() != null && (mouseTool = (EZMouseTool)this.canvas.getToolManager().getTool("mouse")) != null) {
            this.canvas.getToolManager().unregister("mouse");
            mouseTool.clean();
        }
        super.closing();
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public GraphInfo(EZEntityID id) {
            super(id);
            SharedImages.registerImage("jobFlow", "icons/jobflow.png");
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage("jobFlow");
            }
            return this.image;
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            List inputs = JobFlowGraphJob.this.analysis.getContextListValue("input_list");
            if (inputs != null) {
                for (EZEntityID entity : inputs) {
                    EZSourceJobIDSg jobSg = (EZSourceJobIDSg)entity.getSegment(EZSourceJobIDSg.class);
                    buf.append(jobSg.getJobName());
                    if (inputs.indexOf(entity) == inputs.size() - 1) continue;
                    buf.append(", ");
                }
            }
            return Messages.getString(JobFlowGraphJob.class, "analysis.tabName", new Object[]{buf.toString(), JobFlowGraphJob.this.analysis.getContextValue("input_project_names")});
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    JobFlowGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    JobFlowGraphJob.this.addEntriesToLegend(JobFlowGraphJob.this.legend);
                    sc.setContent((Control)JobFlowGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    JobFlowGraphJob.this.legend.pack();
                    sc.setMinSize(JobFlowGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((JobFlowGraphJob)((GraphInfo)GraphInfo.this).JobFlowGraphJob.this).legend.getSize().x;
                    int x = ((JobFlowGraphJob)((GraphInfo)GraphInfo.this).JobFlowGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }
    }
}

