/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.utils;

import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.tsv.EZConnector;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.geometry.shared.TSConstPoint;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.interactive.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import com.tomsawyer.service.layout.TSLayoutInputTailor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GraphUtils.class);
    public static final String GO_TO_IDENTIFIER = "GO TO";
    public static final int IF_THEN_BEGIN = 4;
    public static final int IF_THEN_END = 5;
    public static final int IF_ELSE_BEGIN = 6;
    public static final int IF_ELSE_END = 7;
    public static final int EMPTY_THEN = 8;
    public static final int EMPTY_ELSE = 9;
    public static final int FLOW_CONTROL = 10;
    public static final int WHILE = 11;
    public static final int GO_TO = 12;

    public static void applyAlignmentConstraint(AnalysisGraphManager graphManager, List l1, int orientation) {
        TSLayoutInputTailor layoutInputTailor = graphManager.inputTailor;
        int priority = 0;
        int alignment = 0;
        layoutInputTailor.setGraphManager((TSDGraphManager)graphManager);
        layoutInputTailor.addAlignmentConstraint(l1, orientation, alignment, priority);
    }

    public static void applySeparationConstraint(AnalysisGraphManager graphManager, List l1, List l2, int directionTopToBottom) {
        int spacing = 55;
        TSLayoutInputTailor layoutInputTailor = graphManager.inputTailor;
        int priority = 0;
        layoutInputTailor.setGraphManager((TSDGraphManager)graphManager);
        layoutInputTailor.addSeparationConstraint(l1, l2, directionTopToBottom, (double)spacing, priority);
    }

    public static void applyConstraints(AnalysisGraphManager graphManager, TSENode ifNode, ArrayList<TSENode> tResult, ArrayList<TSENode> eResult, TSENode endNode) {
        ArrayList<TSENode> l1 = new ArrayList<TSENode>();
        ArrayList<TSENode> l2 = new ArrayList<TSENode>();
        ArrayList<TSENode> l3 = new ArrayList<TSENode>();
        l1.add(ifNode);
        l3.add(endNode);
        if (tResult != null || eResult != null) {
            if (tResult != null) {
                l2.addAll(tResult);
            }
            if (eResult != null) {
                l2.addAll(eResult);
            }
            GraphUtils.applySeparationConstraint(graphManager, l1, l2, 3);
            GraphUtils.applySeparationConstraint(graphManager, l2, l3, 3);
        } else {
            GraphUtils.applySeparationConstraint(graphManager, l1, l3, 3);
        }
        l1.add(endNode);
        GraphUtils.applyAlignmentConstraint(graphManager, l1, 0);
        if (tResult != null && eResult != null) {
            l2.clear();
            l2.add(tResult.get(0));
            l2.add(eResult.get(0));
            GraphUtils.applyAlignmentConstraint(graphManager, l2, 1);
        }
        if (tResult != null) {
            l2.clear();
            l2.addAll(tResult);
            GraphUtils.applySeparationConstraint(graphManager, l2, l1, 0);
        }
        if (eResult != null) {
            l2.clear();
            l2.addAll(eResult);
            GraphUtils.applySeparationConstraint(graphManager, l1, l2, 0);
        }
    }

    public static void setType(TSEEdge edge, int type) {
        switch (type) {
            case 10: {
                edge.setAttribute("Color", (Object)TSEColor.darkRed);
                break;
            }
            case 12: {
                edge.setAttribute("Edge_Style", (Object)3);
                edge.setAttribute("Color", (Object)TSEColor.black);
                break;
            }
            default: {
                edge.setAttribute("Color", (Object)TSEColor.black);
            }
        }
        GraphUtils.setConnectors(edge, type);
    }

    private static void setConnectors(TSEEdge edge, int type) {
        int sConType = 4;
        int tConType = 3;
        switch (type) {
            case 8: {
                sConType = 106;
                tConType = 106;
                break;
            }
            case 9: {
                sConType = 107;
                tConType = 107;
                break;
            }
            case 4: {
                sConType = 106;
                tConType = 3;
                break;
            }
            case 5: {
                sConType = 4;
                tConType = 106;
                break;
            }
            case 6: {
                sConType = 107;
                tConType = 3;
                break;
            }
            case 7: {
                sConType = 4;
                tConType = 107;
                break;
            }
            case 10: {
                sConType = 1;
                tConType = 1;
                break;
            }
            case 11: {
                sConType = 2;
                tConType = 2;
                break;
            }
            case 12: {
                sConType = 1;
                tConType = 1;
                break;
            }
            default: {
                sConType = 4;
                tConType = 1;
            }
        }
        EZConnector sourceConnector = new EZConnector();
        sourceConnector.setType(sConType);
        TSENode sNode = (TSENode)edge.getSourceNode();
        sNode.insert((TSConnector)sourceConnector);
        EZConnector targetConnector = new EZConnector();
        targetConnector.setType(tConType);
        TSENode tNode = (TSENode)edge.getTargetNode();
        tNode.insert((TSConnector)targetConnector);
        edge.setSourceConnector((TSConnector)sourceConnector);
        edge.setTargetConnector((TSConnector)targetConnector);
    }

    public static void setOrthogonalPath(TSEEdge edge) {
        GraphUtils.setOrthogonalPath(edge, 0.0);
    }

    public static void setOrthogonalPath(TSEEdge edge, double limit) {
        TSConstPoint sp = edge.getSourcePoint();
        TSConstPoint tp = edge.getTargetPoint();
        EZConnector sc = (EZConnector)edge.getSourceConnector();
        EZConnector tc = (EZConnector)edge.getTargetConnector();
        ((TSENode)edge.getTargetNode()).getCenterY();
        if (sp.getX() != tp.getX() && sp.getY() != tp.getY()) {
            ArrayList<TSConstPoint> list;
            if (sc.getEdgeSide() == 2 && tc.getEdgeSide() == 2) {
                list = new ArrayList<TSConstPoint>();
                list.add(new TSConstPoint(sp.getX(), sp.getY()));
                list.add(new TSConstPoint(limit, sp.getY()));
                list.add(new TSConstPoint(limit, tp.getY()));
                edge.reroute(list);
            } else if (tc.getEdgeSide() == 4 || tc.getEdgeSide() == 8) {
                list = new ArrayList();
                list.add(new TSConstPoint(tp.getX(), sp.getY()));
                edge.reroute(list);
            } else if (tc.getEdgeSide() == 1 || tc.getEdgeSide() == 2) {
                list = new ArrayList();
                list.add(new TSConstPoint(sp.getX(), tp.getY()));
                edge.reroute(list, true);
            }
            if (sc.getEdgeSide() == 1 && tc.getEdgeSide() == 1) {
                list = new ArrayList();
                list.add(new TSConstPoint(sp.getX() - limit, sp.getY()));
                list.add(new TSConstPoint(sp.getX() - limit, tp.getY()));
                edge.reroute(list);
            }
        }
    }

    private static void setAttachementOption(TSEEdge edge, int sourceSide, int targetSide) {
        TSEGraph eGraph = (TSEGraph)edge.getOwnerGraph();
        TSGraphManager gManager = eGraph.getOwnerGraphManager();
        TSEAllOptionsServiceInputData inputData = new TSEAllOptionsServiceInputData((TSDGraphManager)gManager);
        TSHierarchicalLayoutInputTailor hit = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData);
        hit.setGraph((TSDGraph)eGraph);
        hit.setAsCurrentLayoutStyle();
        hit.setSourceAttachmentSide((TSDEdge)edge, sourceSide);
        hit.setTargetAttachmentSide((TSDEdge)edge, targetSide);
    }

    public static Optional<TSENode> findByText(ArrayList<TSENode> nodes, String text) {
        return nodes.stream().filter(node -> text.equalsIgnoreCase(node.getText().trim())).findAny();
    }

    public static List<TSENode> findAllByText(ArrayList<TSENode> nodes, String text) {
        return nodes.stream().filter(node -> text.equalsIgnoreCase(node.getText().trim())).collect(Collectors.toList());
    }

    public static Optional<TSENode> findGoToNode(ArrayList<TSENode> nodes) {
        return nodes.stream().filter(node -> node.getText().trim().startsWith(GO_TO_IDENTIFIER)).findAny();
    }

    public static Optional<FlowElement> findGoToElement(List<FlowElement> cases) {
        return cases.stream().filter(elem -> elem.getSourceInfo().getText().trim().startsWith(GO_TO_IDENTIFIER)).findAny();
    }

    public static List<TSENode> getVisibleNodes(List<TSENode> nodes) {
        return nodes.stream().filter(TSGraphObject::isVisible).collect(Collectors.toList());
    }

    public static List<TSENode> getEmptyNodes(ArrayList<TSENode> nodes) {
        return nodes.stream().filter(node -> node.getText().isEmpty()).collect(Collectors.toList());
    }

    public static double getMinimHorizontalValue(List<TSENode> nodes) {
        return nodes.stream().map(pos -> pos.getCenterX()).min(Comparator.naturalOrder()).get();
    }
}

