/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.ui;

import com.ez.graphs.flowchart.ui.EZDefaultNodeUI;
import com.ez.graphs.flowchart.ui.EZPolygonNodeUI;
import com.ez.graphs.flowchart.ui.EZRectNodeUI;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.ui.TSObjectUI;
import com.tomsawyer.graphicaldrawing.ui.simple.TSENodeUI;
import com.tomsawyer.graphicaldrawing.ui.simple.TSEShapeNodeUI;
import java.util.HashMap;
import java.util.Map;

public class UINodeProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String PARAGRAPH_NODE = "Paragraph";
    public static final String SECTION_NODE = "Section";
    public static final String DEFAULT_NODE = "default";
    public static final String IF_STATEMENT_NODE = "IF_Statemnt";
    public static final String FLOW_CONTROL_STATEMENT_NODE = "Flow_Control_Statemnt";
    public static final String SPECIAL_NODE = "SPECIAL_NODE";
    public static final String CASE_STATEMENT_NODE = "Case Staement";
    public static final String SWITCH_NODE = "Switch statement";
    private Map uiNodes = new HashMap();
    private boolean tsNodeResizability;

    public TSENodeUI getUINode(String type) {
        EZDefaultNodeUI ui = new EZRectNodeUI();
        ((EZDefaultNodeUI)ui).setNodeFullText(this.tsNodeResizability);
        if (type.equals(SECTION_NODE) || type.equals(PARAGRAPH_NODE)) {
            ui.setFillColor(new TSEColor(183, 255, 183));
        }
        if (type.equals(DEFAULT_NODE)) {
            ui.setFillColor(TSEColor.paleGray);
        }
        if (type.equals(FLOW_CONTROL_STATEMENT_NODE)) {
            ui.setFillColor(new TSEColor(196, 185, 255));
        }
        if (type.equals(IF_STATEMENT_NODE)) {
            ui = new EZPolygonNodeUI();
            ui.setFillColor(new TSEColor(254, 211, 203));
            ((EZDefaultNodeUI)ui).setNodeFullText(this.tsNodeResizability);
        }
        if (type.equals(CASE_STATEMENT_NODE)) {
            ui = new EZPolygonNodeUI();
            ui.setFillColor(TSEColor.paleGray);
            ((EZDefaultNodeUI)ui).setNodeFullText(this.tsNodeResizability);
        }
        if (type.equals(SPECIAL_NODE)) {
            ui = new TSEShapeNodeUI();
            ui.setFillColor(TSEColor.white);
        }
        return ui;
    }

    public void setUINode(TSENode node, String type) {
        TSENodeUI nodeUI = this.getUINode(type);
        node.setUI((TSObjectUI)nodeUI);
        nodeUI.setJustification(2);
        if (!type.equals(IF_STATEMENT_NODE) && !type.equals(SPECIAL_NODE)) {
            node.setSize(150.0, 40.0);
        }
        if (this.needsDiamondShape(type)) {
            TSPolygonShape diamondShape = this.createDiamondShape();
            node.setShape((TSShape)diamondShape);
            node.setSize(100.0, 50.0);
        }
    }

    private TSPolygonShape createDiamondShape() {
        TSPolygonShape shape = TSPolygonShape.getInstance((String)"diamond");
        return shape;
    }

    public boolean needsDiamondShape(String type) {
        boolean needsDiamondShape = false;
        if (IF_STATEMENT_NODE.equals(type) || type.equals(CASE_STATEMENT_NODE)) {
            needsDiamondShape = true;
        }
        return needsDiamondShape;
    }

    public void setNodeFullText(boolean tsNodeResizability) {
        this.tsNodeResizability = tsNodeResizability;
    }
}

