/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.ui;

import com.ez.graphs.flowchart.ui.EZDefaultNodeUI;
import com.tomsawyer.drawing.geometry.shared.TSConstPoint;
import com.tomsawyer.drawing.geometry.shared.TSDeviceRectangle;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.drawing.geometry.shared.TSTransform;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSEGraphics;
import com.tomsawyer.graphicaldrawing.ui.simple.TSEObjectUI;
import com.tomsawyer.util.shared.TSProperty;

public class EZPolygonNodeUI
extends EZDefaultNodeUI {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String SHAPE = "polygon";
    public static final String SHAPE_TYPE = "polygonType";
    int[] xCoords;
    int[] yCoords;
    double scaleX;
    double scaleY;
    double shiftX;
    double shiftY;
    String shapeType;
    private static TSShape dummyShape = new TSPolygonShape();

    @Override
    public void draw(TSEGraphics graphics) {
        this.validateShape(this.getOwnerNode().getShape(), graphics.getTSTransform());
        if (!this.isTransparent()) {
            graphics.setColor(this.getFillColor());
            graphics.fillPolygon(this.xCoords, this.yCoords, this.xCoords.length);
        }
        if (this.isBorderDrawn()) {
            graphics.setColor(this.getBorderColor());
            graphics.drawPolygon(this.xCoords, this.yCoords, this.xCoords.length);
            graphics.setColor(TSEColor.black);
        }
        this.paintText(graphics);
    }

    public void drawOutline(TSEGraphics tsegraphics) {
        this.validateShape(this.getOwnerNode().getShape(), tsegraphics.getTSTransform());
        tsegraphics.drawPolygon(this.xCoords, this.yCoords, this.xCoords.length);
    }

    public void copy(TSEObjectUI tseobjectui) {
        super.copy(tseobjectui);
        this.scaleX = Double.NaN;
        this.scaleY = Double.NaN;
        this.shiftX = Double.NaN;
        this.shiftY = Double.NaN;
        this.xCoords = null;
        this.yCoords = null;
    }

    private void validateShape(TSShape tsshape, TSTransform tstransform) {
        if (tsshape instanceof TSPolygonShape) {
            TSPolygonShape tspolygonshape = (TSPolygonShape)tsshape;
            if (this.xCoords == null || this.xCoords.length != tspolygonshape.points().size()) {
                this.xCoords = new int[tspolygonshape.points().size()];
            }
            if (this.yCoords == null || this.yCoords.length != tspolygonshape.points().size()) {
                this.yCoords = new int[tspolygonshape.points().size()];
            }
            TSDeviceRectangle rectangle = tstransform.boundsToDevice(this.getOwnerNode().getLocalBounds());
            int i = (int)rectangle.getWidth();
            int j = (int)rectangle.getHeight();
            int k = (int)rectangle.getX();
            int l = (int)rectangle.getY() + j;
            double d = (double)i / 100.0;
            double d1 = (double)j / 100.0;
            if (d != this.scaleX || d1 != this.scaleY || (double)k != this.shiftX || (double)l != this.shiftY) {
                int i1 = 0;
                for (TSConstPoint tsconstpoint : tspolygonshape.points()) {
                    this.xCoords[i1] = (int)Math.round(d * tsconstpoint.getX() + (double)k);
                    this.yCoords[i1] = (int)Math.round((double)l - d1 * tsconstpoint.getY());
                    ++i1;
                }
                this.scaleX = d;
                this.scaleY = d1;
                this.shiftX = k;
                this.shiftY = l;
            }
        } else {
            this.validateShape(dummyShape, tstransform);
        }
    }

    public String getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(String s) {
        this.shapeType = s;
    }

    public void setProperty(TSProperty tsproperty) {
        if ((SHAPE.equals(tsproperty.getName()) || "polygonShape".equals(tsproperty.getName())) && tsproperty.getValue() != null && this.getOwnerNode() != null) {
            this.getOwnerNode().setShape((TSShape)TSPolygonShape.fromString((String)tsproperty.getValue().toString()));
        } else if (SHAPE_TYPE.equals(tsproperty.getName())) {
            this.setShapeType(tsproperty.getValue().toString());
        } else {
            super.setProperty(tsproperty);
        }
    }

    public TSEColor getDefaultFillColor() {
        return TSEColor.darkCyan;
    }
}

