/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.ui;

import com.tomsawyer.drawing.geometry.shared.TSConstRect;
import com.tomsawyer.drawing.geometry.shared.TSTransform;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSEGraphics;
import com.tomsawyer.graphicaldrawing.ui.simple.TSEShapeNodeUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public class EZDefaultNodeUI
extends TSEShapeNodeUI {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private double xtextcenter = 50.0;
    private double ytextcenter = 50.0;
    private double xtextwidth = 95.0;
    private TSEColor ezTextColor;
    private boolean tsNodeResizability;

    public void draw(TSEGraphics graphics) {
        this.paintText(graphics);
    }

    public void paintText(TSEGraphics graphics) {
        Object resizability = this.getOwnerNode().getAttributeValue("resizability");
        if (resizability != null && ((Boolean)resizability).booleanValue()) {
            this.drawText(graphics);
        } else {
            FontMetrics fontmetrics = graphics.getFontMetrics();
            TSTransform tstransform = graphics.getTSTransform();
            TSConstRect bounds = this.getOwner().getLocalBounds();
            Font font = this.getFont().getScaledFont(tstransform.getScaleX(), "1234567890", tstransform.widthToDevice(bounds.getWidth()));
            graphics.setFont(font);
            tstransform = graphics.getTSTransform();
            fontmetrics = graphics.getFontMetrics();
            if (this.getOwnerNode() != null) {
                String text = this.getOwner().getText();
                double xslope = bounds.getWidth() / 100.0;
                double yslope = bounds.getHeight() / 100.0;
                double left = bounds.getLeft();
                double bottom = bounds.getBottom();
                if (text == null) {
                    text = "text";
                }
                int i = fontmetrics.stringWidth(text);
                if (!this.tsNodeResizability && i > tstransform.widthToDevice(xslope * this.xtextwidth)) {
                    StringBuilder sb = new StringBuilder(text);
                    sb.append("...");
                    int idx = sb.length() - 1;
                    while (idx > 4) {
                        sb.deleteCharAt(idx - 3);
                        if (fontmetrics.stringWidth(sb.toString()) < tstransform.widthToDevice(xslope * this.xtextwidth)) break;
                        --idx;
                    }
                    text = sb.toString();
                }
                i = fontmetrics.stringWidth(text);
                double d = left + this.xtextcenter * xslope;
                double d1 = bottom + this.ytextcenter * yslope;
                int j1 = this.getJustification();
                int j = fontmetrics.getAscent() - fontmetrics.getLeading() - fontmetrics.getDescent();
                int l = tstransform.xToDevice(d) - i / 2;
                int i1 = tstransform.yToDevice(d1) - j / 2;
                int l1 = i1 + j;
                if (j1 == 0) {
                    l = tstransform.xToDevice(d) + i / 2 - i;
                } else if (j1 == 1) {
                    l = tstransform.xToDevice(d) - i / 2;
                }
                Color defaultColor = graphics.getColor();
                if (this.ezTextColor != null) {
                    graphics.setColor(this.ezTextColor);
                }
                graphics.drawString(text, l, l1);
                graphics.setColor(defaultColor);
            }
        }
    }

    public boolean hasChildGraphMark() {
        return false;
    }

    public void setEZTextColor(TSEColor textColor) {
        this.ezTextColor = textColor;
    }

    protected void setNodeFullText(boolean tsNodeResizability) {
        this.tsNodeResizability = tsNodeResizability;
    }
}

