/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WhileHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(WhileHandler.class);

    WhileHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        ArrayList<TSENode> tResult = new ArrayList<TSENode>();
        if (stmts != null && stmts.size() > 0) {
            TSENode oldnode = null;
            TSEGraph graph = DrawElements.flowModel.getGraph();
            for (FlowElement elem : stmts) {
                ArrayList<TSENode> res = DrawElements.doDraw(elem);
                tResult.addAll(res);
                TSENode first = res.get(0);
                if (oldnode != null) {
                    L.debug("draw edge: " + oldnode.getName() + " to " + "first");
                    graph.addEdge((TSNode)oldnode, (TSNode)first);
                }
                oldnode = first;
            }
        }
        TSEGraph graph = DrawElements.flowModel.getGraph();
        L.debug("draw start while");
        TSENode startNode = DrawElements.flowModel.createPointNode();
        ret.add(startNode);
        L.debug("draw while node");
        TSENode whileNode = DrawElements.flowModel.createNode(element);
        if (!tResult.isEmpty()) {
            L.debug("draw edge to first while node");
            TSENode elseNode = (TSENode)tResult.get(0);
            TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)whileNode, (TSNode)elseNode);
            GraphUtils.setType(edge, 6);
            L.debug("draw edge to from last while to begin point");
            TSENode lastNode = (TSENode)tResult.get(tResult.size() - 1);
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)startNode);
            GraphUtils.setType(edge, 11);
        }
        L.debug("draw end while");
        TSENode endNode = DrawElements.flowModel.createPointNode();
        ret.add(endNode);
        graph.addEdge((TSNode)startNode, (TSNode)whileNode);
        graph.addEdge((TSNode)whileNode, (TSNode)endNode);
        return ret;
    }

    public static void applyConstraintsForWhile(AnalysisGraphManager graphManager, TSENode whileNode, ArrayList<TSENode> eResult, TSENode startNode, TSENode endNode) {
        ArrayList<TSENode> l1 = new ArrayList<TSENode>();
        ArrayList<TSENode> l2 = new ArrayList<TSENode>();
        ArrayList<TSENode> l3 = new ArrayList<TSENode>();
        ArrayList<TSENode> l4 = new ArrayList<TSENode>();
        l1.add(whileNode);
        l3.add(endNode);
        l4.add(startNode);
        if (eResult != null) {
            if (eResult != null) {
                l2.addAll(eResult);
            }
            GraphUtils.applySeparationConstraint(graphManager, l4, l1, 3);
            GraphUtils.applySeparationConstraint(graphManager, l1, l2, 3);
            GraphUtils.applySeparationConstraint(graphManager, l2, l3, 3);
        } else {
            GraphUtils.applySeparationConstraint(graphManager, l4, l1, 3);
            GraphUtils.applySeparationConstraint(graphManager, l1, l3, 3);
        }
        l1.add(endNode);
        l1.add(startNode);
        GraphUtils.applyAlignmentConstraint(graphManager, l1, 0);
        if (eResult != null) {
            l2.clear();
            l2.addAll(eResult);
            GraphUtils.applySeparationConstraint(graphManager, l1, l2, 0);
        }
    }
}

