/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.ParsFile;
import com.ez.graphs.flowchart.model.SourceInfo;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.gui.rdz.HookUtils;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.gotosource.ReceiveContentCallback;
import com.ez.workspace.model.EZWorkspace;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagFiller {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TagFiller.class);
    static int commentCol = 72;
    private static int COBOL_STMT_OFFSET_COL = 7;
    private static int NATURAL_STMT_OFFSET_COL = 6;
    private static int PL1_STMT_OFFSET_COL = 2;
    private Integer filesCount = 0;
    private int exceptionStatus = 0;
    private String projectName;
    private int programTypeId;

    public TagFiller(String projectName) {
        this.projectName = projectName;
        this.programTypeId = 0;
    }

    public TagFiller(String projectName, int programType) {
        this.projectName = projectName;
        this.programTypeId = programType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fill(List<SourceInfo> list, Map<String, ParsFile> files) {
        List<SourceInfo> siL;
        HashMap<String, List<SourceInfo>> fileSIs = new HashMap<String, List<SourceInfo>>();
        for (SourceInfo si : list) {
            String fileID = si.getFileID();
            siL = null;
            if (fileSIs.containsKey(fileID)) {
                siL = (List)fileSIs.get(fileID);
            } else {
                siL = new ArrayList();
                fileSIs.put(fileID, siL);
            }
            siL.add(si);
        }
        this.filesCount = files.size();
        boolean[] wait = new boolean[]{this.filesCount == 0};
        for (String fileN : files.keySet()) {
            siL = (List)fileSIs.get(fileN);
            if (siL != null) {
                this.computeElementSourceText(siL, files.get(fileN), wait);
                continue;
            }
            this.filesCount = this.filesCount - 1;
        }
        wait[0] = this.filesCount == 0;
        Object object = wait;
        synchronized (wait) {
            while (true) {
                while (true) {
                    if (wait[0]) {
                        // ** MonitorExit[var5_4] (shouldn't be in output)
                        return;
                    }
                    try {
                        wait.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.exceptionStatus = 2;
                    }
                }
                break;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private String[] slurp(String file, final List<SourceInfo> siL, final boolean[] wait) {
        ArrayList lines;
        block19: {
            lines = new ArrayList();
            Collection viewSrcContributors = EZWorkspace.getInstance().getViewSourceContributors();
            boolean notOpen = true;
            if (viewSrcContributors != null) {
                for (final IGoToSourceService goToService : viewSrcContributors) {
                    HashMap<String, Properties> map = new HashMap<String, Properties>();
                    map.put(file, new Properties());
                    if (!goToService.isEnableGoToSource(map)) continue;
                    notOpen = false;
                    String queryforVersion = goToService.getQueryForVersion();
                    if (queryforVersion != null) {
                        Utils.getFilesVersion((String)this.projectName, (String)queryforVersion, map);
                    }
                    final ReceiveContentCallback rc = new ReceiveContentCallback(){

                        public void receiveContent(String pathStr, IFile file, StringBuilder sb) {
                            TagFiller.this.change(wait, false, -1);
                            TagFiller.this.processFileContent(siL, sb);
                        }

                        public void onErrorOrCancel() {
                            TagFiller.this.change(wait, true, 1);
                        }
                    };
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            goToService.openSource(rc, null);
                        }
                    });
                    break;
                }
            }
            if (notOpen) {
                if (HookUtils.isRdzAdditionsAvailable() && HookUtils.isValitRemotePath((String)file)) {
                    try {
                        StringBuilder sb = HookUtils.getContent((IProgressMonitor)new NullProgressMonitor(), (String)this.projectName, (String)file);
                        this.change(wait, false, -1);
                        this.processFileContent(siL, sb);
                    }
                    catch (IOException iOException) {
                        this.change(wait, true, 1);
                    }
                } else {
                    String msg;
                    Exception ex = null;
                    int status = 0;
                    try {
                        HttpResponseConsumer consumer = FileAuthUtils.getFileContent((String)file);
                        if (consumer != null) {
                            this.change(wait, false, -1);
                            this.processFileContent(siL, new StringBuilder(consumer.getContent()));
                        }
                    }
                    catch (SecurityException e) {
                        ex = e;
                        status = 5;
                        if (ex != null) {
                            this.change(wait, true, status);
                            msg = Messages.getString(TagFiller.class, "errorProcessingfile.errorMessage", new String[]{file});
                            LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                        }
                        break block19;
                    }
                    catch (FileNotFoundException e) {
                        ex = e;
                        status = 6;
                        if (ex == null) break block19;
                        this.change(wait, true, status);
                        msg = Messages.getString(TagFiller.class, "errorProcessingfile.errorMessage", new String[]{file});
                        LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                        break block19;
                    }
                    catch (Exception e) {
                        ex = e;
                        status = 7;
                        if (ex == null) break block19;
                        this.change(wait, true, status);
                        {
                            catch (Throwable throwable) {
                                if (ex != null) {
                                    this.change(wait, true, status);
                                    msg = Messages.getString(TagFiller.class, "errorProcessingfile.errorMessage", new String[]{file});
                                    LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                                }
                                throw throwable;
                            }
                        }
                        msg = Messages.getString(TagFiller.class, "errorProcessingfile.errorMessage", new String[]{file});
                        LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                        break block19;
                    }
                    if (ex == null) break block19;
                    this.change(wait, true, status);
                    msg = Messages.getString(TagFiller.class, "errorProcessingfile.errorMessage", new String[]{file});
                    LogUtil.displayErrorMessage((Throwable)ex, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
                }
            }
        }
        return lines.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void change(boolean[] wait, boolean hasException, int exceptStatus) {
        this.filesCount = this.filesCount - 1;
        if (hasException) {
            this.exceptionStatus = exceptStatus;
        }
        boolean[] blArray = wait;
        synchronized (wait) {
            if (this.filesCount == 0 || this.exceptionStatus != 0) {
                L.trace("mark wait[0]=true");
                wait[0] = true;
                wait.notifyAll();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void processFileContent(List<SourceInfo> siL, StringBuilder sb) {
        if (sb != null && siL != null) {
            String[] lines = sb.toString().split("\\n");
            if (lines.length > 0) {
                for (SourceInfo si : siL) {
                    String text = this.computeText(lines, si);
                    si.setText(text);
                }
            }
        } else {
            L.warn("content={}; siL={}", (Object)sb, siL);
        }
    }

    public int getExceptionStatus() {
        return this.exceptionStatus;
    }

    private void computeElementSourceText(List<SourceInfo> siL, ParsFile f, boolean[] wait) {
        String path = f.getPath();
        if (path == null) {
            L.debug("no path for {}", (Object)f.getName());
            return;
        }
        String[] lines = this.slurp(path, siL, wait);
        if (lines.length > 0) {
            for (SourceInfo si : siL) {
                String text = this.computeText(lines, si);
                si.setText(text);
            }
        }
    }

    private String computeText(String[] lines, SourceInfo si) {
        StringBuilder sb = new StringBuilder();
        if (si != null) {
            int startLine = si.getSline();
            int endLine = si.getEline();
            int startC = si.getScolumn();
            int endC = si.getEcolumn();
            String line = null;
            if (startLine <= lines.length && endLine <= lines.length && startLine <= endLine) {
                int l = startLine;
                while (l <= endLine) {
                    line = lines[l - 1];
                    if (startLine == endLine) {
                        startC = startC > 0 ? startC - 1 : startC;
                        int ll = line.length();
                        if (startC > endC) {
                            L.error("start Column value > end Column value for line {}", (Object)line);
                            return line.trim();
                        }
                        try {
                            line = line.substring(startC, endC < ll ? endC : ll);
                        }
                        catch (IndexOutOfBoundsException e) {
                            L.error(" exception when compute text from line {}, startC {}, endC {} : {} ", new Object[]{line, startC, endC, e});
                        }
                    } else {
                        if (commentCol < line.length()) {
                            line = line.substring(0, commentCol);
                        }
                        if (l == startLine) {
                            if (startC > 0) {
                                try {
                                    line = line.substring(startC - 1, line.length());
                                }
                                catch (StringIndexOutOfBoundsException ex) {
                                    L.debug("Exception parsing line: {}, {}", (Object)line, (Object)ex);
                                }
                            }
                        } else {
                            int stmtStartC = this.getStatementOffsetByPrgType(this.programTypeId);
                            if (l == endLine) {
                                int ll = line.length();
                                line = line.substring(0, endC < ll ? endC : ll);
                            }
                            try {
                                stmtStartC = stmtStartC > 0 ? stmtStartC - 1 : 0;
                                line = line.substring(stmtStartC, line.length());
                            }
                            catch (StringIndexOutOfBoundsException ex) {
                                L.debug("Exception parsing line: {}, {}", (Object)line, (Object)ex);
                            }
                        }
                    }
                    sb.append(line.trim());
                    if (endLine != startLine && l != endLine) {
                        sb.append(" ");
                        sb.append(System.getProperty("line.separator"));
                    }
                    ++l;
                }
            }
        }
        return sb.length() == 0 ? "text" : sb.toString();
    }

    public int getStatementOffsetByPrgType(int programTypeId) {
        int offsetCol = 1;
        if (programTypeId == 1) {
            offsetCol = COBOL_STMT_OFFSET_COL;
        } else if (programTypeId == 3) {
            offsetCol = NATURAL_STMT_OFFSET_COL;
        } else if (programTypeId == 2) {
            offsetCol = PL1_STMT_OFFSET_COL;
        }
        return offsetCol;
    }
}

