/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SectionHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(SectionHandler.class);

    SectionHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        L.debug("create section node");
        Properties pr = element.getProperties();
        String name = pr.getProperty("Name");
        element.getSourceInfo().setText(name);
        TSENode sectionNode = DrawElements.flowModel.createNode(element);
        AnalysisGraphManager graphManager = (AnalysisGraphManager)DrawElements.flowModel.getGraphManager();
        if (stmts != null) {
            ArrayList<Object> prevL = new ArrayList();
            TSENode last = null;
            TSENode first = null;
            TSEGraph graph = DrawElements.flowModel.getGraph();
            for (FlowElement fe : stmts) {
                ArrayList<TSENode> sResult = DrawElements.doDraw(fe);
                TSENode paragraphNode = sResult.get(0);
                if (first == null) {
                    first = paragraphNode;
                    ret.add(first);
                    graph.addEdge((TSNode)sectionNode, (TSNode)paragraphNode);
                    L.debug("draw edge to paragraph");
                }
                if (last != null) {
                    graph.addEdge(last, (TSNode)paragraphNode);
                    L.debug("draw edge to paragraph");
                } else if (!prevL.isEmpty()) {
                    ArrayList l1 = new ArrayList();
                    l1.add(prevL.get(prevL.size() - 1));
                    ArrayList<TSENode> l2 = new ArrayList<TSENode>();
                    l2.add(paragraphNode);
                    GraphUtils.applySeparationConstraint(graphManager, l1, l2, 3);
                }
                last = sResult.get(sResult.size() - 1);
                if (last.hasAttribute("exitstatement") || last.hasAttribute("IS_DEAD_CODE")) {
                    ret.add(last);
                    last = null;
                }
                prevL = sResult;
            }
            if (last != null) {
                ret.add(last);
            }
        }
        return ret;
    }
}

