/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepeatHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(RepeatHandler.class);

    RepeatHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        L.debug("draw repeat node");
        TSENode repeatNode = DrawElements.flowModel.createNode(element);
        ret.add(repeatNode);
        ArrayList<TSENode> tResult = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        TSEGraph graph = DrawElements.flowModel.getGraph();
        if (stmts != null && stmts.size() > 0) {
            TSENode oldnode = null;
            for (FlowElement elem : stmts) {
                ArrayList<TSENode> res = DrawElements.doDraw(elem);
                tResult.addAll(res);
                TSENode first = res.get(0);
                if (oldnode != null) {
                    L.debug("draw edge: " + oldnode.getName() + " to " + "first");
                    graph.addEdge((TSNode)oldnode, (TSNode)first);
                }
                oldnode = res.get(res.size() - 1);
            }
        }
        TSENode endNode = DrawElements.flowModel.createPointNode();
        if (!tResult.isEmpty()) {
            L.debug("draw edge to repeat node");
            TSENode firstNode = (TSENode)tResult.get(0);
            graph.addEdge((TSNode)repeatNode, (TSNode)firstNode);
            TSENode lastNode = tResult.size() == 1 ? firstNode : (TSENode)tResult.get(tResult.size() - 1);
            graph.addEdge((TSNode)lastNode, (TSNode)endNode);
            TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)endNode, (TSNode)repeatNode);
            GraphUtils.setType(edge, 11);
            L.debug("apply vertical constraints");
            ArrayList<TSENode> l1 = new ArrayList<TSENode>();
            ArrayList<TSENode> l2 = new ArrayList<TSENode>();
            ArrayList<TSENode> l3 = new ArrayList<TSENode>();
            l1.add(repeatNode);
            l2.add(firstNode);
            l3.add(endNode);
            AnalysisGraphManager graphManager = (AnalysisGraphManager)DrawElements.flowModel.getGraphManager();
            GraphUtils.applySeparationConstraint(graphManager, l1, l2, 3);
            GraphUtils.applySeparationConstraint(graphManager, l2, l3, 3);
        } else {
            graph.addEdge((TSNode)repeatNode, (TSNode)endNode);
        }
        ret.add(endNode);
        return ret;
    }
}

