/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProgramHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(ProgramHandler.class);

    ProgramHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        if (stmts != null) {
            ArrayList<Object> prevL = new ArrayList();
            TSENode firstNode = null;
            TSENode lastNode = null;
            for (FlowElement fe : stmts) {
                L.debug("handing section:");
                ArrayList<TSENode> sResult = DrawElements.doDraw(fe);
                TSENode sectionNode = sResult.get(0);
                if (firstNode == null) {
                    firstNode = sectionNode;
                    ret.add(firstNode);
                }
                if (!prevL.isEmpty()) {
                    ArrayList<Object> l1 = new ArrayList<Object>();
                    l1.add(prevL.get(prevL.size() - 1));
                    ArrayList<TSENode> l2 = new ArrayList<TSENode>();
                    l2.add(sectionNode);
                    AnalysisGraphManager graphManager = (AnalysisGraphManager)DrawElements.flowModel.getGraphManager();
                    GraphUtils.applySeparationConstraint(graphManager, l1, l2, 3);
                }
                prevL = sResult;
                lastNode = sResult.get(sResult.size() - 1);
            }
            if (lastNode != null) {
                ret.add(lastNode);
            }
        }
        return ret;
    }
}

