/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParagraphHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(ParagraphHandler.class);

    ParagraphHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        L.debug("draw paragraph");
        Properties pr = element.getProperties();
        String name = pr.getProperty("Name");
        element.getSourceInfo().setText(name);
        TSENode paragNode = DrawElements.flowModel.createNode(element);
        ret.add(paragNode);
        TSENode last = null;
        if (stmts != null) {
            last = paragNode;
            TSEGraph graph = DrawElements.flowModel.getGraph();
            for (FlowElement fe : stmts) {
                ArrayList<TSENode> sResult = DrawElements.doDraw(fe);
                if (sResult.size() == 0) continue;
                TSENode first = sResult.get(0);
                L.debug("draw edge: " + last + " to " + first);
                graph.addEdge((TSNode)last, (TSNode)first);
                last = sResult.get(sResult.size() - 1);
            }
        }
        if (last != null && last != paragNode) {
            ret.add(last);
        }
        return ret;
    }
}

