/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IfHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(IfHandler.class);

    IfHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        TSENode lastNode;
        TSEEdge edge;
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        List<FlowElement> stmts = element.getStatements();
        FlowElement tElem = null;
        FlowElement eElem = null;
        if (stmts.size() == 2) {
            tElem = stmts.get(0);
            eElem = stmts.get(1);
        } else if (stmts.size() == 1) {
            tElem = stmts.get(0);
        } else {
            L.debug("if statement without THEN/ELSE ?");
        }
        ArrayList<TSENode> tResult = null;
        if (tElem != null) {
            tResult = DrawElements.doDraw(tElem);
        }
        ArrayList<TSENode> eResult = null;
        if (eElem != null) {
            eResult = DrawElements.doDraw(eElem);
        }
        TSEGraph graph = DrawElements.flowModel.getGraph();
        L.debug("draw if node");
        TSENode ifNode = DrawElements.flowModel.createNode(element);
        ret.add(ifNode);
        L.debug("draw end if");
        TSENode endNode = DrawElements.flowModel.createPointNode();
        if (tResult != null && !tResult.isEmpty()) {
            L.debug("draw edge to first then");
            TSENode thenNode = tResult.get(0);
            edge = (TSEEdge)graph.addEdge((TSNode)ifNode, (TSNode)thenNode);
            GraphUtils.setType(edge, 4);
            L.debug("draw edge to from last then to end point");
            lastNode = tResult.get(tResult.size() - 1);
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)endNode);
            GraphUtils.setType(edge, 5);
        } else {
            graph.addEdge((TSNode)ifNode, (TSNode)endNode);
        }
        if (eResult != null && !eResult.isEmpty()) {
            L.debug("draw edge to first else");
            TSENode elseNode = eResult.get(0);
            edge = (TSEEdge)graph.addEdge((TSNode)ifNode, (TSNode)elseNode);
            GraphUtils.setType(edge, 6);
            L.debug("draw edge to from last else to end point");
            lastNode = eResult.get(eResult.size() - 1);
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)endNode);
            GraphUtils.setType(edge, 7);
        } else {
            graph.addEdge((TSNode)ifNode, (TSNode)endNode);
        }
        ret.add(endNode);
        return ret;
    }
}

