/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.ParsFile;
import com.ez.graphs.flowchart.model.SourceInfo;
import com.ez.graphs.internal.Messages;
import com.ez.mainframe.data.utils.CanceledException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FlowSAXHandler
extends DefaultHandler {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(FlowSAXHandler.class);
    private Set<String> ignoreElements = new HashSet<String>(){
        {
            this.add("FlowChart".toLowerCase());
            this.add("Files".toLowerCase());
            this.add("Statements".toLowerCase());
            this.add("Sections".toLowerCase());
            this.add("FlowChart".toLowerCase());
            this.add("Cases".toLowerCase());
        }
    };
    private Stack<FlowElement> stack = new Stack();
    private List<SourceInfo> sourceInfos = new ArrayList<SourceInfo>();
    private FlowElement model = new FlowElement("PROGRAM");
    private Map<String, ParsFile> filesMap;
    private IProgressMonitor monitor;

    public FlowSAXHandler(IProgressMonitor monitor) {
        this.stack.push(this.model);
        this.monitor = monitor;
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
    }

    public FlowElement getModel() {
        return this.model;
    }

    public Map<String, ParsFile> getFiles() {
        return this.filesMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        L.debug("uri: " + uri);
        L.debug("localName:" + localName);
        L.debug("qname:" + qName);
        L.debug("attrs: " + attributes);
        if (this.monitor.isCanceled()) {
            this.monitor.subTask("canceling ...");
            throw new CanceledException("canceled by user");
        }
        this.monitor.subTask(Messages.getString(FlowSAXHandler.class, "handling.task", new Object[]{qName}));
        if (qName.equalsIgnoreCase("File")) {
            ParsFile f = new ParsFile();
            int len = attributes.getLength();
            int i = 0;
            while (i < len) {
                String aName = attributes.getQName(i);
                String aValue = attributes.getValue(i);
                if (aName.equalsIgnoreCase("id")) {
                    f.setId(aValue);
                }
                if (aName.equalsIgnoreCase("name")) {
                    f.setPath(aValue);
                    int idx = aValue.lastIndexOf("\\");
                    f.setName(aValue.substring(idx + 1));
                }
                L.debug("name: " + aName);
                L.debug("value: " + aValue);
                ++i;
            }
            if (this.filesMap == null) {
                this.filesMap = new HashMap<String, ParsFile>();
            }
            this.filesMap.put(f.getId(), f);
        } else if (qName.equalsIgnoreCase("StartPos")) {
            FlowElement lastElem = this.stack.peek();
            int len = attributes.getLength();
            SourceInfo pos = new SourceInfo();
            this.sourceInfos.add(pos);
            int i = 0;
            while (i < len) {
                String aName = attributes.getQName(i);
                String aValue = attributes.getValue(i);
                lastElem.setSourceInfo(pos);
                if (aName.equalsIgnoreCase("FileId")) {
                    pos.setFileID(aValue);
                }
                if (aName.equalsIgnoreCase("Row")) {
                    pos.setSline(Integer.valueOf(aValue));
                }
                if (aName.equalsIgnoreCase("Column")) {
                    pos.setScolumn(Integer.valueOf(aValue));
                }
                L.debug("name: " + aName);
                L.debug("value: " + aValue);
                ++i;
            }
        } else if (qName.equalsIgnoreCase("EndPos")) {
            FlowElement lastElem = this.stack.peek();
            SourceInfo pos = lastElem.getSourceInfo();
            int len = attributes.getLength();
            int i = 0;
            while (i < len) {
                String aName = attributes.getQName(i);
                String aValue = attributes.getValue(i);
                if (aName.equalsIgnoreCase("FileId") && !pos.getFileID().equals(aValue)) {
                    pos.setSecondFileID(aValue);
                }
                if (aName.equalsIgnoreCase("Row")) {
                    pos.setEline(Integer.valueOf(aValue));
                }
                if (aName.equalsIgnoreCase("Column")) {
                    pos.setEcolumn(Integer.valueOf(aValue));
                }
                L.debug("name: " + aName);
                L.debug("value: " + aValue);
                ++i;
            }
        } else if (qName.equalsIgnoreCase("ParagraphRef")) {
            String aName = attributes.getQName(0);
            if (aName != null) {
                String aValue = attributes.getValue(0);
                FlowElement lastElem = this.stack.peek();
                lastElem.addProperty(aName, aValue);
                L.debug("name: " + aName);
                L.debug("value: " + aValue);
            }
        } else if (!this.ignoreElements.contains(qName.toLowerCase())) {
            FlowElement ne = new FlowElement(qName);
            Properties p = null;
            int len = attributes.getLength();
            int i = 0;
            while (i < len) {
                if (p == null) {
                    p = new Properties();
                }
                String aName = attributes.getQName(i);
                String aValue = attributes.getValue(i);
                p.setProperty(aName, aValue);
                ++i;
            }
            ne.setProperties(p);
            FlowElement parent = this.stack.peek();
            parent.registerChild(ne);
            this.stack.push(ne);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equalsIgnoreCase("StartPos") || qName.equalsIgnoreCase("EndPos") || qName.equalsIgnoreCase("ParagraphRef") || qName.equalsIgnoreCase("File") || this.ignoreElements.contains(qName.toLowerCase()) || this.stack.isEmpty())) {
            FlowElement element = this.stack.pop();
            element.updatePositions();
        }
    }

    public List<SourceInfo> getSourceInfos() {
        return this.sourceInfos;
    }
}

