/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.SourceInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FlowElement {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String type;
    private SourceInfo sourceInfo;
    private List<FlowElement> statements;
    private Properties properties;
    private int width = 1;
    private int height = 1;
    private int topPos = 1;
    private int childTop = 1;

    public FlowElement(String type) {
        this.type = type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getChildTop() {
        return this.childTop;
    }

    public String getType() {
        return this.type;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public List<FlowElement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<FlowElement> statements) {
        this.statements = statements;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void addProperty(String aName, String aValue) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(aName, aValue);
    }

    public void registerChild(FlowElement ne) {
        if (this.statements == null) {
            this.statements = new ArrayList<FlowElement>();
        }
        this.statements.add(ne);
    }

    public void updatePositions() {
        this.topPos = 1;
        this.width = 1;
        this.height = 1;
        if (this.sourceInfo != null) {
            this.height = this.sourceInfo.eline - this.sourceInfo.sline;
        }
        if (this.type.equalsIgnoreCase("switchstate")) {
            int i = 0;
            while (i < this.statements.size()) {
                if (i == 0) {
                    this.width = this.statements.get(i).getWidth();
                    this.topPos = this.statements.get(i).getTopPos();
                } else {
                    this.width += this.statements.get(i).getWidth() - 2;
                    this.topPos += this.statements.get(i).getWidth() - 2;
                }
                ++i;
            }
        } else if (this.type.equalsIgnoreCase("ifstatement")) {
            FlowElement child = null;
            if (this.statements.size() == 2) {
                child = this.statements.get(0);
                this.width = child.getWidth();
                ++this.width;
                this.topPos = this.width;
                child = this.statements.get(1);
                this.width += child.getWidth();
            } else if (this.statements.size() == 1) {
                child = this.statements.get(0);
                this.width = child.getWidth();
                ++this.width;
                this.topPos = this.width;
            }
        } else if (this.statements != null && !this.statements.isEmpty()) {
            int elemWidth = 0;
            int elemTop = 0;
            for (FlowElement elem : this.statements) {
                elemWidth = elem.getWidth();
                this.height += elem.getHeight();
                elemTop = elem.getTopPos();
                if (elemTop > this.topPos) {
                    this.width += elemTop - this.topPos;
                    this.topPos = elemTop;
                }
                if (elemWidth - elemTop <= this.width - this.topPos) continue;
                this.width += elemWidth - elemTop - (this.width - this.topPos);
            }
        }
        this.childTop = this.topPos;
        if (this.type.equalsIgnoreCase("whilestate")) {
            this.width += 2;
            this.topPos = 1;
        }
        if (this.type.equalsIgnoreCase("performvartimesstate")) {
            this.width += 2;
            this.topPos = 1;
        }
        this.type.equalsIgnoreCase("switchstate");
        if (this.type.equalsIgnoreCase("case")) {
            this.width += 2;
            this.childTop = this.topPos + 1;
            this.topPos = 2;
        }
    }
}

