/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.FlowchartGraphModel;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.XDrawHandler;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowChartLayout {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(FlowChartLayout.class);
    public static final String LAYOUT_CENTER_Y = "layoutCenterY";
    public static final String LAYOUT_CENTER_X = "layoutCenterX";
    public static final String EXIT_PERFORM = "EXIT PERFORM";
    public static final String EXIT_PERFORM_ID = "EXIT PERFORM ID";
    public static final String GO_TO = "GO TO";
    public static final String IF_STATEMENT = "IF";
    public static final String ELSE_STATEMENT = "ELSE";
    public static final String EVALUATE = "EVALUATE";
    public static final int Y_COORDINATE_OFFSET = 100;
    private static double MIN_Y_COORDINATE = 0.0;
    private static final String EMPTY_STRING = "";
    private Map<String, XDrawHandler> handlers = new HashMap<String, XDrawHandler>(){
        {
            this.put("program", new XBlockHandler());
            this.put("section", new XSectionHandler());
            this.put("paragraph", new XParagraphHandler());
            this.put("ifstatement", new XIfHandler());
            this.put("then", new XBlockHandler());
            this.put("else", new XBlockHandler());
            this.put("statement", new XStatementHandler());
            this.put("exitstatement", new XStatementHandler());
            this.put("flowcontrolstatement", new XStatementHandler());
            this.put("labelstatement", new XStatementHandler());
            this.put("whilestate", new XWhileHandler());
            this.put("switchstate", new XSwitchHandler());
            this.put("performvartimesstate", new XRepeatHandler());
            this.put("case", new XCaseHandler());
        }
    };
    private FlowchartGraphModel flowchartGraphModel;
    private Set<String> paragraphIDS = new HashSet<String>();
    private Map<String, TSENode> labelIDS = new HashMap<String, TSENode>();
    private Map<String, Set<TSENode>> goToLabel = new HashMap<String, Set<TSENode>>();
    private int VGAP = 100;
    private int HGAP = 180;
    private int SPACEPERTEXTLINE = 0;
    private int goto_count = 0;

    public FlowChartLayout(FlowchartGraphModel flowchartGraphModel) {
        this.flowchartGraphModel = flowchartGraphModel;
    }

    public static void draw(FlowchartGraphModel flowchartGraphModel, FlowElement flow, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IPreferenceStore store = PreferenceUtils.getPreferenceStore();
        boolean tsNodeResizability = store.getBoolean("showFlowchartAsText");
        monitor.subTask("drawing nodes ");
        FlowChartLayout fcl = new FlowChartLayout(flowchartGraphModel);
        if (tsNodeResizability) {
            L.debug("Increase width between nodes if flowchart is draw with full text ");
            fcl.setHGap(300);
            fcl.setVGap(200);
            fcl.setSpacePerLine(5);
        }
        fcl.draw(flow, 0.0, 0.0, (IProgressMonitor)monitor.newChild(100));
        monitor.setTaskName(EMPTY_STRING);
    }

    private void setSpacePerLine(int i) {
        this.SPACEPERTEXTLINE = i;
    }

    private void setVGap(int i) {
        this.VGAP = i;
    }

    private void setHGap(int i) {
        this.HGAP = i;
    }

    private ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        ArrayList<Object> ret = null;
        monitor.subTask("drawing node " + element.getType());
        L.debug("element: " + element.getType().toLowerCase());
        XDrawHandler handler = this.handlers.get(element.getType().toLowerCase());
        if (handler == null) {
            L.warn("element not handled " + element.getType());
            ret = new ArrayList();
        } else {
            ret = handler.draw(element, x, y, (IProgressMonitor)monitor.newChild(100));
        }
        monitor.setWorkRemaining(0);
        return ret;
    }

    private void computeGOTOedges(FlowElement element, double x, TSENode lastNode, TSENode paragraph) {
        TSEGraph graph = this.flowchartGraphModel.getGraph();
        TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)paragraph);
        GraphUtils.setType(edge, 12);
        double maxx = x + (double)(element.getWidth() * this.HGAP) - (double)(this.HGAP / 2);
        double space = maxx / 2.0 + (double)(this.goto_count * 2);
        GraphUtils.setOrthogonalPath(edge, space);
        ++this.goto_count;
    }

    class XBlockHandler
    implements XDrawHandler {
        XBlockHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            List<FlowElement> stmts = element.getStatements();
            if (stmts != null) {
                Optional<FlowElement> goToElement = stmts.stream().filter(st -> st.getSourceInfo().text.trim().startsWith(FlowChartLayout.GO_TO)).findAny();
                TSENode firstN = null;
                TSENode last = null;
                TSENode first = null;
                TSENode oldnode = null;
                TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
                monitor.setWorkRemaining(stmts.size());
                for (FlowElement fe : stmts) {
                    if (monitor.isCanceled()) break;
                    ArrayList sResult = FlowChartLayout.this.draw(fe, x, y, (IProgressMonitor)monitor.newChild(1));
                    if (sResult.size() > 0) {
                        first = (TSENode)sResult.get(0);
                        if (firstN == null) {
                            firstN = first;
                            nodes.add(firstN);
                        }
                        last = (TSENode)sResult.get(sResult.size() - 1);
                        if (oldnode != null) {
                            L.debug("draw edge: " + oldnode.getName() + " to " + "first");
                            if ((oldnode.hasAttribute("exitstatement") || oldnode.hasAttribute("IS_DEAD_CODE") || oldnode.hasAttribute("flow_control_statement, paragraph_ref id")) && "section".equals(fe.getType().toLowerCase())) {
                                if (oldnode.hasAttribute("flow_control_statement, paragraph_ref id")) {
                                    String val = (String)oldnode.getAttributeValue("flow_control_statement, paragraph_ref id");
                                    if (FlowChartLayout.this.paragraphIDS.contains(val)) {
                                        graph.addEdge((TSNode)oldnode, (TSNode)first);
                                    }
                                }
                            } else {
                                graph.addEdge((TSNode)oldnode, (TSNode)first);
                            }
                        }
                        oldnode = last;
                        y = oldnode.getBottom();
                    }
                    if (FlowChartLayout.EVALUATE.equalsIgnoreCase(fe.getSourceInfo().text)) {
                        List<TSENode> exitNodes = GraphUtils.findAllByText(sResult, FlowChartLayout.EXIT_PERFORM);
                        if (!goToElement.isPresent() && !exitNodes.isEmpty()) {
                            nodes.addAll(exitNodes);
                            nodes.add(last);
                            return nodes;
                        }
                    }
                    if (first != null && FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(first.getText())) {
                        L.debug("perform until exit condition is reached.");
                        if (!nodes.contains(first)) {
                            nodes.add(first);
                        }
                        return nodes;
                    }
                    if (first == null || !first.getText().startsWith(FlowChartLayout.GO_TO)) continue;
                    nodes.add(first);
                    return nodes;
                }
                if (last != null) {
                    nodes.add(last);
                }
            }
            return nodes;
        }
    }

    class XCaseHandler
    implements XDrawHandler {
        XCaseHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            String text;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            double elemx = 0.0;
            boolean isDefault = false;
            List<FlowElement> caseElems = element.getStatements();
            String txt = element.getSourceInfo().getText();
            String string = text = txt != null ? txt.toLowerCase() : FlowChartLayout.EMPTY_STRING;
            if (text.startsWith("otherwise") || text.startsWith("other")) {
                elemx = x;
                isDefault = true;
            } else {
                elemx = x + (double)((element.getChildTop() - 1) * FlowChartLayout.this.HGAP);
            }
            TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
            TSENode caseNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            nodes.add(caseNode);
            caseNode.setCenterX(x);
            caseNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            caseNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            caseNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            double detaily = y;
            boolean hasExitPerformed = false;
            ArrayList<TSENode> eResult = new ArrayList<TSENode>();
            if (caseElems != null && !caseElems.isEmpty()) {
                monitor.setWorkRemaining(caseElems.size());
                TSENode oldnode = null;
                for (FlowElement caseElem : caseElems) {
                    if (monitor.isCanceled()) break;
                    ArrayList res = FlowChartLayout.this.draw(caseElem, elemx, y, (IProgressMonitor)monitor.newChild(1));
                    eResult.addAll(res);
                    TSENode frst = (TSENode)res.get(0);
                    if (oldnode != null) {
                        L.debug("draw edge: " + oldnode.getName() + " to " + "first");
                        graph.addEdge((TSNode)oldnode, (TSNode)frst);
                    }
                    oldnode = (TSENode)res.get(res.size() - 1);
                    y = oldnode.getBottom();
                    if (FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(frst.getText())) {
                        L.debug("perform until exit condition is reached.");
                        if (!nodes.contains(frst)) {
                            nodes.add(frst);
                        }
                        hasExitPerformed = true;
                        break;
                    }
                    if (!frst.getText().startsWith(FlowChartLayout.GO_TO)) continue;
                    nodes.add(frst);
                    break;
                }
            }
            TSENode matchEndNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            matchEndNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            matchEndNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            TSENode noMatchEndNode = matchEndNode;
            if (!isDefault) {
                noMatchEndNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
                graph.addEdge((TSNode)caseNode, (TSNode)noMatchEndNode);
                noMatchEndNode.setCenterX(x - (double)FlowChartLayout.this.HGAP);
                noMatchEndNode.setCenterY(detaily);
                noMatchEndNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)(x - (double)FlowChartLayout.this.HGAP));
                noMatchEndNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)detaily);
            }
            if (!eResult.isEmpty()) {
                L.debug("draw edge to case node");
                TSENode firstNode = (TSENode)eResult.get(0);
                TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)caseNode, (TSNode)firstNode);
                if (!isDefault) {
                    GraphUtils.setType(edge, 6);
                    GraphUtils.setOrthogonalPath(edge);
                }
                if (!hasExitPerformed) {
                    this.drawLastNodeToEnd(eResult, graph, edge, matchEndNode);
                } else {
                    matchEndNode.setVisible(false);
                }
            } else {
                TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)caseNode, (TSNode)matchEndNode);
                GraphUtils.setType(edge, 6);
                GraphUtils.setOrthogonalPath(edge);
            }
            nodes.add(matchEndNode);
            nodes.add(noMatchEndNode);
            return nodes;
        }

        private void drawLastNodeToEnd(ArrayList<TSENode> nodes, TSEGraph graph, TSEEdge edge, TSENode matchEndNode) {
            L.debug("draw edge to from last node to end point");
            TSENode lastNode = nodes.get(nodes.size() - 1);
            if (!lastNode.getText().startsWith(FlowChartLayout.GO_TO)) {
                edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)matchEndNode);
                matchEndNode.setCenterX(lastNode.getCenterX());
                matchEndNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)lastNode.getCenterX());
            } else {
                matchEndNode.setVisible(false);
            }
        }
    }

    class XIfHandler
    implements XDrawHandler {
        XIfHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            TSEEdge edge;
            TSENode lastNode;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)3);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            List<FlowElement> stmts = element.getStatements();
            FlowElement tElem = null;
            FlowElement eElem = null;
            if (stmts.size() == 2) {
                tElem = stmts.get(0);
                eElem = stmts.get(1);
            } else if (stmts.size() == 1) {
                tElem = stmts.get(0);
            } else {
                L.debug("if statement without THEN/ELSE ?");
            }
            TSENode ifNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            nodes.add(ifNode);
            ifNode.setCenterX(x);
            ifNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            ifNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            ifNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            ArrayList tResult = null;
            if (tElem != null) {
                double left = x - (double)((element.getTopPos() - tElem.getTopPos()) * FlowChartLayout.this.HGAP);
                tResult = FlowChartLayout.this.draw(tElem, left, y, (IProgressMonitor)monitor.newChild(1));
            } else {
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                return nodes;
            }
            ArrayList eResult = null;
            if (eElem != null) {
                double right = x + (double)(eElem.getChildTop() * FlowChartLayout.this.HGAP);
                eResult = FlowChartLayout.this.draw(eElem, right, y, (IProgressMonitor)monitor.newChild(1));
            } else {
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                return nodes;
            }
            TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
            double miny = y;
            if (tResult != null && !tResult.isEmpty()) {
                lastNode = (TSENode)tResult.get(tResult.size() - 1);
                miny = lastNode.getCenterY();
            }
            if (eResult != null && !eResult.isEmpty()) {
                lastNode = (TSENode)eResult.get(eResult.size() - 1);
                miny = lastNode.getCenterY() < miny ? lastNode.getCenterY() : miny;
            }
            TSENode endNode = this.buildEndNode(miny -= (double)FlowChartLayout.this.VGAP, x);
            boolean noThen = true;
            boolean noElse = true;
            boolean isFlowControlStatement = true;
            TSENode lastNode2 = null;
            List<TSENode> exitNodes = null;
            boolean containsEndStatement = this.mustBeAlign(tResult);
            if (tResult != null && !tResult.isEmpty()) {
                L.debug("draw edge to first then");
                TSENode thenNode = (TSENode)tResult.get(0);
                edge = (TSEEdge)graph.addEdge((TSNode)ifNode, (TSNode)thenNode);
                GraphUtils.setType(edge, 4);
                GraphUtils.setOrthogonalPath(edge);
                L.debug("draw edge to from last then to end point");
                lastNode2 = (TSENode)tResult.get(tResult.size() - 1);
                exitNodes = GraphUtils.findAllByText(tResult, FlowChartLayout.EXIT_PERFORM);
                if (FlowChartLayout.EVALUATE.equalsIgnoreCase(thenNode.getText()) && !exitNodes.isEmpty()) {
                    exitNodes.stream().forEach(node -> {
                        node.setAttribute(FlowChartLayout.EXIT_PERFORM_ID, (Object)FlowChartLayout.EXIT_PERFORM);
                        nodes.add((TSENode)node);
                    });
                }
                if (FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(lastNode2.getText())) {
                    lastNode2.setAttribute(FlowChartLayout.EXIT_PERFORM_ID, (Object)FlowChartLayout.EXIT_PERFORM);
                    nodes.add(lastNode2);
                    isFlowControlStatement = false;
                }
                if (isFlowControlStatement) {
                    this.processFlowControlStatement(lastNode2, element, x, edge, graph, endNode, nodes, (Pair<String, Boolean>)new Pair((Object)FlowChartLayout.EMPTY_STRING, (Object)false));
                }
                noThen = false;
            }
            if (eResult != null && !eResult.isEmpty()) {
                L.debug("draw edge to first else");
                TSENode elseNode = (TSENode)eResult.get(0);
                edge = (TSEEdge)graph.addEdge((TSNode)ifNode, (TSNode)elseNode);
                GraphUtils.setType(edge, 6);
                GraphUtils.setOrthogonalPath(edge);
                L.debug("draw edge to from last else to end point");
                lastNode2 = (TSENode)eResult.get(eResult.size() - 1);
                exitNodes = GraphUtils.findAllByText(eResult, FlowChartLayout.EXIT_PERFORM);
                isFlowControlStatement = true;
                if (FlowChartLayout.EVALUATE.equalsIgnoreCase(elseNode.getText()) && !exitNodes.isEmpty()) {
                    exitNodes.stream().forEach(node -> {
                        node.setAttribute(FlowChartLayout.EXIT_PERFORM_ID, (Object)FlowChartLayout.EXIT_PERFORM);
                        nodes.add((TSENode)node);
                    });
                    isFlowControlStatement = false;
                    this.processFlowControlStatement(lastNode2, element, x, edge, graph, endNode, nodes, (Pair<String, Boolean>)new Pair((Object)FlowChartLayout.ELSE_STATEMENT, (Object)containsEndStatement));
                }
                if (FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(lastNode2.getText())) {
                    lastNode2.setAttribute(FlowChartLayout.EXIT_PERFORM_ID, (Object)FlowChartLayout.EXIT_PERFORM);
                    nodes.add(lastNode2);
                    return nodes;
                }
                if (isFlowControlStatement) {
                    this.processFlowControlStatement(lastNode2, element, x, edge, graph, endNode, nodes, (Pair<String, Boolean>)new Pair((Object)FlowChartLayout.ELSE_STATEMENT, (Object)containsEndStatement));
                    return nodes;
                }
                noElse = false;
            }
            if (noThen || noElse) {
                endNode.setVisible(true);
                TSEEdge edge2 = (TSEEdge)graph.addEdge((TSNode)ifNode, (TSNode)endNode);
                GraphUtils.setOrthogonalPath(edge2);
            }
            nodes.add(endNode);
            monitor.setWorkRemaining(0);
            return nodes;
        }

        private boolean mustBeAlign(ArrayList<TSENode> nodes) {
            if (nodes == null || nodes.isEmpty()) {
                return false;
            }
            String lastNode = nodes.get(nodes.size() - 1).getText().trim();
            return FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(lastNode) && lastNode.startsWith(FlowChartLayout.GO_TO);
        }

        private TSENode buildEndNode(double miny, double x) {
            TSENode node = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            node.setCenterX(x);
            node.setCenterY(miny);
            node.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            node.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)miny);
            node.setVisible(false);
            return node;
        }

        private void processFlowControlStatement(TSENode lastNode, FlowElement element, double x, TSEEdge edge, TSEGraph graph, TSENode endNode, ArrayList<TSENode> nodes, Pair<String, Boolean> statementInfo) {
            boolean mustBeAligned;
            if (!nodes.contains(lastNode)) {
                nodes.add(lastNode);
            }
            if ("FlowControlStatement".equals(lastNode.getAttributeValue("RESOURCE_TYPE_INTEGER")) && lastNode.hasAttribute("flow_control_statement, paragraph_ref id")) {
                String labelID = (String)lastNode.getAttributeValue("flow_control_statement, paragraph_ref id");
                if (FlowChartLayout.this.labelIDS.containsKey(labelID)) {
                    TSENode paragraph = (TSENode)FlowChartLayout.this.labelIDS.get(labelID);
                    FlowChartLayout.this.computeGOTOedges(element, x, lastNode, paragraph);
                } else {
                    HashSet<TSENode> nodesToGoTO = (HashSet<TSENode>)FlowChartLayout.this.goToLabel.get(labelID);
                    if (nodesToGoTO == null) {
                        nodesToGoTO = new HashSet<TSENode>();
                        FlowChartLayout.this.goToLabel.put(labelID, nodesToGoTO);
                    }
                    nodesToGoTO.add(lastNode);
                }
            }
            endNode.setVisible(true);
            nodes.add(endNode);
            boolean bl = mustBeAligned = FlowChartLayout.ELSE_STATEMENT.equalsIgnoreCase((String)statementInfo.getFirst()) && (Boolean)statementInfo.getSecond() == false;
            if (mustBeAligned) {
                endNode.setCenterX(lastNode.getCenterX());
                endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)lastNode.getCenterX());
                graph.addEdge((TSNode)lastNode, (TSNode)endNode);
                return;
            }
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)endNode);
            GraphUtils.setType(edge, 5);
            GraphUtils.setOrthogonalPath(edge);
        }
    }

    class XParagraphHandler
    implements XDrawHandler {
        XParagraphHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            L.debug("draw paragraph " + element);
            Properties pr = element.getProperties();
            String name = pr.getProperty("Name");
            element.getSourceInfo().setText(name);
            TSENode paragNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            FlowChartLayout.this.paragraphIDS.add(pr.getProperty("id"));
            paragNode.setCenterX(x);
            paragNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            paragNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            paragNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            nodes.add(paragNode);
            List<FlowElement> stmts = element.getStatements();
            TSENode last = null;
            if (stmts != null) {
                monitor.setWorkRemaining(stmts.size());
                last = paragNode;
                TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
                for (FlowElement fe : stmts) {
                    if (monitor.isCanceled()) break;
                    ArrayList sResult = FlowChartLayout.this.draw(fe, x, y, (IProgressMonitor)monitor.newChild(1));
                    if (sResult.size() == 0) continue;
                    TSENode first = (TSENode)sResult.get(0);
                    graph.addEdge((TSNode)last, (TSNode)first);
                    last = (TSENode)sResult.get(sResult.size() - 1);
                    y = last.getBottom();
                    x = last.getCenterX();
                }
            }
            if (last != null && last != paragNode) {
                nodes.add(last);
            }
            return nodes;
        }
    }

    class XRepeatHandler
    implements XDrawHandler {
        XRepeatHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
            TSENode repeatNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            nodes.add(repeatNode);
            repeatNode.setCenterX(x);
            repeatNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            repeatNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            repeatNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            double elemx = x + (double)(element.getChildTop() * FlowChartLayout.this.HGAP);
            double maxx = x + (double)(element.getWidth() * FlowChartLayout.this.HGAP) - (double)(FlowChartLayout.this.HGAP / 2);
            ArrayList tResult = new ArrayList();
            List<FlowElement> stmts = element.getStatements();
            if (stmts != null && stmts.size() > 0) {
                TSENode oldnode = null;
                for (FlowElement elem : stmts) {
                    ArrayList res = FlowChartLayout.this.draw(elem, elemx, y, (IProgressMonitor)monitor.newChild(1));
                    tResult.addAll(res);
                    TSENode first = (TSENode)res.get(0);
                    if (oldnode != null) {
                        graph.addEdge(oldnode, (TSNode)first);
                    }
                    oldnode = (TSENode)res.get(res.size() - 1);
                    y = oldnode.getBottom();
                }
            }
            TSENode outNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            outNode.setCenterY(y -= (double)(FlowChartLayout.this.VGAP / 2));
            outNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            TSENode endNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            endNode.setCenterX(x);
            endNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            if (!tResult.isEmpty()) {
                L.debug("draw edge to repeat node");
                TSENode firstNode = (TSENode)tResult.get(0);
                TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)repeatNode, (TSNode)firstNode);
                GraphUtils.setType(edge, 6);
                GraphUtils.setOrthogonalPath(edge);
                TSENode lastNode = tResult.size() == 1 ? firstNode : (TSENode)tResult.get(tResult.size() - 1);
                outNode.setCenterX(lastNode.getCenterX());
                outNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)lastNode.getCenterX());
                edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)outNode);
                GraphUtils.setOrthogonalPath(edge);
                edge = (TSEEdge)graph.addEdge((TSNode)outNode, (TSNode)repeatNode);
                GraphUtils.setType(edge, 11);
                GraphUtils.setOrthogonalPath(edge, maxx);
            }
            graph.addEdge((TSNode)repeatNode, (TSNode)endNode);
            nodes.add(endNode);
            return nodes;
        }
    }

    class XSectionHandler
    implements XDrawHandler {
        XSectionHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            L.debug("draw section " + element);
            Properties pr = element.getProperties();
            String name = pr.getProperty("Name");
            element.getSourceInfo().setText(name);
            TSENode sectionNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            sectionNode.setCenterX(x);
            sectionNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            sectionNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            sectionNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            nodes.add(sectionNode);
            List<FlowElement> stmts = element.getStatements();
            if (stmts != null) {
                TSENode first = null;
                TSENode last = null;
                TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
                monitor.setWorkRemaining(stmts.size());
                boolean isFallThrough = false;
                for (FlowElement fe : stmts) {
                    if (monitor.isCanceled()) break;
                    ArrayList sResult = FlowChartLayout.this.draw(fe, x, y, (IProgressMonitor)monitor.newChild(1));
                    if (sResult.size() > 0) {
                        TSENode paraNode = (TSENode)sResult.get(0);
                        if (first == null) {
                            first = paraNode;
                            nodes.add(first);
                            graph.addEdge((TSNode)sectionNode, (TSNode)first);
                        }
                        if (last != null && !isFallThrough) {
                            graph.addEdge(last, (TSNode)paraNode);
                            L.debug("draw edge to paragraph");
                        }
                        last = (TSENode)sResult.get(sResult.size() - 1);
                        y = last.getBottom();
                        if (last.hasAttribute("exitstatement")) {
                            nodes.add(last);
                            last = null;
                        }
                    }
                    if ("Paragraph".equalsIgnoreCase(fe.getType())) {
                        Properties props = fe.getProperties();
                        String paragraphName = props.getProperty("Name");
                        L.debug(String.format("starting to process fall through value associated with %s paragraph", paragraphName));
                        String fallThrough = props.getProperty("FallThrough");
                        isFallThrough = Objects.nonNull(fallThrough) ? Integer.valueOf(fallThrough) == 0 : false;
                        L.debug(String.format("fall through value corresponding to %s is %s ", paragraphName, fallThrough));
                        continue;
                    }
                    L.info("fall through is processed only for paragraps");
                }
                if (last != null) {
                    nodes.add(last);
                }
            }
            return nodes;
        }
    }

    class XStatementHandler
    implements XDrawHandler {
        XStatementHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)1);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            L.debug("draw statement " + element.getType());
            TSENode stmtNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            stmtNode.setCenterX(x);
            stmtNode.setCenterY(y -= (double)(FlowChartLayout.this.VGAP + element.getHeight() * FlowChartLayout.this.SPACEPERTEXTLINE));
            stmtNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            stmtNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            nodes.add(stmtNode);
            if (element.getType().equals("LabelStatement")) {
                Properties pr = element.getProperties();
                String key = pr.getProperty("id");
                FlowChartLayout.this.labelIDS.put(key, stmtNode);
                if (FlowChartLayout.this.goToLabel.containsKey(key)) {
                    Set nodesToParagraph = (Set)FlowChartLayout.this.goToLabel.get(key);
                    for (TSENode nodeToGo : nodesToParagraph) {
                        FlowChartLayout.this.computeGOTOedges(element, x, nodeToGo, stmtNode);
                    }
                }
            }
            monitor.worked(1);
            return nodes;
        }
    }

    class XSwitchHandler
    implements XDrawHandler {
        XSwitchHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
            TSENode switchNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            nodes.add(switchNode);
            switchNode.setCenterX(x);
            switchNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            switchNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            switchNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            double maxy = y;
            double initialX = x;
            TSENode endSwitch = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            endSwitch.setCenterX(x);
            endSwitch.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            ArrayList<TSENode> endNodes = new ArrayList<TSENode>();
            List<FlowElement> stmts = element.getStatements();
            if (stmts != null && stmts.size() > 0) {
                TSENode lastMatchNode = null;
                TSENode lastNoMatchNode = null;
                TSEEdge edge = null;
                monitor.setWorkRemaining(stmts.size());
                L.debug("cases");
                int i = 0;
                while (i < stmts.size()) {
                    boolean containsValidExit;
                    FlowElement elem = stmts.get(i);
                    if (monitor.isCanceled()) break;
                    ArrayList res = FlowChartLayout.this.draw(elem, x, y - (double)(i * FlowChartLayout.this.VGAP), (IProgressMonitor)monitor.newChild(1));
                    if (i + 1 < stmts.size()) {
                        FlowElement next = stmts.get(i + 1);
                        String txt = element.getSourceInfo().getText();
                        String text = txt != null ? txt.toLowerCase() : FlowChartLayout.EMPTY_STRING;
                        x -= (double)((next.getWidth() - next.getTopPos()) * FlowChartLayout.this.HGAP);
                        if (text.startsWith("otherwise") || text.startsWith("other")) {
                            x += (double)(2 * FlowChartLayout.this.HGAP);
                        }
                    } else {
                        x -= (double)FlowChartLayout.this.HGAP;
                    }
                    if (containsValidExit = this.containsExitPerform(nodes, res)) {
                        endSwitch.setCenterX(initialX - 20.0);
                        endSwitch.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)(initialX - 20.0));
                    }
                    TSENode caseNode = (TSENode)res.get(0);
                    lastMatchNode = (TSENode)res.get(res.size() - 2);
                    TSENode noMatchNode = (TSENode)res.get(res.size() - 1);
                    if (lastNoMatchNode == null) {
                        edge = (TSEEdge)graph.addEdge((TSNode)switchNode, (TSNode)caseNode);
                    } else {
                        edge = (TSEEdge)graph.addEdge(lastNoMatchNode, (TSNode)caseNode);
                        GraphUtils.setType(edge, 4);
                        GraphUtils.setOrthogonalPath(edge);
                    }
                    lastNoMatchNode = noMatchNode;
                    if (maxy > lastMatchNode.getBottom()) {
                        maxy = lastMatchNode.getBottom();
                    }
                    endNodes.add(lastMatchNode);
                    ++i;
                }
                endNodes.add(lastNoMatchNode);
            }
            y = maxy - (double)FlowChartLayout.this.VGAP;
            endSwitch.setCenterY(y);
            endSwitch.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            nodes.add(endSwitch);
            MIN_Y_COORDINATE = endSwitch.getCenterY() < MIN_Y_COORDINATE ? endSwitch.getCenterY() : MIN_Y_COORDINATE;
            this.linkNodesToEndSwith(graph, endNodes, endSwitch);
            return nodes;
        }

        private void linkNodesToEndSwith(TSEGraph graph, List<TSENode> endNodes, TSENode endSwitch) {
            List<TSENode> nodesToEndSwitch = GraphUtils.getVisibleNodes(endNodes);
            if (nodesToEndSwitch.size() == 1) {
                TSENode nodeToLink = nodesToEndSwitch.get(0);
                double x_position = nodeToLink.getCenterX();
                endSwitch.setCenterX(x_position);
                endSwitch.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x_position);
                graph.addEdge((TSNode)nodeToLink, (TSNode)endSwitch);
                return;
            }
            if (!nodesToEndSwitch.isEmpty()) {
                double min_x_position = GraphUtils.getMinimHorizontalValue(nodesToEndSwitch);
                endSwitch.setCenterX(min_x_position);
                endSwitch.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)min_x_position);
            } else {
                graph.remove((TSNode)endSwitch);
            }
            for (TSENode node : nodesToEndSwitch) {
                TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)node, (TSNode)endSwitch);
                GraphUtils.setType(edge, 5);
                GraphUtils.setOrthogonalPath(edge);
            }
        }

        private boolean containsExitPerform(ArrayList<TSENode> nodes, ArrayList<TSENode> result) {
            Optional<TSENode> tempNode = GraphUtils.findByText(result, FlowChartLayout.EXIT_PERFORM);
            if (tempNode.isPresent()) {
                nodes.add(tempNode.get());
                return true;
            }
            return false;
        }
    }

    class XWhileHandler
    implements XDrawHandler {
        XWhileHandler() {
        }

        @Override
        public ArrayList<TSENode> draw(FlowElement element, double x, double y, IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
            ArrayList<TSENode> nodes = new ArrayList<TSENode>();
            if (monitor.isCanceled()) {
                return nodes;
            }
            TSEGraph graph = FlowChartLayout.this.flowchartGraphModel.getGraph();
            List<FlowElement> stmts = element.getStatements();
            L.debug("draw start while");
            TSENode startNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            nodes.add(startNode);
            startNode.setCenterX(x);
            startNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            startNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            startNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            TSENode whileNode = FlowChartLayout.this.flowchartGraphModel.createNode(element);
            nodes.add(whileNode);
            whileNode.setCenterX(x);
            whileNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            whileNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            whileNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            double elemx = x + (double)(element.getChildTop() * FlowChartLayout.this.HGAP);
            double maxx = x + (double)(element.getWidth() * FlowChartLayout.this.HGAP) - (double)(FlowChartLayout.this.HGAP / 2);
            TSENode endNode = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            ArrayList<TSENode> tResult = new ArrayList<TSENode>();
            if (stmts != null && stmts.size() > 0) {
                monitor.setWorkRemaining(stmts.size());
                TSENode oldnode = null;
                for (FlowElement elem : stmts) {
                    if (monitor.isCanceled()) break;
                    ArrayList res = FlowChartLayout.this.draw(elem, elemx, y, (IProgressMonitor)monitor.newChild(1));
                    tResult.addAll(res);
                    TSENode first = (TSENode)res.get(0);
                    if (oldnode != null) {
                        graph.addEdge(oldnode, (TSNode)first);
                    }
                    TSENode lastNode = (TSENode)res.get(res.size() - 1);
                    y = lastNode.getBottom();
                    oldnode = lastNode;
                }
            }
            TSENode outNode = this.buildOutNode(y -= (double)(FlowChartLayout.this.VGAP / 2));
            endNode.setCenterX(x);
            endNode.setCenterY(y -= (double)FlowChartLayout.this.VGAP);
            endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)x);
            endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            int countExitNodes = this.countExitNodes(tResult, graph, endNode);
            if (!tResult.isEmpty()) {
                boolean drawToBeginPoint;
                L.debug("draw edge to first while node");
                TSENode firstNode = tResult.get(0);
                TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)whileNode, (TSNode)firstNode);
                GraphUtils.setType(edge, 6);
                GraphUtils.setOrthogonalPath(edge);
                TSENode lastNode = tResult.get(tResult.size() - 1);
                boolean isGoTo = false;
                List<TSENode> emptyNodes = GraphUtils.getEmptyNodes(tResult);
                if (lastNode.getText().startsWith(FlowChartLayout.GO_TO)) {
                    if (emptyNodes.isEmpty()) {
                        isGoTo = true;
                    } else {
                        lastNode = emptyNodes.get(emptyNodes.size() - 1);
                    }
                }
                boolean bl = drawToBeginPoint = FlowChartLayout.IF_STATEMENT.equalsIgnoreCase(lastNode.getText()) && countExitNodes == 2;
                if (!drawToBeginPoint && !isGoTo) {
                    this.drawEdgestoBeginPoint(lastNode, outNode, edge, graph, startNode, maxx);
                }
            }
            graph.addEdge((TSNode)startNode, (TSNode)whileNode);
            graph.addEdge((TSNode)whileNode, (TSNode)endNode);
            nodes.add(endNode);
            return nodes;
        }

        private TSENode buildOutNode(double y) {
            TSENode node = FlowChartLayout.this.flowchartGraphModel.createPointNode();
            node.setCenterY(y);
            node.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)y);
            node.setVisible(false);
            return node;
        }

        private int countExitNodes(ArrayList<TSENode> tResult, TSEGraph graph, TSENode endNode) {
            ArrayList<TSENode> exitPerformedAsList = new ArrayList<TSENode>();
            String valueAsString = null;
            int i = 0;
            while (i < tResult.size()) {
                valueAsString = (String)tResult.get(i).getAttributeValue(FlowChartLayout.EXIT_PERFORM_ID);
                if (FlowChartLayout.EXIT_PERFORM.equalsIgnoreCase(valueAsString)) {
                    exitPerformedAsList.add(tResult.get(i));
                }
                ++i;
            }
            if (!exitPerformedAsList.isEmpty()) {
                this.drawPerformExitNodes(exitPerformedAsList, tResult, graph, endNode);
            }
            return exitPerformedAsList.size();
        }

        private void drawPerformExitNodes(List<TSENode> nodes, ArrayList<TSENode> allNodes, TSEGraph tseGraph, TSENode endNode) {
            double yCoordinate = endNode.getCenterY();
            yCoordinate = MIN_Y_COORDINATE < yCoordinate ? MIN_Y_COORDINATE : yCoordinate;
            endNode.setCenterY(yCoordinate - 100.0);
            endNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_Y, (Object)(yCoordinate - 100.0));
            for (TSENode exitNode : nodes) {
                TSEEdge edge = (TSEEdge)tseGraph.addEdge((TSNode)exitNode, (TSNode)endNode);
                GraphUtils.setType(edge, 5);
                GraphUtils.setOrthogonalPath(edge);
                allNodes.remove(exitNode);
            }
        }

        private void drawEdgestoBeginPoint(TSENode lastNode, TSENode outNode, TSEEdge edge, TSEGraph graph, TSENode startNode, double maxx) {
            L.debug("draw edge to from last while to begin point");
            outNode.setVisible(true);
            outNode.setCenterX(lastNode.getCenterX());
            outNode.setAttribute(FlowChartLayout.LAYOUT_CENTER_X, (Object)lastNode.getCenterX());
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)outNode);
            GraphUtils.setOrthogonalPath(edge);
            edge = (TSEEdge)graph.addEdge((TSNode)outNode, (TSNode)startNode);
            GraphUtils.setType(edge, 11);
            GraphUtils.setOrthogonalPath(edge, maxx);
        }
    }
}

