/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.FlowchartGraphModel;
import com.ez.graphs.flowchart.model.BlockHandler;
import com.ez.graphs.flowchart.model.CaseHandler;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.IfHandler;
import com.ez.graphs.flowchart.model.ParagraphHandler;
import com.ez.graphs.flowchart.model.ProgramHandler;
import com.ez.graphs.flowchart.model.RepeatHandler;
import com.ez.graphs.flowchart.model.SectionHandler;
import com.ez.graphs.flowchart.model.StatementHandler;
import com.ez.graphs.flowchart.model.SwitchHandler;
import com.ez.graphs.flowchart.model.WhileHandler;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawElements {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DrawElements.class);
    static FlowchartGraphModel flowModel;
    static Map<String, DrawHandler> handlers;

    static {
        handlers = new HashMap<String, DrawHandler>(){
            {
                this.put("program", new ProgramHandler());
                this.put("section", new SectionHandler());
                this.put("paragraph", new ParagraphHandler());
                this.put("ifstatement", new IfHandler());
                this.put("then", new BlockHandler());
                this.put("else", new BlockHandler());
                this.put("statement", new StatementHandler());
                this.put("exitstatement", new StatementHandler());
                this.put("flowcontrolstatement", new StatementHandler());
                this.put("labelstatement", new StatementHandler());
                this.put("whilestate", new WhileHandler());
                this.put("switchstate", new SwitchHandler());
                this.put("performvartimesstate", new RepeatHandler());
                this.put("case", new CaseHandler());
            }
        };
    }

    public static ArrayList<TSENode> doDraw(FlowElement element) {
        L.debug("element: " + element.getType().toLowerCase());
        DrawHandler handler = handlers.get(element.getType().toLowerCase());
        if (handler == null) {
            L.debug("element not handled " + element.getType());
            return new ArrayList<TSENode>();
        }
        return handler.draw(element);
    }

    public void setGraphModel(FlowchartGraphModel flowModel) {
        DrawElements.flowModel = flowModel;
    }
}

