/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.flowchart.model;

import com.ez.graphs.flowchart.model.DrawElements;
import com.ez.graphs.flowchart.model.DrawHandler;
import com.ez.graphs.flowchart.model.FlowElement;
import com.ez.graphs.flowchart.model.RepeatHandler;
import com.ez.graphs.flowchart.utils.GraphUtils;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CaseHandler
implements DrawHandler {
    private static final Logger L = LoggerFactory.getLogger(RepeatHandler.class);

    CaseHandler() {
    }

    @Override
    public ArrayList<TSENode> draw(FlowElement element) {
        ArrayList<TSENode> ret = new ArrayList<TSENode>();
        TSENode caseNode = DrawElements.flowModel.createNode(element);
        TSEGraph graph = DrawElements.flowModel.getGraph();
        List<FlowElement> caseElems = element.getStatements();
        ArrayList<TSENode> eResult = new ArrayList<TSENode>();
        if (caseElems != null && !caseElems.isEmpty()) {
            TSENode oldnode = null;
            for (FlowElement caseElem : caseElems) {
                ArrayList<TSENode> res = DrawElements.doDraw(caseElem);
                eResult.addAll(res);
                TSENode frst = res.get(0);
                if (oldnode != null) {
                    L.debug("draw edge: " + oldnode.getName() + " to " + "first");
                    graph.addEdge((TSNode)oldnode, (TSNode)frst);
                }
                oldnode = res.get(res.size() - 1);
            }
        }
        TSENode endNode = DrawElements.flowModel.createPointNode();
        graph.addEdge((TSNode)caseNode, (TSNode)endNode);
        ret.add(caseNode);
        if (!eResult.isEmpty()) {
            L.debug("draw edge to case node");
            TSENode firstNode = (TSENode)eResult.get(0);
            TSEEdge edge = (TSEEdge)graph.addEdge((TSNode)caseNode, (TSNode)firstNode);
            GraphUtils.setType(edge, 6);
            L.debug("draw edge to from last node to end point");
            TSENode lastNode = (TSENode)eResult.get(eResult.size() - 1);
            edge = (TSEEdge)graph.addEdge((TSNode)lastNode, (TSNode)endNode);
            GraphUtils.setType(edge, 7);
        }
        ret.add(endNode);
        return ret;
    }
}

